/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.content.BonusSpellInfo;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpellProgressionCache;
import pcgen.core.analysis.SpellCountCalc;
import pcgen.core.character.CharacterSpell;
import pcgen.core.spell.Spell;

public class SpellSupportForPCClass {
    private HashMap<Integer, Integer> castForLevelMap = null;
    private SpellProgressionCache spellCache = null;
    private boolean spellCacheValid = false;
    private final PCClass source;

    public SpellSupportForPCClass(PCClass cis) {
        this.source = cis;
    }

    public int getMaxCastLevel() {
        int currHighest = -1;
        if (this.castForLevelMap != null) {
            for (int key : this.castForLevelMap.keySet()) {
                Integer value = this.castForLevelMap.get(key);
                if (value == null || value <= 0 || key <= currHighest) continue;
                currHighest = key;
            }
        }
        return currHighest;
    }

    public int getMaxCastLevel(PlayerCharacter aPC) {
        if (this.castForLevelMap == null) {
            this.calcCastPerDayMapForLevel(aPC);
        }
        return this.getMaxCastLevel();
    }

    public List<Formula> getCastListForLevel(int aLevel) {
        if (!this.updateSpellCache(false)) {
            return null;
        }
        return this.spellCache.getCastForLevel(aLevel);
    }

    public boolean hasCastList() {
        return this.updateSpellCache(false) && this.spellCache.hasCastProgression();
    }

    public int getHighestLevelSpell() {
        if (!this.updateSpellCache(false)) {
            return -1;
        }
        return Math.max(this.spellCache.getHighestCastSpellLevel(), this.spellCache.getHighestKnownSpellLevel());
    }

    public boolean canCastSpells(PlayerCharacter aPC) {
        if (!this.updateSpellCache(false) || !this.spellCache.hasCastProgression()) {
            return false;
        }
        for (int i = 0; i < 100; ++i) {
            int numSpellsCastable = this.getCastForLevel(i, aPC);
            if (numSpellsCastable <= 0) continue;
            return true;
        }
        return false;
    }

    public int getKnownForLevel(int spellLevel, String bookName, PlayerCharacter aPC) {
        int maxSpellLevel;
        int total = 0;
        int stat = 0;
        String classKeyName = "CLASS." + this.source.getKeyName();
        String levelSpellLevel = ";LEVEL." + spellLevel;
        String allSpellLevel = ";LEVEL.All";
        int pcLevel = aPC.getLevel(this.source);
        pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", this.source.getKeyName());
        if (this.updateSpellCache(false) && this.spellCache.hasCastProgression() && this.getNumFromCastList(pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", "TYPE." + this.source.getSpellType()), spellLevel, aPC) < 0) {
            return (int)aPC.getTotalBonusTo("SPELLKNOWN", classKeyName + levelSpellLevel);
        }
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", classKeyName + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", "TYPE." + this.source.getSpellType() + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", "CLASS.Any" + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", classKeyName + ";LEVEL.All");
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", "TYPE." + this.source.getSpellType() + ";LEVEL.All");
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", "CLASS.Any;LEVEL.All");
        PCStat aStat = this.source.baseSpellStat();
        String statString = "None";
        if (aStat != null) {
            stat = aPC.getTotalStatFor(aStat);
            statString = aStat.getKeyName();
        }
        int bonusStat = (int)aPC.getTotalBonusTo("STAT", "KNOWN." + statString) + (int)aPC.getTotalBonusTo("STAT", "BASESPELLKNOWNSTAT") + (int)aPC.getTotalBonusTo("STAT", "BASESPELLKNOWNSTAT;CLASS=" + this.source.getKeyName());
        if (!this.source.getSafe(ObjectKey.USE_SPELL_SPELL_STAT).booleanValue() && !this.source.getSafe(ObjectKey.CASTER_WITHOUT_SPELL_STAT).booleanValue() && (maxSpellLevel = aPC.getVariableValue("MAXLEVELSTAT=" + statString, "").intValue()) + bonusStat < spellLevel) {
            return total;
        }
        stat += bonusStat;
        int mult = (int)aPC.getTotalBonusTo("SPELLKNOWNMULT", classKeyName + levelSpellLevel);
        if ((mult += (int)aPC.getTotalBonusTo("SPELLKNOWNMULT", "TYPE." + this.source.getSpellType() + levelSpellLevel)) < 1) {
            mult = 1;
        }
        if (!this.updateSpellCache(false)) {
            return total;
        }
        if (this.spellCache.hasKnownProgression()) {
            List<Formula> knownList = this.spellCache.getKnownForLevel(pcLevel);
            if (spellLevel >= 0 && knownList != null && spellLevel < knownList.size()) {
                int base;
                total += mult * knownList.get(spellLevel).resolve(aPC, "").intValue();
                BonusSpellInfo bsi = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(BonusSpellInfo.class, String.valueOf(spellLevel));
                if (Globals.checkRule("BONUSSPELLKNOWN") && bsi != null && bsi.isValid() && stat >= (base = bsi.getStatScore())) {
                    int range = bsi.getStatRange();
                    total += Math.max(0, (stat - base + range) / range);
                }
            }
        }
        if (total > 0 && spellLevel > 0) {
            total += this.source.getSafe(IntegerKey.KNOWN_SPELLS_FROM_SPECIALTY);
            Integer assoc = aPC.getDomainSpellCount(this.source);
            if (assoc != null) {
                total += assoc.intValue();
            }
        }
        return total += aPC.getKnownSpellCountForLevel(this.source.get(ObjectKey.CLASS_SPELLLIST), spellLevel);
    }

    public int getMinLevelForSpellLevel(int spellLevel, boolean allowBonus) {
        if (!this.updateSpellCache(false)) {
            return -1;
        }
        return this.spellCache.getMinLevelForSpellLevel(spellLevel, allowBonus);
    }

    public int getMaxSpellLevelForClassLevel(int classLevel) {
        if (!this.updateSpellCache(false)) {
            return -1;
        }
        return this.spellCache.getMaxSpellLevelForClassLevel(classLevel);
    }

    public boolean hasKnownList() {
        return this.updateSpellCache(false) && this.spellCache.hasKnownProgression();
    }

    public int getSpecialtyKnownForLevel(int spellLevel, PlayerCharacter aPC) {
        List<Formula> specKnown;
        int maxSpellLevel;
        int total = (int)aPC.getTotalBonusTo("SPECIALTYSPELLKNOWN", "CLASS." + this.source.getKeyName() + ";LEVEL." + spellLevel);
        total += (int)aPC.getTotalBonusTo("SPECIALTYSPELLKNOWN", "TYPE." + this.source.getSpellType() + ";LEVEL." + spellLevel);
        int pcLevel = aPC.getLevel(this.source);
        pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", this.source.getKeyName());
        pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", "TYPE." + this.source.getSpellType());
        PCStat aStat = this.source.baseSpellStat();
        if (aStat != null && spellLevel > (maxSpellLevel = aPC.getVariableValue("MAXLEVELSTAT=" + aStat.getKeyName(), "").intValue())) {
            return total;
        }
        if (this.updateSpellCache(false) && (specKnown = this.spellCache.getSpecialtyKnownForLevel(pcLevel)) != null && specKnown.size() > spellLevel) {
            total += specKnown.get(spellLevel).resolve(aPC, "").intValue();
        }
        total += this.source.getSafe(IntegerKey.KNOWN_SPELLS_FROM_SPECIALTY);
        Integer assoc = aPC.getDomainSpellCount(this.source);
        if (assoc != null) {
            total += assoc.intValue();
        }
        return total;
    }

    public boolean updateSpellCache(boolean force) {
        if (force || !this.spellCacheValid) {
            SpellProgressionCache cache = new SpellProgressionCache();
            for (PCClassLevel cl : this.source.getOriginalClassLevelCollection()) {
                List<Formula> spec;
                List<Formula> known;
                Integer lvl = cl.get(IntegerKey.LEVEL);
                List<Formula> cast = cl.getListFor(ListKey.CAST);
                if (cast != null) {
                    cache.setCast(lvl, cast);
                }
                if ((known = cl.getListFor(ListKey.KNOWN)) != null) {
                    cache.setKnown(lvl, known);
                }
                if ((spec = cl.getListFor(ListKey.SPECIALTYKNOWN)) == null) continue;
                cache.setSpecialtyKnown(lvl, spec);
            }
            if (!cache.isEmpty()) {
                this.spellCache = cache;
            }
            this.spellCacheValid = true;
        }
        return this.spellCache != null;
    }

    void calcCastPerDayMapForLevel(PlayerCharacter aPC) {
        if (this.castForLevelMap == null) {
            this.castForLevelMap = new HashMap(100);
        }
        for (int i = 0; i < 100; ++i) {
            int s = this.getCastForLevel(i, aPC);
            this.castForLevelMap.put(i, s);
        }
    }

    public boolean isAutoKnownSpell(Spell aSpell, int spellLevel, boolean useMap, PlayerCharacter aPC) {
        Integer val;
        List<KnownSpellIdentifier> knownSpellsList = this.source.getListFor(ListKey.KNOWN_SPELLS);
        if (knownSpellsList == null) {
            return false;
        }
        if (useMap ? (val = this.castForLevelMap.get(spellLevel)) == null || val == 0 || aSpell == null : this.getCastForLevel(spellLevel, aPC) == 0 || aSpell == null) {
            return false;
        }
        if (SpellCountCalc.isProhibited(aSpell, this.source, aPC) && !SpellCountCalc.isSpecialtySpell(aPC, this.source, aSpell)) {
            return false;
        }
        for (KnownSpellIdentifier filter : knownSpellsList) {
            if (!filter.matchesFilter(aSpell, spellLevel)) continue;
            return true;
        }
        return false;
    }

    public int getNumFromCastList(int iCasterLevel, int iSpellLevel, PlayerCharacter aPC) {
        if (iCasterLevel == 0) {
            return -1;
        }
        List<Formula> castListForLevel = this.getCastListForLevel(iCasterLevel);
        if (castListForLevel == null || iSpellLevel >= castListForLevel.size()) {
            return -1;
        }
        return castListForLevel.get(iSpellLevel).resolve(aPC, "").intValue();
    }

    public int getCastForLevel(int spellLevel, PlayerCharacter aPC) {
        return this.getCastForLevel(spellLevel, Globals.getDefaultSpellBook(), true, true, aPC);
    }

    public int getCastForLevel(int spellLevel, String bookName, boolean includeAdj, boolean limitByStat, PlayerCharacter aPC) {
        int base;
        int maxSpellLevel;
        PCStat ss;
        int pcLevel = aPC.getLevel(this.source);
        int total = 0;
        int stat = 0;
        String classKeyName = "CLASS." + this.source.getKeyName();
        String levelSpellLevel = ";LEVEL." + spellLevel;
        String allSpellLevel = ";LEVEL.All";
        pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", this.source.getKeyName());
        if (this.getNumFromCastList(pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", "TYPE." + this.source.getSpellType()), spellLevel, aPC) < 0) {
            return (int)aPC.getTotalBonusTo("SPELLCAST", classKeyName + levelSpellLevel);
        }
        total += (int)aPC.getTotalBonusTo("SPELLCAST", classKeyName + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLCAST", "TYPE." + this.source.getSpellType() + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLCAST", "CLASS.Any" + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLCAST", classKeyName + ";LEVEL.All");
        total += (int)aPC.getTotalBonusTo("SPELLCAST", "TYPE." + this.source.getSpellType() + ";LEVEL.All");
        total += (int)aPC.getTotalBonusTo("SPELLCAST", "CLASS.Any;LEVEL.All");
        PCStat aStat = this.source.bonusSpellStat();
        String statString = "None";
        if (aStat != null) {
            stat = aPC.getTotalStatFor(aStat);
            statString = aStat.getKeyName();
        }
        int bonusStat = (int)aPC.getTotalBonusTo("STAT", "CAST." + statString) + (int)aPC.getTotalBonusTo("STAT", "BASESPELLSTAT") + (int)aPC.getTotalBonusTo("STAT", "BASESPELLSTAT;CLASS=" + this.source.getKeyName());
        if (limitByStat && (ss = this.source.baseSpellStat()) != null && (maxSpellLevel = aPC.getVariableValue("MAXLEVELSTAT=" + ss.getKeyName(), "").intValue()) + bonusStat < spellLevel) {
            return total;
        }
        stat += bonusStat;
        int adj = 0;
        if (includeAdj && !bookName.equals(Globals.getDefaultSpellBook()) && (aPC.hasAssocs(this.source, AssociationKey.SPECIALTY) || aPC.hasDomains())) {
            for (int ix = 0; ix <= spellLevel; ++ix) {
                Collection<CharacterSpell> aList = aPC.getCharacterSpells((PObject)this.source, ix);
                Collection<Object> bList = new ArrayList();
                if (!aList.isEmpty()) {
                    if (ix > 0 && "DIVINE".equalsIgnoreCase(this.source.getSpellType())) {
                        for (Domain d : aPC.getDomainSet()) {
                            if (!this.source.getKeyName().equals(aPC.getDomainSource(d).getPcclass().getKeyName())) continue;
                            bList = aPC.getSpellsIn(d.get(ObjectKey.DOMAIN_SPELLLIST), ix);
                        }
                    }
                    for (CharacterSpell cs : aList) {
                        int x = -1;
                        if (!bList.isEmpty()) {
                            if (bList.contains(cs.getSpell())) {
                                x = 0;
                            }
                        } else {
                            x = cs.getInfoIndexFor(aPC, "", ix, 1);
                        }
                        if (x <= -1) continue;
                        PCClass target = this.source;
                        String subClassKey = aPC.getSubClassName(this.source);
                        if (subClassKey != null && subClassKey.length() > 0 && !subClassKey.equals("None")) {
                            target = this.source.getSubClassKeyed(subClassKey);
                        }
                        adj = aPC.getSpellSupport(target).getSpecialtyKnownForLevel(spellLevel, aPC);
                        break;
                    }
                }
                if (adj > 0) break;
            }
        }
        int mult = (int)aPC.getTotalBonusTo("SPELLCASTMULT", classKeyName + levelSpellLevel);
        if ((mult += (int)aPC.getTotalBonusTo("SPELLCASTMULT", "TYPE." + this.source.getSpellType() + levelSpellLevel)) < 1) {
            mult = 1;
        }
        int t = this.getNumFromCastList(pcLevel, spellLevel, aPC);
        total += t * mult + adj;
        BonusSpellInfo bsi = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(BonusSpellInfo.class, String.valueOf(spellLevel));
        if (bsi != null && bsi.isValid() && stat >= (base = bsi.getStatScore())) {
            int range = bsi.getStatRange();
            total += Math.max(0, (stat - base + range) / range);
        }
        return total;
    }

    public int getHighestLevelSpell(PlayerCharacter pc) {
        int mapHigh;
        String classKeyName = "CLASS." + this.source.getKeyName();
        int high = mapHigh = this.getHighestLevelSpell();
        for (int i = mapHigh; i < mapHigh + 30; ++i) {
            String levelSpellLevel = ";LEVEL." + i;
            StringBuilder stringBuilder = new StringBuilder();
            if (pc.getTotalBonusTo("SPELLCAST", stringBuilder.append(classKeyName).append(levelSpellLevel).toString()) > 0.0) {
                high = i;
                continue;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!(pc.getTotalBonusTo("SPELLKNOWN", stringBuilder2.append(classKeyName).append(levelSpellLevel).toString()) > 0.0)) continue;
            high = i;
        }
        return high;
    }

    public String getBonusCastForLevelString(int spellLevel, String bookName, PlayerCharacter aPC) {
        if (this.getCastForLevel(spellLevel, bookName, true, true, aPC) > 0) {
            if (aPC.hasAssocs(this.source, AssociationKey.SPECIALTY)) {
                PCClass target = this.source;
                String subClassKey = aPC.getSubClassName(this.source);
                if (subClassKey != null && subClassKey.length() > 0 && !subClassKey.equals("None")) {
                    target = this.source.getSubClassKeyed(subClassKey);
                }
                return "+" + aPC.getSpellSupport(target).getSpecialtyKnownForLevel(spellLevel, aPC);
            }
            if (!aPC.hasDomains()) {
                return "";
            }
            if (spellLevel > 0 && "DIVINE".equalsIgnoreCase(this.source.getSpellType())) {
                for (Domain d : aPC.getDomainSet()) {
                    if (!this.source.getKeyName().equals(aPC.getDomainSource(d).getPcclass().getKeyName())) continue;
                    return "+1";
                }
            }
        }
        return "";
    }

    public boolean hasKnownSpells(PlayerCharacter aPC) {
        for (int i = 0; i <= this.getHighestLevelSpell(); ++i) {
            if (this.getKnownForLevel(i, aPC) <= 0) continue;
            return true;
        }
        return false;
    }

    public int getKnownForLevel(int spellLevel, PlayerCharacter aPC) {
        return this.getKnownForLevel(spellLevel, "null", aPC);
    }
}

