/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.core.GameMode;
import pcgen.core.GameModeDisplay;
import pcgen.core.SettingsHandler;
import pcgen.core.character.EquipSlot;
import pcgen.core.system.MigrationRule;

public class SystemCollections {
    private static final Map<String, List<String>> birthplaceMap = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> cityMap = new HashMap<String, List<String>>();
    private static final List<GameMode> gameModeList = new ArrayList<GameMode>();
    private static final List<GameModeDisplay> gameModeDisplayList = new ArrayList<GameModeDisplay>();
    private static final Map<String, List<String>> hairStyleMap = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> interestsMap = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> locationMap = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> phobiaMap = new HashMap<String, List<String>>();
    private static final Map<String, Set<String>> phraseMap = new HashMap<String, Set<String>>();
    private static final Map<String, List<String>> speechMap = new HashMap<String, List<String>>();
    private static final Map<String, Set<String>> traitMap = new HashMap<String, Set<String>>();
    private static final Map<String, List<String>> bodyStructureMap = new HashMap<String, List<String>>();
    private static final Map<String, List<EquipSlot>> equipSlotMap = new HashMap<String, List<EquipSlot>>();
    private static final Map<String, List<MigrationRule>> migrationRuleMap = new HashMap<String, List<MigrationRule>>();

    private SystemCollections() {
    }

    public static GameMode getGameModeNamed(String aString) {
        for (GameMode gameMode : gameModeList) {
            if (!gameMode.getName().equalsIgnoreCase(aString)) continue;
            return gameMode;
        }
        return null;
    }

    public static GameMode getGameModeWithDisplayName(String aString) {
        for (GameMode gameMode : gameModeList) {
            if (!gameMode.getDisplayName().equalsIgnoreCase(aString)) continue;
            return gameMode;
        }
        return null;
    }

    public static List<String> getUnmodifiableBirthplaceList() {
        List<String> birthplaceList = birthplaceMap.get(SettingsHandler.getGame().getName());
        if (birthplaceList == null) {
            birthplaceList = birthplaceMap.get("*");
        }
        if (birthplaceList == null) {
            birthplaceList = Collections.emptyList();
        }
        return Collections.unmodifiableList(birthplaceList);
    }

    public static List<String> getUnmodifiableCityList() {
        List<String> cityList = cityMap.get(SettingsHandler.getGame().getName());
        if (cityList == null) {
            cityList = cityMap.get("*");
        }
        if (cityList == null) {
            cityList = Collections.emptyList();
        }
        return Collections.unmodifiableList(cityList);
    }

    public static List<EquipSlot> getUnmodifiableEquipSlotList() {
        List<EquipSlot> equipSlotList = equipSlotMap.get(SettingsHandler.getGame().getName());
        if (equipSlotList == null) {
            equipSlotList = equipSlotMap.get("*");
        }
        if (equipSlotList == null) {
            equipSlotList = Collections.emptyList();
        }
        return Collections.unmodifiableList(equipSlotList);
    }

    public static List<String> getUnmodifiableBodyStructureList() {
        List<String> bodyStructures = bodyStructureMap.get(SettingsHandler.getGame().getName());
        if (bodyStructures == null) {
            bodyStructures = bodyStructureMap.get("*");
        }
        if (bodyStructures == null) {
            bodyStructures = Collections.emptyList();
        }
        return Collections.unmodifiableList(bodyStructures);
    }

    public static List<MigrationRule> getUnmodifiableMigrationRuleList(String gameModeName) {
        List<MigrationRule> migrationRuleList = migrationRuleMap.get(gameModeName);
        if (migrationRuleList == null) {
            migrationRuleList = migrationRuleMap.get("*");
        }
        if (migrationRuleList == null) {
            migrationRuleList = Collections.emptyList();
        }
        return Collections.unmodifiableList(migrationRuleList);
    }

    public static List<GameMode> getUnmodifiableGameModeList() {
        return Collections.unmodifiableList(gameModeList);
    }

    public static List<GameModeDisplay> getUnmodifiableGameModeDisplayList() {
        return Collections.unmodifiableList(gameModeDisplayList);
    }

    public static List<String> getUnmodifiableHairStyleList() {
        List<String> hairStyleList = hairStyleMap.get(SettingsHandler.getGame().getName());
        if (hairStyleList == null) {
            hairStyleList = hairStyleMap.get("*");
        }
        if (hairStyleList == null) {
            hairStyleList = Collections.emptyList();
        }
        return Collections.unmodifiableList(hairStyleList);
    }

    public static List<String> getUnmodifiableInterestsList() {
        List<String> interestsList = interestsMap.get(SettingsHandler.getGame().getName());
        if (interestsList == null) {
            interestsList = interestsMap.get("*");
        }
        if (interestsList == null) {
            interestsList = Collections.emptyList();
        }
        return Collections.unmodifiableList(interestsList);
    }

    public static List<String> getUnmodifiableLocationList() {
        List<String> locationList = locationMap.get(SettingsHandler.getGame().getName());
        if (locationList == null) {
            locationList = locationMap.get("*");
        }
        if (locationList == null) {
            locationList = Collections.emptyList();
        }
        return Collections.unmodifiableList(locationList);
    }

    public static List<String> getUnmodifiablePhobiaList() {
        List<String> phobiaList = phobiaMap.get(SettingsHandler.getGame().getName());
        if (phobiaList == null) {
            phobiaList = phobiaMap.get("*");
        }
        if (phobiaList == null) {
            phobiaList = Collections.emptyList();
        }
        return Collections.unmodifiableList(phobiaList);
    }

    public static List<String> getUnmodifiablePhraseList() {
        Set<String> phraseSet = phraseMap.get(SettingsHandler.getGame().getName());
        if (phraseSet == null) {
            phraseSet = phraseMap.get("*");
        }
        if (phraseSet == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(phraseSet);
    }

    public static List<String> getUnmodifiableSpeechList() {
        List<String> speechList = speechMap.get(SettingsHandler.getGame().getName());
        if (speechList == null) {
            speechList = speechMap.get("*");
        }
        if (speechList == null) {
            speechList = Collections.emptyList();
        }
        return Collections.unmodifiableList(speechList);
    }

    public static List<String> getUnmodifiableTraitList() {
        Set<String> traitList = traitMap.get(SettingsHandler.getGame().getName());
        if (traitList == null) {
            traitList = traitMap.get("*");
        }
        if (traitList == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(traitList);
    }

    public static void addToBirthplaceList(String birthplace, String gameMode) {
        List<String> birthplaceList = birthplaceMap.get(gameMode);
        if (birthplaceList == null) {
            birthplaceList = new ArrayList<String>();
            birthplaceMap.put(gameMode, birthplaceList);
        }
        if (!birthplaceList.contains(birthplace)) {
            birthplaceList.add(birthplace);
        }
    }

    public static void addToCityList(String city, String gameMode) {
        List<String> cityList = cityMap.get(gameMode);
        if (cityList == null) {
            cityList = new ArrayList<String>();
            cityMap.put(gameMode, cityList);
        }
        if (!cityList.contains(city)) {
            cityList.add(city);
        }
    }

    public static void addToEquipSlotsList(EquipSlot equipmentSlot, String gameMode) {
        List<EquipSlot> equipSlotList = equipSlotMap.get(gameMode);
        if (equipSlotList == null) {
            equipSlotList = new ArrayList<EquipSlot>();
            equipSlotMap.put(gameMode, equipSlotList);
        }
        if (!equipSlotList.contains(equipmentSlot)) {
            equipSlotList.add(equipmentSlot);
        }
    }

    public static void addToBodyStructureList(String bodyStructure, String gameMode) {
        List<String> bodyStructureList = bodyStructureMap.get(gameMode);
        if (bodyStructureList == null) {
            bodyStructureList = new ArrayList<String>();
            bodyStructureMap.put(gameMode, bodyStructureList);
        }
        if (!bodyStructureList.contains(bodyStructure)) {
            bodyStructureList.add(bodyStructure);
        }
    }

    public static void addToMigrationRulesList(MigrationRule migrationRule, String gameMode) {
        List<MigrationRule> migrationRuleList = migrationRuleMap.get(gameMode);
        if (migrationRuleList == null) {
            migrationRuleList = new ArrayList<MigrationRule>();
            migrationRuleMap.put(gameMode, migrationRuleList);
        }
        if (!migrationRuleList.contains(migrationRule)) {
            migrationRuleList.add(migrationRule);
        }
    }

    public static void addToGameModeList(GameMode mode) {
        gameModeList.add(mode);
        gameModeDisplayList.add(new GameModeDisplay(mode));
    }

    public static void addToHairStyleList(String hairStyle, String gameMode) {
        List<String> hairStyleList = hairStyleMap.get(gameMode);
        if (hairStyleList == null) {
            hairStyleList = new ArrayList<String>();
            hairStyleMap.put(gameMode, hairStyleList);
        }
        if (!hairStyleList.contains(hairStyle)) {
            hairStyleList.add(hairStyle);
        }
        hairStyleList.add(hairStyle);
    }

    public static void addToInterestsList(String interest, String gameMode) {
        List<String> interestsList = interestsMap.get(gameMode);
        if (interestsList == null) {
            interestsList = new ArrayList<String>();
            interestsMap.put(gameMode, interestsList);
        }
        if (!interestsList.contains(interest)) {
            interestsList.add(interest);
        }
    }

    public static void addToLocationList(String location, String gameMode) {
        List<String> locationList = locationMap.get(gameMode);
        if (locationList == null) {
            locationList = new ArrayList<String>();
            locationMap.put(gameMode, locationList);
        }
        if (!locationList.contains(location)) {
            locationList.add(location);
        }
    }

    public static void addToPhobiaList(String phobia, String gameMode) {
        List<String> phobiaList = phobiaMap.get(gameMode);
        if (phobiaList == null) {
            phobiaList = new ArrayList<String>();
            phobiaMap.put(gameMode, phobiaList);
        }
        if (!phobiaList.contains(phobia)) {
            phobiaList.add(phobia);
        }
    }

    public static void addToPhraseList(String phrase, String gameMode) {
        Set<String> phraseList = phraseMap.get(gameMode);
        if (phraseList == null) {
            phraseList = new HashSet<String>();
            phraseMap.put(gameMode, phraseList);
        }
        phraseList.add(phrase);
    }

    public static void addToSpeechList(String speech, String gameMode) {
        List<String> speechList = speechMap.get(gameMode);
        if (speechList == null) {
            speechList = new ArrayList<String>();
            speechMap.put(gameMode, speechList);
        }
        if (!speechList.contains(speech)) {
            speechList.add(speech);
        }
    }

    public static void addToTraitList(String trait, String gameMode) {
        Set<String> traitList = traitMap.get(gameMode);
        if (traitList == null) {
            traitList = new HashSet<String>();
            traitMap.put(gameMode, traitList);
        }
        traitList.add(trait);
    }

    public static void clearEquipSlotsMap() {
        equipSlotMap.clear();
    }

    public static void clearMigrationRuleMap() {
        migrationRuleMap.clear();
    }

    public static void clearGameModeList() {
        gameModeList.clear();
        gameModeDisplayList.clear();
    }

    public static void sortGameModeList() {
        Collections.sort(gameModeList);
        Collections.sort(gameModeDisplayList);
    }
}

