/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import pcgen.core.chooser.InfoWrapper;
import pcgen.facade.core.ChooserFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DelegatingListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.FacadeListModel;
import pcgen.gui2.util.JListEx;
import pcgen.gui2.util.JTreeViewTable;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;

public class ChooserDialog
extends JDialog
implements ActionListener,
ReferenceListener<Integer>,
ListSelectionListener {
    private final ChooserFacade chooser;
    private final JTreeViewTable<InfoFacade> availTable;
    private final JTextField availInput;
    private final JLabel remainingLabel;
    private final GeneralTreeViewModel treeViewModel;
    private final FacadeListModel<InfoFacade> listModel;
    private final JListEx list;
    private final InfoPane infoPane;
    private boolean committed;

    public ChooserDialog(Frame frame, ChooserFacade chooser) {
        super(frame, true);
        this.chooser = chooser;
        if (chooser.isUserInput()) {
            this.availTable = null;
            this.availInput = new JTextField(20);
        } else {
            this.availTable = new JTreeViewTable();
            this.availInput = null;
        }
        this.remainingLabel = new JLabel();
        this.treeViewModel = new GeneralTreeViewModel();
        this.list = new JListEx();
        this.listModel = new FacadeListModel();
        this.infoPane = new InfoPane();
        this.treeViewModel.setDelegate(chooser.getAvailableList());
        this.listModel.setListFacade(chooser.getSelectedList());
        chooser.getRemainingSelections().addReferenceListener(this);
        this.overridePrefs();
        this.initComponents();
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        int method;
        ListFacade<InfoFacade> availableList = this.chooser.getAvailableList();
        if (availableList != null && availableList.getSize() == 1 && this.listModel.getSize() == 0 && b && !this.chooser.isUserInput() && (method = UIPropertyContext.getSingleChoiceAction()) != 0) {
            this.chooser.addSelected(availableList.getElementAt(0));
            if (method == 2) {
                this.chooser.commit();
                this.committed = true;
                return;
            }
        }
        super.setVisible(b);
    }

    private void overridePrefs() {
        UIPropertyContext baseContext = UIPropertyContext.createContext("tablePrefs");
        UIPropertyContext context = baseContext.createChildContext(this.treeViewModel.getDataView().getPrefsKey());
        String VIEW_INDEX_PREFS_KEY = "viewIdx";
        context.setInt("viewIdx", this.treeViewModel.getDefaultTreeViewIndex());
    }

    private void initComponents() {
        this.setTitle(this.chooser.getName());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ChooserDialog.this.treeViewModel.setDelegate(null);
                ChooserDialog.this.listModel.setListFacade(null);
                ChooserDialog.this.chooser.getRemainingSelections().removeReferenceListener(ChooserDialog.this);
            }
        });
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane();
        JPanel leftPane = new JPanel(new BorderLayout());
        if (this.availTable != null) {
            this.availTable.setTreeViewModel(this.treeViewModel);
            this.availTable.addActionListener(this);
            leftPane.add((Component)new JScrollPane(this.availTable), "Center");
        } else {
            this.availInput.addActionListener(this);
            Dimension maxDim = new Dimension(Integer.MAX_VALUE, this.availInput.getPreferredSize().height);
            this.availInput.setMaximumSize(maxDim);
            JPanel availPanel = new JPanel();
            availPanel.setLayout(new BoxLayout(availPanel, 3));
            availPanel.add(Box.createRigidArea(new Dimension(10, 30)));
            availPanel.add(Box.createVerticalGlue());
            availPanel.add(new JLabel(LanguageBundle.getString("in_uichooser_value")));
            availPanel.add(this.availInput);
            availPanel.add(Box.createVerticalGlue());
            leftPane.add((Component)availPanel, "West");
        }
        JPanel buttonPane1 = new JPanel(new FlowLayout());
        JButton addButton = new JButton(this.chooser.getAddButtonName());
        addButton.setActionCommand("ADD");
        addButton.addActionListener(this);
        buttonPane1.add(addButton);
        buttonPane1.add(new JLabel(Icons.Forward16.getImageIcon()));
        leftPane.add((Component)buttonPane1, "South");
        split.setLeftComponent(leftPane);
        JPanel rightPane = new JPanel(new BorderLayout());
        JPanel labelPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        labelPane.add((Component)new JLabel(this.chooser.getSelectionCountName()), new GridBagConstraints());
        this.remainingLabel.setText(this.chooser.getRemainingSelections().getReference().toString());
        labelPane.add((Component)this.remainingLabel, gbc);
        labelPane.add((Component)new JLabel(this.chooser.getSelectedTableTitle()), gbc);
        rightPane.add((Component)labelPane, "North");
        this.list.setModel(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addActionListener(this);
        rightPane.add((Component)new JScrollPane(this.list), "Center");
        JPanel buttonPane2 = new JPanel(new FlowLayout());
        buttonPane2.add(new JLabel(Icons.Back16.getImageIcon()));
        JButton removeButton = new JButton(this.chooser.getRemoveButtonName());
        removeButton.setActionCommand("REMOVE");
        removeButton.addActionListener(this);
        buttonPane2.add(removeButton);
        rightPane.add((Component)buttonPane2, "South");
        split.setRightComponent(rightPane);
        if (this.chooser.isInfoAvailable()) {
            JSplitPane infoSplit = new JSplitPane(0);
            infoSplit.setTopComponent(split);
            infoSplit.setBottomComponent(this.infoPane);
            infoSplit.setResizeWeight(0.8);
            pane.add((Component)infoSplit, "Center");
            if (this.availTable != null) {
                this.availTable.getSelectionModel().addListSelectionListener(this);
            }
        } else {
            pane.add((Component)split, "Center");
        }
        JPanel bottomPane = new JPanel(new FlowLayout());
        JButton button = new JButton(LanguageBundle.getString("in_ok"));
        button.setMnemonic(LanguageBundle.getMnemonic("in_mn_ok"));
        button.setActionCommand("OK");
        button.addActionListener(this);
        bottomPane.add(button);
        button = new JButton(LanguageBundle.getString("in_cancel"));
        button.setMnemonic(LanguageBundle.getMnemonic("in_mn_cancel"));
        button.setActionCommand("CANCEL");
        button.addActionListener(this);
        bottomPane.add(button);
        pane.add((Component)bottomPane, "South");
    }

    @Override
    public void referenceChanged(ReferenceEvent<Integer> e) {
        this.remainingLabel.setText(e.getNewReference().toString());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.availTable != null && !e.getValueIsAdjusting() && e.getSource() == this.availTable.getSelectionModel() && this.availTable.getSelectedObject() instanceof InfoFacade) {
            InfoFacade target = (InfoFacade)this.availTable.getSelectedObject();
            InfoFactory factory = this.chooser.getInfoFactory();
            if (factory != null && target != null) {
                this.infoPane.setText(factory.getHTMLInfo(target));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.availTable != null && (e.getActionCommand().equals("ADD") || e.getSource() == this.availTable)) {
            List<Object> data = this.availTable.getSelectedData();
            if (!data.isEmpty()) {
                for (Object object : data) {
                    if (!(object instanceof InfoFacade)) continue;
                    this.chooser.addSelected((InfoFacade)object);
                }
            }
            return;
        }
        if (this.availInput != null && (e.getActionCommand().equals("ADD") || e.getSource() == this.availInput)) {
            String data = this.availInput.getText();
            if (StringUtils.isNotBlank(data)) {
                this.chooser.addSelected(new InfoWrapper(data));
            }
            this.availInput.setText("");
            return;
        }
        if (e.getActionCommand().equals("REMOVE") || e.getSource() == this.list) {
            Object value = this.list.getSelectedValue();
            if (value != null && value instanceof InfoFacade) {
                this.chooser.removeSelected((InfoFacade)value);
                if (this.availInput != null) {
                    this.availInput.setText(value.toString());
                }
            }
            return;
        }
        if (e.getActionCommand().equals("OK")) {
            if (this.chooser.isRequireCompleteSelection() && this.chooser.getRemainingSelections().getReference() > 0) {
                JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_chooserRequireComplete", this.chooser.getRemainingSelections().getReference()), this.chooser.getName(), 1);
                return;
            }
            this.chooser.commit();
        } else {
            this.chooser.rollback();
        }
        this.committed = e.getActionCommand().equals("OK");
        this.dispose();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    private class ChooserTreeView
    implements TreeView<InfoFacade> {
        private String viewName;
        private final ChooserFacade chooser;
        private final ChooserFacade.ChooserTreeViewType viewType;

        private ChooserTreeView(ChooserFacade.ChooserTreeViewType viewType, String name, ChooserFacade chooser) {
            this.viewType = viewType;
            this.viewName = name;
            this.chooser = chooser;
        }

        @Override
        public String getViewName() {
            return this.viewName;
        }

        @Override
        public List<TreeViewPath<InfoFacade>> getPaths(InfoFacade pobj) {
            switch (this.viewType) {
                case TYPE_NAME: {
                    ArrayList<TreeViewPath<InfoFacade>> paths = new ArrayList<TreeViewPath<InfoFacade>>();
                    for (String type : this.chooser.getBranchNames(pobj)) {
                        paths.add(new TreeViewPath<InfoFacade>(pobj, (Object)type));
                    }
                    if (!paths.isEmpty()) {
                        return paths;
                    }
                }
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<InfoFacade>(pobj));
                }
            }
            throw new InternalError();
        }
    }

    private class GeneralTreeViewModel
    extends DelegatingListFacade<InfoFacade>
    implements TreeViewModel<InfoFacade>,
    DataView<InfoFacade> {
        private GeneralTreeViewModel() {
        }

        @Override
        public ListFacade<? extends TreeView<InfoFacade>> getTreeViews() {
            DefaultListFacade<ChooserTreeView> views = new DefaultListFacade<ChooserTreeView>();
            views.addElement(new ChooserTreeView(ChooserFacade.ChooserTreeViewType.NAME, ChooserDialog.this.chooser.getAvailableTableTitle(), ChooserDialog.this.chooser));
            views.addElement(new ChooserTreeView(ChooserFacade.ChooserTreeViewType.TYPE_NAME, ChooserDialog.this.chooser.getAvailableTableTypeNameTitle(), ChooserDialog.this.chooser));
            return views;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return ChooserDialog.this.chooser.getDefaultView().ordinal();
        }

        @Override
        public DataView<InfoFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<InfoFacade> getDataModel() {
            return this;
        }

        @Override
        public List<?> getData(InfoFacade obj) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return Collections.emptyList();
        }

        @Override
        public String getPrefsKey() {
            return ChooserDialog.this.chooser.getAvailableTableTypeNameTitle();
        }
    }
}

