/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.render.awt.viewer.PreviewPanel;
import pcgen.facade.core.CharacterFacade;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utility;
import pcgen.system.BatchExporter;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Logging;
import pcgen.util.fop.FopTask;

public class PrintPreviewDialog
extends JDialog
implements ActionListener {
    private static final String SHEET_COMMAND = "sheet";
    private static final String PAGE_COMMAND = "page";
    private static final String ZOOM_COMMAND = "zoom";
    private static final String ZOOM_IN_COMMAND = "zoomin";
    private static final String ZOOM_OUT_COMMAND = "zoomout";
    private static final String PRINT_COMMAND = "print";
    private static final String CANCEL_COMMAND = "cancel";
    private static final double ZOOM_MULTIPLIER = Math.pow(2.0, 0.125);
    private final CharacterFacade character;
    private final JComboBox sheetBox;
    private final JComboBox pageBox;
    private final JComboBox zoomBox;
    private final JButton zoomInButton;
    private final JButton zoomOutButton;
    private final JButton printButton;
    private final JButton cancelButton;
    private final JPanel previewPanelParent;
    private PreviewPanel previewPanel;
    private final JProgressBar progressBar;
    private final PCGenFrame frame;
    private Pageable pageable;

    public static void showPrintPreviewDialog(PCGenFrame frame) {
        PrintPreviewDialog dialog = new PrintPreviewDialog(frame);
        Utility.setDialogRelativeLocation(frame, dialog);
        dialog.setVisible(true);
    }

    private PrintPreviewDialog(PCGenFrame frame) {
        super((Frame)frame, true);
        this.frame = frame;
        this.character = frame.getSelectedCharacterRef().getReference();
        this.previewPanelParent = new JPanel(new GridLayout(1, 1));
        this.sheetBox = new JComboBox();
        this.progressBar = new JProgressBar();
        this.pageBox = new JComboBox();
        this.zoomBox = new JComboBox();
        this.zoomInButton = new JButton();
        this.zoomOutButton = new JButton();
        this.printButton = new JButton();
        this.cancelButton = new JButton();
        this.initComponents();
        this.initLayout();
        this.pack();
        new SheetLoader().execute();
    }

    private void initComponents() {
        this.setTitle("Print Preview");
        this.sheetBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setToolTipText(value.toString());
                }
                return this;
            }
        });
        this.sheetBox.setActionCommand(SHEET_COMMAND);
        this.sheetBox.addActionListener(this);
        this.pageBox.addItem("0 of 0");
        this.pageBox.setActionCommand(PAGE_COMMAND);
        this.pageBox.addActionListener(this);
        this.zoomBox.addItem(0.25);
        this.zoomBox.addItem(0.5);
        this.zoomBox.addItem(0.75);
        this.zoomBox.addItem(1.0);
        this.zoomBox.setSelectedItem(0.75);
        this.zoomBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                NumberFormat format = NumberFormat.getPercentInstance();
                value = format.format(value);
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.zoomBox.setEditable(true);
        this.zoomBox.setEditor(new PercentEditor(this.zoomBox));
        this.zoomBox.setActionCommand(ZOOM_COMMAND);
        this.zoomBox.addActionListener(this);
        this.zoomInButton.setIcon(Icons.ZoomIn16.getImageIcon());
        this.zoomInButton.setActionCommand(ZOOM_IN_COMMAND);
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.setIcon(Icons.ZoomOut16.getImageIcon());
        this.zoomOutButton.setActionCommand(ZOOM_OUT_COMMAND);
        this.zoomOutButton.addActionListener(this);
        this.printButton.setText("Print");
        this.printButton.setActionCommand(PRINT_COMMAND);
        this.printButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand(CANCEL_COMMAND);
        this.cancelButton.addActionListener(this);
        this.enableEditGroup(false);
        Utility.installEscapeCloseOperation(this);
    }

    private void enableEditGroup(boolean enable) {
        this.pageBox.setEnabled(enable);
        this.zoomBox.setEnabled(enable);
        this.zoomInButton.setEnabled(enable);
        this.zoomOutButton.setEnabled(enable);
        this.printButton.setEnabled(enable);
    }

    private void setPreviewPanel(PreviewPanel previewPanel) {
        this.previewPanelParent.removeAll();
        this.previewPanel = previewPanel;
        this.previewPanelParent.add((Component)previewPanel);
        previewPanel.reload();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (SHEET_COMMAND.equals(e.getActionCommand())) {
            new PreviewLoader((URI)this.sheetBox.getSelectedItem()).execute();
        } else if (PAGE_COMMAND.equals(e.getActionCommand())) {
            this.previewPanel.setPage(this.pageBox.getSelectedIndex());
        } else if (ZOOM_COMMAND.equals(e.getActionCommand())) {
            Double zoom = (Double)this.zoomBox.getSelectedItem();
            this.previewPanel.setScaleFactor(zoom.doubleValue());
        } else if (ZOOM_IN_COMMAND.equals(e.getActionCommand())) {
            Double zoom = (Double)this.zoomBox.getSelectedItem();
            this.zoomBox.setSelectedItem(zoom * ZOOM_MULTIPLIER);
        } else if (ZOOM_OUT_COMMAND.equals(e.getActionCommand())) {
            Double zoom = (Double)this.zoomBox.getSelectedItem();
            this.zoomBox.setSelectedItem(zoom / ZOOM_MULTIPLIER);
        } else if (PRINT_COMMAND.equals(e.getActionCommand())) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPageable(this.pageable);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                    this.dispose();
                }
                catch (PrinterException ex) {
                    String message = "Could not print " + this.character.getNameRef().getReference();
                    Logging.errorPrint(message, ex);
                    this.frame.showErrorMessage("PCGen", message);
                }
            }
        } else if (CANCEL_COMMAND.equals(e.getActionCommand())) {
            this.dispose();
        }
    }

    private void initLayout() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel bar = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 256;
        gbc.insets = new Insets(8, 6, 8, 2);
        bar.add((Component)new JLabel("Select Template:"), gbc);
        gbc.insets = new Insets(8, 2, 8, 6);
        gbc.weightx = 1.0;
        bar.add((Component)this.sheetBox, gbc);
        pane.add((Component)bar, "North");
        Box vbox = Box.createVerticalBox();
        this.previewPanelParent.setPreferredSize(new Dimension(600, 800));
        vbox.add(this.previewPanelParent);
        vbox.add(this.progressBar);
        pane.add((Component)vbox, "Center");
        Box hbox = Box.createHorizontalBox();
        hbox.add(new JLabel("Page:"));
        hbox.add(Box.createHorizontalStrut(4));
        hbox.add(this.pageBox);
        hbox.add(Box.createHorizontalStrut(10));
        hbox.add(new JLabel("Zoom:"));
        hbox.add(Box.createHorizontalStrut(4));
        hbox.add(this.zoomBox);
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.zoomInButton);
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.zoomOutButton);
        hbox.add(Box.createHorizontalGlue());
        hbox.add(this.printButton);
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.cancelButton);
        hbox.setBorder(BorderFactory.createEmptyBorder(8, 5, 8, 5));
        pane.add((Component)hbox, "South");
    }

    private static ComboBoxModel createPagesModel(int pages) {
        String[] pageNumbers = new String[pages];
        for (int i = 0; i < pages; ++i) {
            pageNumbers[i] = i + 1 + " of " + pages;
        }
        return new DefaultComboBoxModel<String>(pageNumbers);
    }

    private class SheetLoader
    extends SwingWorker<Object[], Object>
    implements FilenameFilter {
        private SheetLoader() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return dir.getName().equalsIgnoreCase("pdf");
        }

        @Override
        protected Object[] doInBackground() throws Exception {
            IOFileFilter pdfFilter = FileFilterUtils.asFileFilter((FilenameFilter)this);
            IOFileFilter suffixFilter = FileFilterUtils.notFileFilter((IOFileFilter)new SuffixFileFilter(".fo"));
            IOFileFilter sheetFilter = FileFilterUtils.prefixFileFilter((String)"csheet");
            IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{pdfFilter, suffixFilter, sheetFilter});
            IOFileFilter dirFilter = FileFilterUtils.makeSVNAware((IOFileFilter)TrueFileFilter.INSTANCE);
            File dir = new File(ConfigurationSettings.getOutputSheetsDir());
            Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
            URI osPath = new File(ConfigurationSettings.getOutputSheetsDir()).toURI();
            Object[] uriList = new Object[files.size()];
            int i = 0;
            for (File file : files) {
                uriList[i] = osPath.relativize(file.toURI());
                ++i;
            }
            return uriList;
        }

        @Override
        protected void done() {
            try {
                DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>((Object[])this.get());
                model.setSelectedItem(null);
                PrintPreviewDialog.this.sheetBox.setModel(model);
            }
            catch (InterruptedException ex) {
                Logging.errorPrint("could not load sheets", ex);
            }
            catch (ExecutionException ex) {
                Logging.errorPrint("could not load sheets", ex.getCause());
            }
        }
    }

    private class PreviewLoader
    extends SwingWorker<AWTRenderer, Object> {
        private URI uri;

        public PreviewLoader(URI uri) {
            this.uri = uri;
            PrintPreviewDialog.this.progressBar.setIndeterminate(true);
            PrintPreviewDialog.this.sheetBox.setEnabled(false);
            PrintPreviewDialog.this.enableEditGroup(false);
        }

        @Override
        protected AWTRenderer doInBackground() throws Exception {
            URI osPath = new File(ConfigurationSettings.getOutputSheetsDir()).toURI();
            File xsltFile = new File(osPath.resolve(this.uri));
            AWTRenderer renderer = new AWTRenderer();
            renderer.setPreviewDialogDisplayed(false);
            PipedOutputStream out = new PipedOutputStream();
            FopTask task = FopTask.newFopTask((InputStream)new PipedInputStream(out), xsltFile, (Renderer)renderer);
            Thread thread = new Thread((Runnable)task, "fop-preview");
            thread.setDaemon(true);
            thread.start();
            BatchExporter.exportCharacter(PrintPreviewDialog.this.character, out);
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                thread.interrupt();
            }
            return renderer;
        }

        @Override
        protected void done() {
            PrintPreviewDialog.this.progressBar.setIndeterminate(false);
            PrintPreviewDialog.this.sheetBox.setEnabled(true);
            PrintPreviewDialog.this.enableEditGroup(true);
            try {
                AWTRenderer renderer = (AWTRenderer)this.get();
                PrintPreviewDialog.this.pageable = (Pageable)renderer;
                PrintPreviewDialog.this.setPreviewPanel(new PreviewPanel(renderer.getUserAgent(), null, renderer));
                PrintPreviewDialog.this.pageBox.setModel(PrintPreviewDialog.createPagesModel(renderer.getNumberOfPages()));
            }
            catch (InterruptedException ex) {
                Logging.errorPrint("Could not load sheet", ex);
            }
            catch (ExecutionException ex) {
                Logging.errorPrint("Could not load sheet", ex.getCause());
            }
        }
    }

    private static class PercentEditor
    extends JFormattedTextField
    implements ComboBoxEditor,
    PropertyChangeListener {
        public PercentEditor(JComboBox comboBox) {
            super(NumberFormat.getPercentInstance());
            this.addPropertyChangeListener("value", this);
            JComponent oldEditor = (JComponent)comboBox.getEditor().getEditorComponent();
            this.setBorder(oldEditor.getBorder());
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            this.setValue(anObject);
        }

        @Override
        public Object getItem() {
            return this.getValue();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireActionPerformed();
        }
    }
}

