/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.filter;

import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.SortedListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilteredListFacade;
import pcgen.gui2.util.table.SortableTableModel;

public abstract class FilteredListFacadeTableModel<E>
extends AbstractTableModel
implements SortableTableModel,
ListListener<E> {
    protected final SortedListFacade<E> sortedList;
    private final FilteredListFacade<CharacterFacade, E> filteredList;
    protected final CharacterFacade character;

    public FilteredListFacadeTableModel() {
        this(null);
    }

    public FilteredListFacadeTableModel(CharacterFacade character) {
        this.character = character;
        this.filteredList = new FilteredListFacade();
        this.filteredList.setContext(character);
        this.sortedList = new SortedListFacade<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return 0;
            }
        });
        this.sortedList.addListListener(this);
        this.sortedList.setDelegate(this.filteredList);
    }

    protected void setDelegate(ListFacade<E> delegate) {
        this.filteredList.setDelegate(delegate);
    }

    public void setFilter(Filter<? super CharacterFacade, ? super E> filter) {
        this.filteredList.setFilter(filter);
    }

    public void refilter() {
        this.filteredList.refilter();
    }

    @Override
    public int getRowCount() {
        return this.sortedList.getSize();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(this.sortedList.getElementAt(rowIndex), columnIndex);
    }

    protected abstract Object getValueAt(E var1, int var2);

    @Override
    public void sortModel(Comparator<List<?>> comparator) {
        if (comparator == null) {
            return;
        }
        this.sortedList.setComparator(new RowComparator(comparator));
    }

    @Override
    public void elementAdded(ListEvent<E> e) {
        this.fireTableRowsInserted(e.getIndex(), e.getIndex());
    }

    @Override
    public void elementRemoved(ListEvent<E> e) {
        this.fireTableRowsDeleted(e.getIndex(), e.getIndex());
    }

    @Override
    public void elementsChanged(ListEvent<E> e) {
        this.fireTableDataChanged();
    }

    @Override
    public void elementModified(ListEvent<E> e) {
        this.fireTableRowsUpdated(e.getIndex(), e.getIndex());
    }

    private class RowComparator
    implements Comparator<E> {
        private Comparator<List<?>> comp;

        public RowComparator(Comparator<List<?>> comparator) {
            this.comp = comparator;
        }

        @Override
        public int compare(E o1, E o2) {
            return this.comp.compare(new RowList(o1), new RowList(o2));
        }
    }

    private class RowList
    extends AbstractList<Object> {
        private final E element;

        public RowList(E element) {
            this.element = element;
        }

        @Override
        public Object get(int index) {
            return FilteredListFacadeTableModel.this.getValueAt(this.element, index);
        }

        @Override
        public int size() {
            return FilteredListFacadeTableModel.this.getColumnCount();
        }
    }
}

