/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.models.CharacterTreeCellRenderer;
import pcgen.gui2.tabs.models.ConcurrentDataView;
import pcgen.gui2.tabs.models.QualifiedTreeCellRenderer;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.SortMode;
import pcgen.gui2.util.SortingPriority;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class RaceInfoTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private static final TabTitle title = new TabTitle(Tab.RACE);
    private final FilteredTreeViewTable<Object, RaceFacade> raceTable = new FilteredTreeViewTable();
    private final FilteredTreeViewTable<Object, RaceFacade> selectedTable = new FilteredTreeViewTable();
    private final InfoPane infoPane = new InfoPane(LanguageBundle.getString("in_irRaceInfo"));
    private final JButton selectRaceButton = new JButton();
    private final JButton removeButton = new JButton();
    private final FilterButton<Object, RaceFacade> qFilterButton = new FilterButton("RaceQualified");
    private final FilterButton<Object, RaceFacade> noRacialHdFilterButton = new FilterButton("RaceNoHD");
    private final QualifiedTreeCellRenderer qualifiedRenderer = new QualifiedTreeCellRenderer();

    public RaceInfoTab() {
        super("Race");
        this.initComponents();
    }

    private void initComponents() {
        FlippingSplitPane topPane = new FlippingSplitPane("RaceTop");
        this.setTopComponent(topPane);
        this.setOrientation(0);
        JPanel availPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> bar = new FilterBar<Object, Object>();
        bar.addDisplayableFilter(new SearchFilterPanel());
        this.noRacialHdFilterButton.setText(LanguageBundle.getString("in_irNoRacialHd"));
        this.noRacialHdFilterButton.setToolTipText(LanguageBundle.getString("in_irNoRacialHdTip"));
        bar.addDisplayableFilter(this.noRacialHdFilterButton);
        this.qFilterButton.setText(LanguageBundle.getString("in_igQualFilter"));
        bar.addDisplayableFilter(this.qFilterButton);
        this.raceTable.setDisplayableFilter(bar);
        availPanel.add(bar, "North");
        this.raceTable.getSelectionModel().setSelectionMode(0);
        this.raceTable.setTreeCellRenderer(this.qualifiedRenderer);
        this.raceTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.raceTable.sortModel();
        availPanel.add((Component)new JScrollPane(this.raceTable), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.selectRaceButton.setHorizontalTextPosition(10);
        box.add(this.selectRaceButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        availPanel.add((Component)box, "South");
        topPane.setLeftComponent(availPanel);
        JPanel selPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.selectedTable.setDisplayableFilter(filterBar);
        this.selectedTable.setTreeCellRenderer(this.qualifiedRenderer);
        this.selectedTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.selectedTable.sortModel();
        JScrollPane scrollPane = new JScrollPane(this.selectedTable);
        selPanel.add((Component)scrollPane, "Center");
        scrollPane.setPreferredSize(new Dimension(0, 0));
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(this.removeButton);
        box.add(Box.createHorizontalGlue());
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        selPanel.add((Component)box, "South");
        topPane.setRightComponent(selPanel);
        topPane.setResizeWeight(0.75);
        this.setBottomComponent(this.infoPane);
        this.setResizeWeight(0.75);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(SelectRaceAction.class, new SelectRaceAction(character));
        models.put(RemoveRaceAction.class, new RemoveRaceAction(character));
        models.put(TreeViewModelHandler.class, new TreeViewModelHandler(character));
        models.put(InfoHandler.class, new InfoHandler(character));
        models.put(CharacterTreeCellRenderer.Handler.class, this.qualifiedRenderer.createHandler(character));
        models.put(QualifiedFilterHandler.class, new QualifiedFilterHandler(character));
        models.put(NoRacialHdFilterHandler.class, new NoRacialHdFilterHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(QualifiedFilterHandler.class).install();
        models.get(NoRacialHdFilterHandler.class).install();
        models.get(CharacterTreeCellRenderer.Handler.class).install();
        models.get(TreeViewModelHandler.class).install();
        models.get(InfoHandler.class).install();
        models.get(SelectRaceAction.class).install();
        models.get(RemoveRaceAction.class).install();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(TreeViewModelHandler.class).uninstall();
        models.get(InfoHandler.class).uninstall();
        models.get(SelectRaceAction.class).uninstall();
        models.get(RemoveRaceAction.class).uninstall();
        models.get(CharacterTreeCellRenderer.Handler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return title;
    }

    private static enum RaceTreeView implements TreeView<RaceFacade>
    {
        NAME(LanguageBundle.getString("in_nameLabel")),
        TYPE_NAME(LanguageBundle.getString("in_typeName")),
        RACETYPE_NAME(LanguageBundle.getString("in_racetypeName")),
        RACETYPE_RACE_SUBTYPE_NAME(LanguageBundle.getString("in_racetypeSubtypeName")),
        SOURCE_NAME(LanguageBundle.getString("in_sourceName"));

        private String name;

        private RaceTreeView(String name) {
            this.name = name;
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<RaceFacade>> getPaths(RaceFacade pobj) {
            switch (this) {
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<RaceFacade>(pobj));
                }
                case TYPE_NAME: {
                    return Collections.singletonList(new TreeViewPath<RaceFacade>(pobj, (Object)pobj.getType()));
                }
                case RACETYPE_RACE_SUBTYPE_NAME: {
                    List<String> subtypes = pobj.getRaceSubTypes();
                    if (!subtypes.isEmpty()) {
                        ArrayList<TreeViewPath<RaceFacade>> paths = new ArrayList<TreeViewPath<RaceFacade>>();
                        String raceType = pobj.getRaceType();
                        for (String subtype : subtypes) {
                            paths.add(new TreeViewPath<RaceFacade>(pobj, raceType, subtype));
                        }
                        return paths;
                    }
                    return Collections.singletonList(new TreeViewPath<RaceFacade>(pobj, (Object)pobj.getRaceType()));
                }
                case RACETYPE_NAME: {
                    return Collections.singletonList(new TreeViewPath<RaceFacade>(pobj, (Object)pobj.getRaceType()));
                }
                case SOURCE_NAME: {
                    return Collections.singletonList(new TreeViewPath<RaceFacade>(pobj, (Object)pobj.getSourceForNodeDisplay()));
                }
            }
            throw new InternalError();
        }
    }

    private static class RaceTreeViewModel
    implements TreeViewModel<RaceFacade> {
        private static final DefaultListFacade<? extends TreeView<RaceFacade>> treeViews = new DefaultListFacade<RaceTreeView>(Arrays.asList(RaceTreeView.values()));
        private final CharacterFacade character;
        private final boolean isAvailModel;
        private final DataView<RaceFacade> dataView;

        public RaceTreeViewModel(CharacterFacade character, boolean isAvailModel, DataView<RaceFacade> dataView) {
            this.character = character;
            this.isAvailModel = isAvailModel;
            this.dataView = dataView;
        }

        @Override
        public ListFacade<? extends TreeView<RaceFacade>> getTreeViews() {
            return treeViews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<RaceFacade> getDataView() {
            return this.dataView;
        }

        @Override
        public ListFacade<RaceFacade> getDataModel() {
            if (this.isAvailModel) {
                return this.character.getDataSet().getRaces();
            }
            return this.character.getRaceAsList();
        }
    }

    private class RaceDataView
    extends ConcurrentDataView<RaceFacade> {
        private final List<DefaultDataViewColumn> columns;
        private final InfoFactory infoFactory;
        private final boolean isAvailModel;

        public RaceDataView(CharacterFacade character, boolean isAvailModel) {
            this.infoFactory = character.getInfoFactory();
            this.isAvailModel = isAvailModel;
            this.columns = isAvailModel ? Arrays.asList(new DefaultDataViewColumn("in_irTableStat", String.class, true), new DefaultDataViewColumn("in_preReqs", String.class), new DefaultDataViewColumn("in_size", String.class, true), new DefaultDataViewColumn("in_movement", String.class, true), new DefaultDataViewColumn("in_vision", String.class), new DefaultDataViewColumn("in_favoredClass", String.class, true), new DefaultDataViewColumn("in_lvlAdj", String.class, true), new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_source", String.class, false)) : Arrays.asList(new DefaultDataViewColumn("in_irTableStat", String.class, false), new DefaultDataViewColumn("in_preReqs", String.class, false), new DefaultDataViewColumn("in_size", String.class, false), new DefaultDataViewColumn("in_movement", String.class, false), new DefaultDataViewColumn("in_vision", String.class, false), new DefaultDataViewColumn("in_favoredClass", String.class, false), new DefaultDataViewColumn("in_lvlAdj", String.class, false), new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_source", String.class, false));
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        @Override
        public String getPrefsKey() {
            return this.isAvailModel ? "RaceTreeAvail" : "RaceTreeSelected";
        }

        @Override
        protected List<?> getDataList(RaceFacade obj) {
            return Arrays.asList(this.infoFactory.getStatAdjustments(obj), this.infoFactory.getPreReqHTML(obj), obj.getSize(), this.infoFactory.getMovement(obj), this.infoFactory.getVision(obj), this.infoFactory.getFavoredClass(obj), this.infoFactory.getLevelAdjustment(obj), this.infoFactory.getDescription(obj), obj.getSource());
        }

        @Override
        protected void refreshTableData() {
            if (this.isAvailModel) {
                RaceInfoTab.this.raceTable.refreshModelData();
            } else {
                RaceInfoTab.this.selectedTable.refreshModelData();
            }
        }
    }

    private class TreeViewModelHandler {
        private final RaceDataView availableView;
        private final RaceDataView selectedView;
        private final RaceTreeViewModel availableModel;
        private final RaceTreeViewModel selectedModel;

        public TreeViewModelHandler(CharacterFacade character) {
            this.availableView = new RaceDataView(character, true);
            this.selectedView = new RaceDataView(character, false);
            this.availableModel = new RaceTreeViewModel(character, true, this.availableView);
            this.selectedModel = new RaceTreeViewModel(character, false, this.selectedView);
        }

        public void install() {
            RaceInfoTab.this.raceTable.setTreeViewModel(this.availableModel);
            RaceInfoTab.this.selectedTable.setTreeViewModel(this.selectedModel);
            this.availableView.install();
            this.selectedView.install();
        }

        public void uninstall() {
            this.availableView.uninstall();
            this.selectedView.uninstall();
        }
    }

    private class QualifiedFilterHandler
    implements Filter<Object, RaceFacade> {
        private final CharacterFacade character;

        public QualifiedFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            RaceInfoTab.this.qFilterButton.setFilter(this);
        }

        @Override
        public boolean accept(Object context, RaceFacade element) {
            return this.character.isQualifiedFor(element);
        }
    }

    private class NoRacialHdFilterHandler
    implements Filter<Object, RaceFacade> {
        private final InfoFactory infoFactory;

        public NoRacialHdFilterHandler(CharacterFacade character) {
            this.infoFactory = character.getInfoFactory();
        }

        public void install() {
            RaceInfoTab.this.noRacialHdFilterButton.setFilter(this);
        }

        @Override
        public boolean accept(Object context, RaceFacade element) {
            return this.infoFactory.getNumMonsterClassLevels(element) == 0;
        }
    }

    private class RemoveRaceAction
    extends AbstractAction {
        private final CharacterFacade character;

        public RemoveRaceAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_irUnselectRace"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.setRace(null);
        }

        public void install() {
            RaceInfoTab.this.selectedTable.addActionListener(this);
            RaceInfoTab.this.removeButton.setAction(this);
        }

        public void uninstall() {
            RaceInfoTab.this.selectedTable.removeActionListener(this);
        }
    }

    private class SelectRaceAction
    extends AbstractAction {
        private final CharacterFacade character;

        public SelectRaceAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_irSelectRace"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = RaceInfoTab.this.raceTable.getSelectedObject();
            if (obj instanceof RaceFacade) {
                this.character.setRace((RaceFacade)obj);
            }
        }

        public void install() {
            RaceInfoTab.this.raceTable.addActionListener(this);
            RaceInfoTab.this.selectRaceButton.setAction(this);
        }

        public void uninstall() {
            RaceInfoTab.this.raceTable.removeActionListener(this);
        }
    }

    private class InfoHandler
    implements ListSelectionListener {
        private final CharacterFacade character;
        private String text;

        public InfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
        }

        public void install() {
            RaceInfoTab.this.raceTable.getSelectionModel().addListSelectionListener(this);
            RaceInfoTab.this.selectedTable.getSelectionModel().addListSelectionListener(this);
            RaceInfoTab.this.infoPane.setText(this.text);
        }

        public void uninstall() {
            RaceInfoTab.this.raceTable.getSelectionModel().removeListSelectionListener(this);
            RaceInfoTab.this.selectedTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object obj = null;
                if (e.getSource() == RaceInfoTab.this.raceTable.getSelectionModel()) {
                    int selectedRow = RaceInfoTab.this.raceTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = RaceInfoTab.this.raceTable.getModel().getValueAt(selectedRow, 0);
                    }
                } else {
                    int selectedRow = RaceInfoTab.this.selectedTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = RaceInfoTab.this.selectedTable.getModel().getValueAt(selectedRow, 0);
                    }
                }
                if (obj instanceof RaceFacade) {
                    this.text = this.character.getInfoFactory().getHTMLInfo((RaceFacade)obj);
                    RaceInfoTab.this.infoPane.setText(this.text);
                }
            }
        }
    }
}

