/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import pcgen.core.SettingsHandler;
import pcgen.gui2.UIPropertyContext;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class TipOfTheDayHandler {
    private static final UIPropertyContext propertyContext = UIPropertyContext.createContext("TipOfTheDay");
    private static TipOfTheDayHandler INSTANCE = null;
    private List<String> tipList = null;
    private int lastNumber = propertyContext.initInt("lastTip", -1);

    private TipOfTheDayHandler() {
    }

    public static synchronized TipOfTheDayHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TipOfTheDayHandler();
        }
        return INSTANCE;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public synchronized void loadTips() {
        this.tipList = new ArrayList<String>(20);
        String systemDir = ConfigurationSettings.getSystemsDir();
        String tipsFileName = LanguageBundle.getString("in_tipsFileName");
        String tipsFileNameDefault = "tips.txt";
        String tipsFilePath = systemDir + File.separator + "gameModes" + File.separator + SettingsHandler.getGame().getName() + File.separator;
        String tipsDefaultPath = systemDir + File.separator + "gameModes" + File.separator + "default" + File.separator;
        Object[] tipFiles = new String[]{tipsFilePath + tipsFileName, tipsDefaultPath + tipsFileName, tipsFilePath + tipsFileNameDefault, tipsDefaultPath + tipsFileNameDefault};
        boolean loaded = false;
        for (String string : tipFiles) {
            try {
                this.loadTipFile(string);
                Logging.log(Logging.INFO, "Loaded tips from " + string);
                loaded = true;
                break;
            }
            catch (FileNotFoundException e) {
                if (!Logging.isDebugMode()) continue;
                Logging.debugPrint("Unable to load tips file " + string, e);
            }
            catch (IOException e) {
                if (!Logging.isDebugMode()) continue;
                Logging.debugPrint("Unable to load tips file " + string, e);
            }
        }
        if (!loaded) {
            Logging.errorPrint("Warning: game mode " + SettingsHandler.getGame().getName() + " is missing tips. Tried all of " + StringUtils.join(tipFiles, "\n"));
        }
    }

    private void loadTipFile(String tipsFilePath) throws FileNotFoundException, IOException {
        File tipsFile = new File(tipsFilePath);
        BufferedReader tipsReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tipsFile), "UTF-8"));
        int length = (int)tipsFile.length();
        char[] inputLine = new char[length];
        tipsReader.read(inputLine, 0, length);
        tipsReader.close();
        StringTokenizer aTok = new StringTokenizer(new String(inputLine), "\r\n", false);
        while (aTok.hasMoreTokens()) {
            String line = aTok.nextToken();
            if (line.trim().length() <= 0 || line.charAt(0) == '#') continue;
            this.tipList.add(line);
        }
    }

    public synchronized boolean hasTips() {
        return this.tipList != null && this.tipList.size() > 0;
    }

    public synchronized String getNextTip() {
        if (this.hasTips()) {
            if (++this.lastNumber >= this.tipList.size()) {
                this.lastNumber = 0;
            }
            propertyContext.setInt("lastTip", this.lastNumber);
            return this.tipList.get(this.lastNumber);
        }
        return "";
    }

    public synchronized String getPrevTip() {
        if (this.hasTips()) {
            if (--this.lastNumber < 0) {
                this.lastNumber = this.tipList.size() - 1;
            }
            propertyContext.setInt("lastTip", this.lastNumber);
            return this.tipList.get(this.lastNumber);
        }
        return "";
    }
}

