/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.BiographyField;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.PCStringKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.helper.ClassSource;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.BonusManager;
import pcgen.core.ChronicleEntry;
import pcgen.core.Deity;
import pcgen.core.Description;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.NoteItem;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellProhibitor;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.display.BonusDisplay;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.pclevelinfo.PCLevelInfoStat;
import pcgen.core.spell.Spell;
import pcgen.facade.core.CampaignFacade;
import pcgen.io.Cache;
import pcgen.io.Compatibility;
import pcgen.io.EntityEncoder;
import pcgen.io.IOConstants;
import pcgen.system.PCGenPropBundle;
import pcgen.util.FileHelper;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;

public final class PCGVer2Creator
implements IOConstants {
    private final PlayerCharacter thePC;
    private final CharacterDisplay charDisplay;
    private GameMode mode;
    private List<? extends CampaignFacade> campaigns;

    public PCGVer2Creator(PlayerCharacter aPC, GameMode mode, List<? extends CampaignFacade> campaigns) {
        this.thePC = aPC;
        this.charDisplay = aPC.getDisplay();
        this.mode = mode;
        this.campaigns = campaigns;
    }

    public String createPCGString() {
        StringBuilder buffer = new StringBuilder(1000);
        PCGVer2Creator.appendPCGVersionLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("System Information", buffer);
        this.appendCampaignLine(buffer);
        PCGVer2Creator.appendVersionLine(buffer);
        this.appendRollMethodLine(buffer);
        this.appendPurchasePointsLine(buffer);
        this.appendCharacterTypeLine(buffer);
        this.appendPreviewSheetLine(buffer);
        this.appendPoolPointsLine(buffer);
        this.appendGameModeLine(buffer);
        PCGVer2Creator.appendTabLabelLine(buffer);
        this.appendAutoSpellsLine(buffer);
        this.appendUseHigherSpellSlotsLines(buffer);
        this.appendLoadCompanionLine(buffer);
        this.appendUseTempModsLine(buffer);
        this.appendOutputSheetsLines(buffer);
        this.appendAutoSortLines(buffer);
        this.appendSkillFilterLine(buffer);
        this.appendGearCostSizeLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Bio", buffer);
        this.appendCharacterNameLine(buffer);
        this.appendTabNameLine(buffer);
        this.appendPlayerNameLine(buffer);
        this.appendHeightLine(buffer);
        this.appendWeightLine(buffer);
        this.appendAgeLine(buffer);
        this.appendGenderLine(buffer);
        this.appendHandedLine(buffer);
        this.appendSkinColorLine(buffer);
        this.appendEyeColorLine(buffer);
        this.appendHairColorLine(buffer);
        this.appendHairStyleLine(buffer);
        this.appendLocationLine(buffer);
        this.appendResidenceLine(buffer);
        this.appendBirthdayLine(buffer);
        this.appendBirthplaceLine(buffer);
        this.appendPersonalityTrait1Line(buffer);
        this.appendPersonalityTrait2Line(buffer);
        this.appendSpeechPatternLine(buffer);
        this.appendPhobiasLine(buffer);
        this.appendInterestsLine(buffer);
        this.appendCatchPhraseLine(buffer);
        this.appendPortraitLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Attributes", buffer);
        this.appendStatLines(buffer);
        this.appendAlignmentLine(buffer);
        this.appendRaceLine(buffer);
        this.appendFavoredClassLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Class(es)", buffer);
        this.appendClassLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Experience", buffer);
        this.appendExperienceLine(buffer);
        this.appendExperienceTableLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Templates", buffer);
        this.appendTemplateLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Region", buffer);
        this.appendRegionLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Skills", buffer);
        this.appendSkillLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Languages", buffer);
        this.appendLanguageLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Feats", buffer);
        this.appendFeatLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Abilities", buffer);
        this.appendAbilityLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Weapon proficiencies", buffer);
        this.appendWeaponProficiencyLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Equipment", buffer);
        this.appendMoneyLine(buffer);
        this.appendEquipmentLines(buffer);
        this.appendEquipmentSetLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Temporary Bonuses", buffer);
        this.appendTempBonuses(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("EquipSet Temp Bonuses", buffer);
        this.appendEqSetBonuses(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Deity/Domain", buffer);
        this.appendDeityLine(buffer);
        this.appendDomainLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Spells Information", buffer);
        this.appendSpellBookLines(buffer);
        this.appendSpellLines(buffer);
        this.appendSpellListLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Description/Bio/History", buffer);
        this.appendCharacterBioLine(buffer);
        this.appendCharacterDescLine(buffer);
        this.appendCharacterCompLine(buffer);
        this.appendCharacterAssetLine(buffer);
        this.appendCharacterMagicLine(buffer);
        this.appendCharacterDmNotesLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Kits", buffer);
        this.appendKitLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Master/Follower", buffer);
        this.appendFollowerLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Character Notes Tab", buffer);
        this.appendNotesLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Age Set Selections", buffer);
        this.appendAgeSetLine(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Campaign History", buffer);
        this.appendCampaignHistoryLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        PCGVer2Creator.appendComment("Suppressed Biography Fields", buffer);
        this.appendSuppressBioFieldLines(buffer);
        PCGVer2Creator.appendNewline(buffer);
        return buffer.toString();
    }

    private void appendCampaignLine(StringBuilder buffer) {
        String del = "";
        if (this.campaigns != null) {
            for (CampaignFacade campaignFacade : this.campaigns) {
                buffer.append(del);
                buffer.append("CAMPAIGN").append(':');
                buffer.append(campaignFacade.getKeyName());
                del = "|";
            }
            buffer.append("\n");
        }
    }

    private void appendSuppressBioFieldLines(StringBuilder buffer) {
        buffer.append("SUPPRESSBIOFIELDS").append(':');
        String delim = "";
        for (BiographyField field : BiographyField.values()) {
            if (!this.charDisplay.getSuppressBioField(field)) continue;
            buffer.append(delim);
            buffer.append((Object)field);
            delim = "|";
        }
        buffer.append("\n");
    }

    private GameMode getGameMode() {
        if (this.mode != null) {
            return this.mode;
        }
        return SettingsHandler.getGame();
    }

    private void appendGameModeLine(StringBuilder buffer) {
        buffer.append("GAMEMODE").append(':');
        buffer.append(this.getGameMode().getName());
        buffer.append("\n");
    }

    private static void appendPCGVersionLine(StringBuilder buffer) {
        buffer.append("PCGVERSION").append(':');
        buffer.append("2.0");
        buffer.append("\n");
    }

    private void appendPurchasePointsLine(StringBuilder buffer) {
        buffer.append("PURCHASEPOINTS").append(':');
        if (this.getGameMode().isPurchaseStatMode()) {
            buffer.append('Y');
            buffer.append('|');
            buffer.append("TYPE").append(':');
            buffer.append(this.getGameMode().getPurchaseModeMethodName());
        } else {
            buffer.append('N');
        }
        buffer.append("\n");
    }

    private void appendRollMethodLine(StringBuilder buffer) {
        GameMode game = this.getGameMode();
        buffer.append("ROLLMETHOD").append(':');
        buffer.append(game.getRollMethod());
        buffer.append('|');
        buffer.append("EXPRESSION").append(':');
        switch (game.getRollMethod()) {
            case 1: {
                buffer.append(game.getAllStatsValue());
                break;
            }
            case 2: {
                buffer.append(game.getPurchaseModeMethodName());
                break;
            }
            case 3: {
                buffer.append(game.getRollMethodExpression());
                break;
            }
            default: {
                buffer.append(0);
            }
        }
        buffer.append("\n");
    }

    private static void appendVersionLine(StringBuilder buffer) {
        buffer.append("VERSION").append(':');
        buffer.append(PCGenPropBundle.getVersionNumber());
        buffer.append("\n");
    }

    private void appendAgeLine(StringBuilder buffer) {
        buffer.append("AGE").append(':');
        buffer.append(this.charDisplay.getAge());
        buffer.append("\n");
    }

    private void appendAgeSetLine(StringBuilder buffer) {
        buffer.append("AGESET");
        for (int i = 0; i < 10; ++i) {
            buffer.append(':');
            if (this.thePC.hasMadeKitSelectionForAgeSet(i)) {
                buffer.append('1');
                continue;
            }
            buffer.append('0');
        }
        buffer.append("\n");
    }

    private void appendAlignmentLine(StringBuilder buffer) {
        if (Globals.getGameModeAlignmentText().length() != 0 && this.charDisplay.getPCAlignment() != null) {
            buffer.append("ALIGN").append(':');
            buffer.append(this.charDisplay.getPCAlignment().getKeyName());
            buffer.append("\n");
        }
    }

    private void appendBirthdayLine(StringBuilder buffer) {
        buffer.append("BIRTHDAY").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.BIRTHDAY)));
        buffer.append("\n");
    }

    private void appendBirthplaceLine(StringBuilder buffer) {
        buffer.append("BIRTHPLACE").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.BIRTHPLACE)));
        buffer.append("\n");
    }

    private void appendCampaignHistoryLines(StringBuilder buffer) {
        for (ChronicleEntry ce : this.charDisplay.getChronicleEntries()) {
            buffer.append("CHRONICLEENTRY").append(':');
            buffer.append(ce.isOutputEntry() ? "Y" : "N:");
            buffer.append('|');
            buffer.append("CAMPAIGN").append(':');
            buffer.append(EntityEncoder.encode(ce.getCampaign()));
            buffer.append('|');
            buffer.append("ADVENTURE").append(':');
            buffer.append(EntityEncoder.encode(ce.getAdventure()));
            buffer.append('|');
            buffer.append("PARTY").append(':');
            buffer.append(EntityEncoder.encode(ce.getParty()));
            buffer.append('|');
            buffer.append("DATE").append(':');
            buffer.append(EntityEncoder.encode(ce.getDate()));
            buffer.append('|');
            buffer.append("EXPERIENCE").append(':');
            buffer.append(ce.getXpField());
            buffer.append('|');
            buffer.append("GM").append(':');
            buffer.append(EntityEncoder.encode(ce.getGmField()));
            buffer.append('|');
            buffer.append("CHRONICLE").append(':');
            buffer.append(EntityEncoder.encode(ce.getChronicle()));
            buffer.append("\n");
        }
    }

    private void appendCatchPhraseLine(StringBuilder buffer) {
        buffer.append("CATCHPHRASE").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.CATCHPHRASE)));
        buffer.append("\n");
    }

    private void appendCharacterAssetLine(StringBuilder buffer) {
        buffer.append("CHARACTERASSET").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.ASSETS)));
        buffer.append("\n");
    }

    private void appendCharacterBioLine(StringBuilder buffer) {
        buffer.append("CHARACTERBIO").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.BIO)));
        buffer.append("\n");
    }

    private void appendCharacterCompLine(StringBuilder buffer) {
        buffer.append("CHARACTERCOMP").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.COMPANIONS)));
        buffer.append("\n");
    }

    private void appendCharacterDescLine(StringBuilder buffer) {
        buffer.append("CHARACTERDESC").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.DESCRIPTION)));
        buffer.append("\n");
    }

    private void appendCharacterMagicLine(StringBuilder buffer) {
        buffer.append("CHARACTERMAGIC").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.MAGIC)));
        buffer.append("\n");
    }

    private void appendCharacterDmNotesLine(StringBuilder buffer) {
        buffer.append("CHARACTERDMNOTES").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.GMNOTES)));
        buffer.append("\n");
    }

    private void appendCharacterTypeLine(StringBuilder buffer) {
        buffer.append("CHARACTERTYPE").append(':');
        buffer.append(this.charDisplay.getCharacterType());
        buffer.append("\n");
    }

    private void appendPreviewSheetLine(StringBuilder buffer) {
        buffer.append("PREVIEWSHEET").append(':');
        buffer.append(this.charDisplay.getPreviewSheet());
        buffer.append("\n");
    }

    private void appendClassLines(StringBuilder buffer) {
        Cache specials = new Cache();
        for (PCClass pcClass : this.charDisplay.getClassSet()) {
            Iterator<ConcretePrereqObject> i$;
            Collection<? extends SpellProhibitor> prohib;
            boolean isPsionic;
            int classLevel = this.charDisplay.getLevel(pcClass);
            buffer.append("CLASS").append(':');
            buffer.append(EntityEncoder.encode(pcClass.getKeyName()));
            String subClassKey = this.charDisplay.getSubClassName(pcClass);
            if (subClassKey != null && !"".equals(subClassKey)) {
                buffer.append('|');
                buffer.append("SUBCLASS").append(':');
                buffer.append(EntityEncoder.encode(subClassKey));
            }
            buffer.append('|');
            buffer.append("LEVEL").append(':');
            buffer.append(classLevel);
            buffer.append('|');
            buffer.append("SKILLPOOL").append(':');
            Integer currentPool = this.thePC.getSkillPool(pcClass);
            buffer.append(currentPool == null ? 0 : currentPool);
            boolean isCaster = false;
            if (!this.thePC.getSpellSupport(pcClass).canCastSpells(this.thePC)) {
                isCaster = true;
            }
            boolean bl = isPsionic = this.thePC.getSpellSupport(pcClass).hasKnownList() && !isCaster;
            if (isCaster || isPsionic) {
                buffer.append('|');
                buffer.append("SPELLBASE").append(':');
                buffer.append(EntityEncoder.encode(pcClass.getSpellBaseStat()));
                buffer.append('|');
                buffer.append("CANCASTPERDAY").append(':');
                buffer.append(StringUtil.join(this.thePC.getSpellSupport(pcClass).getCastListForLevel(classLevel), (String)","));
            }
            if ((prohib = this.charDisplay.getProhibitedSchools(pcClass)) != null) {
                TreeSet<String> set = new TreeSet<String>();
                for (SpellProhibitor spellProhibitor : prohib) {
                    set.addAll(spellProhibitor.getValueList());
                }
                if (!set.isEmpty()) {
                    buffer.append('|');
                    buffer.append("PROHIBITED").append(':');
                    buffer.append(EntityEncoder.encode(StringUtil.join(set, (String)",")));
                }
            }
            this.appendAddTokenInfo(buffer, pcClass);
            buffer.append("\n");
            String spec = this.thePC.getAssoc(pcClass, AssociationKey.SPECIALTY);
            if (spec != null) {
                specials.put(pcClass.getKeyName() + "SPECIALTY" + '0', spec);
            }
            String key = pcClass.getKeyName() + "SAVE" + '0';
            List<? extends SpecialAbility> list = this.charDisplay.getUserSpecialAbilityList(pcClass);
            if (list != null && (i$ = list.iterator()).hasNext()) {
                SpecialAbility sa = (SpecialAbility)i$.next();
                specials.put(pcClass.getKeyName() + "SA" + 0, sa.getKeyName());
            }
            i$ = this.thePC.getSaveableBonusList(pcClass).iterator();
            while (i$.hasNext()) {
                BonusObj save = (BonusObj)i$.next();
                specials.put(key, "BONUS|" + save);
            }
            for (int i = 1; i <= this.charDisplay.getLevel(pcClass); ++i) {
                key = pcClass.getKeyName() + "SAVE" + (i - 1);
                PCClassLevel pcl = this.charDisplay.getActiveClassLevel(pcClass, i);
                for (BonusObj bonusObj : this.thePC.getSaveableBonusList(pcl)) {
                    specials.put(key, "BONUS|" + bonusObj);
                }
            }
        }
        for (PCLevelInfo pcl : this.charDisplay.getLevelInfo()) {
            List<PCLevelInfoStat> statList;
            String classKeyName = pcl.getClassKeyName();
            int lvl = pcl.getClassLevel() - 1;
            PCClass pcClass = this.thePC.getClassKeyed(classKeyName);
            buffer.append("CLASSABILITIESLEVEL").append(':');
            if (pcClass == null && (pcClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKeyName)) != null) {
                pcClass = this.thePC.getClassKeyed(pcClass.get(ObjectKey.EX_CLASS).resolvesTo().getKeyName());
            }
            if (pcClass != null) {
                buffer.append(EntityEncoder.encode(pcClass.getKeyName()));
            } else {
                buffer.append(EntityEncoder.encode("???"));
            }
            buffer.append('=').append(lvl + 1);
            if (pcClass != null) {
                String aKey = this.charDisplay.getSubstitutionClassName(this.charDisplay.getActiveClassLevel(pcClass, lvl + 1));
                if (aKey != null) {
                    buffer.append('|');
                    buffer.append("SUBSTITUTIONLEVEL").append(':');
                    buffer.append(aKey);
                }
                buffer.append('|');
                buffer.append("HITPOINTS").append(':');
                PCClassLevel classLevel = this.charDisplay.getActiveClassLevel(pcClass, lvl);
                Integer hp = this.charDisplay.getHP(classLevel);
                buffer.append(hp == null ? 0 : hp);
                PCGVer2Creator.appendSpecials(buffer, specials.get(pcClass.getKeyName() + "SAVE" + lvl), "SAVES", "SAVE", lvl);
                PCGVer2Creator.appendSpecials(buffer, specials.get(pcClass.getKeyName() + "SPECIALTY" + lvl), "SPECIALTIES", "SPECIALTY", lvl);
                PCGVer2Creator.appendSpecials(buffer, specials.get(pcClass.getKeyName() + "SA" + lvl), "SPECIALABILITIES", "SA", lvl);
                if (lvl == 0) {
                    PCGVer2Creator.appendSpecials(buffer, specials.get(pcClass.getKeyName() + "SA" + (lvl - 1)), "SPECIALABILITIES", "SA", -1);
                }
                this.appendAddTokenInfo(buffer, this.charDisplay.getActiveClassLevel(pcClass, lvl + 1));
            }
            if ((statList = pcl.getModifiedStats(true)) != null) {
                for (PCLevelInfoStat stat : statList) {
                    buffer.append('|').append("PRESTAT").append(':').append(stat.toString());
                }
            }
            if ((statList = pcl.getModifiedStats(false)) != null) {
                for (PCLevelInfoStat stat : statList) {
                    buffer.append('|').append("PRESTAT").append(':').append(stat.toString());
                }
            }
            int sp = pcl.getSkillPointsGained(this.thePC);
            buffer.append('|').append("SKILLSGAINED").append(':').append(sp);
            sp = pcl.getSkillPointsRemaining();
            buffer.append('|').append("SKILLSREMAINING").append(':').append(sp);
            buffer.append("\n");
        }
    }

    private static void appendComment(String comment, StringBuilder buffer) {
        buffer.append(PCGVer2Creator.createComment(comment));
    }

    private void appendDeityLine(StringBuilder buffer) {
        if (this.charDisplay.getDeity() != null) {
            Deity aDeity = this.charDisplay.getDeity();
            buffer.append("DEITY").append(':');
            buffer.append(EntityEncoder.encode(aDeity.getKeyName()));
            buffer.append('|');
            buffer.append("DEITYDOMAINS").append(':');
            buffer.append('[');
            String del = "";
            for (CDOMReference ref : aDeity.getSafeListMods(Deity.DOMAINLIST)) {
                for (Domain d : ref.getContainedObjects()) {
                    buffer.append(del);
                    buffer.append("DOMAIN").append(':');
                    buffer.append(EntityEncoder.encode(d.getKeyName()));
                    del = "|";
                }
            }
            buffer.append(']');
            buffer.append('|');
            buffer.append("ALIGNALLOW").append(':');
            for (Description desc : aDeity.getSafeListFor(ListKey.DESCRIPTION)) {
                buffer.append('|');
                buffer.append("DESC").append(':');
                buffer.append(desc.getPCCText());
            }
            buffer.append('|');
            buffer.append("DEITYFAVWEAP").append(':');
            buffer.append('[');
            List<CDOMReference<WeaponProf>> dwp = aDeity.getListFor(ListKey.DEITYWEAPON);
            if (dwp != null) {
                del = "";
                for (CDOMReference<WeaponProf> ref : dwp) {
                    buffer.append(del);
                    buffer.append("WEAPON").append(':');
                    buffer.append(EntityEncoder.encode(ref.getLSTformat(false)));
                    del = "|";
                }
            }
            buffer.append(']');
            buffer.append('|');
            buffer.append("DEITYALIGN").append(':');
            CDOMSingleRef<PCAlignment> al = aDeity.get(ObjectKey.ALIGNMENT);
            if (al != null) {
                buffer.append(al.getLSTformat(false));
            }
            buffer.append("\n");
        }
    }

    private void appendDomainLines(StringBuilder buffer) {
        for (Domain domain : this.charDisplay.getDomainSet()) {
            buffer.append("DOMAIN").append(':');
            buffer.append(EntityEncoder.encode(domain.getKeyName()));
            for (String assoc : this.thePC.getAssociationList(domain)) {
                buffer.append('|');
                buffer.append("ASSOCIATEDDATA").append(':');
                buffer.append(EntityEncoder.encode(assoc));
            }
            for (Description desc : domain.getSafeListFor(ListKey.DESCRIPTION)) {
                buffer.append('|');
                buffer.append("DOMAINGRANTS").append(':');
                buffer.append(desc.getPCCText());
            }
            buffer.append('|');
            PCGVer2Creator.appendSourceInTaggedFormat(buffer, this.getDomainSourcePcgString(domain));
            this.appendAddTokenInfo(buffer, domain);
            buffer.append("\n");
        }
    }

    private String getDomainSourcePcgString(Domain domain) {
        StringBuilder buff = new StringBuilder(30);
        ClassSource source = this.thePC.getDomainSource(domain);
        buff.append("PCClass");
        buff.append('|');
        buff.append(source.getPcclass().getKeyName());
        if (source.getLevel() > 0) {
            buff.append('|');
            buff.append(source.getLevel());
        }
        return buff.toString();
    }

    private void appendEqSetBonuses(StringBuilder buffer) {
        for (EquipSet eSet : this.charDisplay.getEquipSet()) {
            if (!eSet.useTempBonusList()) continue;
            buffer.append("EQSETBONUS").append(':');
            buffer.append(eSet.getIdPath());
            ArrayList<String> trackList = new ArrayList<String>();
            for (Map.Entry<BonusObj, BonusManager.TempBonusInfo> me : eSet.getTempBonusMap().entrySet()) {
                BonusManager.TempBonusInfo tbi = me.getValue();
                Object cObj = tbi.source;
                Object tObj = tbi.target;
                String aName = this.tempBonusName(cObj, tObj);
                if (trackList.contains(aName)) continue;
                trackList.add(aName);
                buffer.append('|');
                buffer.append("TBBONUS").append(':');
                buffer.append(EntityEncoder.encode(aName));
            }
            buffer.append("\n");
        }
    }

    private void appendEquipmentLines(StringBuilder buffer) {
        List<Equipment> eqsorted = this.thePC.getEquipmentMasterList();
        Collections.sort(eqsorted);
        for (Equipment eq : eqsorted) {
            buffer.append("EQUIPNAME").append(':');
            buffer.append(EntityEncoder.encode(eq.getName()));
            buffer.append('|');
            buffer.append("OUTPUTORDER").append(':');
            buffer.append(eq.getOutputIndex());
            buffer.append('|');
            buffer.append("COST").append(':');
            buffer.append(eq.getCost(this.thePC).toString());
            buffer.append('|');
            buffer.append("WT").append(':');
            buffer.append(eq.getWeight(this.thePC).toString());
            buffer.append('|');
            buffer.append("QUANTITY").append(':');
            buffer.append(eq.qty());
            String note = eq.getNote();
            if (note != null) {
                buffer.append('|');
                buffer.append("NOTE").append(':');
                buffer.append(eq.getNote());
            }
            String customization = eq.formatSaveLine('$', '=').trim();
            int delimiterIndex = customization.indexOf(36);
            if (customization.length() > 0 && delimiterIndex >= 0) {
                buffer.append('|');
                buffer.append("CUSTOMIZATION").append(':');
                buffer.append('[');
                buffer.append("BASEITEM").append(':');
                buffer.append(EntityEncoder.encode(customization.substring(0, delimiterIndex)));
                buffer.append('|');
                buffer.append("DATA").append(':');
                buffer.append(EntityEncoder.encode(customization.substring(delimiterIndex + 1)));
                buffer.append(']');
            }
            buffer.append("\n");
        }
    }

    private void appendEquipmentSetLines(StringBuilder buffer) {
        ArrayList<EquipSet> eqSetList = new ArrayList<EquipSet>(this.charDisplay.getEquipSet());
        Collections.sort(eqSetList);
        for (EquipSet eqSet : eqSetList) {
            buffer.append("EQUIPSET").append(':');
            buffer.append(EntityEncoder.encode(eqSet.getName()));
            buffer.append('|');
            buffer.append("ID").append(':');
            buffer.append(eqSet.getIdPath());
            if (eqSet.getValue().length() > 0) {
                buffer.append('|');
                buffer.append("VALUE").append(':');
                buffer.append(EntityEncoder.encode(eqSet.getValue()));
                buffer.append('|');
                buffer.append("QUANTITY").append(':');
                buffer.append(eqSet.getQty());
            }
            if (eqSet.getNote().length() > 0) {
                buffer.append('|');
                buffer.append("NOTE").append(':');
                buffer.append(eqSet.getNote());
            }
            if (eqSet.getUseTempMods()) {
                buffer.append('|');
                buffer.append("USETEMPMODS").append(':');
                buffer.append(eqSet.getUseTempMods() ? (char)'Y' : 'N');
            }
            buffer.append("\n");
        }
        String calcEquipSet = this.thePC.getCalcEquipSetId();
        buffer.append("CALCEQUIPSET").append(':');
        buffer.append(calcEquipSet);
        buffer.append("\n");
    }

    private void appendEyeColorLine(StringBuilder buffer) {
        buffer.append("EYECOLOR").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.EYECOLOR)));
        buffer.append("\n");
    }

    private void appendFeatLines(StringBuilder buffer) {
        buffer.append("FEATPOOL").append(':');
        buffer.append(this.thePC.getRemainingFeatPoints(false));
        buffer.append("\n");
    }

    private void appendAbilityLines(StringBuilder buffer) {
        ArrayList<AbilityCategory> categories = new ArrayList<AbilityCategory>(this.getGameMode().getAllAbilityCategories());
        categories.add(AbilityCategory.LANGBONUS);
        Collection<CNAbilitySelection> virtSave = this.thePC.getSaveAbilities();
        Collections.sort(categories, new Comparator<AbilityCategory>(){

            @Override
            public int compare(AbilityCategory a, AbilityCategory b) {
                return a.getKeyName().compareTo(b.getKeyName());
            }
        });
        for (AbilityCategory cat : categories) {
            ArrayList<CNAbility> normalAbilitiesToSave = new ArrayList<CNAbility>(this.thePC.getPoolAbilities(cat, Nature.NORMAL));
            Collections.sort(normalAbilitiesToSave);
            for (CNAbility ability : normalAbilitiesToSave) {
                this.writeAbilityToBuffer(buffer, ability);
            }
            boolean hasVirt = false;
            for (CNAbilitySelection ability : virtSave) {
                CNAbility cnAbility = ability.getCNAbility();
                if (!cnAbility.getAbilityCategory().equals(cat)) continue;
                this.writeAbilityToBuffer(buffer, cnAbility);
                hasVirt = true;
            }
            if (normalAbilitiesToSave.isEmpty() && !hasVirt && this.thePC.getUserPoolBonus(cat) == 0.0) continue;
            buffer.append("USERPOOL").append(":");
            buffer.append(EntityEncoder.encode(cat.getKeyName())).append("|");
            buffer.append("POOLPOINTS").append(":");
            buffer.append(this.thePC.getUserPoolBonus(cat));
            buffer.append("\n");
        }
    }

    private void writeAbilityToBuffer(StringBuilder buffer, CNAbility cna) {
        Category<Ability> cat = cna.getAbilityCategory();
        Nature nature = cna.getNature();
        Ability ability = cna.getAbility();
        buffer.append("ABILITY").append(":");
        buffer.append(EntityEncoder.encode(cat.getKeyName())).append("|");
        buffer.append("TYPE").append(":");
        buffer.append(EntityEncoder.encode(nature.toString())).append("|");
        buffer.append("CATEGORY").append(":");
        buffer.append(EntityEncoder.encode(ability.getCategory())).append("|");
        buffer.append("KEY").append(":");
        buffer.append(EntityEncoder.encode(ability.getKeyName())).append("|");
        if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            buffer.append("APPLIEDTO").append(":");
            List<String> assocList = this.thePC.getAssociationList(cna);
            boolean bl = true;
            for (String assoc : assocList) {
                boolean bl2;
                if (!bl2) {
                    buffer.append(",");
                }
                bl2 = false;
                buffer.append(EntityEncoder.encode(assoc));
            }
            buffer.append("|");
        }
        buffer.append("TYPE").append(":");
        buffer.append(EntityEncoder.encode(ability.getType()));
        for (BonusObj bonusObj : this.thePC.getSaveableBonusList(ability)) {
            buffer.append('|');
            buffer.append("SAVE").append(':');
            buffer.append(EntityEncoder.encode("BONUS|" + bonusObj));
        }
        for (Description description : ability.getSafeListFor(ListKey.DESCRIPTION)) {
            buffer.append("|");
            buffer.append("DESC").append(':');
            buffer.append(EntityEncoder.encode(description.getPCCText()));
        }
        buffer.append("\n");
    }

    private void appendFollowerLines(StringBuilder buffer) {
        Follower aMaster = this.charDisplay.getMaster();
        if (aMaster != null) {
            buffer.append("MASTER").append(':');
            buffer.append(EntityEncoder.encode(aMaster.getName()));
            buffer.append('|');
            buffer.append("TYPE").append(':');
            buffer.append(EntityEncoder.encode(aMaster.getType().getKeyName()));
            buffer.append('|');
            buffer.append("HITDICE").append(':');
            buffer.append(aMaster.getUsedHD());
            buffer.append('|');
            buffer.append("FILE").append(':');
            buffer.append(EntityEncoder.encode(FileHelper.findRelativePath(new File(this.charDisplay.getFileName()), new File(aMaster.getFileName()))));
            buffer.append('|');
            buffer.append("ADJUSTMENT").append(':');
            buffer.append(aMaster.getAdjustment());
            buffer.append("\n");
        }
        if (this.charDisplay.hasFollowers()) {
            for (Follower follower : this.charDisplay.getFollowerList()) {
                buffer.append("FOLLOWER").append(':');
                buffer.append(EntityEncoder.encode(follower.getName()));
                buffer.append('|');
                buffer.append("TYPE").append(':');
                buffer.append(EntityEncoder.encode(follower.getType().getKeyName()));
                buffer.append('|');
                if (follower.getRace() != null) {
                    buffer.append("RACE").append(':');
                    buffer.append(EntityEncoder.encode(follower.getRace().getKeyName().toUpperCase()));
                    buffer.append('|');
                }
                buffer.append("HITDICE").append(':');
                buffer.append(follower.getUsedHD());
                buffer.append('|');
                buffer.append("FILE").append(':');
                if (StringUtils.isNotEmpty(follower.getFileName())) {
                    buffer.append(EntityEncoder.encode(FileHelper.findRelativePath(new File(this.charDisplay.getFileName()), new File(follower.getFileName()))));
                }
                buffer.append("\n");
            }
        }
    }

    private void appendGenderLine(StringBuilder buffer) {
        buffer.append("GENDER").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getGenderObject().name()));
        buffer.append("\n");
    }

    private void appendHairColorLine(StringBuilder buffer) {
        buffer.append("HAIRCOLOR").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.HAIRCOLOR)));
        buffer.append("\n");
    }

    private void appendHairStyleLine(StringBuilder buffer) {
        buffer.append("HAIRSTYLE").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.HAIRSTYLE)));
        buffer.append("\n");
    }

    private void appendHandedLine(StringBuilder buffer) {
        buffer.append("HANDED").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getHandedObject().name()));
        buffer.append("\n");
    }

    private void appendInterestsLine(StringBuilder buffer) {
        buffer.append("INTERESTS").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.INTERESTS)));
        buffer.append("\n");
    }

    private void appendKitLines(StringBuilder buffer) {
        for (Kit kit : this.charDisplay.getKitInfo()) {
            buffer.append("KIT").append(':').append(kit.getKeyName()).append("\n");
        }
    }

    private void appendLanguageLine(StringBuilder buffer) {
        String del = "";
        TreeSet<Language> sortedlangs = new TreeSet<Language>(this.charDisplay.getLanguageSet());
        for (Language lang : sortedlangs) {
            buffer.append(del);
            buffer.append("LANGUAGE").append(':');
            buffer.append(EntityEncoder.encode(lang.getKeyName()));
            del = "|";
        }
        buffer.append("\n");
    }

    private void appendLocationLine(StringBuilder buffer) {
        buffer.append("LOCATION").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.LOCATION)));
        buffer.append("\n");
    }

    private static void appendNewline(StringBuilder buffer) {
        buffer.append("\n");
    }

    private void appendNotesLines(StringBuilder buffer) {
        for (NoteItem ni : this.charDisplay.getNotesList()) {
            buffer.append("NOTE").append(':');
            buffer.append(EntityEncoder.encode(ni.getName()));
            buffer.append('|');
            buffer.append("ID").append(':');
            buffer.append(ni.getId());
            buffer.append('|');
            buffer.append("PARENTID").append(':');
            buffer.append(ni.getParentId());
            buffer.append('|');
            buffer.append("VALUE").append(':');
            buffer.append(EntityEncoder.encode(ni.getValue()));
            buffer.append("\n");
        }
    }

    private void appendPersonalityTrait1Line(StringBuilder buffer) {
        buffer.append("PERSONALITYTRAIT1").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.PERSONALITY1)));
        buffer.append("\n");
    }

    private void appendPersonalityTrait2Line(StringBuilder buffer) {
        buffer.append("PERSONALITYTRAIT2").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.PERSONALITY2)));
        buffer.append("\n");
    }

    private void appendPhobiasLine(StringBuilder buffer) {
        buffer.append("PHOBIAS").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.PHOBIAS)));
        buffer.append("\n");
    }

    private void appendPoolPointsLine(StringBuilder buffer) {
        buffer.append("POOLPOINTS").append(':');
        buffer.append(this.thePC.getPoolAmount());
        buffer.append("\n");
        buffer.append("POOLPOINTSAVAIL").append(':');
        buffer.append(this.thePC.getPointBuyPoints());
        buffer.append("\n");
    }

    private static void appendTabLabelLine(StringBuilder buffer) {
        buffer.append("TABLABEL").append(':');
        buffer.append(SettingsHandler.getNameDisplayStyle());
        buffer.append("\n");
    }

    private void appendAutoSortLines(StringBuilder buffer) {
        buffer.append("AUTOSORTGEAR").append(':');
        buffer.append(this.thePC.isAutoSortGear() ? (char)'Y' : 'N');
        buffer.append("\n");
        buffer.append("SKILLSOUTPUTORDER").append(':');
        buffer.append(this.thePC.getSkillsOutputOrder().ordinal());
        buffer.append("\n");
    }

    private void appendSkillFilterLine(StringBuilder buffer) {
        buffer.append("SKILLFILTER").append(':');
        buffer.append(this.thePC.getSkillFilter().getValue());
        buffer.append("\n");
    }

    private void appendGearCostSizeLines(StringBuilder buffer) {
        buffer.append("IGNORECOST").append(':');
        buffer.append(this.thePC.isIgnoreCost() ? (char)'Y' : 'N');
        buffer.append("\n");
        buffer.append("ALLOWDEBT").append(':');
        buffer.append(this.thePC.isAllowDebt() ? (char)'Y' : 'N');
        buffer.append("\n");
        buffer.append("AUTORESIZEGEAR").append(':');
        buffer.append(this.thePC.isAutoResize() ? (char)'Y' : 'N');
        buffer.append("\n");
    }

    private void appendAutoSpellsLine(StringBuilder buffer) {
        buffer.append("AUTOSPELLS").append(':');
        buffer.append(this.thePC.getAutoSpells() ? (char)'Y' : 'N');
        buffer.append("\n");
    }

    private void appendUseHigherSpellSlotsLines(StringBuilder buffer) {
        buffer.append("USEHIGHERKNOWN").append(':');
        buffer.append(this.thePC.getUseHigherKnownSlots() ? (char)'Y' : 'N');
        buffer.append("\n");
        buffer.append("USEHIGHERPREPPED").append(':');
        buffer.append(this.thePC.getUseHigherPreppedSlots() ? (char)'Y' : 'N');
        buffer.append("\n");
    }

    private void appendCharacterNameLine(StringBuilder buffer) {
        buffer.append("CHARACTERNAME").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getName()));
        buffer.append("\n");
    }

    private void appendHeightLine(StringBuilder buffer) {
        buffer.append("HEIGHT").append(':');
        buffer.append(this.charDisplay.getHeight());
        buffer.append("\n");
    }

    private void appendLoadCompanionLine(StringBuilder buffer) {
        buffer.append("LOADCOMPANIONS").append(':');
        buffer.append(this.thePC.getLoadCompanion() ? (char)'Y' : 'N');
        buffer.append("\n");
    }

    private void appendOutputSheetsLines(StringBuilder buffer) {
        if (SettingsHandler.getSaveOutputSheetWithPC()) {
            buffer.append("OUTPUTSHEETHTML").append(':');
            buffer.append(EntityEncoder.encode(SettingsHandler.getSelectedCharacterHTMLOutputSheet(null)));
            buffer.append("\n");
            buffer.append("OUTPUTSHEETPDF").append(':');
            buffer.append(EntityEncoder.encode(SettingsHandler.getSelectedCharacterPDFOutputSheet(null)));
            buffer.append("\n");
        }
    }

    private void appendPlayerNameLine(StringBuilder buffer) {
        buffer.append("PLAYERNAME").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getPlayersName()));
        buffer.append("\n");
    }

    private void appendPortraitLine(StringBuilder buffer) {
        buffer.append("PORTRAIT").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getPortraitPath()));
        buffer.append("\n");
        Rectangle rect = this.charDisplay.getPortraitThumbnailRect();
        if (rect != null) {
            buffer.append("PORTRAITTHUMBNAILRECT").append(':');
            buffer.append(rect.x).append(',');
            buffer.append(rect.y).append(',');
            buffer.append(rect.width).append(',');
            buffer.append(rect.height);
            buffer.append("\n");
        }
    }

    private void appendRaceLine(StringBuilder buffer) {
        buffer.append("RACE").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getRace().getKeyName()));
        List<String> assocList = this.thePC.getAssociationList(this.charDisplay.getRace());
        if (assocList != null && !assocList.isEmpty()) {
            buffer.append("|");
            buffer.append("APPLIEDTO").append(":");
            boolean first = true;
            for (String assoc : assocList) {
                if (!first) {
                    buffer.append(",");
                }
                first = false;
                buffer.append(EntityEncoder.encode(assoc));
            }
        }
        this.appendAddTokenInfo(buffer, this.charDisplay.getRace());
        buffer.append("\n");
    }

    private void appendFavoredClassLine(StringBuilder buffer) {
        PCClass sfc = this.thePC.getLegacyFavoredClass();
        if (sfc != null) {
            buffer.append("FAVOREDCLASS").append(':');
            buffer.append(EntityEncoder.encode(sfc.getKeyName()));
            buffer.append("\n");
        }
    }

    private void appendResidenceLine(StringBuilder buffer) {
        buffer.append("CITY").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.RESIDENCE)));
        buffer.append("\n");
    }

    private void appendSkinColorLine(StringBuilder buffer) {
        buffer.append("SKINCOLOR").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.SKINCOLOR)));
        buffer.append("\n");
    }

    private static void appendSourceInTaggedFormat(StringBuilder buffer, String source) {
        StringTokenizer tokens = new StringTokenizer(source, "|=");
        buffer.append("SOURCE").append(':');
        buffer.append('[');
        buffer.append("TYPE").append(':');
        buffer.append(tokens.nextToken());
        buffer.append('|');
        buffer.append("NAME").append(':');
        buffer.append(tokens.nextToken());
        if (tokens.hasMoreTokens()) {
            buffer.append('|');
            buffer.append("LEVEL").append(':');
            buffer.append(tokens.nextToken());
        }
        if (source.indexOf(61) >= 0) {
            buffer.append('|');
            buffer.append("DEFINED").append(':');
            buffer.append('Y');
        }
        buffer.append(']');
    }

    private static void appendSourceInTaggedFormat(StringBuilder buffer, CDOMObject source) {
        buffer.append("SOURCE").append(':');
        buffer.append('[');
        buffer.append("TYPE").append(':');
        Class<?> srcClass = source.getClass();
        String pckName = srcClass.getPackage().getName();
        String srcName = srcClass.getName().substring(pckName.length() + 1);
        buffer.append(srcName.toUpperCase());
        buffer.append('|');
        buffer.append("NAME").append(':');
        buffer.append(source.getKeyName());
        buffer.append(']');
    }

    private static void appendSpecials(StringBuilder buffer, List<String> specials, String tag_group, String tag_item, int lvl) {
        if (specials != null && !specials.isEmpty()) {
            buffer.append('|');
            buffer.append(tag_group).append(':');
            buffer.append('[');
            String del = "";
            for (String special : specials) {
                buffer.append(del);
                buffer.append(tag_item).append(':');
                buffer.append(EntityEncoder.encode(special));
                if (lvl == -1) {
                    buffer.append(":-1");
                }
                del = "|";
            }
            buffer.append(']');
        }
    }

    private void appendExperienceLine(StringBuilder buffer) {
        buffer.append("EXPERIENCE").append(':');
        buffer.append(this.charDisplay.getXP());
        buffer.append("\n");
    }

    private void appendExperienceTableLine(StringBuilder buffer) {
        buffer.append("EXPERIENCETABLE").append(':');
        buffer.append(this.charDisplay.getXPTableName());
        buffer.append("\n");
    }

    private void appendRegionLine(StringBuilder buffer) {
        String r = this.charDisplay.getRegionString();
        if (r != null) {
            buffer.append("REGION").append(':').append(r).append("\n");
        }
    }

    private void appendSkillLines(StringBuilder buffer) {
        ArrayList<Skill> skillList = new ArrayList<Skill>(this.charDisplay.getSkillSet());
        Collections.sort(skillList);
        for (Skill skill : skillList) {
            Integer outputIndex = this.thePC.getSkillOrder(skill);
            if (!(this.thePC.getRank(skill).doubleValue() > 0.0) && (outputIndex == null || outputIndex == 0)) continue;
            buffer.append("SKILL").append(':');
            buffer.append(EntityEncoder.encode(skill.getKeyName()));
            buffer.append('|');
            if (outputIndex != null && outputIndex != 0) {
                buffer.append("OUTPUTORDER").append(':');
                buffer.append(outputIndex == null ? 0 : outputIndex);
                buffer.append('|');
            }
            for (PCClass pcc : this.thePC.getSkillRankClasses(skill)) {
                if (pcc == null) continue;
                Double rank = this.thePC.getSkillRankForClass(skill, pcc);
                buffer.append("CLASSBOUGHT").append(':');
                buffer.append('[');
                buffer.append("CLASS").append(':');
                buffer.append(EntityEncoder.encode(pcc == null ? "None" : pcc.getKeyName()));
                buffer.append('|');
                buffer.append("RANKS").append(':');
                buffer.append(rank);
                buffer.append('|');
                buffer.append("COST").append(':');
                buffer.append(Integer.toString(this.thePC.getSkillCostForClass(skill, pcc).getCost()));
                buffer.append('|');
                buffer.append("CLASSSKILL").append(':');
                buffer.append(this.thePC.isClassSkill(pcc, skill) ? (char)'Y' : 'N');
                buffer.append(']');
            }
            for (String assoc : this.thePC.getAssociationList(skill)) {
                buffer.append('|');
                buffer.append("ASSOCIATEDDATA").append(':');
                buffer.append(EntityEncoder.encode(assoc));
            }
            this.appendLevelAbilityInfo(buffer, skill);
            buffer.append("\n");
        }
    }

    private void appendSpeechPatternLine(StringBuilder buffer) {
        buffer.append("SPEECHPATTERN").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.SPEECHTENDENCY)));
        buffer.append("\n");
    }

    private void appendSpellBookLines(StringBuilder buffer) {
        for (SpellBook book : this.charDisplay.getSpellBooks()) {
            String bookName = book.getName();
            if (bookName.equals(Globals.getDefaultSpellBook()) || bookName.equals("Innate")) continue;
            buffer.append("SPELLBOOK").append(':');
            buffer.append(book.getName());
            buffer.append('|');
            buffer.append("TYPE").append(':');
            buffer.append(book.getType());
            if (book.getName().equals(this.thePC.getSpellBookNameToAutoAddKnown())) {
                buffer.append('|');
                buffer.append("AUTOADDKNOWN").append(':');
                buffer.append('Y');
            }
            buffer.append("\n");
        }
    }

    private void appendSpellLines(StringBuilder buffer) {
        for (PCClass pcClass : this.charDisplay.getClassSet()) {
            Collection<? extends CharacterSpell> sp = this.charDisplay.getCharacterSpells(pcClass);
            ArrayList<CharacterSpell> classSpells = new ArrayList<CharacterSpell>(sp);
            this.thePC.addBonusKnownSpellsToList(pcClass, classSpells);
            Collections.sort(classSpells);
            for (CharacterSpell cSpell : classSpells) {
                for (SpellInfo spellInfo : cSpell.getInfoList()) {
                    List<Ability> metaFeats;
                    CDOMObject owner = cSpell.getOwner();
                    List<? extends CDOMList<Spell>> lists = this.charDisplay.getSpellLists(owner);
                    if (SpellLevel.getFirstLevelForKey(cSpell.getSpell(), lists, this.thePC) < 0) {
                        Logging.errorPrint("Ignoring unqualified spell " + cSpell.getSpell() + " in list for class " + pcClass + ".");
                        continue;
                    }
                    if (spellInfo.getBook().equals(Globals.getDefaultSpellBook()) && this.thePC.getSpellSupport(pcClass).isAutoKnownSpell(cSpell.getSpell(), SpellLevel.getFirstLevelForKey(cSpell.getSpell(), lists, this.thePC), false, this.thePC) && this.thePC.getAutoSpells()) continue;
                    buffer.append("SPELLNAME").append(':');
                    buffer.append(EntityEncoder.encode(cSpell.getSpell().getKeyName()));
                    buffer.append('|');
                    buffer.append("TIMES").append(':');
                    buffer.append(spellInfo.getTimes());
                    buffer.append('|');
                    buffer.append("CLASS").append(':');
                    buffer.append(EntityEncoder.encode(pcClass.getKeyName()));
                    buffer.append('|');
                    buffer.append("BOOK").append(':');
                    buffer.append(EntityEncoder.encode(spellInfo.getBook()));
                    buffer.append('|');
                    buffer.append("SPELLLEVEL").append(':');
                    buffer.append(spellInfo.getActualLevel());
                    if (Globals.hasSpellPPCost()) {
                        buffer.append('|');
                        buffer.append("SPELLPPCOST").append(':');
                        buffer.append(spellInfo.getActualPPCost());
                    }
                    if (spellInfo.getNumPages() > 0) {
                        buffer.append('|');
                        buffer.append("SPELLNUMPAGES").append(':');
                        buffer.append(spellInfo.getNumPages());
                    }
                    if ((metaFeats = spellInfo.getFeatList()) != null && !metaFeats.isEmpty()) {
                        buffer.append('|');
                        buffer.append("FEATLIST").append(':');
                        buffer.append('[');
                        String del = "";
                        for (Ability feat : metaFeats) {
                            buffer.append(del);
                            buffer.append("FEAT").append(':');
                            buffer.append(EntityEncoder.encode(feat.getKeyName()));
                            del = "|";
                        }
                        buffer.append(']');
                    }
                    buffer.append('|');
                    PCGVer2Creator.appendSourceInTaggedFormat(buffer, StringPClassUtil.getStringFor(owner.getClass()) + "|" + owner.getKeyName());
                    buffer.append("\n");
                }
            }
        }
    }

    private void appendSpellListLines(StringBuilder buffer) {
        for (PCClass pcClass : this.charDisplay.getClassSet()) {
            TransitionChoice<CDOMListObject<Spell>> csc = pcClass.get(ObjectKey.SPELLLIST_CHOICE);
            if (csc == null) continue;
            List<? extends CDOMList<Spell>> assocList = this.charDisplay.getSpellLists(pcClass);
            buffer.append("SPELLLIST").append(':');
            buffer.append(pcClass.getKeyName());
            for (CDOMList<Spell> cDOMList : assocList) {
                buffer.append('|');
                if (ClassSpellList.class.equals(cDOMList.getClass())) {
                    buffer.append("CLASS");
                } else {
                    buffer.append("DOMAIN");
                }
                buffer.append('.').append(cDOMList.getLSTformat());
            }
            buffer.append("\n");
        }
    }

    private void appendStatLines(StringBuilder buffer) {
        for (PCStat aStat : this.charDisplay.getStatSet()) {
            buffer.append("STAT").append(':');
            buffer.append(aStat.getKeyName());
            buffer.append('|');
            buffer.append("SCORE").append(':');
            buffer.append(this.charDisplay.getStat(aStat));
            buffer.append("\n");
        }
    }

    private void appendTabNameLine(StringBuilder buffer) {
        buffer.append("TABNAME").append(':');
        buffer.append(EntityEncoder.encode(this.charDisplay.getSafeStringFor(PCStringKey.TABNAME)));
        buffer.append("\n");
    }

    private void appendTempBonuses(StringBuilder buffer) {
        ArrayList<String> trackList = new ArrayList<String>();
        TreeSet<Map.Entry<BonusObj, BonusManager.TempBonusInfo>> sortedbonus = new TreeSet<Map.Entry<BonusObj, BonusManager.TempBonusInfo>>(new Comparator<Map.Entry<BonusObj, BonusManager.TempBonusInfo>>(){

            @Override
            public int compare(Map.Entry<BonusObj, BonusManager.TempBonusInfo> a, Map.Entry<BonusObj, BonusManager.TempBonusInfo> b) {
                BonusObj keyA = a.getKey();
                BonusObj keyB = b.getKey();
                if (!keyA.getBonusName().equals(keyB.getBonusName())) {
                    return keyA.getBonusName().compareTo(keyB.getBonusName());
                }
                if (!keyA.getBonusInfo().equals(keyB.getBonusInfo())) {
                    return keyA.getBonusInfo().compareTo(keyB.getBonusInfo());
                }
                return keyA.getPCCText().compareTo(keyB.getPCCText());
            }
        });
        sortedbonus.addAll(this.thePC.getTempBonusMap().entrySet());
        for (Map.Entry<BonusObj, BonusManager.TempBonusInfo> me : sortedbonus) {
            BonusObj bonus = me.getKey();
            BonusManager.TempBonusInfo tbi = me.getValue();
            Object creObj = tbi.source;
            Object tarObj = tbi.target;
            String outString = this.tempBonusName(creObj, tarObj);
            if (trackList.contains(outString)) continue;
            trackList.add(outString);
            buffer.append(outString);
            String bonusName = BonusDisplay.getBonusDisplayName(tbi);
            if (this.thePC.getTempBonusFilters().contains(bonusName)) {
                buffer.append('|');
                buffer.append("TBACTIVE").append(":N");
            }
            for (Map.Entry<BonusObj, BonusManager.TempBonusInfo> subme : sortedbonus) {
                BonusObj subBonus = subme.getKey();
                BonusManager.TempBonusInfo subtbi = subme.getValue();
                Object cObj = subtbi.source;
                Object tObj = subtbi.target;
                String inString = this.tempBonusName(cObj, tObj);
                if (!inString.equals(outString)) continue;
                buffer.append('|');
                buffer.append("TBBONUS").append(':');
                buffer.append(EntityEncoder.encode(subBonus.getPCCText()));
            }
            buffer.append("\n");
        }
    }

    private void appendTemplateLines(StringBuilder buffer) {
        for (PCTemplate template : this.charDisplay.getTemplateSet()) {
            List<String> assocList;
            Collection<PCTemplate> templatesAdded;
            buffer.append("TEMPLATESAPPLIED").append(':').append('[');
            buffer.append("NAME").append(':').append(EntityEncoder.encode(template.getKeyName()));
            String chosenFeats = this.chosenFeats(template);
            if (chosenFeats.length() != 0) {
                buffer.append('|').append(chosenFeats);
            }
            if ((templatesAdded = this.thePC.getTemplatesAdded(template)) != null) {
                for (PCTemplate ownedTemplate : templatesAdded) {
                    buffer.append('|').append("CHOSENTEMPLATE").append(':').append('[');
                    buffer.append("NAME").append(':').append(EntityEncoder.encode(ownedTemplate.getKeyName()));
                    buffer.append(']');
                }
            }
            if ((assocList = this.thePC.getAssociationList(template)) != null && !assocList.isEmpty()) {
                buffer.append("|");
                buffer.append("APPLIEDTO").append(":");
                boolean first = true;
                for (String assoc : assocList) {
                    if (!first) {
                        buffer.append(",");
                    }
                    first = false;
                    buffer.append(EntityEncoder.encode(assoc));
                }
            }
            buffer.append(']');
            this.appendAddTokenInfo(buffer, template);
            buffer.append("\n");
        }
    }

    private void appendUseTempModsLine(StringBuilder buffer) {
        buffer.append("USETEMPMODS").append(':');
        buffer.append(this.thePC.getUseTempMods() ? (char)'Y' : 'N');
        buffer.append("\n");
    }

    private void appendWeaponProficiencyLines(StringBuilder buffer) {
        int size = this.charDisplay.getWeaponProfSet().size();
        if (size > 0) {
            String[] weaponProficiencies = new String[size];
            int j = 0;
            for (WeaponProf wp : this.charDisplay.getSortedWeaponProfs()) {
                weaponProficiencies[j++] = wp.getKeyName();
            }
            int step = 10;
            int times = size / 10 + (size % 10 > 0 ? 1 : 0);
            for (int k = 0; k < times; ++k) {
                buffer.append("WEAPONPROF").append(':');
                buffer.append('[');
                String del = "";
                int stop = Math.min(size, k * 10 + 10);
                for (int i = k * 10; i < stop; ++i) {
                    buffer.append(del);
                    buffer.append("WEAPON").append(':');
                    buffer.append(EntityEncoder.encode(weaponProficiencies[i]));
                    del = "|";
                }
                buffer.append(']');
                buffer.append("\n");
            }
        }
        this.appendWeaponProficiencyLines(buffer, this.charDisplay.getRace());
        for (PCTemplate pct : this.charDisplay.getTemplateSet()) {
            this.appendWeaponProficiencyLines(buffer, pct);
        }
        for (PCClass pcClass : this.charDisplay.getClassSet()) {
            this.appendWeaponProficiencyLines(buffer, pcClass);
        }
    }

    private void appendWeaponProficiencyLines(StringBuilder buffer, CDOMObject source) {
        if (source == null) {
            return;
        }
        List<? extends WeaponProf> profs = this.thePC.getBonusWeaponProfs(source);
        if (profs == null || profs.isEmpty()) {
            return;
        }
        int step = 10;
        int times = profs.size() / 10 + 1;
        for (int k = 0; k < times; ++k) {
            buffer.append("WEAPONPROF").append(':');
            buffer.append('[');
            String del = "";
            int stop = Math.min(profs.size(), k * 10 + 10);
            for (int i = k * 10; i < stop; ++i) {
                buffer.append(del);
                buffer.append("WEAPON").append(':');
                buffer.append(EntityEncoder.encode(profs.get(i).getLSTformat()));
                del = "|";
            }
            buffer.append(']');
            buffer.append('|');
            PCGVer2Creator.appendSourceInTaggedFormat(buffer, source);
            buffer.append("\n");
        }
    }

    private void appendMoneyLine(StringBuilder buffer) {
        buffer.append("MONEY").append(':');
        buffer.append(this.thePC.getGold().toString());
        buffer.append("\n");
    }

    private void appendWeightLine(StringBuilder buffer) {
        buffer.append("WEIGHT").append(':');
        buffer.append(this.charDisplay.getWeight());
        buffer.append("\n");
    }

    private String chosenFeats(PCTemplate pct) {
        List<? extends CNAbilitySelection> featList;
        StringBuilder aString = new StringBuilder(50);
        for (PCTemplate rlt : pct.getSafeListFor(ListKey.REPEATLEVEL_TEMPLATES)) {
            for (PCTemplate lt : rlt.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
                List<? extends CNAbilitySelection> featList2 = this.thePC.getTemplateFeatList(lt);
                if (featList2 == null) continue;
                this.writeTemplateFeat(aString, lt, featList2);
            }
        }
        for (PCTemplate lt : pct.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
            featList = this.thePC.getTemplateFeatList(lt);
            if (featList == null) continue;
            this.writeTemplateFeat(aString, lt, featList);
        }
        for (PCTemplate lt : pct.getSafeListFor(ListKey.HD_TEMPLATES)) {
            featList = this.thePC.getTemplateFeatList(lt);
            if (featList == null) continue;
            this.writeTemplateFeat(aString, lt, featList);
        }
        return aString.toString();
    }

    private void writeTemplateFeat(StringBuilder aString, PCTemplate pct, List<? extends CNAbilitySelection> featList) {
        for (CNAbilitySelection cNAbilitySelection : featList) {
            if (aString.length() != 0) {
                aString.append('|');
            }
            String featKey = Compatibility.getKeyFor(pct);
            aString.append("CHOSENFEAT").append(':');
            aString.append('[');
            aString.append("KEY").append(':').append(EntityEncoder.encode(featKey)).append('|');
            aString.append("VALUE").append(':').append(EntityEncoder.encode(cNAbilitySelection.getPersistentFormat()));
            aString.append(']');
        }
    }

    private static String createComment(String s) {
        String work = s + "\n";
        work = work.replace('\t', ' ');
        work = work.replace('\f', ' ');
        StringBuilder buffer = new StringBuilder(work.length() + 100);
        StringTokenizer tokens = new StringTokenizer(work, "#");
        while (tokens.hasMoreTokens()) {
            buffer.append(tokens.nextToken());
        }
        work = buffer.toString();
        buffer.setLength(0);
        tokens = new StringTokenizer(work, "\r\n");
        while (tokens.hasMoreTokens()) {
            buffer.append("# ").append(tokens.nextToken()).append("\n");
        }
        return buffer.toString();
    }

    private String tempBonusName(Object creator, Object target) {
        CDOMObject oCreator;
        StringBuilder cb = new StringBuilder(100);
        cb.append("TEMPBONUS").append(':');
        if (creator instanceof CDOMObject) {
            oCreator = (CDOMObject)creator;
            if (oCreator instanceof Ability) {
                cb.append("FEAT").append('=');
            } else if (oCreator instanceof Spell) {
                cb.append("SPELL").append('=');
            } else if (oCreator instanceof Equipment) {
                cb.append("EQUIPMENT").append('=');
            } else if (oCreator instanceof PCClass) {
                cb.append("CLASS").append('=');
            } else if (oCreator instanceof PCTemplate) {
                cb.append("TEMPLATE").append('=');
            } else if (oCreator instanceof Skill) {
                cb.append("SKILL").append('=');
            } else {
                cb.append("ERROR").append('=');
            }
        } else {
            return "";
        }
        cb.append(EntityEncoder.encode(oCreator.getKeyName()));
        cb.append('|');
        cb.append("TBTARGET").append(':');
        if (target instanceof PlayerCharacter) {
            cb.append("PC");
        } else if (target instanceof Equipment) {
            cb.append(EntityEncoder.encode(((Equipment)target).getName()));
        }
        return cb.toString();
    }

    private void appendLevelAbilityInfo(StringBuilder buffer, CDOMObject pObj) {
        this.appendAddTokenInfo(buffer, pObj);
    }

    private void appendAddTokenInfo(StringBuilder buffer, CDOMObject pObj) {
        List<PersistentTransitionChoice<?>> addList = pObj.getListFor(ListKey.ADD);
        if (addList == null) {
            return;
        }
        for (PersistentTransitionChoice<?> tc : addList) {
            this.addChoices(buffer, tc);
        }
    }

    private <T> void addChoices(StringBuilder buffer, PersistentTransitionChoice<T> tc) {
        List<Object> assocList = this.thePC.getAssocList(tc, AssociationListKey.ADD);
        if (assocList == null) {
            return;
        }
        SelectableSet choices = tc.getChoices();
        buffer.append('|').append("ADD").append(':').append('[');
        buffer.append(EntityEncoder.encode(choices.getName())).append(':');
        buffer.append(EntityEncoder.encode(choices.getLSTformat()));
        for (Object assoc : assocList) {
            buffer.append('|').append("CHOICE").append(':').append(EntityEncoder.encode(tc.encodeChoice(tc.castChoice(assoc))));
        }
        buffer.append(']');
    }
}

