/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import pcgen.core.InstallableCampaign;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.InstallLstToken;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class InstallLoader
extends LstLineFileLoader {
    private InstallableCampaign campaign = null;

    @Override
    public void loadLstString(LoadContext context, URI fileName, String lstData) throws PersistenceLayerException {
        this.campaign = new InstallableCampaign();
        this.campaign.setSourceURI(fileName);
        super.loadLstString(context, fileName, lstData);
    }

    @Override
    public void parseLine(LoadContext context, String inputLine, URI sourceURI) throws PersistenceLayerException {
        int idxColon = inputLine.indexOf(58);
        if (idxColon < 0) {
            Logging.errorPrint("Unparsed line: " + inputLine + " in " + sourceURI.toString());
            return;
        }
        String key = inputLine.substring(0, idxColon);
        String value = inputLine.substring(idxColon + 1);
        Map<String, LstToken> tokenMap = TokenStore.inst().getTokenMap(InstallLstToken.class);
        InstallLstToken token = (InstallLstToken)tokenMap.get(key);
        if (token != null) {
            LstUtils.deprecationCheck(token, this.campaign, value);
            if (!token.parse(this.campaign, new String(value), sourceURI)) {
                Logging.errorPrint("Error parsing install " + this.campaign.getDisplayName() + ':' + inputLine);
            }
        } else {
            Logging.errorPrint("Unparsed line: " + inputLine + " in " + sourceURI.toString());
        }
    }

    public InstallableCampaign getCampaign() {
        return this.campaign;
    }
}

