/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.util.logging.LogRecord;
import javax.swing.event.EventListenerList;
import pcgen.system.PCGenTaskEvent;
import pcgen.system.PCGenTaskListener;
import pcgen.util.Logging;

public abstract class PCGenTask {
    private EventListenerList listenerList = new EventListenerList();
    private int progress = 0;
    private int maximum = 0;
    private String message;

    public void addPCGenTaskListener(PCGenTaskListener listener) {
        this.listenerList.add(PCGenTaskListener.class, listener);
    }

    public void removePCGenTaskListener(PCGenTaskListener listener) {
        this.listenerList.remove(PCGenTaskListener.class, listener);
    }

    public abstract void execute();

    public int getMaximum() {
        return this.maximum;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setValues(int progress, int maximum) {
        this.progress = progress;
        this.maximum = maximum;
        this.fireProgressChangedEvent();
    }

    protected void setValues(String message, int progress, int maximum) {
        this.progress = progress;
        this.maximum = maximum;
        this.message = message;
        this.fireProgressChangedEvent();
    }

    protected void setProgress(int progress) {
        this.progress = progress;
        this.fireProgressChangedEvent();
    }

    protected void setProgress(String message, int progress) {
        this.message = message;
        this.progress = progress;
        this.fireProgressChangedEvent();
    }

    protected void setMaximum(int maximum) {
        this.maximum = maximum;
        this.fireProgressChangedEvent();
    }

    protected void fireProgressChangedEvent() {
        PCGenTaskEvent taskEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PCGenTaskListener.class) continue;
            if (taskEvent == null) {
                taskEvent = new PCGenTaskEvent(this);
            }
            ((PCGenTaskListener)listeners[i + 1]).progressChanged(taskEvent);
        }
    }

    protected void sendErrorMessage(Exception e) {
        LogRecord record = new LogRecord(Logging.ERROR, e.getMessage());
        record.setThrown(e);
        this.fireErrorOccurredEvent(record);
    }

    protected void sendErrorMessage(LogRecord record) {
        this.fireErrorOccurredEvent(record);
    }

    protected void sendErrorMessage(String message) {
        this.fireErrorOccurredEvent(new LogRecord(Logging.ERROR, message));
    }

    protected void fireErrorOccurredEvent(LogRecord message) {
        PCGenTaskEvent taskEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PCGenTaskListener.class) continue;
            if (taskEvent == null) {
                taskEvent = new PCGenTaskEvent(this, message);
            }
            ((PCGenTaskListener)listeners[i + 1]).errorOccurred(taskEvent);
        }
    }
}

