/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.basekit;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.helper.OptionBound;
import pcgen.core.kit.BaseKit;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class OptionToken
extends AbstractNonEmptyToken<BaseKit>
implements CDOMPrimaryToken<BaseKit> {
    @Override
    public String getTokenName() {
        return "OPTION";
    }

    @Override
    public Class<BaseKit> getTokenClass() {
        return BaseKit.class;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, BaseKit kit, String value) {
        ParsingSeparator pipeSep = new ParsingSeparator(value, '|');
        while (pipeSep.hasNext()) {
            String subTok = pipeSep.next();
            if (subTok.length() == 0) {
                return new ParseResult.Fail(this.getTokenName() + " arguments has invalid pipe separator: " + value, context);
            }
            ParseResult pr = this.checkForIllegalSeparator(',', subTok);
            if (!pr.passed()) {
                return pr;
            }
            ParsingSeparator commaSep = new ParsingSeparator(subTok, ',');
            String minString = commaSep.next();
            String maxString = commaSep.hasNext() ? commaSep.next() : subTok;
            if (commaSep.hasNext()) {
                return new ParseResult.Fail("Token cannot have more than one separator ','", context);
            }
            Formula min = FormulaFactory.getFormulaFor(minString);
            if (!min.isValid()) {
                return new ParseResult.Fail("Min Formula in " + this.getTokenName() + " was not valid: " + min.toString(), context);
            }
            Formula max = FormulaFactory.getFormulaFor(maxString);
            if (!max.isValid()) {
                return new ParseResult.Fail("Max Formula in " + this.getTokenName() + " was not valid: " + max.toString(), context);
            }
            kit.setOptionBounds(min, max);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, BaseKit kit) {
        Collection<OptionBound> bounds = kit.getBounds();
        if (bounds == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (OptionBound bound : bounds) {
            Formula min = bound.getOptionMin();
            Formula max = bound.getOptionMax();
            if (min == null || max == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(min);
            if (!min.equals(max)) {
                sb.append(',').append(max);
            }
            list.add(sb.toString());
        }
        return new String[]{StringUtil.join(list, (String)"|")};
    }
}

