/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.FloatingInfo;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.CollectionUtilities;

public class RRelative
extends BaseRCollection {
    private final RElement child;
    private final int xoffset;
    private final int yoffset;

    public RRelative(RenderableContainer container, ModelNode modelNode, RElement child, int xoffset, int yoffset) {
        super(container, modelNode);
        child.setOriginalParent(this);
        child.setParent(this);
        child.setOrigin(xoffset, yoffset);
        this.child = child;
        this.xoffset = xoffset;
        this.yoffset = yoffset;
    }

    public void assignDimension() {
        RElement child = this.child;
        this.width = child.getWidth();
        this.height = child.getHeight();
    }

    public FloatingInfo getExportableFloatingInfo() {
        RElement child = this.child;
        if (child instanceof RBlock) {
            return ((RBlock)child).getExportableFloatingInfo();
        }
        return null;
    }

    public RElement getElement() {
        return this.child;
    }

    public int getXOffset() {
        return this.xoffset;
    }

    public int getYOffset() {
        return this.yoffset;
    }

    public Iterator getRenderables() {
        return CollectionUtilities.singletonIterator(this.child);
    }

    protected void invalidateLayoutLocal() {
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        return this.child.getLowestRenderableSpot(x - this.xoffset, y - this.yoffset);
    }

    public boolean isContainedByNode() {
        return true;
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        return this.child.onDoubleClick(event, x - this.xoffset, y - this.yoffset);
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        return this.child.onMouseClick(event, x - this.xoffset, y - this.yoffset);
    }

    public boolean onMouseDisarmed(MouseEvent event) {
        return this.child.onMouseDisarmed(event);
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        return this.child.onMousePressed(event, x - this.xoffset, y - this.yoffset);
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        return this.child.onMouseReleased(event, x - this.xoffset, y - this.yoffset);
    }

    public void paint(Graphics g) {
        this.child.paintTranslated(g);
    }
}

