/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.NodeTreeModel;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.lobobrowser.util.io.IORoutines;
import org.w3c.dom.Document;

public class ParserTest
extends JFrame {
    private static final Logger logger = Logger.getLogger(ParserTest.class.getName());
    private final JTree tree;
    private final JTextArea textArea;

    public ParserTest() throws HeadlessException {
        this("HTML Parser-Only Test Tool");
    }

    public ParserTest(String title) throws HeadlessException {
        super(title);
        this.setDefaultCloseOperation(3);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        final JTextField textField = new JTextField();
        JButton button = new JButton("Parse & Render");
        JTabbedPane tabbedPane = new JTabbedPane();
        JTree tree = new JTree();
        tree.setModel(null);
        JScrollPane scrollPane = new JScrollPane(tree);
        this.tree = tree;
        contentPane.add((Component)topPanel, "North");
        contentPane.add((Component)bottomPanel, "Center");
        topPanel.add((Component)new JLabel("URL: "), "West");
        topPanel.add((Component)textField, "Center");
        topPanel.add((Component)button, "East");
        bottomPanel.add((Component)tabbedPane, "Center");
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        this.textArea = textArea;
        JScrollPane textAreaSp = new JScrollPane(textArea);
        tabbedPane.addTab("HTML DOM", scrollPane);
        tabbedPane.addTab("Source Code", textAreaSp);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ParserTest.this.process(textField.getText());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String uri) {
        try {
            byte[] content;
            URL url;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException mfu) {
                int idx = uri.indexOf(58);
                if (idx == -1 || idx == 1) {
                    url = new URL("file:" + uri);
                }
                throw mfu;
            }
            logger.info("process(): Loading URI=[" + uri + "].");
            long time0 = System.currentTimeMillis();
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible;) Cobra/0.96.1+");
            connection.setRequestProperty("Cookie", "");
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection hc = (HttpURLConnection)connection;
                hc.setInstanceFollowRedirects(true);
                int responseCode = hc.getResponseCode();
                logger.info("process(): HTTP response code: " + responseCode);
            }
            InputStream in = connection.getInputStream();
            try {
                content = IORoutines.load(in, 8192);
            }
            finally {
                in.close();
            }
            String source = new String(content, "ISO-8859-1");
            this.textArea.setText(source);
            long time1 = System.currentTimeMillis();
            ByteArrayInputStream bin = new ByteArrayInputStream(content);
            SimpleUserAgentContext ucontext = new SimpleUserAgentContext();
            DocumentBuilderImpl builder = new DocumentBuilderImpl(ucontext);
            String actualURI = url.toExternalForm();
            Document document = builder.parse(new InputSourceImpl(bin, actualURI, "ISO-8859-1"));
            long time2 = System.currentTimeMillis();
            logger.info("Parsed URI=[" + uri + "]: Parse elapsed: " + (time2 - time1) + " ms. Load elapsed: " + (time1 - time0) + " ms.");
            this.tree.setModel(new NodeTreeModel(document));
        }
        catch (Exception err) {
            logger.log(Level.SEVERE, "Error trying to load URI=[" + uri + "].", err);
        }
    }

    public static void main(String[] args) {
        ParserTest frame = new ParserTest();
        frame.setSize(800, 400);
        frame.setExtendedState(6);
        frame.setVisible(true);
    }
}

