// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/machine_images/v1/machine_images.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_MACHINE_IMAGES_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_MACHINE_IMAGES_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/machine_images/v1/machine_images.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_machine_images_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MachineImagesConnectionIdempotencyPolicy {
 public:
  virtual ~MachineImagesConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<MachineImagesConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency DeleteMachineImage(
      google::cloud::cpp::compute::machine_images::v1::
          DeleteMachineImageRequest const& request);

  virtual google::cloud::Idempotency GetMachineImage(
      google::cloud::cpp::compute::machine_images::v1::
          GetMachineImageRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::cloud::cpp::compute::machine_images::v1::
          GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency InsertMachineImage(
      google::cloud::cpp::compute::machine_images::v1::
          InsertMachineImageRequest const& request);

  virtual google::cloud::Idempotency ListMachineImages(
      google::cloud::cpp::compute::machine_images::v1::ListMachineImagesRequest
          request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::cloud::cpp::compute::machine_images::v1::
          SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::cloud::cpp::compute::machine_images::v1::
          TestIamPermissionsRequest const& request);
};

std::unique_ptr<MachineImagesConnectionIdempotencyPolicy>
MakeDefaultMachineImagesConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_machine_images_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_MACHINE_IMAGES_CONNECTION_IDEMPOTENCY_POLICY_H
