// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/group_service.proto

#include "google/cloud/monitoring/v3/internal/group_auth_decorator.h"
#include <google/monitoring/v3/group_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GroupServiceAuth::GroupServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<GroupServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::monitoring::v3::ListGroupsResponse>
GroupServiceAuth::ListGroups(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::ListGroupsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListGroups(context, options, request);
}

StatusOr<google::monitoring::v3::Group> GroupServiceAuth::GetGroup(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::GetGroupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetGroup(context, options, request);
}

StatusOr<google::monitoring::v3::Group> GroupServiceAuth::CreateGroup(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::CreateGroupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateGroup(context, options, request);
}

StatusOr<google::monitoring::v3::Group> GroupServiceAuth::UpdateGroup(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::UpdateGroupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateGroup(context, options, request);
}

Status GroupServiceAuth::DeleteGroup(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::DeleteGroupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteGroup(context, options, request);
}

StatusOr<google::monitoring::v3::ListGroupMembersResponse>
GroupServiceAuth::ListGroupMembers(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::ListGroupMembersRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListGroupMembers(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
