// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/managed_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_MANAGED_NOTEBOOK_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_MANAGED_NOTEBOOK_CLIENT_H

#include "google/cloud/notebooks/v1/managed_notebook_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace notebooks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// API v1 service for Managed Notebooks.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ManagedNotebookServiceClient {
 public:
  explicit ManagedNotebookServiceClient(
      std::shared_ptr<ManagedNotebookServiceConnection> connection,
      Options opts = {});
  ~ManagedNotebookServiceClient();

  ///@{
  /// @name Copy and move support
  ManagedNotebookServiceClient(ManagedNotebookServiceClient const&) = default;
  ManagedNotebookServiceClient& operator=(ManagedNotebookServiceClient const&) =
      default;
  ManagedNotebookServiceClient(ManagedNotebookServiceClient&&) = default;
  ManagedNotebookServiceClient& operator=(ManagedNotebookServiceClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ManagedNotebookServiceClient const& a,
                         ManagedNotebookServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ManagedNotebookServiceClient const& a,
                         ManagedNotebookServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists Runtimes in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Runtime], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.ListRuntimesRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L209}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Runtime> ListRuntimes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Runtimes in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ListRuntimesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Runtime], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.ListRuntimesRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L209}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Runtime> ListRuntimes(
      google::cloud::notebooks::v1::ListRuntimesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Runtime. The location must be a regional endpoint
  /// rather than zonal.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Runtime])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.GetRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L243}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Runtime> GetRuntime(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Runtime. The location must be a regional endpoint
  /// rather than zonal.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.GetRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Runtime])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.GetRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L243}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Runtime> GetRuntime(
      google::cloud::notebooks::v1::GetRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Runtime in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param runtime_id  Required. User-defined unique ID of this Runtime.
  /// @param runtime  Required. The Runtime to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L255}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> CreateRuntime(
      std::string const& parent, std::string const& runtime_id,
      google::cloud::notebooks::v1::Runtime const& runtime, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateRuntime(
      NoAwaitTag, std::string const& parent, std::string const& runtime_id,
      google::cloud::notebooks::v1::Runtime const& runtime, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Runtime in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.CreateRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L255}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> CreateRuntime(
      google::cloud::notebooks::v1::CreateRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::CreateRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> CreateRuntime(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Update Notebook Runtime configuration.
  ///
  /// @param runtime  Required. The Runtime to be updated.
  /// @param update_mask  Required. Specifies the path, relative to `Runtime`, of
  ///  the field to update. For example, to change the software configuration
  ///  kernels, the `update_mask` parameter would be
  ///  specified as `software_config.kernels`,
  ///  and the `PATCH` request body would specify the new value.
  ///  @n
  ///  For more information, see [UpdateRuntimeRequest][google.cloud.notebooks.v1.UpdateRuntimeRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.UpdateRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L368}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> UpdateRuntime(
      google::cloud::notebooks::v1::Runtime const& runtime,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateRuntime(
      NoAwaitTag, google::cloud::notebooks::v1::Runtime const& runtime,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update Notebook Runtime configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.UpdateRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.UpdateRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L368}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> UpdateRuntime(
      google::cloud::notebooks::v1::UpdateRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::UpdateRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> UpdateRuntime(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Runtime.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L276}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteRuntime(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteRuntime(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Runtime.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.DeleteRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L276}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteRuntime(
      google::cloud::notebooks::v1::DeleteRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::DeleteRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteRuntime(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Starts a Managed Notebook Runtime.
  /// Perform "Start" on GPU instances; "Resume" on CPU instances
  /// See:
  /// https://cloud.google.com/compute/docs/instances/stop-start-instance
  /// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.StartRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L291}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> StartRuntime(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief StartRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StartRuntime(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Starts a Managed Notebook Runtime.
  /// Perform "Start" on GPU instances; "Resume" on CPU instances
  /// See:
  /// https://cloud.google.com/compute/docs/instances/stop-start-instance
  /// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.StartRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.StartRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L291}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> StartRuntime(
      google::cloud::notebooks::v1::StartRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StartRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StartRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::StartRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StartRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> StartRuntime(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Stops a Managed Notebook Runtime.
  /// Perform "Stop" on GPU instances; "Suspend" on CPU instances
  /// See:
  /// https://cloud.google.com/compute/docs/instances/stop-start-instance
  /// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.StopRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L301}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> StopRuntime(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief StopRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StopRuntime(NoAwaitTag,
                                                       std::string const& name,
                                                       Options opts = {});

  // clang-format off
  ///
  /// Stops a Managed Notebook Runtime.
  /// Perform "Stop" on GPU instances; "Suspend" on CPU instances
  /// See:
  /// https://cloud.google.com/compute/docs/instances/stop-start-instance
  /// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.StopRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.StopRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L301}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> StopRuntime(
      google::cloud::notebooks::v1::StopRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StopRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StopRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::StopRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StopRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> StopRuntime(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Switch a Managed Notebook Runtime.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.SwitchRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L311}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> SwitchRuntime(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief SwitchRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> SwitchRuntime(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Switch a Managed Notebook Runtime.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.SwitchRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.SwitchRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L311}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> SwitchRuntime(
      google::cloud::notebooks::v1::SwitchRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief SwitchRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> SwitchRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::SwitchRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief SwitchRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> SwitchRuntime(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Resets a Managed Notebook Runtime.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.ResetRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L327}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> ResetRuntime(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResetRuntime(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Resets a Managed Notebook Runtime.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ResetRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.ResetRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L327}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> ResetRuntime(
      google::cloud::notebooks::v1::ResetRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResetRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::ResetRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> ResetRuntime(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Upgrades a Managed Notebook Runtime to the latest version.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.UpgradeRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L339}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> UpgradeRuntime(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpgradeRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpgradeRuntime(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Upgrades a Managed Notebook Runtime to the latest version.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.UpgradeRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  /// [google.cloud.notebooks.v1.UpgradeRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L339}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> UpgradeRuntime(
      google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpgradeRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpgradeRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpgradeRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> UpgradeRuntime(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Report and process a runtime event.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.ReportRuntimeEventRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L349}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> ReportRuntimeEvent(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReportRuntimeEvent
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ReportRuntimeEvent(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Report and process a runtime event.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ReportRuntimeEventRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.ReportRuntimeEventRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L349}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> ReportRuntimeEvent(
      google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReportRuntimeEvent
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ReportRuntimeEvent(
      NoAwaitTag,
      google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReportRuntimeEvent
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> ReportRuntimeEvent(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets an access token for the consumer service account that the customer
  /// attached to the runtime. Only accessible from the tenant instance.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
  /// @param vm_id  Required. The VM hardware token for authenticating the VM.
  ///  https://cloud.google.com/compute/docs/instances/verifying-instance-identity
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.RefreshRuntimeTokenInternalRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L402}
  /// [google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L418}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::RefreshRuntimeTokenInternalResponse>
  RefreshRuntimeTokenInternal(std::string const& name, std::string const& vm_id,
                              Options opts = {});

  // clang-format off
  ///
  /// Gets an access token for the consumer service account that the customer
  /// attached to the runtime. Only accessible from the tenant instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.RefreshRuntimeTokenInternalRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.RefreshRuntimeTokenInternalRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L402}
  /// [google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L418}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::RefreshRuntimeTokenInternalResponse>
  RefreshRuntimeTokenInternal(
      google::cloud::notebooks::v1::RefreshRuntimeTokenInternalRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Diagnostic File and runs Diagnostic Tool given a Runtime.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/runtimes/{runtimes_id}`
  /// @param diagnostic_config  Required. Defines flags that are used to run the diagnostic tool
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DiagnoseRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L427}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> DiagnoseRuntime(
      std::string const& name,
      google::cloud::notebooks::v1::DiagnosticConfig const& diagnostic_config,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DiagnoseRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DiagnoseRuntime(
      NoAwaitTag, std::string const& name,
      google::cloud::notebooks::v1::DiagnosticConfig const& diagnostic_config,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Diagnostic File and runs Diagnostic Tool given a Runtime.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.DiagnoseRuntimeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Runtime] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DiagnoseRuntimeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/managed_service.proto#L427}
  /// [google.cloud.notebooks.v1.Runtime]: @googleapis_reference_link{google/cloud/notebooks/v1/runtime.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> DiagnoseRuntime(
      google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DiagnoseRuntime
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DiagnoseRuntime(
      NoAwaitTag,
      google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DiagnoseRuntime
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Runtime>> DiagnoseRuntime(
      google::longrunning::Operation const& operation, Options opts = {});

 private:
  std::shared_ptr<ManagedNotebookServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_MANAGED_NOTEBOOK_CLIENT_H
