// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policysimulator/v1/simulator.proto

#include "google/cloud/policysimulator/v1/simulator_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace policysimulator_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SimulatorConnectionIdempotencyPolicy::~SimulatorConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<SimulatorConnectionIdempotencyPolicy>
SimulatorConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SimulatorConnectionIdempotencyPolicy>(*this);
}

Idempotency SimulatorConnectionIdempotencyPolicy::GetReplay(
    google::cloud::policysimulator::v1::GetReplayRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SimulatorConnectionIdempotencyPolicy::CreateReplay(
    google::cloud::policysimulator::v1::CreateReplayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SimulatorConnectionIdempotencyPolicy::ListReplayResults(
    google::cloud::policysimulator::v1::ListReplayResultsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<SimulatorConnectionIdempotencyPolicy>
MakeDefaultSimulatorConnectionIdempotencyPolicy() {
  return std::make_unique<SimulatorConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policysimulator_v1
}  // namespace cloud
}  // namespace google
