/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.registry.DeleteRegistryItemAction;
import com.install4j.runtime.beans.actions.registry.SetRegistryValueAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class RegisterAddRemoveAction
extends SystemAutoUninstallInstallAction {
    private String itemName = "";
    private ExternalFile icon;
    private static final String UNINSTALL_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
    private static final String DISPLAY_NAME_VALUE_NAME = "DisplayName";
    private static final String DISPLAY_ICON_VALUE_NAME = "DisplayIcon";
    private static final String DISPLAY_VERSION_VALUE_NAME = "DisplayVersion";
    private static final String UNINSTALL_STRING_VALUE_NAME = "UninstallString";
    private static final String PUBLISHER_VALUE_NAME = "Publisher";
    private static final String URL_INFO_ABOUT_VALUE_NAME = "URLInfoAbout";
    private static final String VERSION_MAJOR_VALUE_NAME = "VersionMajor";
    private static final String VERSION_MINOR_VALUE_NAME = "VersionMinor";
    private static final String INSTALL_LOCATION_VALUE_NAME = "InstallLocation";

    public boolean uninstall(UninstallerContext uninstallerContext) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        File file = uninstallerContext.getDestinationFile(this.getUninstallerFilename());
        if (file.exists()) {
            this.removeUninstallLinks(file, uninstallerContext);
        }
        return true;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        String string;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        File file = installerContext.getDestinationFile(this.getUninstallerFilename());
        if (!file.exists()) {
            Logger.getInstance().log(this, "No uninstaller was found.", false);
            return false;
        }
        this.removeUninstallLinks(file, installerContext);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        RegistryRoot registryRoot = RegistryRoot.HKEY_LOCAL_MACHINE;
        String string2 = this.getUnusedKey(UNINSTALL_KEY + installerContext.getApplicationId(), registryRoot);
        if (WinRegistry.createKey(registryRoot, string2)) {
            WinRegistry.deleteKey(registryRoot, string2, true);
        } else {
            registryRoot = RegistryRoot.HKEY_CURRENT_USER;
            string2 = this.getUnusedKey(UNINSTALL_KEY + installerContext.getApplicationId(), registryRoot);
        }
        SetRegistryValueAction setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, DISPLAY_NAME_VALUE_NAME, this.getItemName(), false);
        this.addRollbackAction(setRegistryValueAction);
        setRegistryValueAction.execute(installerContext);
        File file2 = installerContext.getExternalFile(this.getIcon(), true);
        if (file2 != null) {
            setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, DISPLAY_ICON_VALUE_NAME, file2.getAbsolutePath(), false);
            this.addRollbackAction(setRegistryValueAction);
            setRegistryValueAction.execute(installerContext);
        }
        setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, UNINSTALL_STRING_VALUE_NAME, "\"" + file.getAbsolutePath() + "\"", false);
        this.addRollbackAction(setRegistryValueAction);
        setRegistryValueAction.execute(installerContext);
        String string3 = installerConfig.getPublisherName();
        if (string3 != null && !string3.trim().equals("")) {
            setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, PUBLISHER_VALUE_NAME, string3, false);
            this.addRollbackAction(setRegistryValueAction);
            setRegistryValueAction.execute(installerContext);
        }
        if ((string = installerConfig.getPublisherURL()) != null && !string.trim().equals("")) {
            setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, URL_INFO_ABOUT_VALUE_NAME, string, false);
            this.addRollbackAction(setRegistryValueAction);
            setRegistryValueAction.execute(installerContext);
        }
        setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, INSTALL_LOCATION_VALUE_NAME, installerContext.getInstallationDirectory().getAbsolutePath(), false);
        this.addRollbackAction(setRegistryValueAction);
        setRegistryValueAction.execute(installerContext);
        try {
            setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, DISPLAY_VERSION_VALUE_NAME, InstallerConfig.getCurrentInstance().getApplicationVersion(), false);
            this.addRollbackAction(setRegistryValueAction);
            setRegistryValueAction.execute(installerContext);
            StringTokenizer stringTokenizer = new StringTokenizer(InstallerConfig.getCurrentInstance().getApplicationVersion(), ",.", false);
            if (stringTokenizer.hasMoreTokens()) {
                setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, VERSION_MAJOR_VALUE_NAME, new Integer(stringTokenizer.nextToken().trim()), false);
                this.addRollbackAction(setRegistryValueAction);
                setRegistryValueAction.execute(installerContext);
            }
            if (stringTokenizer.hasMoreTokens()) {
                setRegistryValueAction = new SetRegistryValueAction(registryRoot, string2, VERSION_MINOR_VALUE_NAME, new Integer(stringTokenizer.nextToken().trim()), false);
                this.addRollbackAction(setRegistryValueAction);
                setRegistryValueAction.execute(installerContext);
            }
        }
        catch (Exception exception) {
            Logger.getInstance().info(this, "Could not set app version: " + exception.getMessage());
        }
        return true;
    }

    private String getUnusedKey(String string, RegistryRoot registryRoot) {
        String string2 = string;
        int n = 0;
        while (WinRegistry.keyExists(registryRoot, string2)) {
            string2 = string + "-" + ++n;
        }
        return string2;
    }

    private String getUninstallerFilename() {
        return InstallerConfig.getCurrentInstance().getUninstallerPath() + ".exe";
    }

    public ExternalFile getIcon() {
        return this.icon;
    }

    public void setIcon(ExternalFile externalFile) {
        this.icon = externalFile;
    }

    public String getItemName() {
        return RegisterAddRemoveAction.replaceVariables(this.itemName, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setItemName(String string) {
        this.itemName = string;
    }

    private void removeUninstallLinks(File file, Context context) throws UserCanceledException {
        this.removeUninstallLinks(file, context, RegistryRoot.HKEY_LOCAL_MACHINE);
        this.removeUninstallLinks(file, context, RegistryRoot.HKEY_CURRENT_USER);
    }

    private void removeUninstallLinks(File file, Context context, RegistryRoot registryRoot) throws UserCanceledException {
        String[] stringArray = WinRegistry.getSubKeyNames(registryRoot, UNINSTALL_KEY);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2;
                String string = UNINSTALL_KEY + stringArray[i];
                Object object = WinRegistry.getValue(registryRoot, string, UNINSTALL_STRING_VALUE_NAME);
                if (object == null || !(object instanceof String)) continue;
                String string2 = ((String)object).trim().toLowerCase();
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("\"")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (!string2.endsWith(".exe") || !string2.startsWith(file.getAbsolutePath().substring(0, 2).toLowerCase()) || !(file2 = new File(string2)).exists()) continue;
                try {
                    if (!file2.getCanonicalFile().equals(file.getCanonicalFile())) continue;
                    DeleteRegistryItemAction deleteRegistryItemAction = new DeleteRegistryItemAction(registryRoot, string, "", false);
                    this.addRollbackAction(deleteRegistryItemAction);
                    deleteRegistryItemAction.execute(context);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

