/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public abstract class AbstractExtractZipFileAction
extends SystemInstallOrUninstallAction {
    private static final String DEFAULT_DIR_MODE = "755";
    private File zipFile;
    private File destinationDirectory;
    private String mode = "644";
    private String dirMode = "755";
    private boolean showProgress = true;
    private ScriptProperty fileFilter;

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public File getZipFile() {
        return AbstractExtractZipFileAction.replaceVariables(this.zipFile);
    }

    public void setZipFile(File file) {
        this.zipFile = file;
    }

    public File getDestinationDirectory() {
        return AbstractExtractZipFileAction.replaceVariables(this.destinationDirectory);
    }

    public void setDestinationDirectory(File file) {
        this.destinationDirectory = file;
    }

    public String getMode() {
        return AbstractExtractZipFileAction.replaceVariables(this.mode);
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public String getDirMode() {
        return AbstractExtractZipFileAction.replaceVariables(this.dirMode);
    }

    public void setDirMode(String string) {
        this.dirMode = string;
    }

    public ScriptProperty getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(ScriptProperty scriptProperty) {
        this.fileFilter = scriptProperty;
    }

    protected abstract void createFile(File var1, ZipInputStream var2, ZipEntry var3, long var4, ProgressAdapter var6) throws UserCanceledException, IOException;

    protected abstract void createDirectory(File var1) throws IOException;

    public boolean execute(Context context) throws UserCanceledException {
        File file = context.getDestinationFile(this.getZipFile());
        if (!file.exists()) {
            Logger.getInstance().error(this, file + " does not exist");
            return false;
        }
        File file2 = context.getDestinationFile(this.getDestinationDirectory());
        try {
            this.extractZip((InstallerContext)context, file, file2);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Logger.getInstance().error(this, "exception " + iOException);
            Logger.getInstance().log(iOException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZip(InstallerContext installerContext, File file, File file2) throws IOException, UserCanceledException {
        ProgressInterface progressInterface = installerContext.getProgressInterface();
        boolean bl = this.isShowProgress();
        ArrayList arrayList = new ArrayList();
        long l = Long.MAX_VALUE;
        if (bl) {
            progressInterface.setPercentCompleted(0);
            progressInterface.setDetailMessage("");
            l = AbstractExtractZipFileAction.getMaxProgress(file, arrayList);
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            long l2 = 0L;
            int n = 0;
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (installerContext.isCancelling()) {
                    throw new UserCanceledException();
                }
                String string = AbstractExtractZipFileAction.getEntryName(zipEntry);
                if (this.passesFileFilter(string, installerContext)) {
                    if (bl) {
                        progressInterface.setDetailMessage(InstallerUtil.cleanupName(string));
                    }
                    long l3 = l2 + 153600L;
                    long l4 = arrayList.isEmpty() ? 0L : (Long)arrayList.get(n++);
                    File file3 = new File(file2, string);
                    if (zipEntry.isDirectory()) {
                        this.createDirectory(file3);
                        file3.setLastModified(zipEntry.getTime());
                        if (!InstallerUtil.isWindows()) {
                            UnixFileSystem.setMode(this.getDirMode(), file3);
                        }
                    } else {
                        l3 += l4;
                        ProgressAdapter progressAdapter = null;
                        if (bl) {
                            progressAdapter = new ProgressAdapter(progressInterface, (int)(l2 * 100L / l), (int)(l3 * 100L / l));
                        }
                        this.createFile(file3, zipInputStream, zipEntry, l4, progressAdapter);
                    }
                    if (installerContext.isCancelling()) {
                        throw new UserCanceledException();
                    }
                    l2 = l3;
                    if (bl) {
                        progressInterface.setPercentCompleted((int)(l2 * 100L / l));
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
            if (bl) {
                progressInterface.setPercentCompleted(100);
                progressInterface.setDetailMessage("");
            }
        }
    }

    private static String getEntryName(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        string = InstallerUtil.isWindows() ? string.replace('/', '\\') : string.replace('\\', '/');
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getMaxProgress(File file, List list) throws IOException {
        long l = 0L;
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                long l2 = zipEntry.isDirectory() ? 0L : zipEntry.getSize();
                list.add(new Long(l2));
                l += l2 + 153600L;
            }
            long l3 = l;
            return l3;
        }
        finally {
            zipFile.close();
        }
    }

    private boolean passesFileFilter(String string, Context context) {
        File file = new File(string);
        return ContextImpl.runBooleanScript(context, this.fileFilter, this, new Object[]{file, string.endsWith(File.separator)});
    }
}

