/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public abstract class AbstractFileAction
extends SystemInstallOrUninstallAction {
    private File[] files;
    private ScriptProperty fileFilter;
    private ScriptProperty directoryFilter;

    public File[] getFiles() {
        return AbstractFileAction.replaceVariables(this.files);
    }

    public void setFiles(File[] fileArray) {
        this.files = fileArray;
    }

    public ScriptProperty getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(ScriptProperty scriptProperty) {
        this.fileFilter = scriptProperty;
    }

    public ScriptProperty getDirectoryFilter() {
        return this.directoryFilter;
    }

    public void setDirectoryFilter(ScriptProperty scriptProperty) {
        this.directoryFilter = scriptProperty;
    }

    public boolean execute(Context context) throws UserCanceledException {
        return this.executeForMultipleFilesAction(context, this.getFiles());
    }

    protected boolean executeForMultipleFilesAction(Context context, File[] fileArray) throws UserCanceledException {
        if (fileArray == null) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            File file2 = context.getDestinationFile(file);
            if (!file2.exists()) {
                Util.logInfo(this, "The file \"" + file2.getPath() + "\" does not exist");
                if (!this.isErrorIfFileMissing()) continue;
                bl = false;
                continue;
            }
            try {
                bl &= this.executeForSingleFile(context, file2);
                continue;
            }
            catch (IOException iOException) {
                bl = false;
                Logger.getInstance().log(iOException);
            }
        }
        return bl;
    }

    protected boolean isErrorIfFileMissing() {
        return true;
    }

    protected abstract boolean executeForSingleFile(Context var1, File var2) throws UserCanceledException, IOException;

    protected boolean passesFileOrDirectoryFilter(File file, Context context) {
        return ContextImpl.runBooleanScript(context, file.isDirectory() ? this.directoryFilter : this.fileFilter, this, new Object[]{file});
    }
}

