/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;
import java.io.IOException;

public class DeleteRegistryItemAction
extends SystemInstallOrUninstallAction {
    private RegistryRoot registryRoot;
    private String keyName = "";
    private String valueName = "";
    private boolean onlyIfEmpty = true;

    public DeleteRegistryItemAction() {
    }

    public DeleteRegistryItemAction(RegistryRoot registryRoot, String string, String string2, boolean bl) {
        this.registryRoot = registryRoot;
        this.keyName = string;
        this.valueName = string2;
        this.onlyIfEmpty = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        String string = this.getValueName();
        PerformedAction performedAction = new PerformedAction();
        this.addRollbackAction(performedAction);
        if (string.trim().length() == 0) {
            if (context instanceof InstallerContext) {
                try {
                    performedAction.backupFile = File.createTempFile("i4j", ".reg");
                    performedAction.backupFile.delete();
                    if (!WinRegistry.saveKey(this.getRegistryRoot(), this.getKeyName(), performedAction.backupFile.getAbsolutePath())) {
                        performedAction.backupFile.delete();
                        performedAction.backupFile = null;
                    } else {
                        performedAction.backupFile.deleteOnExit();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            WinRegistry.deleteKey(this.getRegistryRoot(), this.getKeyName(), this.isOnlyIfEmpty());
        } else {
            performedAction.oldValue = WinRegistry.getValue(this.getRegistryRoot(), this.getKeyName(), string);
            WinRegistry.deleteValue(this.getRegistryRoot(), this.getKeyName(), string);
        }
        return true;
    }

    public RegistryRoot getRegistryRoot() {
        return this.registryRoot;
    }

    public void setRegistryRoot(RegistryRoot registryRoot) {
        this.registryRoot = registryRoot;
    }

    public String getKeyName() {
        return DeleteRegistryItemAction.replaceVariables(this.keyName);
    }

    public void setKeyName(String string) {
        this.keyName = string;
    }

    public String getValueName() {
        return DeleteRegistryItemAction.replaceVariables(this.valueName);
    }

    public void setValueName(String string) {
        this.valueName = string;
    }

    public boolean isOnlyIfEmpty() {
        return this.onlyIfEmpty;
    }

    public void setOnlyIfEmpty(boolean bl) {
        this.onlyIfEmpty = bl;
    }

    private class PerformedAction
    extends DeleteRegistryItemAction {
        private Object oldValue;
        private File backupFile;

        public PerformedAction() {
            DeleteRegistryItemAction.this.registryRoot = DeleteRegistryItemAction.this.getRegistryRoot();
            DeleteRegistryItemAction.this.keyName = DeleteRegistryItemAction.this.getKeyName();
            DeleteRegistryItemAction.this.valueName = DeleteRegistryItemAction.this.getValueName();
        }

        public void rollback(InstallerContext installerContext) {
            if (this.backupFile != null) {
                WinRegistry.restoreKey(DeleteRegistryItemAction.this.registryRoot, DeleteRegistryItemAction.this.keyName, this.backupFile.getAbsolutePath());
            } else if (this.oldValue != null) {
                WinRegistry.setValue(DeleteRegistryItemAction.this.registryRoot, DeleteRegistryItemAction.this.keyName, DeleteRegistryItemAction.this.valueName, this.oldValue);
            }
        }
    }
}

