/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.beans.actions.registry.PreferencesWriteAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.VariableEncoding;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SaveInstallerVariablesAction
extends PreferencesWriteAction {
    private String[] installerVariables;

    public String[] getInstallerVariables() {
        return SaveInstallerVariablesAction.replaceVariables(this.installerVariables);
    }

    public void setInstallerVariables(String[] stringArray) {
        this.installerVariables = stringArray;
    }

    public boolean execute(Context context) throws UserCanceledException {
        String[] stringArray = this.getInstallerVariables();
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object object = context.getVariable(string);
            if (VariableEncoding.encodeVariable(properties, string, object) || object == null) continue;
            Logger.getInstance().log(this, "The variable " + string + " of type " + object.getClass().getName() + " cannot be encoded to a string", false);
            return false;
        }
        return this.executePreferencesWriter(new SaveInstallerVariablesPreferencesWriter(properties), context);
    }

    private static class SaveInstallerVariablesPreferencesWriter
    implements PreferencesWriteAction.PreferencesWriter {
        private final Properties encodedVariables;

        public SaveInstallerVariablesPreferencesWriter(Properties properties) {
            this.encodedVariables = properties;
        }

        public boolean writeToPreferences(PreferencesAction.PackageNodeProvider packageNodeProvider, Context context, List list) {
            Iterator<Map.Entry<Object, Object>> iterator = this.encodedVariables.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                PreferencesWriteAction.writeValue(packageNodeProvider, (String)entry.getKey(), (String)entry.getValue(), list);
            }
            return true;
        }
    }
}

