/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallationComponentSetup;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.DescriptionScreen;
import com.install4j.runtime.beans.screens.components.InstallationDirectorySelector;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.installationcomponents.InstallationComponentTree;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ComponentsScreen
extends DescriptionScreen {
    private boolean showInstallationDirectoryChooser = false;
    private ScriptProperty selectionChangedScript;
    private JLabel destinationLabel;
    private InstallationDirectorySelector installationDirectorySelector = new InstallationDirectorySelector(this);
    private InstallationComponentTree tree;
    private JScrollPane scpTree;

    public ComponentsScreen() {
        this.installationDirectorySelector.setCompact(true);
        this.setBoldDescription(true);
    }

    public ScriptProperty getSelectionChangedScript() {
        return this.selectionChangedScript;
    }

    public void setSelectionChangedScript(ScriptProperty scriptProperty) {
        this.selectionChangedScript = scriptProperty;
    }

    public boolean isShowInstallationDirectoryChooser() {
        Boolean bl;
        Context context = this.getContext();
        Boolean bl2 = bl = context == null ? null : (Boolean)context.getVariable("sys.confirmedUpdateInstallation");
        if (bl != null) {
            return this.showInstallationDirectoryChooser && bl == false;
        }
        return this.showInstallationDirectoryChooser;
    }

    public void setShowInstallationDirectoryChooser(boolean bl) {
        this.showInstallationDirectoryChooser = bl;
    }

    public boolean isShowRequiredDiskSpace() {
        return this.installationDirectorySelector.isShowRequiredDiskSpace();
    }

    public void setShowRequiredDiskSpace(boolean bl) {
        this.installationDirectorySelector.setShowRequiredDiskSpace(bl);
    }

    public boolean isShowFreeDiskSpace() {
        return this.installationDirectorySelector.isShowFreeDiskSpace();
    }

    public void setShowFreeDiskSpace(boolean bl) {
        this.installationDirectorySelector.setShowFreeDiskSpace(bl);
    }

    public boolean isCheckFreeSpace() {
        return this.installationDirectorySelector.isCheckFreeSpace();
    }

    public void setCheckFreeSpace(boolean bl) {
        this.installationDirectorySelector.setCheckFreeSpace(bl);
    }

    public boolean isSuggestAppDir() {
        return this.installationDirectorySelector.isSuggestAppDir();
    }

    public void setSuggestAppDir(boolean bl) {
        this.installationDirectorySelector.setSuggestAppDir(bl);
    }

    public boolean isExistingDirWarning() {
        return this.installationDirectorySelector.isExistingDirWarning();
    }

    public void setExistingDirWarning(boolean bl) {
        this.installationDirectorySelector.setExistingDirWarning(bl);
    }

    public boolean isValidateApplicationId() {
        return this.installationDirectorySelector.isValidateApplicationId();
    }

    public void setValidateApplicationId(boolean bl) {
        this.installationDirectorySelector.setValidateApplicationId(bl);
    }

    public boolean isAllowSpacesOnUnix() {
        return this.installationDirectorySelector.isAllowSpacesOnUnix();
    }

    public void setAllowSpacesOnUnix(boolean bl) {
        this.installationDirectorySelector.setAllowSpacesOnUnix(bl);
    }

    public boolean isAllowNewFolderCreation() {
        return this.installationDirectorySelector.isAllowNewFolderCreation();
    }

    public void setAllowNewFolderCreation(boolean bl) {
        this.installationDirectorySelector.setAllowNewFolderCreation(bl);
    }

    public boolean isManualEntryAllowed() {
        return this.installationDirectorySelector.isManualEntryAllowed();
    }

    public void setManualEntryAllowed(boolean bl) {
        this.installationDirectorySelector.setManualEntryAllowed(bl);
    }

    public ScriptProperty getValidationScript() {
        return this.installationDirectorySelector.getValidationScript();
    }

    public void setValidationScript(ScriptProperty scriptProperty) {
        this.installationDirectorySelector.setValidationScript(scriptProperty);
    }

    public void setInstallerContext(InstallerContext installerContext) {
        super.setInstallerContext(installerContext);
        if (this.showInstallationDirectoryChooser) {
            this.installationDirectorySelector.setContext(installerContext);
        }
    }

    public boolean isHidden() {
        return InstallerConfig.getCurrentInstance().getComponents().size() == 0 || this.getContext().getBooleanVariable("sys.preventComponentCustomization");
    }

    public String getTitle() {
        return this.getMessage("WizardSelectComponents");
    }

    public String getSubTitle() {
        return this.getMessage("SelectComponentsDesc");
    }

    public void willActivate() {
        super.willActivate();
        boolean bl = this.isShowInstallationDirectoryChooser();
        this.installationDirectorySelector.setVisible(bl);
        this.destinationLabel.setVisible(bl);
        if (bl) {
            this.installationDirectorySelector.update();
        }
    }

    public void activated() {
        super.activated();
        this.tree.updateAllNodes();
        this.tree.checkFolders();
    }

    protected boolean checkCompleted() {
        return super.checkCompleted() && (!this.isShowInstallationDirectoryChooser() || this.installationDirectorySelector.checkCompleted());
    }

    public boolean handleUnattended() {
        return !this.isShowInstallationDirectoryChooser() || this.installationDirectorySelector.handleUnattended();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        if (this.isShowInstallationDirectoryChooser() && !this.installationDirectorySelector.handleConsole(console)) {
            return false;
        }
        console.println(this.getMessage("SelectComponentsDesc"));
        ComponentFolderConfig componentFolderConfig = InstallerConfig.getCurrentInstance().getComponentRoot();
        ComponentConsoleState componentConsoleState = new ComponentConsoleState();
        this.printFolder(console, componentFolderConfig, componentConsoleState, "");
        while (true) {
            CharSequence charSequence;
            if (componentConsoleState.helpIndexToComponentNodeConfig.size() > 0) {
                charSequence = new StringBuffer();
                for (int i = 0; i < componentConsoleState.helpIndexToComponentNodeConfig.size(); ++i) {
                    if (i > 0) {
                        ((StringBuffer)charSequence).append(", ");
                    }
                    ((StringBuffer)charSequence).append("*");
                    ((StringBuffer)charSequence).append(i + 1);
                }
                console.println(MessageFormat.format(this.getMessage("ConsoleComponentHelpLabel"), ((StringBuffer)charSequence).toString()));
            }
            charSequence = console.askString(this.getMessage("ConsoleMultipleSelectionLabel"), componentConsoleState.defaultConsoleSelection);
            try {
                if (((String)charSequence).startsWith("*")) {
                    ComponentNodeConfig componentNodeConfig = this.getConfigForIndex(((String)charSequence).substring(1), componentConsoleState.helpIndexToComponentNodeConfig);
                    console.println();
                    console.println(componentNodeConfig.getName() + ": " + componentNodeConfig.getDescription());
                    console.println();
                    continue;
                }
                if (((String)charSequence).equals("\"\"")) {
                    charSequence = "";
                }
                HashSet<ComponentNodeConfig> hashSet = new HashSet<ComponentNodeConfig>();
                StringTokenizer stringTokenizer = new StringTokenizer((String)charSequence, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    ComponentNodeConfig componentNodeConfig = this.getConfigForIndex(stringTokenizer.nextToken().trim(), componentConsoleState.indexToComponentNodeConfig);
                    hashSet.add(componentNodeConfig);
                }
                hashSet.addAll(componentConsoleState.mandatoryComponents);
                componentFolderConfig.setSelected(false);
                this.updateTree(hashSet, componentFolderConfig);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    private ComponentNodeConfig getConfigForIndex(String string, Map map) throws NumberFormatException {
        int n = Integer.parseInt(string);
        ComponentNodeConfig componentNodeConfig = (ComponentNodeConfig)map.get(new Integer(n));
        if (componentNodeConfig == null) {
            throw new NumberFormatException("not available");
        }
        return componentNodeConfig;
    }

    private void updateTree(Set set, ComponentFolderConfig componentFolderConfig) {
        for (int i = 0; i < componentFolderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig componentNodeConfig;
            componentNodeConfig.setSelected(set.contains(componentNodeConfig = (ComponentNodeConfig)componentFolderConfig.getComponents().get(i)) || componentFolderConfig.isIncluded());
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            this.updateTree(set, (ComponentFolderConfig)componentNodeConfig);
        }
    }

    private void printFolder(Console console, ComponentFolderConfig componentFolderConfig, ComponentConsoleState componentConsoleState, String string) {
        for (int i = 0; i < componentFolderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig componentNodeConfig = (ComponentNodeConfig)componentFolderConfig.getComponents().get(i);
            this.printNode(componentConsoleState, componentNodeConfig, console, string);
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            this.printFolder(console, (ComponentFolderConfig)componentNodeConfig, componentConsoleState, string + "      ");
        }
    }

    private void printNode(ComponentConsoleState componentConsoleState, ComponentNodeConfig componentNodeConfig, Console console, String string) {
        boolean bl;
        if (componentNodeConfig.isHidden()) {
            if (componentNodeConfig.isSelected()) {
                componentConsoleState.mandatoryComponents.add(componentNodeConfig);
            }
            return;
        }
        boolean bl2 = bl = componentNodeConfig instanceof ComponentConfig && !((ComponentConfig)componentNodeConfig).isChangeable();
        if (!bl || componentNodeConfig.isSelected()) {
            console.print(string + (bl ? "*" : String.valueOf(componentConsoleState.index)) + ": " + componentNodeConfig.getName());
            if (componentNodeConfig.getDescription().length() > 0) {
                console.print(" [*" + componentConsoleState.helpIndex + "]");
                componentConsoleState.helpIndexToComponentNodeConfig.put(new Integer(componentConsoleState.helpIndex++), componentNodeConfig);
            }
            console.println();
            if (componentNodeConfig instanceof ComponentFolderConfig) {
                componentNodeConfig.setSelected(false);
            }
            if (bl) {
                componentConsoleState.mandatoryComponents.add(componentNodeConfig);
            } else {
                if (componentNodeConfig.isSelected()) {
                    componentConsoleState.defaultConsoleSelection = componentConsoleState.defaultConsoleSelection == null ? "" : componentConsoleState.defaultConsoleSelection + ",";
                    componentConsoleState.defaultConsoleSelection = componentConsoleState.defaultConsoleSelection + componentConsoleState.index;
                }
                componentConsoleState.indexToComponentNodeConfig.put(new Integer(componentConsoleState.index++), componentNodeConfig);
            }
        }
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        String string = this.getMessage("SelectComponentsLabel2");
        if (string.trim().length() > 0) {
            this.addDisplayTextArea(MessageFormat.format(string, this.getApplicationName()), jPanel, gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.scpTree, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        if (this.showInstallationDirectoryChooser) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = InstallerUtil.isAtLeastJava16() ? GUIHelper.BASELINE_LEADING : 18;
            gridBagConstraints.insets.right = 5;
            jPanel.add((Component)this.destinationLabel, gridBagConstraints);
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.installationDirectorySelector, gridBagConstraints);
        }
    }

    protected int getMaxGridWidth() {
        return 2;
    }

    protected void setupControls() {
        super.setupControls();
        this.tree = new InstallationComponentTree(this);
        this.scpTree = new JScrollPane(this.tree);
        this.destinationLabel = new JLabel(this.getMessage("ReadyMemoDir"));
        if (this.showInstallationDirectoryChooser) {
            this.installationDirectorySelector.createComponent();
        }
    }

    public void nodeToggled() {
        if (this.isShowInstallationDirectoryChooser()) {
            this.installationDirectorySelector.update();
        }
    }

    public void selectionChanged(ComponentNode componentNode, boolean bl) {
        ComponentNodeConfig componentNodeConfig = componentNode.getComponentNodeConfig();
        if (componentNodeConfig instanceof ComponentConfig) {
            ComponentConfig componentConfig = (ComponentConfig)componentNodeConfig;
            Context context = this.getContext();
            InstallationComponentSetup installationComponentSetup = context.getInstallationComponentById(componentConfig.getId());
            try {
                context.runScript(this.selectionChangedScript, this, new Object[]{installationComponentSetup, bl});
            }
            catch (Exception exception) {
                Util.printAnnotatedStackTrace(exception);
                Logger.getInstance().log(exception);
            }
        }
    }

    private class ComponentConsoleState {
        public int index = 1;
        public int helpIndex = 1;
        public String defaultConsoleSelection;
        public Map indexToComponentNodeConfig = new HashMap();
        public Map helpIndexToComponentNodeConfig = new HashMap();
        public Set mandatoryComponents = new HashSet();

        private ComponentConsoleState() {
        }
    }
}

