/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.DescriptionScreen;
import com.install4j.runtime.beans.screens.installationtype.ComponentsSelectionType;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeConfig;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeTree;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InstallationTypeScreen
extends DescriptionScreen {
    public static final String VARIABLE_PREVENT_COMPONENT_CUSTOMIZATION = "sys.preventComponentCustomization";
    private InstallationTypeTree tree;
    private JScrollPane scpTree;
    private List installationTypeConfigs = new ArrayList();
    private String initialId = null;
    private Boolean overridePreventComponentCustomization;

    public List getInstallationTypeConfigs() {
        return this.installationTypeConfigs;
    }

    public void setInstallationTypeConfigs(List list) {
        this.installationTypeConfigs = list;
    }

    public String getTitle() {
        return this.getMessage("WizardInstallationType");
    }

    public String getSubTitle() {
        return this.getMessage("SelectInstallationType");
    }

    public String getInitialId() {
        return this.initialId;
    }

    public boolean next() {
        this.applySelectedConfig(this.tree.getSelectedConfig());
        return true;
    }

    private void applySelectedConfig(InstallationTypeConfig installationTypeConfig) {
        if (installationTypeConfig != null) {
            ComponentConfig componentConfig;
            Iterator iterator = InstallerConfig.getCurrentInstance().getComponents().iterator();
            while (iterator.hasNext()) {
                componentConfig = (ComponentConfig)iterator.next();
                if (componentConfig.isMandatory()) continue;
                componentConfig.setSelected(false);
            }
            iterator = InstallerConfig.getCurrentInstance().getComponents().iterator();
            while (iterator.hasNext()) {
                componentConfig = (ComponentConfig)iterator.next();
                if (componentConfig.isMandatory()) continue;
                componentConfig.setSelected(this.isSelectedComponent(componentConfig, installationTypeConfig));
            }
        }
    }

    private boolean isSelectedComponent(ComponentConfig componentConfig, InstallationTypeConfig installationTypeConfig) {
        ComponentsSelectionType componentsSelectionType = installationTypeConfig.getComponentsSelectionType();
        if (componentsSelectionType == ComponentsSelectionType.ALL) {
            return true;
        }
        if (componentsSelectionType == ComponentsSelectionType.DEFAULT) {
            return componentConfig.isInitiallySelected();
        }
        String string = componentConfig.getId();
        Iterator iterator = installationTypeConfig.getSelectedComponentIds().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            ComponentNodeConfig componentNodeConfig = InstallerConfig.getCurrentInstance().getComponentNodeById(string2);
            if (componentNodeConfig == null || !(componentNodeConfig instanceof ComponentFolderConfig ? this.isContainedInFolder((ComponentFolderConfig)componentNodeConfig, string) : componentNodeConfig.getId().equals(string))) continue;
            return true;
        }
        return false;
    }

    private boolean isContainedInFolder(ComponentFolderConfig componentFolderConfig, String string) {
        Iterator iterator = componentFolderConfig.getComponents().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            ComponentNodeConfig componentNodeConfig = (ComponentNodeConfig)iterator.next();
            if (!(componentNodeConfig instanceof ComponentFolderConfig ? (bl = this.isContainedInFolder((ComponentFolderConfig)componentNodeConfig, string)) : componentNodeConfig.getId().equals(string))) continue;
            return true;
        }
        return false;
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        String string = this.getMessage("SelectInstallationTypeLabel");
        if (string.trim().length() > 0) {
            this.addDisplayTextArea(string, jPanel, gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.scpTree, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    public void setInstallerContext(InstallerContext installerContext) {
        super.setInstallerContext(installerContext);
        InstallerVariables.registerResponseFileVariable("sys.installationTypeId");
        Object object = InstallerVariables.getVariable("sys.installationTypeId");
        if (object != null && object instanceof String) {
            this.initialId = (String)object;
        }
        InstallerVariables.registerVariableProvider("sys.installationTypeId", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return InstallationTypeScreen.this.tree == null ? InstallationTypeScreen.this.initialId : InstallationTypeScreen.this.tree.getSelectedId();
            }

            public void setVariable(Object object) {
                if (object != null && object instanceof String) {
                    String string = (String)object;
                    if (InstallationTypeScreen.this.tree == null) {
                        InstallationTypeScreen.this.initialId = string;
                    } else {
                        InstallationTypeScreen.this.tree.setSelectedId(string);
                    }
                }
            }
        });
        InstallerVariables.registerVariableProvider(VARIABLE_PREVENT_COMPONENT_CUSTOMIZATION, new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                if (InstallationTypeScreen.this.overridePreventComponentCustomization != null) {
                    return InstallationTypeScreen.this.overridePreventComponentCustomization;
                }
                if (InstallationTypeScreen.this.tree == null) {
                    return Boolean.FALSE;
                }
                InstallationTypeConfig installationTypeConfig = InstallationTypeScreen.this.tree.getSelectedConfig();
                if (installationTypeConfig == null) {
                    return Boolean.FALSE;
                }
                return installationTypeConfig.isUserCanCustomize() ? Boolean.FALSE : Boolean.TRUE;
            }

            public void setVariable(Object object) {
            }
        });
    }

    protected void setupControls() {
        super.setupControls();
        this.tree = new InstallationTypeTree(this);
        this.scpTree = new JScrollPane(this.tree);
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        InstallationTypeConfig installationTypeConfig;
        int n;
        if (!super.handleConsole(console)) {
            return false;
        }
        int n2 = this.installationTypeConfigs.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.valueOf(n + 1);
            installationTypeConfig = (InstallationTypeConfig)this.installationTypeConfigs.get(n);
            stringArray2[n] = installationTypeConfig.getName();
            if (!installationTypeConfig.getId().equals(this.initialId) && !installationTypeConfig.getDisplayedId().equals(this.initialId)) continue;
            n3 = n;
        }
        n = console.askOption(this.getMessage("SelectInstallationType"), stringArray2, stringArray, n3, false, true);
        if (n > -1) {
            installationTypeConfig = (InstallationTypeConfig)this.installationTypeConfigs.get(n);
            this.overridePreventComponentCustomization = installationTypeConfig.isUserCanCustomize() ? Boolean.FALSE : Boolean.TRUE;
            this.applySelectedConfig(installationTypeConfig);
            this.initialId = installationTypeConfig.getDisplayedId();
        }
        return true;
    }
}

