/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.update.UpdateSchedule;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class UpdateScheduleRegistryImpl {
    private static final String REGVAL_PREFIX_UPDATE_SCHEDULE = "updateSchedule";
    private static final String REGVAL_PREFIX_LAST_UPDATE = "lastUpdate";

    private UpdateScheduleRegistryImpl() {
    }

    public static boolean checkAndReset() {
        UpdateSchedule updateSchedule = UpdateScheduleRegistryImpl.getUpdateSchedule();
        if (updateSchedule == null || updateSchedule == UpdateSchedule.NEVER) {
            return false;
        }
        Date date = UpdateScheduleRegistryImpl.getLastUpdateCheckDate();
        if (date == null || updateSchedule == UpdateSchedule.ON_EVERY_START) {
            UpdateScheduleRegistryImpl.checkedForUpdate();
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.add(UpdateScheduleRegistryImpl.getField(updateSchedule), 1);
        if (calendar2.before(calendar)) {
            UpdateScheduleRegistryImpl.checkedForUpdate();
            return true;
        }
        return false;
    }

    private static int getField(UpdateSchedule updateSchedule) {
        if (updateSchedule == UpdateSchedule.DAILY) {
            return 5;
        }
        if (updateSchedule == UpdateSchedule.WEEKLY) {
            return 3;
        }
        if (updateSchedule == UpdateSchedule.MONTHLY) {
            return 2;
        }
        return -1;
    }

    public static Date getLastUpdateCheckDate() {
        String string = UpdateScheduleRegistryImpl.getApplicationId();
        if (string == null) {
            return null;
        }
        String string2 = InstallRegistry.getValue(REGVAL_PREFIX_LAST_UPDATE + string);
        if (string2 == null) {
            return null;
        }
        try {
            return new Date(Long.parseLong(string2));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return null;
        }
    }

    public static void checkedForUpdate() {
        String string = UpdateScheduleRegistryImpl.getApplicationId();
        if (string == null) {
            return;
        }
        InstallRegistry.setValue(REGVAL_PREFIX_LAST_UPDATE + string, String.valueOf(new Date().getTime()));
    }

    public static void setUpdateSchedule(UpdateSchedule updateSchedule) {
        String string = UpdateScheduleRegistryImpl.getApplicationId();
        if (string == null) {
            return;
        }
        InstallRegistry.setValue(REGVAL_PREFIX_UPDATE_SCHEDULE + string, updateSchedule.getId());
    }

    public static UpdateSchedule getUpdateSchedule() {
        String string = UpdateScheduleRegistryImpl.getApplicationId();
        if (string == null) {
            return null;
        }
        return UpdateSchedule.getById(InstallRegistry.getValue(REGVAL_PREFIX_UPDATE_SCHEDULE + string));
    }

    public static String getApplicationId() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            try {
                installerConfig = InstallerConfig.getGeneralConfigFromFile(new File(ResourceHelper.getRuntimeDir(), "i4jparams.conf"));
            }
            catch (IOException iOException) {
                if (System.getProperty("install4j.launcherId") != null) {
                    iOException.printStackTrace();
                }
                return null;
            }
        }
        return installerConfig.getApplicationId();
    }
}

