/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.RegistryView;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.JVMLocator;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WinJVMLocator {
    private static final String REGKEY_JAVASOFT_JDK = "SOFTWARE\\JavaSoft\\Java Development Kit";
    private static final String REGKEY_JAVASOFT_JRE = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
    private static final String REGVAL_JAVAHOME = "JavaHome";
    public static final String[] JDK_FILES = new String[]{"bin/javac.exe", "lib/tools.jar"};
    public static final String JAVA_EXECUTABLE = "bin/java.exe";

    public static Collection getJVMLocations(boolean bl) {
        HashSet hashSet = new HashSet();
        if (bl) {
            WinJVMLocator.addJvms(hashSet, RegistryView.BIT32);
            WinJVMLocator.addJvms(hashSet, RegistryView.BIT64);
        } else {
            WinJVMLocator.addJvms(hashSet, RegistryView.DEFAULT);
        }
        hashSet.addAll(WinJVMLocator.getSharedJRES());
        return hashSet;
    }

    private static void addJvms(Set set, RegistryView registryView) {
        set.addAll(WinJVMLocator.getFromKey(REGKEY_JAVASOFT_JDK, registryView));
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((JVMLocator.JVMLocation)iterator.next()).setJDK(true);
        }
        set.addAll(WinJVMLocator.getFromKey(REGKEY_JAVASOFT_JRE, registryView));
    }

    private static Collection getSharedJRES() {
        ArrayList<JVMLocator.JVMLocation> arrayList = new ArrayList<JVMLocator.JVMLocation>();
        File file = InstallerUtil.isWindows9X() ? FolderInfo.getProgramFilesDirectory() : FolderInfo.getCommonFilesDirectory();
        File[] fileArray = (file = new File(file, "i4j_jres")).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isDirectory() || file2.getName().startsWith("jre") || !new File(file2, "bin\\java.exe").exists()) continue;
                JVMLocator.JVMLocation jVMLocation = new JVMLocator.JVMLocation();
                jVMLocation.setJavaHome(file2);
                jVMLocation.setVersion(file2.getName());
                arrayList.add(jVMLocation);
            }
        }
        return arrayList;
    }

    private static Collection getFromKey(String string, RegistryView registryView) {
        HashMap<JVMLocator.JVMLocation, JVMLocator.JVMLocation> hashMap = new HashMap<JVMLocator.JVMLocation, JVMLocator.JVMLocation>();
        String[] stringArray = WinRegistry.getSubKeyNames(RegistryRoot.HKEY_LOCAL_MACHINE, string, registryView);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                String string3 = stringArray[i];
                JVMLocator.JVMLocation jVMLocation = new JVMLocator.JVMLocation();
                jVMLocation.setVersion(string3);
                Object object = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, string + "\\" + string3, REGVAL_JAVAHOME, registryView);
                if (object == null || !(object instanceof String) || !new File((string2 = (String)object) + "\\bin\\java.exe").exists()) continue;
                jVMLocation.setJavaHome(new File(string2));
                JVMLocator.JVMLocation jVMLocation2 = (JVMLocator.JVMLocation)hashMap.get(jVMLocation);
                if (jVMLocation2 != null && jVMLocation2.getVersion().length() >= jVMLocation.getVersion().length()) continue;
                hashMap.put(jVMLocation, jVMLocation);
            }
        }
        return hashMap.values();
    }
}

