/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.StringElaborator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NormalizeSpace_1
extends ScalarSystemFunction {
    @Override
    public Sequence resultWhenEmpty() {
        return StringValue.EMPTY_STRING;
    }

    @Override
    public AtomicValue evaluate(Item arg, XPathContext context) throws XPathException {
        return new StringValue(NormalizeSpace_1.normalizeSpace(arg.getUnicodeStringValue()));
    }

    public static UnicodeString normalizeSpace(UnicodeString sv) {
        if (sv == null) {
            return EmptyUnicodeString.getInstance();
        }
        return Whitespace.collapseWhitespace(sv);
    }

    @Override
    public Expression makeFunctionCall(Expression[] arguments) {
        return new SystemFunctionCall(this, arguments){

            @Override
            public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
                AtomicValue sv = (AtomicValue)this.getArg(0).evaluateItem(c);
                if (sv == null) {
                    return false;
                }
                return !Whitespace.isAllWhite(sv.getUnicodeStringValue());
            }
        };
    }

    @Override
    public Elaborator getElaborator() {
        return new NormalizeSpaceFnElaborator();
    }

    public static class NormalizeSpaceFnElaborator
    extends StringElaborator {
        @Override
        public boolean returnZeroLengthWhenAbsent() {
            return true;
        }

        @Override
        public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            UnicodeStringEvaluator argEval = fnc.getArg(0).makeElaborator().elaborateForUnicodeString(true);
            return context -> Whitespace.collapseWhitespace(argEval.eval(context));
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            StringEvaluator argEval = arg.makeElaborator().elaborateForString(zeroLengthWhenAbsent);
            return context -> {
                String in = argEval.eval(context);
                if (in == null || in.isEmpty()) {
                    return this.handleNullString(zeroLengthWhenAbsent);
                }
                return Whitespace.collapseWhitespace(in);
            };
        }

        @Override
        public BooleanEvaluator elaborateForBoolean() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            UnicodeStringEvaluator argEval = arg.makeElaborator().elaborateForUnicodeString(false);
            return context -> {
                UnicodeString in = argEval.eval(context);
                if (in == null || in.isEmpty()) {
                    return false;
                }
                return !Whitespace.isAllWhite(in);
            };
        }
    }
}

