/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapter;
import org.apache.fop.render.pdf.pdfbox.StructureTreeMergerUtil;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDPage;

public class StructureTreeMerger {
    PDFBoxAdapter adapter;
    PDFPage targetPage;
    PDFDocument pdfDoc;
    private PDPage srcPage;
    private COSDictionary roleMap;
    private PDFStructElem currentSessionElem;
    private PDFLogicalStructureHandler logicalStructHandler;
    private Map<Integer, PDFStructElem> structElemCache = new HashMap<Integer, PDFStructElem>();
    private Map<Integer, PDFStructElem> markedContentMap = new TreeMap<Integer, PDFStructElem>();
    private int currentMCID;
    private List<COSObject> topElems = new ArrayList<COSObject>();
    private COSArray extra = new COSArray();
    private COSArray originalParentTree = new COSArray();

    public StructureTreeMerger(PDFStructElem currentSessionElem, PDFLogicalStructureHandler logicalStructHandler, PDFBoxAdapter adapter, PDPage srcPage) {
        this.adapter = adapter;
        this.srcPage = srcPage;
        this.targetPage = adapter.getTargetPage();
        this.pdfDoc = this.targetPage.getDocument();
        this.currentMCID = adapter.getCurrentMCID();
        this.logicalStructHandler = logicalStructHandler;
        this.currentSessionElem = currentSessionElem;
    }

    public void setRoleMap(COSDictionary roleMap) {
        this.roleMap = roleMap;
    }

    public void copyStructure(COSArray pageParentTreeArray) throws IOException {
        this.originalParentTree = pageParentTreeArray;
        pageParentTreeArray = this.removeNonCOSObjects(pageParentTreeArray);
        for (COSBase entry : pageParentTreeArray) {
            COSObject entryObj = (COSObject)entry;
            this.createPageStructElements(entryObj);
        }
        this.createParents(pageParentTreeArray);
        for (COSObject top : this.topElems) {
            this.findLeafNodesInPageFromStructElemObjects((COSBase)top);
        }
        this.createParents(this.extra);
        this.addToPageParentTreeArray();
        this.removeNullPlaceholders();
    }

    public void createDirectDescendants(COSBase base, PDFStructElem parent) throws IOException {
        if (base instanceof COSDictionary) {
            COSDictionary baseDict = (COSDictionary)base;
            if (baseDict.keySet().contains(COSName.K)) {
                this.createDirectDescendants(baseDict.getItem(COSName.K), parent);
            }
        } else if (base instanceof COSArray) {
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                this.createDirectDescendants(array.get(i), parent);
            }
        } else {
            assert (base instanceof COSObject);
            COSObject obj = (COSObject)base;
            this.createAndRegisterStructElem(obj);
            PDFStructElem elem = this.structElemCache.get((int)obj.getObjectNumber());
            this.copyElemEntries((COSBase)obj, elem);
            parent.addKid((PDFObject)elem);
            elem.setParent((PDFObject)parent);
            COSDictionary dict = (COSDictionary)obj.getObject();
            COSBase objKid = dict.getItem(COSName.K);
            if (objKid != null) {
                this.createDirectDescendants(objKid, elem);
            }
        }
    }

    public PDFStructElem getCurrentSessionElem() {
        return this.currentSessionElem;
    }

    public void setCurrentSessionElem() {
        if (this.isCurrentSessionElemEmpty(this.currentSessionElem)) {
            List structureTreeElements = this.pdfDoc.getStructureTreeElements();
            for (int i = structureTreeElements.size() - 1; i >= 0; --i) {
                PDFStructElem elem = (PDFStructElem)structureTreeElements.get(i);
                if (this.isCurrentSessionElemEmpty(elem)) continue;
                this.currentSessionElem = elem;
                break;
            }
        }
    }

    private boolean isCurrentSessionElemEmpty(PDFStructElem elem) {
        return elem == null || elem.get("P") == null;
    }

    private void createParents(COSArray markedContentParents) throws IOException {
        for (COSBase entry : markedContentParents) {
            COSObject elemCos = (COSObject)entry;
            COSDictionary dict = (COSDictionary)elemCos.getObject();
            COSObject elemParent = (COSObject)dict.getItem(COSName.P);
            if (elemParent == null) continue;
            PDFStructElem elem = this.structElemCache.get((int)elemCos.getObjectNumber());
            this.createParents(elemCos, elemParent, elem);
        }
    }

    private PDFStructElem createAndRegisterStructElem(COSObject entry) {
        PDFStructElem elem = new PDFStructElem();
        this.pdfDoc.registerStructureElement(elem);
        this.structElemCache.put((int)entry.getObjectNumber(), elem);
        return elem;
    }

    private void copyElemEntries(COSBase base, PDFStructElem elem) throws IOException {
        COSName[] names;
        assert (base instanceof COSObject);
        COSObject baseObj = (COSObject)base;
        COSDictionary baseDic = (COSDictionary)baseObj.getObject();
        for (COSName name : names = new COSName[]{COSName.TYPE, COSName.S, COSName.PG, COSName.ALT, COSName.LANG, COSName.A, COSName.ACTUAL_TEXT, COSName.T, COSName.E, COSName.C}) {
            if (!baseDic.keySet().contains(name)) continue;
            if (name.equals((Object)COSName.PG)) {
                elem.put(COSName.PG.getName(), (Object)this.targetPage.makeReference());
                continue;
            }
            elem.put(name.getName(), this.adapter.cloneForNewDocument(baseDic.getItem(name)));
        }
        this.adapter.cacheClonedObject(base, elem);
    }

    private PDFStructElem createPageStructElements(COSObject entry) throws IOException {
        int objID = (int)entry.getObjectNumber();
        if (this.structElemCache.containsKey(objID)) {
            return null;
        }
        PDFStructElem elem = this.createAndRegisterStructElem(entry);
        this.copyElemEntries((COSBase)entry, elem);
        COSDictionary baseDict = (COSDictionary)entry.getObject();
        COSBase kid = baseDict.getItem(COSName.K);
        this.createKids(kid, baseDict, elem, false);
        return elem;
    }

    private void createParents(COSObject cosElem, COSObject cosParentElem, PDFStructElem elem) throws IOException {
        int elemObjectID = (int)cosParentElem.getObjectNumber();
        COSDictionary parentElemDictionary = (COSDictionary)cosParentElem.getObject();
        PDFStructElem elemParent = this.structElemCache.get(elemObjectID);
        if (this.isStructureTreeRoot(parentElemDictionary)) {
            elem.setParent((PDFObject)this.currentSessionElem);
            this.currentSessionElem.addKid((PDFObject)elem);
            this.topElems.add(cosElem);
        } else if (elemParent != null) {
            if (!this.checkIfStructureTypeIsPresent(parentElemDictionary, "TR")) {
                elem.setParent((PDFObject)elemParent);
                int position = StructureTreeMergerUtil.findObjectPositionInKidsArray(cosElem);
                elemParent.addKidInSpecificOrder(position, elem);
            }
        } else if (!this.checkIfStructureTypeIsPresent(parentElemDictionary, "Document") && !this.checkIfStructureTypeIsPresent(parentElemDictionary, "Part")) {
            elemParent = this.createAndRegisterStructElem(cosParentElem);
            this.copyElemEntries((COSBase)cosParentElem, elemParent);
            elem.setParent((PDFObject)elemParent);
            this.fillKidsWithNull(elemParent, (COSDictionary)cosParentElem.getObject());
            if (parentElemDictionary.getDictionaryObject(COSName.S) == COSName.TR) {
                COSBase rowKids = parentElemDictionary.getItem(COSName.K);
                this.createKids(rowKids, parentElemDictionary, elemParent, true);
            } else {
                int position = StructureTreeMergerUtil.findObjectPositionInKidsArray(cosElem);
                elemParent.addKidInSpecificOrder(position, elem);
            }
            COSObject parentObj = (COSObject)parentElemDictionary.getItem(COSName.P);
            this.createParents(cosParentElem, parentObj, elemParent);
        } else {
            elem.setParent((PDFObject)this.currentSessionElem);
            int position = StructureTreeMergerUtil.findObjectPositionInKidsArray(cosElem);
            this.currentSessionElem.addKidInSpecificOrder(position, elem);
            this.topElems.add(cosElem);
        }
    }

    private void createKids(COSBase baseKid, COSDictionary parentDict, PDFStructElem parent, boolean originatedFromTableRow) throws IOException {
        if (baseKid instanceof COSArray) {
            COSArray baseArray = (COSArray)baseKid;
            for (COSBase entry : baseArray) {
                this.createKids(entry, parentDict, parent, originatedFromTableRow);
            }
        } else if (baseKid instanceof COSObject) {
            COSObject kid = (COSObject)baseKid;
            this.createKidFromCOSObject(kid, parentDict, parent, originatedFromTableRow);
        } else if (baseKid instanceof COSInteger) {
            if (this.checkPageEntryInAncestorsRecursively(parentDict)) {
                PDFNumber num = (PDFNumber)this.adapter.cloneForNewDocument(baseKid);
                this.createKidEntryFromInt(num, parent);
            }
        } else if (baseKid instanceof COSDictionary) {
            COSDictionary mcrDict = (COSDictionary)baseKid;
            this.createKidFromCOSDictionary(mcrDict, parent, parentDict);
        }
    }

    private void createKidFromCOSObject(COSObject baseObj, COSDictionary parentDict, PDFStructElem parent, boolean originatedFromTableRow) throws IOException {
        COSBase baseKid = baseObj.getObject();
        if (baseKid instanceof COSInteger) {
            COSInteger number = (COSInteger)baseKid;
            this.createKids((COSBase)number, parentDict, parent, originatedFromTableRow);
        } else if (baseKid instanceof COSDictionary) {
            COSDictionary unwrappedDict = (COSDictionary)baseKid;
            if (unwrappedDict.getDictionaryObject(COSName.S) == null) {
                COSDictionary mcrDict = (COSDictionary)baseKid;
                this.createKidFromCOSDictionary(mcrDict, parent, parentDict);
            } else if (originatedFromTableRow) {
                int objID = (int)baseObj.getObjectNumber();
                if (this.structElemCache.get(objID) != null) {
                    PDFStructElem kidElem = this.structElemCache.get(objID);
                    parent.addKid((PDFObject)kidElem);
                    kidElem.setParent((PDFObject)parent);
                } else {
                    this.createkidEntryFromCosObjectForRow(baseObj, parent);
                }
            } else {
                parent.addKid(null);
            }
        }
    }

    private void createkidEntryFromCosObjectForRow(COSObject entree, PDFStructElem parent) throws IOException {
        int entreeObjID = (int)entree.getObjectNumber();
        PDFStructElem elemRef = this.structElemCache.get(entreeObjID);
        if (elemRef == null) {
            elemRef = this.createAndRegisterStructElem(entree);
            this.copyElemEntries((COSBase)entree, elemRef);
            COSDictionary baseDict = (COSDictionary)entree.getObject();
            COSBase kid = baseDict.getItem(COSName.K);
            this.createKids(kid, baseDict, elemRef, true);
            parent.addKid((PDFObject)elemRef);
        } else {
            parent.addKid((PDFObject)elemRef);
        }
        elemRef.setParent((PDFObject)parent);
    }

    private boolean checkPageEntryInAncestorsRecursively(COSDictionary elem) {
        if (elem.containsKey(COSName.PG)) {
            COSDictionary pageDict = (COSDictionary)elem.getDictionaryObject(COSName.PG);
            return this.srcPage.getCOSObject() == pageDict;
        }
        if (elem.containsKey(COSName.P)) {
            COSDictionary parent = (COSDictionary)elem.getDictionaryObject(COSName.P);
            return this.checkPageEntryInAncestorsRecursively(parent);
        }
        return true;
    }

    private boolean isElementFromSourcePage(COSDictionary mrcDict, COSDictionary parentDict) {
        if (mrcDict.containsKey(COSName.PG)) {
            COSDictionary page = (COSDictionary)mrcDict.getDictionaryObject(COSName.PG);
            return this.srcPage.getCOSObject() == page;
        }
        return this.checkPageEntryInAncestorsRecursively(parentDict);
    }

    private void createKidFromCOSDictionary(COSDictionary mcrDict, PDFStructElem parent, COSDictionary baseDict) throws IOException {
        List<COSName> exclude = Arrays.asList(COSName.PG);
        if (this.isElementFromSourcePage(mcrDict, baseDict)) {
            PDFDictionary contentItem = (PDFDictionary)this.adapter.cloneForNewDocument(mcrDict, mcrDict, exclude);
            if (mcrDict.keySet().contains(COSName.TYPE)) {
                String type = ((COSName)mcrDict.getDictionaryObject(COSName.TYPE)).getName();
                if (type.equals("OBJR")) {
                    COSObject obj = (COSObject)mcrDict.getItem(COSName.OBJ);
                    PDFReference referenceObj = this.adapter.getCachedClone(obj) == null ? null : ((PDFObject)this.adapter.getCachedClone(obj)).makeReference();
                    contentItem.put(COSName.OBJ.getName(), (Object)referenceObj);
                    this.updateStructParentAndAddToPageParentTree(referenceObj, parent);
                } else if (type.equals("MCR")) {
                    this.updateMCIDEntry(contentItem);
                    this.markedContentMap.put(((PDFNumber)contentItem.get(COSName.MCID.getName())).getNumber().intValue(), parent);
                }
            }
            if (mcrDict.keySet().contains(COSName.PG)) {
                contentItem.put(COSName.PG.getName(), (Object)this.targetPage.makeReference());
            } else {
                parent.put(COSName.PG.getName(), (Object)this.targetPage.makeReference());
            }
            parent.addKid((PDFObject)contentItem);
        } else {
            parent.addKid(null);
        }
    }

    private void createKidEntryFromInt(PDFNumber num, PDFStructElem parent) {
        num.setNumber((Number)(num.getNumber().intValue() + this.currentMCID));
        parent.addKid((PDFObject)num);
        this.markedContentMap.put(num.getNumber().intValue(), parent);
    }

    private void updateMCIDEntry(PDFDictionary mcrDictionary) {
        if (this.currentMCID > 0) {
            int oldMCID = ((PDFNumber)mcrDictionary.get(COSName.MCID.getName())).getNumber().intValue();
            PDFNumber number = new PDFNumber();
            number.setNumber((Number)(oldMCID + this.currentMCID));
            mcrDictionary.put(COSName.MCID.getName(), (Object)number);
        }
    }

    private void removeNullPlaceholders() {
        ArrayList<PDFStructElem> list = new ArrayList<PDFStructElem>(this.structElemCache.values());
        for (PDFStructElem elem : list) {
            List kids = elem.getKids();
            if (kids == null) continue;
            kids.removeAll(Collections.singleton(null));
        }
    }

    private boolean isStructureTreeRoot(COSDictionary elem) {
        if (elem.keySet().contains(COSName.TYPE)) {
            COSName type = (COSName)elem.getDictionaryObject(COSName.TYPE);
            return type.equals((Object)COSName.STRUCT_TREE_ROOT);
        }
        return false;
    }

    public void addToPageParentTreeArray() {
        List<PDFStructElem> complete = this.restoreNullValuesInParentTree();
        for (PDFStructElem entry : complete) {
            this.logicalStructHandler.getPageParentTree().add((Object)entry);
        }
    }

    private List<PDFStructElem> restoreNullValuesInParentTree() {
        int total = this.markedContentMap.size();
        ArrayList<PDFStructElem> list = new ArrayList<PDFStructElem>(this.markedContentMap.values());
        ArrayList<PDFStructElem> complete = new ArrayList<PDFStructElem>(total);
        for (COSBase base : this.originalParentTree) {
            if (base instanceof COSNull || base == null) {
                complete.add(null);
                continue;
            }
            if (list.isEmpty()) continue;
            complete.add((PDFStructElem)list.get(0));
            list.remove(0);
        }
        return complete;
    }

    private void updateStructParentAndAddToPageParentTree(PDFReference obj, PDFStructElem elem) {
        int nextParentTreeKey = this.logicalStructHandler.getNextParentTreeKey();
        if (obj != null) {
            PDFObject referenceObj = obj.getObject();
            assert (referenceObj instanceof PDFDictionary);
            PDFDictionary objDict = (PDFDictionary)referenceObj;
            objDict.put(COSName.STRUCT_PARENT.getName(), nextParentTreeKey);
        }
        this.logicalStructHandler.getParentTree().addToNums(nextParentTreeKey, (Object)elem);
    }

    private void findLeafNodesInPageFromStructElemObjects(COSBase entry) throws IOException {
        if (entry instanceof COSObject) {
            COSObject entryObj = (COSObject)entry;
            COSDictionary structElemDictionary = (COSDictionary)entryObj.getObject();
            COSBase kid = structElemDictionary.getItem(COSName.K);
            this.findLeafKids(kid, entryObj);
        }
    }

    private void findLeafKids(COSBase kid, COSObject parent) throws IOException {
        if (kid instanceof COSArray) {
            COSArray arrayKid = (COSArray)kid;
            for (COSBase arrayEntry : arrayKid) {
                this.findLeafKids(arrayEntry, parent);
            }
        } else if (kid instanceof COSObject) {
            COSObject kidObject = (COSObject)kid;
            COSBase base = kidObject.getObject();
            if (base instanceof COSDictionary) {
                COSDictionary temp = (COSDictionary)base;
                if (temp.getDictionaryObject(COSName.S) != null && temp.getItem(COSName.K) != null) {
                    COSBase tempKids = temp.getItem(COSName.K);
                    this.findLeafKids(tempKids, kidObject);
                } else {
                    this.findLeafKids((COSBase)temp, parent);
                }
            }
        } else if (kid instanceof COSDictionary) {
            PDFStructElem elem;
            COSDictionary kidDictionary = (COSDictionary)kid;
            COSDictionary parentDict = (COSDictionary)parent.getObject();
            if (this.isElementFromSourcePage(kidDictionary, parentDict) && (elem = this.structElemCache.get((int)parent.getObjectNumber())) == null) {
                elem = this.createAndRegisterStructElem(parent);
                this.copyElemEntries((COSBase)parent, elem);
                this.extra.add((COSBase)parent);
                this.createKids(kid, parentDict, elem, false);
            }
        } else {
            PDFStructElem elem;
            assert (kid instanceof COSInteger);
            COSDictionary parentDict = (COSDictionary)parent.getObject();
            if (this.checkPageEntryInAncestorsRecursively(parentDict) && (elem = this.structElemCache.get((int)parent.getObjectNumber())) == null) {
                elem = this.createAndRegisterStructElem(parent);
                this.copyElemEntries((COSBase)parent, elem);
                this.createKids(kid, parentDict, elem, false);
            }
        }
    }

    private void fillKidsWithNull(PDFStructElem elem, COSDictionary baseElem) {
        COSBase baseArray = baseElem.getItem(COSName.K);
        if (baseArray instanceof COSArray) {
            COSArray array = (COSArray)baseArray;
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                elem.addKid(null);
            }
        }
    }

    private boolean checkIfStructureTypeIsPresent(COSDictionary elemDictionary, String type) {
        String potentialCustomElemType = ((COSName)elemDictionary.getDictionaryObject(COSName.S)).getName();
        if (type.equals(potentialCustomElemType)) {
            return true;
        }
        List<String> rolemapValues = StructureTreeMergerUtil.findRoleMapKeyByValue(type, this.roleMap);
        return rolemapValues.contains(potentialCustomElemType);
    }

    private COSArray removeNonCOSObjects(COSArray pageParentTreeArray) {
        COSArray objectList = new COSArray();
        for (COSBase entry : pageParentTreeArray) {
            if (!(entry instanceof COSObject)) continue;
            COSObject entryObj = (COSObject)entry;
            objectList.add((COSBase)entryObj);
        }
        return objectList;
    }

    public void setCurrentSessionElemKid() {
        PDFNumber num = new PDFNumber();
        this.createKidEntryFromInt(num, this.currentSessionElem);
        this.addToPageParentTreeArray();
    }
}

