/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb.infra.Util;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import spec.jbb.infra.Util.ScreenException;

public class TransactionLogBuffer {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,US Government Users Restricted Rights,Use, duplication or disclosure restrictedby GSA ADP Schedule Contract with IBM Corp.,Licensed Materials - Property of SPEC";
    public static final short alignLeft = 0;
    public static final short alignCenter = 1;
    public static final short alignRight = 2;
    static FileOutputStream fout = new FileOutputStream(FileDescriptor.out);
    static final float[] fround = new float[]{0.49f, 0.049f, 0.0049f, 4.9E-4f, 4.9E-5f, 4.9E-6f, 4.9E-7f, 4.9E-8f, 4.9E-9f, 4.9E-10f};
    static final double[] dround = new double[]{0.49, 0.049, 0.0049, 4.9E-4, 4.9E-5, 4.9E-6, 4.9E-7, 4.9E-8, 4.9E-9, 4.9E-10, 4.9E-11, 4.9E-12, 4.9E-13, 4.9E-14, 4.9E-15};
    static final float[] f10_nth = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f};
    static final double[] d10_nth = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19};
    static final String fractionPad = ".00000000000000000000";
    char[][] screenBuf;
    byte[] buf;
    int[] lineEnd;
    GregorianCalendar calendar;
    int rows;
    int cols;

    public TransactionLogBuffer() {
        this.rows = 24;
        this.cols = 80;
        this.calendar = new GregorianCalendar();
        this.buf = new byte[(this.cols + 1) * this.rows];
        this.screenBuf = new char[this.rows][];
        this.lineEnd = new int[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.screenBuf[i] = new char[this.cols];
            for (int j = 0; j < this.cols; ++j) {
                this.screenBuf[i][j] = 32;
            }
            this.lineEnd[i] = -1;
        }
    }

    public TransactionLogBuffer(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.calendar = new GregorianCalendar();
        this.buf = new byte[(this.cols + 1) * this.rows];
        this.screenBuf = new char[this.rows][];
        this.lineEnd = new int[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.screenBuf[i] = new char[this.cols];
            for (int j = 0; j < this.cols; ++j) {
                this.screenBuf[i][j] = 32;
            }
            this.lineEnd[i] = -1;
        }
    }

    public TransactionLogBuffer(TransactionLogBuffer transactionLogBuffer) {
        this.rows = transactionLogBuffer.rows;
        this.cols = transactionLogBuffer.cols;
        this.calendar = new GregorianCalendar();
        this.buf = new byte[(this.cols + 1) * this.rows];
        this.screenBuf = new char[this.rows][];
        this.lineEnd = new int[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.screenBuf[i] = new char[this.cols];
            System.arraycopy(transactionLogBuffer.screenBuf[i], 0, this.screenBuf[i], 0, this.cols);
            this.lineEnd[i] = transactionLogBuffer.lineEnd[i];
        }
    }

    public void clearBuffer() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.screenBuf[i][j] = 32;
            }
            this.lineEnd[i] = -1;
        }
    }

    private final void privSubstring(String string, int n, int n2, int n3, int n4) {
        int n5 = n4 > string.length() - n3 ? string.length() - n3 : n4;
        string.getChars(n3, n3 + n5, this.screenBuf[n2], n);
        if (n5 < n4) {
            for (int i = n + n5; i < n + n4; ++i) {
                this.screenBuf[n2][i] = 32;
            }
        }
    }

    public void putSubstring(String string, int n, int n2, int n3, int n4) {
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n4 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n4) + " exceeds left margin");
            throw screenException;
        }
        this.privSubstring(string, n, n2, n3, n4);
        if (n + n4 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n4;
        }
    }

    private final void privText(String string, int n, int n2, int n3) {
        int n4 = n3 > string.length() ? string.length() : n3;
        string.getChars(0, n4, this.screenBuf[n2], n);
        if (n4 < n3) {
            for (int i = n + n4; i < n + n3; ++i) {
                this.screenBuf[n2][i] = 32;
            }
        }
    }

    public void putText(String string, int n, int n2, int n3) {
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n3 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " exceeds left margin");
            throw screenException;
        }
        this.privText(string, n, n2, n3);
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    private final void privText(String string, int n, int n2, int n3, short s) {
        int n4;
        int n5;
        int n6;
        if (n3 > string.length()) {
            n6 = string.length();
            n5 = s == 2 ? n + (n3 - n6) : (s == 1 ? n + (n3 - n6) / 2 : n);
        } else {
            n6 = n3;
            n5 = n;
        }
        if (n5 > n) {
            for (n4 = n; n4 < n5; ++n4) {
                this.screenBuf[n2][n4] = 32;
            }
        }
        string.getChars(0, n6, this.screenBuf[n2], n5);
        if (n6 < n3) {
            for (n4 = n5 + n6; n4 < n + n3; ++n4) {
                this.screenBuf[n2][n4] = 32;
            }
        }
    }

    public void putText(String string, int n, int n2, int n3, short s) {
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n3 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " exceeds left margin");
            throw screenException;
        }
        this.privText(string, n, n2, n3, s);
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    private final void privCharFill(char c, int n, int n2, int n3) {
        for (int i = n; i < n + n3; ++i) {
            this.screenBuf[n2][i] = c;
        }
    }

    public void putCharFill(char c, int n, int n2, int n3) {
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n3 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " exceeds left margin");
            throw screenException;
        }
        this.privCharFill(c, n, n2, n3);
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    private final void privChar(char c, int n, int n2) {
        this.screenBuf[n2][n] = c;
    }

    public void putChar(char c, int n, int n2) {
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        this.screenBuf[n2][n] = c;
        if (n + 1 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + 1;
        }
    }

    private final int privIntLeadingZeros(int n, int n2, int n3, int n4) {
        char[] cArray = this.screenBuf[n3];
        for (int i = n2 + n4 - 1; i >= n2; --i) {
            int n5 = n / 10;
            int n6 = n - n5 * 10;
            n = n5;
            cArray[i] = (char)(48 + n6);
        }
        return n;
    }

    private final int privInt(int n, int n2, int n3, int n4) {
        int n5 = 32;
        if (n < 0) {
            n = -n;
            n5 = 45;
        }
        char[] cArray = this.screenBuf[n3];
        int n6 = n2 + n4 - 1;
        do {
            int n7 = n / 10;
            int n8 = n - n7 * 10;
            n = n7;
            cArray[n6] = (char)(48 + n8);
        } while (--n6 >= n2 && n != 0);
        if (n6 >= n2) {
            cArray[n6] = n5;
            --n6;
        } else if (n5 == 45) {
            n = -1;
        }
        while (n6 >= n2) {
            cArray[n6] = 32;
            --n6;
        }
        return n;
    }

    private final long privLong(long l, int n, int n2, int n3) {
        int n4 = 32;
        if (l < 0L) {
            l = -l;
            n4 = 45;
        }
        char[] cArray = this.screenBuf[n2];
        int n5 = n + n3 - 1;
        do {
            long l2 = l / 10L;
            long l3 = l - l2 * 10L;
            l = l2;
            cArray[n5] = (char)(48L + l3);
        } while (--n5 >= n && l != 0L);
        if (n5 >= n) {
            cArray[n5] = n4;
            --n5;
        } else if (n4 == 45) {
            l = -1L;
        }
        while (n5 >= n) {
            cArray[n5] = 32;
            --n5;
        }
        return l;
    }

    private final int privInt(int n, char c, int n2, int n3, int n4) {
        char[] cArray = this.screenBuf[n3];
        int n5 = n2 + n4 - 1;
        do {
            int n6 = n / 10;
            int n7 = n - n6 * 10;
            n = n6;
            cArray[n5] = (char)(48 + n7);
        } while (--n5 >= n2 && n != 0);
        if (n5 >= n2) {
            cArray[n5] = c;
            --n5;
        } else if (c != ' ') {
            n = -1;
        }
        while (n5 >= n2) {
            cArray[n5] = 32;
            --n5;
        }
        return n;
    }

    public void putInt(int n, int n2, int n3, int n4) {
        if (n3 < 0 | n3 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n3) + " out of range");
            throw screenException;
        }
        if (n2 < 0 | n2 >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n2 + n4 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n4) + " exceeds left margin");
            throw screenException;
        }
        if (n4 <= 0) {
            ScreenException screenException = new ScreenException("Screen: length  must be greater than 0 was" + Integer.toString(n4));
            throw screenException;
        }
        if ((n = this.privInt(n, n2, n3, n4)) != 0) {
            this.privCharFill('*', n2, n3, n4);
        }
        if (n2 + n4 > this.lineEnd[n3]) {
            this.lineEnd[n3] = n2 + n4;
        }
    }

    public void putLong(long l, int n, int n2, int n3) {
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n3 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " exceeds left margin");
            throw screenException;
        }
        if (n3 <= 0) {
            ScreenException screenException = new ScreenException("Screen: length  must be greater than 0 was" + Integer.toString(n3));
            throw screenException;
        }
        if ((l = this.privLong(l, n, n2, n3)) != 0L) {
            this.privCharFill('*', n, n2, n3);
        }
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    public void putDouble(String string, int n, int n2, int n3) {
        this.putText(string, n, n2, n3, (short)2);
    }

    public void putDouble(double d, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n3 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " exceeds left margin");
            throw screenException;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 19) {
            n4 = 19;
        }
        if (n4 >= n3 - 1) {
            ScreenException screenException = new ScreenException("Screen: factional digits " + Integer.toString(n4) + " too large for field length " + Integer.toString(n3));
            throw screenException;
        }
        double d2 = d < 0.0 ? -d : d;
        int n5 = (int)d2;
        int n6 = (int)((d2 - (double)n5) * d10_nth[n4] + 0.5);
        if (d < 0.0) {
            n5 = -n5;
            bl = true;
        }
        int n7 = n3 - n4 - 1;
        int n8 = this.privIntLeadingZeros(n6, n + n7 + 1, n2, n4);
        this.screenBuf[n2][n + n7] = 46;
        if (n7 > 0) {
            n8 = this.privInt(n5, n, n2, n7);
            if ((long)n8 != 0L) {
                this.privCharFill('*', n, n2, n3);
            }
        } else if (bl) {
            this.privCharFill('*', n, n2, n3);
        }
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    public void putDate(Date date, int n, int n2, int n3) {
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n3 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " exceeds left margin");
            throw screenException;
        }
        if (n3 < 10) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " too small for date");
            throw screenException;
        }
        this.calendar.setTime(date);
        this.privIntLeadingZeros(this.calendar.get(5), n, n2, 2);
        this.privChar('-', n + 2, n2);
        this.privIntLeadingZeros(this.calendar.get(2) + 1, n + 3, n2, 2);
        this.privChar('-', n + 5, n2);
        this.privIntLeadingZeros(this.calendar.get(1), n + 6, n2, 4);
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    public void putTime(Date date, int n, int n2, int n3) {
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n3 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " exceeds left margin");
            throw screenException;
        }
        if (n3 < 8) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " too small for time");
            throw screenException;
        }
        this.calendar.setTime(date);
        this.privIntLeadingZeros(this.calendar.get(10), n, n2, 2);
        this.privChar(':', n + 2, n2);
        this.privIntLeadingZeros(this.calendar.get(12), n + 3, n2, 2);
        this.privChar(':', n + 5, n2);
        this.privIntLeadingZeros(this.calendar.get(13), n + 6, n2, 2);
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    public void putDollars(BigDecimal bigDecimal, int n, int n2, int n3) {
        String string = bigDecimal.toString();
        int n4 = string.length();
        if (bigDecimal.signum() > 0) {
            this.screenBuf[n2][n] = 36;
            this.putText(string, n + 1, n2, n4, (short)2);
        } else {
            this.putText(string, n, n2, n4, (short)2);
        }
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    public void putDollars(double d, int n, int n2, int n3) {
        int n4;
        int n5 = 2;
        boolean bl = false;
        if (n2 < 0 | n2 >= this.rows) {
            ScreenException screenException = new ScreenException("Screen: row " + Integer.toString(n2) + " out of range");
            throw screenException;
        }
        if (n < 0 | n >= this.cols) {
            ScreenException screenException = new ScreenException("Screen: column " + Integer.toString(n) + " out of range");
            throw screenException;
        }
        if (n + n3 > this.cols) {
            ScreenException screenException = new ScreenException("Screen: length " + Integer.toString(n3) + " exceeds left margin");
            throw screenException;
        }
        if (n5 >= n3 - 1) {
            ScreenException screenException = new ScreenException("Screen: factional digits " + Integer.toString(n5) + " too large for field length " + Integer.toString(n3));
            throw screenException;
        }
        double d2 = d < 0.0 ? -d : d;
        int n6 = (int)((d2 - (double)(n4 = (int)d2)) * d10_nth[n5] + 0.5);
        if (n6 > 99) {
            ++n4;
            n6 -= 100;
        }
        if (d < 0.0) {
            n4 = -n4;
            bl = true;
        }
        int n7 = n3 - n5 - 1;
        int n8 = this.privIntLeadingZeros(n6, n + n7 + 1, n2, n5);
        this.screenBuf[n2][n + n7] = 46;
        if (n7 > 0) {
            char c = '$';
            if (bl) {
                c = '-';
            }
            if ((long)(n8 = this.privInt(n4, c, n, n2, n7)) != 0L) {
                this.privCharFill('*', n, n2, n3);
            }
        } else if (bl) {
            this.privCharFill('*', n, n2, n3);
        }
        if (n + n3 > this.lineEnd[n2]) {
            this.lineEnd[n2] = n + n3;
        }
    }

    public String getLine(int n) {
        return new String(this.screenBuf[n]);
    }

    public int getLineCount() {
        return this.rows;
    }

    public void display(PrintStream printStream) {
        try {
            for (int i = 0; i < this.rows; ++i) {
                int n = this.lineEnd[i];
                if (n > 0) {
                    char[] cArray = this.screenBuf[i];
                    String string = new String(cArray, 0, n);
                    printStream.println(string);
                    continue;
                }
                printStream.println();
            }
            printStream.flush();
        }
        catch (Exception exception) {
            System.out.println("IOException:" + exception.getMessage());
            exception.printStackTrace();
            ScreenException screenException = new ScreenException("file write error");
            throw screenException;
        }
    }

    public String[] validate() {
        String[] stringArray = new String[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            int n = this.lineEnd[i];
            if (n > 0) {
                char[] cArray = this.screenBuf[i];
                stringArray[i] = new String(cArray, 0, n);
                continue;
            }
            stringArray[i] = new String("");
        }
        return stringArray;
    }

    public synchronized void display() {
        try {
            int n = 0;
            for (int i = 0; i < this.rows; ++i) {
                int n2 = this.lineEnd[i];
                if (n2 > 0) {
                    char[] cArray = this.screenBuf[i];
                    for (int j = 0; j < n2; ++j) {
                        this.buf[n++] = (byte)cArray[j];
                    }
                }
                this.buf[n++] = 10;
            }
            fout.write(this.buf, 0, n);
        }
        catch (IOException iOException) {
            System.out.println("IOException:" + iOException.getMessage());
            iOException.printStackTrace();
            ScreenException screenException = new ScreenException("screen write error");
            throw screenException;
        }
    }
}

