#!/bin/bash
# text formatting
YELLOW="\033[1;33m"
CYAN="\033[1;96m"
MAGENTA="\033[1;35m"
GREEN="\033[1;32m"
RED="\033[1;31m"
BLUE="\033[1;34m"
DEFCOLOR="\033[0m"
bold=$(tput bold)
normal=$(tput sgr0)


########## SET THIS ################

DEB_BUILD_ROOT="$HOME/debbuild"
DEB_BIN_ROOT="$HOME/Quimup"
DEB_SHARE_ROOT="./share"
DEB_CONTROL_ROOT="./deb"
QUIMUP_VERSION="quimup_2.1.1_amd64"

####################################


# check if dpkg-deb is installed:
SERVICE=`which dpkg-deb &> /dev/null`
if [[ $? != 0 ]];
then
echo -e $RED"Please install dpkg-deb before using this script"$DEFCOLOR
read -n 1 -s -r -p "Press any key to exit"
echo
exit 0
fi

echo "This script will create $DEB_BUILD_ROOT with sub-dirs"
echo "It wll copy $DEB_BIN_ROOT/quimup to $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/bin/"
echo "and $DEB_SHARE_ROOT/* to $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/share/"
echo "and the 'control' files from $DEB_CONTROL_ROOT to $DEB_BUILD_ROOT/$QUIMUP_VERSION/DEBIAN/*"
echo "Next the package will be built:"
echo -e $YELLOW"dpkg-deb --build quimup.2.1.1.x86_64"$DEFCOLOR
echo
read -n 1 -s -r -p "Press any key to continue"
echo



echo "Setting up $DEB_BUILD_ROOT"
mkdir $DEB_BUILD_ROOT
mkdir $DEB_BUILD_ROOT/$QUIMUP_VERSION
mkdir $DEB_BUILD_ROOT/$QUIMUP_VERSION/DEBIAN
mkdir $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr
mkdir $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/bin
mkdir $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/share


echo -e $BLUE"Copying binary to build directory"$DEFCOLOR
if test -f  $DEB_BIN_ROOT/quimup; then
  cp $DEB_BIN_ROOT/quimup $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/bin/
else
        echo "quimup binary not found!!!"
        exit
fi
echo -e $BLUE"'Stripping' binary"$DEFCOLOR
/usr/bin/strip $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/bin/quimup

echo -e $BLUE"Copying $DEB_SHARE_ROOT files to $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/share/"$DEFCOLOR
cp -r $DEB_SHARE_ROOT/* $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/share/

echo -e $BLUE"Compressing changelog"$DEFCOLOR
gzip -9 -n $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/share/doc/quimup/changelog
echo -e $BLUE"Compressing manual page"$DEFCOLOR
gzip -9 -n $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr/share/man/man1/quimup.1

echo -e $BLUE"Copying 'control' files from $DEB_CONTROL_ROOT to $DEB_BUILD_ROOT/$QUIMUP_VERSION/DEBIAN"$DEFCOLOR
cp $DEB_CONTROL_ROOT/* $DEB_BUILD_ROOT/$QUIMUP_VERSION/DEBIAN/
chmod 0755 $DEB_BUILD_ROOT/$QUIMUP_VERSION/DEBIAN/*

STARTDIR=$PWD

echo -e $BLUE"Moving to $DEB_BUILD_ROOT"$DEFCOLOR
cd $DEB_BUILD_ROOT

echo -e $BLUE"Changing ownership of $DEB_BUILD_ROOT/usr to root"$DEFCOLOR
sudo chown -R root $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr
sudo chgrp -R root $DEB_BUILD_ROOT/$QUIMUP_VERSION/usr

echo -e $BLUE"Running 'dpkg-deb --build $QUIMUP_VERSION'"$DEFCOLOR
dpkg-deb --build $QUIMUP_VERSION

echo -e $BLUE"Moving back to $STARTDIR"$DEFCOLOR
cd $STARTDIR

echo -e $BLUE"Copyin $QUIMUP_VERSION.deb to here"$DEFCOLOR
cp $DEB_BUILD_ROOT/*.deb $STARTDIR

echo -e $BLUE"removing $DEB_BUILD_ROOT"$DEFCOLOR
sudo rm -r $DEB_BUILD_ROOT

echo
read -n 1 -s -r -p "Press any key to exit"
echo
exit 0
