###############################################################################
# Spec file for Quimup on openSuse tumbleweed
################################################################################
# Configured to be built by non-root user
################################################################################
# Build with the following syntax:
# rpmbuild --target x86_64 -bb quimup.spec
################################################################################
Summary: Client for MPD
Name: quimup
Version: 2.1.1
Release: 1
License: GPLv3+
URL: https://sourceforge.net/projects/quimup/
Group: Applications/Multimedia
Packager: Jayes
Requires: libmpdclient2 >= 2.20
Requires: qt6-wayland >= 6.6.0
Requires: libQt6Widgets6 >= 6.6.0
Requires: libQt6Gui6 >= 6.6.0
Requires: libQt6Network6 >= 6.6.0
Requires: libQt6Core6 >= 6.6.0
Requires: libQt6Svg6 >= 6.6.0
Requires: libstdc++6 >= 13.2.1
Requires: glibc >= 2.38
Requires: libgcc_s1 >= 13.2.1
# mpd is NOT a dependency

#RPM_BIN_ROOT
%global RPM_BIN_ROOT $HOME/rpmbuild/BIN

# RPM_SHARE_ROOT
%global RPM_SHARE_ROOT $HOME/rpmbuild/SHARE

# RPM_BUILD_ROOT
BuildRoot: $HOME/rpmbuild/


BuildArch: x86_64

%description
A QT6 client for the Music PLayer Daemon (MPD)

%prep
################################################################################
# Create the build tree and copy the files from the development directories    #
# into the build tree.                                                         #
################################################################################
echo "BUILDROOT = $RPM_BUILD_ROOT"
mkdir -p $RPM_BUILD_ROOT/usr//bin/
mkdir -p $RPM_BUILD_ROOT/usr/share/


if test -f  %{RPM_BIN_ROOT}/quimup; then
    cp %{RPM_BIN_ROOT}/quimup $RPM_BUILD_ROOT/usr/bin/
else
    echo "quimup binary not found!!!"
fi

cp -r %{RPM_SHARE_ROOT}/* $RPM_BUILD_ROOT/usr/share/

exit

%files
/usr//bin/quimup
/usr/share/doc/quimup/*
/usr/share/applications/Quimup.desktop
/usr/share/icons/hicolor/*/apps/quimup*
/usr/share/licenses/quimup/*
/usr/share/man/man1/quimup*

%check
desktop-file-validate $RPM_BUILD_ROOT/usr/share/applications/Quimup.desktop

%pre

%post
/usr/bin/update-desktop-database &> /dev/null || :


%postun
/usr/bin/update-desktop-database &> /dev/null || :
# rm ~./config/quimup/quimup.conf
# rmdir ~./config/quimup

%clean
rm -rf $RPM_BUILD_ROOT/usr/bin
rm -rf $RPM_BUILD_ROOT/usr/share

%changelog
* Fri Dec 20 2024 jayes <oubliette@yxs4allnl> - 2.1.1-1
Added: Option to set the interval to poll MPD.
* Thu May 03 2024 jayes <oubliette@yxs4allnl> - 2.1.0-1
Added: Album art size can be set (requires restart).
Added: User actions to run scripts on files or directories.
Fixed: Problems rendering odd- and under-sized album art.
Fixed: Some menu items were disabled when they shouldn't be.
Fixed: Streams had generic names and titles in the playlist.
Fixed: Stream fetcher dit not handle https correctly.
Fixed: Connect thread not closed before closing quimup.
Other: Only settings in active tab are applied/saved now.
Other: If a song does not exist it is removed from the list.
Other: Player has a bit more space for album info.
Other: Smoother mini-maxi mode transition.
Other: Items in the Settings window were reorganized.
* Thu Feb 08 2024 jayes <oubliette@yxs4allnl> - 2.0.1-1
Fixed: Albun art with W not equal to H caused problems.
* Thu Feb 05 2024 jayes <oubliette@yxs4allnl> - 2.0.0-1
MIGRATED TO QT6
Added: Wayland compatibility
Added: Get album art directly from MPD, also remotely.
Added: Large album comments are now mouse-scrollable.
Added: Auto-reconnecting can be turned off.
Added: MPD's command timeout can be set.
Added: IPv6 for remote connections.
Added: Parameter -e(xtensive) for more detailed cout.
Added: Option 'Bold' and 'Italic' for various labels.
Added: Icons and colors suited for a dark theme.
Added: Option to apply colors to the progress bar.
Added: Double-click on albumart opens it in image viewer.
Added: Set default album/stream art from local file.
Added: "Titles" mode for the library.
Added: "Album" column to (searched) titles in library.
Added: Connect tab shows if MPD is a user/system service.
Fixed: A failing connection could freeze the program.
Fixed: Searched titles were sorted by artist.
Fixed: Connection crashed on 'mpd --kill' by the user.
Fixed: Errors rendering artist-title when scrolling.
Fixed: Artist-title scroll did not speed up on mouse-over.
Fixed: Vertical alingment of scrolling artist-title.
Fixed: Changing font size did not (de)activate scrolling.
Fixed: Scrolling font waaay too big on Fedora.
Fixed: Inconsistent handling of missing tag info.
Fixed: Streams starting with https were refused.
Fixed: Failing start/quit commands (like 'mpd --kill').
Fixed: Window icon was always a generic 'W' in Wayland.
Fixed: Systray's tooltip-text showed formatting code.
Fixed: Window did not open to foreground from system tray.
Fixed: Systray > Quit failed after close [x] from window.
Fixed: Remotely starting external tracks (2xclick) failed.
Fixed: Searching for local album art in the wrong order.
Fixed: Files 'open with' command was rather ramshackle.
Fixed: QtPainter error 'engine == 0' (error on cout).
Fixed: Stream timing-out triggered reconnecting to MPD.
Fixed: Media keys did not (all) work in the browser.
Fixed: Erractic auto-column-width in library and playlist.
Fixed: Palylist # column was too narrow for large numbers.
Fixed: MPD could be found running when it was not.
Fixed: Trying to connect locally when MPD is not running.
Fixed: Starting MPD without checking if it is installed.
Fixed: Not quitting MPD locally when connected remotely.
Fixed: Autodetect ignored ~/.config/mpd/mpd.conf.
Fixed: Context menus disappeared when not connected.
Fixed: Not checking if external apps are installed.
Other: Auto-detect now prioritizes 'bind-to-address'es.
Other: Auto-detect now runs only once, on startup.
Other: Removed taglib (MPD gets embedded album art now).
Other: Settings are now in ~/.config/quimup/quimup.conf.
Other: All bitmaps are svg (scalable vector graphics) now.
Other: Removes option to disable albumart..
Other: Several minor text and tooltip tweaks.
Other: Replaced obsolete email address in various places.
Other: Updated 'README' and 'FAQ.txt' files.
Other: Updated QtSingleApplication code from qt-solutions.
