/*
*  qm_config.cpp
*  QUIMUP configuration class
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#include <stdio.h>
#include <QSettings>
#include "qm_config.h"

qm_Config::qm_Config(bool extensive)
{
 b_cout = extensive;
 load_config();
}


void qm_Config::reset_temps()
{
 mpd_socket_conn = false;
 mpd_op_listall_allowed = false;
 mpd_op_disable_allowed = false;
 mpd_op_enable_allowed = false;
 mpd_update_allowed = false;
 mpd_deleteid_allowed = false;
 mpd_save_allowed = false;
 mpd_single_allowed = false;
 mpd_consume_allowed = false;
 mpd_xfade_allowed = false;
 mpd_repeat_allowed = false;
 mpd_random_allowed = false;
 mpd_rescan_allowed = false;
 mpd_shuffle_allowed = false;
 mpd_rm_allowed = false;
 mpd_config_allowed = false;
 mpd_setrpgain_allowed = false;
 mpd_stats_allowed = false;
 mpd_clear_allowed = false;
 mpd_readpic_allowed = false;
 mpd_albumart_allowed = false;
 xfade_is_on = false;
} // END reset_temps()

// Save the options in a config file
void qm_Config::save_config()
{
 QSettings sts("quimup", "quimup");
 sts.setValue("version", version);
 sts.setValue("version_previous", version_previous);
 // server related values
 sts.setValue("onquit_quitmpd", onquit_quitmpd);
 sts.setValue("onquit_mpd_command", onquit_mpd_command);
 sts.setValue("onstart_startmpd", onstart_startmpd);
 sts.setValue("onstart_mpd_command", onstart_mpd_command);
 sts.setValue("auto_connect", auto_connect);
 sts.setValue("auto_re_connect", auto_re_connect);
 sts.setValue("mpd_timeout", mpd_timeout);
 sts.setValue("mpd_pollfreq",mpd_pollfreq);
 sts.setValue("profile_current", profile_current);

// profile 0, autodetect, is not saved

 // profile_name_1 : set in load_config()
 sts.setValue("profile_note_1", profile_note_1);
 sts.setValue("profile_host_1", profile_host_1);
 sts.setValue("profile_port_1", profile_port_1);
 sts.setValue("profile_pswd_1", profile_pswd_1);
 sts.setValue("profile_mdir_1", profile_mdir_1);

 // profile_name_2 : set in load_config()
 sts.setValue("profile_note_2", profile_note_2);
 sts.setValue("profile_host_2", profile_host_2);
 sts.setValue("profile_port_2", profile_port_2);
 sts.setValue("profile_pswd_2", profile_pswd_2);
 sts.setValue("profile_mdir_2", profile_mdir_2);

 // profile_name_3 : set in load_config()
 sts.setValue("profile_note_3", profile_note_3);
 sts.setValue("profile_host_3", profile_host_3);
 sts.setValue("profile_port_3", profile_port_3);
 sts.setValue("profile_pswd_3", profile_pswd_3);
 sts.setValue("profile_mdir_3", profile_mdir_3);

 // profile_name_4 : set in load_config()
 sts.setValue("profile_note_4", profile_note_4);
 sts.setValue("profile_host_4", profile_host_4);
 sts.setValue("profile_port_4", profile_port_4);
 sts.setValue("profile_pswd_4", profile_pswd_4);
 sts.setValue("profile_mdir_4", profile_mdir_4);

 sts.setValue("xfade_time", xfade_time);

 // 'player' related values
 sts.setValue("player_X", player_X);
 sts.setValue("player_Y", player_Y);
 sts.setValue("albumart_size", albumart_size);
 sts.setValue("player_maxmode", player_maxmode);
 sts.setValue("use_trayicon", use_trayicon);
 sts.setValue("use_timeleft", use_timeleft);
 sts.setValue("tag_editor", tag_editor);
 sts.setValue("image_viewer", image_viewer);
 sts.setValue("file_manager", file_manager);
 sts.setValue("replaygain_mode", replaygain_mode);
 sts.setValue("start_minimized", start_minimized);

 // 'browser window' values
 sts.setValue("browser_X", browser_X);
 sts.setValue("browser_Y", browser_Y);
 sts.setValue("browser_W", browser_W);
 sts.setValue("browser_H", browser_H);
 sts.setValue("browser_L_splitter", browser_L_splitter);
 sts.setValue("browser_R_splitter", browser_R_splitter);
 sts.setValue("browser_libmode", browser_libmode);
 sts.setValue("lib_column_count", lib_column_count);
 sts.setValue("browser_searchmode", browser_searchmode);
 sts.setValue("browser_selectmode", browser_selectmode);
 sts.setValue("sort_albums_year", sort_albums_year);
 sts.setValue("library_autocols", library_autocols);
 sts.setValue("playlist_autocols", playlist_autocols);
 sts.setValue("ignore_leading_the", ignore_leading_the);
 sts.setValue("albumart_custom", albumart_custom);
 sts.setValue("custom_albumart_file", custom_albumart_file);
 sts.setValue("search_string", search_string);
 sts.setValue("auto_playfirst", auto_playfirst);
 sts.setValue("mark_whenplayed", mark_whenplayed);

 // 'settings window' values
 sts.setValue("settings_X", settings_X);
 sts.setValue("settings_Y", settings_Y);
 sts.setValue("settings_W", settings_W);
 sts.setValue("settings_H", settings_H);
 // font sizes
 sts.setValue("font_title_size", font_title_size);
 sts.setValue("font_title_bold", font_title_bold);
 sts.setValue("font_title_italic", font_title_italic);
 sts.setValue("font_codecinfo_size", font_codecinfo_size );
 sts.setValue("font_codecinfo_bold", font_codecinfo_bold);
 sts.setValue("font_time_size", font_time_size);
 sts.setValue("font_time_bold", font_time_bold);
 sts.setValue("font_album_size", font_album_size);
 sts.setValue("font_album_bold", font_album_bold);
 sts.setValue("font_year_size", font_year_size);
 sts.setValue("font_year_bold", font_year_bold);
 sts.setValue("font_browser_size", font_browser_size);
 sts.setValue("font_comment_size", font_comment_size);
 sts.setValue("font_comment_italic", font_comment_italic);
 sts.setValue("color_cus_fg_title", color_cus_fg_title);
 sts.setValue("color_cus_bg_title", color_cus_bg_title);
 sts.setValue("color_cus_fg_album", color_cus_fg_album);
 sts.setValue("color_cus_bg_album", color_cus_bg_album);
 sts.setValue("color_def_fg_title", color_def_fg_title);
 sts.setValue("color_def_bg_title", color_def_bg_title);
 sts.setValue("color_def_fg_album", color_def_fg_album);
 sts.setValue("color_def_bg_album", color_def_bg_album);
 sts.setValue("color_alt_fg_title", color_alt_fg_title);
 sts.setValue("color_alt_bg_title", color_alt_bg_title);
 sts.setValue("color_alt_fg_album", color_alt_fg_album);
 sts.setValue("color_alt_bg_album", color_alt_bg_album);
 sts.setValue("set_dark_theme", set_dark_theme);
 sts.setValue("colors_system", colors_system);
 sts.setValue("colors_default", colors_default);
 sts.setValue("colors_cutom", colors_cutom);
 sts.setValue("colfor_browser", colfor_browser);
 sts.setValue("colfor_albuminfo", colfor_albuminfo);
 sts.setValue("colfor_progressbar", colfor_progressbar);

 sts.setValue("show_tooltips", show_tooltips);
 sts.setValue("cout_extensive", cout_extensive);
 sts.setValue("this_is_wayland", this_is_wayland);

 // user actions
 sts.setValue("usract1_enabled", usract1_enabled);
 sts.setValue("usract1_fileparm", usract1_fileparm);
 sts.setValue("usract1_label", usract1_label);
 sts.setValue("usract1_command", usract1_command);
 sts.setValue("usract2_enabled", usract2_enabled);
 sts.setValue("usract2_fileparm", usract2_fileparm);
 sts.setValue("usract2_label", usract2_label);
 sts.setValue("usract2_command", usract2_command);

 sts.sync();

 if (sts.status() == QSettings::NoError)
 {
    if (b_cout)
    printf ("Saving quimup.conf\n");
 }
 else
    printf ("Saving quimup.conf falied\n");

} // END save_config()


// Get the options from the config file
void qm_Config::load_config()
{
 QSettings sts("quimup", "quimup");

 version = sts.value("version", "0.0" ).toString();
 version_previous = sts.value("version_previous", "0.0.0" ).toString();

 // server related values
 onquit_quitmpd = sts.value("onquit_quitmpd", false ).toBool();
 onquit_mpd_command = sts.value("onquit_mpd_command", "systemctl --user stop mpd").toString();
 onstart_startmpd = sts.value("onstart_startmpd", false ).toBool();
 onstart_mpd_command = sts.value("onstart_mpd_command", "systemctl --user start mpd" ).toString();
 auto_connect = sts.value("auto_connect", true ).toBool();
 auto_re_connect = sts.value("auto_re_connect", true ).toBool();
 mpd_timeout = sts.value("mpd_timeout", 12 ).toInt();
 mpd_pollfreq = sts.value("mpd_pollfreq", 500 ).toInt();
 mpd_musicpath = sts.value("mpd_musicpath", "" ).toString();
 mpd_process_owner = sts.value("mpd_process_owner", "" ).toString();
 mpd_musicdir_status = sts.value("mpd_musicdir_status", 0 ).toInt();

 profile_current = sts.value("profile_current", 0 ).toInt();
 profile_name_0 = sts.value("profile_name_0", "Autodetect").toString();
 profile_note_0 = sts.value("profile_note_0", "from mpd.conf").toString();
 profile_host_0 = sts.value("profile_host_0", "" ).toString();
 profile_port_0 = sts.value("profile_port_0", 0 ).toUInt();
 profile_pswd_0 = sts.value("profile_pswd_0", "" ).toString();
 profile_mdir_1 = sts.value("profile_mdir_0", "" ).toString();

 profile_name_1 = sts.value("profile_name_1", "Socket").toString();
 profile_note_1 = sts.value("profile_note_1", "Local socket connection").toString();
 profile_host_1 = sts.value("profile_host_1", "/home/USER/.mpd/socket < edit" ).toString();
 profile_port_1 = sts.value("profile_port_1", 6600 ).toUInt();
 profile_pswd_1 = sts.value("profile_pswd_1", "" ).toString();
 profile_mdir_1 = sts.value("profile_mdir_1", "" ).toString();

 profile_name_2 = sts.value("profile_name_2", "Local host").toString();
 profile_note_2 = sts.value("profile_note_2", "Not a socket connection").toString();
 profile_host_2 = sts.value("profile_host_2", "localhost" ).toString();
 profile_port_2 = sts.value("profile_port_2", 6600 ).toUInt();
 profile_pswd_2 = sts.value("profile_pswd_2", "" ).toString();
 profile_mdir_2 = sts.value("profile_mdir_2", "" ).toString();

 profile_name_3 = sts.value("profile_name_3", "Remote I").toString();
 profile_note_3 = sts.value("profile_note_3", "MPD server @").toString();
 profile_host_3 = sts.value("profile_host_3", "192.168.178.24 < edit" ).toString();
 profile_port_3 = sts.value("profile_port_3", 6600 ).toUInt();
 profile_pswd_3 = sts.value("profile_pswd_3", "" ).toString();
 profile_mdir_3 = sts.value("profile_mdir_3", "" ).toString();

 profile_name_4 = sts.value("profile_name_4", "Remote II").toString();
 profile_note_4 = sts.value("profile_note_4", "MPD server @") .toString();
 profile_host_4 = sts.value("profile_host_4", "192.168.178.20 < edit" ).toString();
 profile_port_4 = sts.value("profile_port_4", 6600 ).toUInt();
 profile_pswd_4 = sts.value("profile_pswd_4", "" ).toString();
 profile_mdir_4 = sts.value("profile_mdir_4", "" ).toString();

 xfade_time = sts.value("xfade_time", 5 ).toUInt();
 // 'player' related values
 player_X = sts.value("player_X", 300 ).toInt();
 if (player_X < 0)
    player_X = 0;
 player_Y = sts.value("player_Y", 200 ).toInt();
 if (player_Y < 0)
    player_Y = 0;
 albumart_size = sts.value("albumart_size", 220 ).toInt();
 if (albumart_size < 100)
     albumart_size = 100;
 player_maxmode = sts.value("player_maxmode", true ).toBool();
 use_trayicon = sts.value("use_trayicon", false ).toBool();
 start_minimized = sts.value("start_minimized", false ).toBool();
 use_timeleft = sts.value("use_timeleft", false ).toBool();
 tag_editor = sts.value("tag_editor", "kid3" ).toString();
 image_viewer = sts.value("image_viewer", "gwenview" ).toString();
 file_manager = sts.value("file_manager", "dolphin" ).toString();
 tag_editor_installed = sts.value("tag_editor_installed", false ).toBool();
 image_viewer_installed = sts.value("image_viewer_installed", false ).toBool();
 file_manager_installed = sts.value("file_manager_installed", false ).toBool();
 replaygain_mode = sts.value("replaygain_mode", "album" ).toString();
 // 'browser window' values
 browser_X = sts.value("browser_X", 300 ).toInt();
 if (browser_X < 0)
    browser_X = 0;
 browser_Y = sts.value("browser_Y", 200 ).toInt();
 if (browser_Y < 0)
    browser_Y = 0;
 browser_W = sts.value("browser_W", 600 ).toInt();
 browser_H = sts.value("browser_H", 360 ).toInt();
 browser_L_splitter = sts.value("browser_L_splitter", 240 ).toInt();
 browser_R_splitter = sts.value("browser_R_splitter", 340 ).toInt();
 browser_libmode = sts.value("browser_libmode", 0 ).toInt();    // must match lib_column_count
 lib_column_count = sts.value("lib_column_count", 1 ).toInt();  // must match browser_libmode
 browser_searchmode = sts.value("browser_searchmode", 0 ).toInt();
 browser_selectmode = sts.value("browser_selectmode", 0 ).toInt();
 sort_albums_year = sts.value("sort_albums_year", true ).toBool();
 library_autocols = sts.value("library_autocols", true ).toBool();
 playlist_autocols = sts.value("playlist_autocols", true ).toBool();
 ignore_leading_the = sts.value("ignore_leading_the", true ).toBool();
 albumart_custom = sts.value("albumart_custom", false ).toBool();
 custom_albumart_file = sts.value("custom_albumart_file", "/home/USER/../file" ).toString();
 auto_playfirst = sts.value("auto_playfirst", true ).toBool();
 mark_whenplayed = sts.value("mark_whenplayed", true ).toBool();
 search_string = sts.value("search_string", "" ).toString();
 // 'settings window' values
 settings_X = sts.value("settings_X", 300 ).toInt();
 if (settings_X < 0)
    settings_X = 0;
 settings_Y = sts.value("settings_Y", 200 ).toInt();
 if (settings_Y < 0)
    settings_Y = 0;
 settings_W = sts.value("settings_W", 465 ).toInt();
 settings_H = sts.value("settings_H", 695 ).toInt();
 // default font sizes
 font_title_size = sts.value("font_title_size", 12 ).toInt();
 font_title_bold = sts.value("font_title_bold", true ).toBool();
 font_title_italic = sts.value("font_title_italic", true ).toBool();
 font_codecinfo_size = sts.value("font_codecinfo_size", 8 ).toInt();
 font_codecinfo_bold = sts.value("font_codecinfo_bold", false ).toBool();
 font_time_size = sts.value("font_time_size", 8 ).toInt();
 font_time_bold = sts.value("font_time_bold", false ).toBool();
 font_album_size = sts.value("font_album_size", 9 ).toInt();
 font_album_bold = sts.value("font_album_bold", true ).toBool();
 font_year_size = sts.value("font_year_size", 9 ).toInt();
 font_year_bold = sts.value("font_year_bold", false ).toBool();
 font_comment_size = sts.value("font_comment_size", 8 ).toInt();
 font_comment_italic = sts.value("font_comment_italic", true ).toBool();
 font_browser_size = sts.value("font_browser_size", 10 ).toInt();
 color_cus_fg_title = sts.value("color_cus_fg_title", "#c8ebff" ).toString();
 color_cus_bg_title = sts.value("color_cus_bg_title", "#1a1f26" ).toString();
 color_cus_fg_album = sts.value("color_cus_fg_album", "#171c21" ).toString();
 color_cus_bg_album = sts.value("color_cus_bg_album", "#bbd1e9" ).toString();
 color_def_fg_title = sts.value("color_def_fg_title", "#f8fdff" ).toString();
 color_def_bg_title = sts.value("color_def_bg_title", "#1e3960" ).toString();
 color_def_fg_album = sts.value("color_def_fg_album", "#171c21" ).toString();
 color_def_bg_album = sts.value("color_def_bg_album", "#a6b9ce" ).toString();
 color_alt_fg_title = sts.value("color_alt_fg_title", "#d9edff" ).toString();
 color_alt_bg_title = sts.value("color_alt_bg_title", "#212428" ).toString();
 color_alt_fg_album = sts.value("color_alt_fg_album", "#d8ecff" ).toString();
 color_alt_bg_album = sts.value("color_alt_bg_album", "#344054" ).toString();
 set_dark_theme = sts.value("set_dark_theme", false ).toBool();
 colors_system = sts.value("colors_system", false ).toBool();
 colors_default = sts.value("colors_default", true ).toBool();
 colors_cutom = sts.value("colors_cutom", false ).toBool();
 colfor_browser = sts.value("colfor_browser", true ).toBool();
 colfor_albuminfo = sts.value("colfor_albuminfo", true ).toBool();
 colfor_progressbar = sts.value("colfor_progressbar", true ).toBool();

 usract1_enabled  = sts.value("usract1_enabled", false ).toBool();
 usract1_fileparm = sts.value("usract1_fileparm", true ).toBool();
 usract1_label = sts.value("usract1_label", "" ).toString();
 usract1_command = sts.value("usract1_command", "" ).toString();
 usract2_enabled  = sts.value("usract2_enabled", false ).toBool();
 usract2_fileparm = sts.value("usract2_fileparm", true ).toBool();
 usract2_label = sts.value("usract2_label", "" ).toString();
 usract2_command = sts.value("usract2_command", "" ).toString();

 show_tooltips = sts.value("show_tooltips", true ).toBool();
 cout_extensive = sts.value("cout_extensive", false ).toBool();
 this_is_wayland = sts.value("this_is_wayland", false ).toBool();
 sts.sync();

 if (sts.status() == QSettings::NoError)
 {
    if (b_cout)
    printf ("Reading quimup.conf\n");
 }
 else
    printf ("Error reading quimup.conf. Using defaults\n");

} // << load_config()


qm_Config::~qm_Config()
{}
