/*
*  qm_settings.h
*  QUIMUP settings window
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_SETTINGS_H
#define QM_SETTINGS_H

#include <QApplication>
#include <QMainWindow>
#include <QCloseEvent>
#include <QHideEvent>
#include <QAction>
#include <QButtonGroup>
#include <QCheckBox>
#include <QComboBox>
#include <QRadioButton>
#include <QScrollArea>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSpinBox>
#include <QTabWidget>
#include <QSettings>
#include <QGroupBox>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QSpacerItem>
#include "qm_config.h"
#include "qm_mpdcom.h"
#include "qm_colorpicker.h"


class qm_Settings : public QMainWindow
{
    Q_OBJECT

public:

    qm_Settings(qm_Config *);
    virtual ~qm_Settings();

    qm_colorPicker *colorpicker;

public slots:
    void set_connected(qm_mpdCommand*, bool, bool);

private slots:
    void cancel_changes();
    void apply_settings();
    void reset_fonts();
    void set_profile(int);
    void connect_to_server();
    void show_colorpicker();
    void on_new_customcolors();

private:
    QWidget *main_widget;
    QVBoxLayout *vbox_all;
    QHBoxLayout *hbox_buttons;
    QPushButton *bt_close;
    QPushButton *bt_apply;
    QTabWidget *tab_widget;
// tab connect
    QWidget *tab_con;
    QGroupBox *gbox_connect;
    QVBoxLayout *vbox_tab_connect;
    QVBoxLayout *vbox_timing;
    QCheckBox *cb_auto_conn;
    QCheckBox *cb_auto_Re_conn;
    QHBoxLayout *hbox_pollfreq;
    QSpinBox *sb_pollfreq;
    QLabel *lb_pollfreq;
    QHBoxLayout *hbox_timeout;
    QSpinBox *sb_timeout;
    QLabel *lb_timeout;
    QComboBox *cm_profiles;
    QLabel *lb_profiles;
    QGroupBox *gbox_profiles;
    QGridLayout *grid_connect;
    QLabel *lb_profilename;
    QLineEdit *le_note_text;
    QLabel *lb_passwd;
    QLineEdit *le_pswd_text;
    QLabel *lb_port;
    QLineEdit *le_port_text;
    QLabel *lb_host;
    QLineEdit *le_host_text;
    QLabel *lb_musicdir;
    QLineEdit *le_mdir_text;
    QPushButton *bt_connect;
    QSpacerItem *spacer_tab_con;
    QGroupBox *gbox_status;
    QGridLayout *grid_connect_status;
    QLabel *lb_conn_status_text;
    QLabel *lb_conn_icon;
    QLabel *lb_musicdir_status_text;
    QLabel *lb_musicdir_icon;
    QLabel *lb_owner_status_text;
    QLabel *lb_owner_icon;
// tab server
    QVBoxLayout *vbox_tab_server;
    QWidget *tab_server;
    QGroupBox *gbox_xfade;
    QHBoxLayout *hbox_xfade;
    QLabel *lb_xfade;
    QSpinBox *sb_xfade;
    QGroupBox *gbox_replaygain;
    QHBoxLayout *hbox_replaygain;
    QRadioButton *rb_rpg_off;
    QRadioButton *rb_rpg_track;
    QRadioButton *rb_rpg_album;
    QRadioButton *rb_rpg_auto;
    QGroupBox *gbox_outputs;
    QVBoxLayout *vbox_devices;
    QCheckBox *cb_dev1;
    QCheckBox *cb_dev2;
    QCheckBox *cb_dev3;
    QCheckBox *cb_dev4;
    QCheckBox *cb_dev5;
    QLabel *lb_mpdconnected;
    QSpacerItem *spacer_tab_server;
    QGroupBox *gbox_manage_mpd;
    QGridLayout *grid_manage;
    QVBoxLayout *vbox_killmpd;
    QLabel *lb_killcomm;
    QLineEdit *le_killcommand;
    QVBoxLayout *vbox_startmpd;
    QCheckBox *cb_startserver;
    QLabel *lb_startcomm;
    QLineEdit *le_startcommand;
    QCheckBox *cb_killserver;
    QLabel *lb_mpdinstalled;
// tab client
    QVBoxLayout *vbox_tab_client;
    QWidget *tab_client;
    QGroupBox *gbox_general;
    QVBoxLayout *vbox_general;
    QCheckBox *cb_use_systray;
    QCheckBox *cb_start_minimized;
    QCheckBox *cb_showTips;
    QGroupBox *gbox_library;
    QVBoxLayout *vbox_library;
    QCheckBox *cb_sortbyyear;
    QCheckBox *cb_ignore_the;
    QCheckBox *cb_library_autocols;
    QGroupBox *gbox_playlist;
    QVBoxLayout *vbox_playlist;
    QCheckBox *cb_auto_playfirst;
    QCheckBox *cb_mark_whenplayed;
    QCheckBox *cb_playlist_autocols;
    QGroupBox *gbox_albumart;
    QVBoxLayout *vbox_art_size;
    QHBoxLayout *hbox_art_size;
    QCheckBox *cb_custom_art;
    QLineEdit *le_custom_art;
    QLabel *lb_art_size;
    QSpinBox *sb_art_size;
    QSpacerItem *spacer_tab_client;
// tab style
    QVBoxLayout *vbox_tab_style;
    QWidget *tab_style;
    QGroupBox *gbox_fonts;
    QGridLayout *grid_fonts;
    QSpinBox *sb_titlefont;
    QSpinBox *sb_codecfont;
    QCheckBox *cb_codec_bold;
    QSpinBox *sb_timefont;
    QCheckBox *cb_time_bold;
    QSpinBox *sb_albumfont;
    QCheckBox *cb_album_bold;
    QSpinBox *sb_yearfont;
    QCheckBox *cb_year_bold;
    QSpinBox *sb_commentfont;
    QCheckBox *cb_comment_italic;
    QSpinBox *sb_liblistfont;
    QLabel *lb_titlefont;
    QHBoxLayout *hbox_title_b_i;
    QCheckBox *cb_title_bold;
    QCheckBox *cb_title_italic;
    QLabel *lb_codecfont;
    QLabel *lb_timefont;
    QLabel *lb_albumfont;
    QLabel *lb_yearfont;
    QLabel *lb_commentfont;
    QLabel *lb_liblistfont;
    QPushButton *bt_fonts_reset;
    QGroupBox *gbox_colors;
    QHBoxLayout *hbox_colors;
    QHBoxLayout *hbox_dark_theme;
    QVBoxLayout *vbox_colors_left;
    QRadioButton *rb_col_syst;
    QRadioButton *rb_col_def;
    QRadioButton *rb_col_cust;
    QCheckBox *cb_colfor_browser;
    QCheckBox *cb_colfor_albuminfo;
    QCheckBox *cb_colfor_pgsbar;
    QVBoxLayout *vbox_colors_right;
    QSpacerItem *spacer_l;
    QSpacerItem *spacer_r;
    QPushButton *bt_cust_color;
    QVBoxLayout *vbox_custcolor_show;
    QLabel *lb_custcolor_title;
    QLabel *lb_custcolor_album;
    QLabel *lb_custcolor_show_text;
    QGroupBox *gbox_theme;
    QCheckBox *cb_dark_icons;
    QSpacerItem *spacer_tab_style;
    // tab actions
    QVBoxLayout *vbox_tab_actions;
    QWidget *tab_actions;
    QGroupBox *gbox_external_actions;
    QGridLayout *grid_external_actions;
    QLineEdit *le_imageviewer;
    QLineEdit *le_tageditor;
    QLineEdit *le_filemanager;
    QLabel *lb_imageviewer;
    QLabel *lb_tageditor;
    QLabel *lb_filemanager;
    QGroupBox *gbox_usract1;
    QGroupBox *gbox_usract2;
    QGridLayout *grid_usract1;
    QGridLayout *grid_usract2;
    QCheckBox *cb_usract1;
    QCheckBox *cb_usract2;
    QHBoxLayout *hbox_rb_usract1;
    QRadioButton *rb_file_usract1;
    QRadioButton *rb_dir_usract1;
    QHBoxLayout *hbox_rb_usract2;
    QRadioButton *rb_file_usract2;
    QRadioButton *rb_dir_usract2;
    QLineEdit *le_cmd_usract1;
    QLineEdit *le_cmd_usract2;
    QLabel *lb_cmd_usract1;
    QLabel *lb_cmd_usract2;
    QLineEdit *le_label_usract1;
    QLineEdit *le_label_usract2;
    QLabel *lb_name_usract1;
    QLabel *lb_name_usract2;
    QSpacerItem *spacer_usract1;
    QSpacerItem *spacer_usract2;
    QSpacerItem *spacer_tab_actions;
// tab about
    QVBoxLayout *vbox_tab_about;
    QWidget *tb_about;
    QHBoxLayout *hbox_about_top;
    QLabel *lb_version;
    QLabel *px_about;
    QScrollArea *sa_about;
    QLabel *lb_about_info;
    QPixmap
        pm_owner_root,
        pm_owner_user,
        pm_mpd_notactive,
        pm_musicdir_ok,
        pm_musicdir_nocon,
        pm_musicdir_error,
        pm_disconnected,
        pm_connected;
    QIcon
        ic_bt_connect,
        ic_br_check,
        ic_br_reddelete;
    bool
        b_mpd_connected,
        b_profile_readonly,
        dev1_isChecked,
        dev2_isChecked,
        dev3_isChecked,
        dev4_isChecked,
        dev5_isChecked,
        b_new_custom_colors,
        b_wayland;

    qm_mpdCommand *mpd_cmd;
    qm_Config *config;

    void set_themed_icons(bool);
    void setup_widgets();
    void retranslate();
    void get_output_devices();
    void apply_output_devices();
    void apply_fontsizes();
    void apply_colors();
    void set_replaygain_mode();
    void init_vars();

protected:
    void closeEvent(QCloseEvent *);
    void hideEvent(QHideEvent *);
    void showEvent(QShowEvent *);

signals:
    void signal_fonts();
    void signal_colors();
    void signal_mark_whenplayed();
    void signal_playlist_auto_colwidth();
    void signal_library_auto_colwidth();
    void signal_custom_art();
    void signal_actions_changed();
};

#endif // QM_SETTINGS_H
