/*
*  qm_trayicon.h
*  QUIMUP system-tray-icon class
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_TRAYICON_H
#define QM_TRAYICON_H

#include <QSystemTrayIcon>
#include <QMenu>
#include <QMainWindow>
#include <QObject>
#include "qm_mpdcom.h"

class qm_trayIcon : public QSystemTrayIcon
{
    Q_OBJECT

public:
    qm_trayIcon(QMainWindow*, qm_Config *);
    void set_tip(QString, QString, bool = false);
    void set_mode(int);
    void set_connected(qm_mpdCommand*, bool);
    virtual ~qm_trayIcon(); // override;

public slots:

signals:
    void clicked();
    void signal_tray_menu(int);

private:
    bool b_mpd_connected;
    qm_mpdCommand *mpd_cmd;

    QAction
        *a_previous,
        *a_playpause,
        *a_stop,
        *a_next,
        *a_showhide,
        *a_quit;

    QColor m_prevColor;

    QPixmap
        pxb_noconn,
        pxb_paused,
        pxb_playing,
        pxb_stopped,
        pxb_idle,
        pxb_prev,
        pxb_stop,
        pxb_play,
        pxb_pause,
        pxb_next,
        pxb_quit;

    QMenu *context_menu;

private slots:
    void on_activated(QSystemTrayIcon::ActivationReason);
    void on_prev_action();
    void on_stop_action();
    void on_play_action();
    void on_next_action();
    void on_quit_action();
    void set_themed_icons(bool);
    void setup_widgets();

};
#endif // QM_TRAYICON_H
