/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.eg;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.eg.Edge;
import net.sf.hibernate.eg.Source;
import net.sf.hibernate.eg.Vertex;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;

public final class NetworkDemo {
    private static SessionFactory sessions;
    private static Configuration ds;
    static /* synthetic */ Class class$net$sf$hibernate$eg$Edge;
    static /* synthetic */ Class class$net$sf$hibernate$eg$Vertex;

    private NetworkDemo() {
    }

    public static void main(String[] no_args) throws Exception {
        ds = new Configuration().addClass(class$net$sf$hibernate$eg$Vertex == null ? (class$net$sf$hibernate$eg$Vertex = NetworkDemo.class$("net.sf.hibernate.eg.Vertex")) : class$net$sf$hibernate$eg$Vertex).addClass(class$net$sf$hibernate$eg$Edge == null ? (class$net$sf$hibernate$eg$Edge = NetworkDemo.class$("net.sf.hibernate.eg.Edge")) : class$net$sf$hibernate$eg$Edge);
        sessions = ds.buildSessionFactory();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        boolean quit = false;
        do {
            System.out.print("hibernate network demo>>");
            String cmd = reader.readLine();
            try {
                quit = NetworkDemo.command(cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (!quit);
    }

    public static boolean command(String command) throws Exception {
        if (command.toLowerCase().equals("quit")) {
            return true;
        }
        StringTokenizer tokens = new StringTokenizer(command);
        int length = tokens.countTokens();
        if (length != 0) {
            String[] args = new String[length];
            int i = 0;
            while (i < length) {
                args[i] = tokens.nextToken();
                ++i;
            }
            if (args[0].equals("setup")) {
                new SchemaExport(ds).create(true, true);
            } else if (args[0].equals("drop")) {
                new SchemaExport(ds).drop(true, true);
            } else {
                NetworkDemo.processCommand(args);
            }
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private static void processCommand(String[] args) throws Exception {
        block48: {
            try {
                if (args[0].equals("create")) {
                    Session sess = sessions.openSession();
                    try {
                        if (args[1].equals("vertex")) {
                            Vertex v = new Vertex();
                            v.setName(args[2]);
                            sess.save(v);
                            System.out.println("New vertex " + v.getKey());
                        } else if (args[1].equals("source")) {
                            Source s = new Source();
                            s.setName(args[2]);
                            s.setSourceStrength(Float.parseFloat(args[3]));
                            sess.save(s);
                            System.out.println("New source " + s.getKey());
                        } else if (args[1].equals("edge")) {
                            Edge e = new Edge();
                            e.setName(args[2]);
                            e.setCapacity(Float.parseFloat(args[3]));
                            e.setLength(Float.parseFloat(args[4]));
                            Vertex source = (Vertex)sess.find("from v in class net.sf.hibernate.eg.Vertex where v.name = ?", args[5], Hibernate.STRING).get(0);
                            Vertex sink = (Vertex)sess.find("from v in class net.sf.hibernate.eg.Vertex where v.name = ?", args[6], Hibernate.STRING).get(0);
                            source.addOutgoing(e);
                            sink.addIncoming(e);
                            sess.save(e);
                            System.out.println("New edge " + e.getKey());
                        } else {
                            System.out.println("usage: create ( ( vertex | source ) <name> | edge <name> <capacity> <length> <sourcename> <sinkname> )");
                        }
                        sess.flush();
                        sess.connection().commit();
                        Object var6_28 = null;
                        sess.close();
                    }
                    catch (Throwable throwable) {
                        Object var6_29 = null;
                        sess.close();
                        throw throwable;
                    }
                    {
                        break block48;
                        catch (Exception e) {
                            sess.connection().rollback();
                            throw e;
                        }
                    }
                }
                if (args[0].equals("delete")) {
                    Session sess = sessions.openSession();
                    try {
                        if (args[1].equals("edge")) {
                            int i = 2;
                            while (i < args.length) {
                                Edge e = (Edge)sess.find("from e in class net.sf.hibernate.eg.Edge where e.name = ?", args[i], Hibernate.STRING).get(0);
                                e.getSink().removeIncoming(e);
                                e.getSource().removeOutgoing(e);
                                sess.delete(e);
                                System.out.println("deleted");
                                ++i;
                            }
                        } else if (args[1].equals("vertex")) {
                            int i = 2;
                            while (i < args.length) {
                                Vertex v = (Vertex)sess.find("from v in class net.sf.hibernate.eg.Vertex where v.name = ?", args[i], Hibernate.STRING).get(0);
                                sess.delete(v);
                                System.out.println("deleted");
                                ++i;
                            }
                        } else {
                            System.out.println("usage: delete ( vertex | edge ) <name> [ <name> ] ... ");
                        }
                        sess.flush();
                        sess.connection().commit();
                        Object var8_33 = null;
                        sess.close();
                    }
                    catch (Throwable throwable) {
                        Object var8_34 = null;
                        sess.close();
                        throw throwable;
                    }
                    {
                        break block48;
                        catch (Exception e) {
                            sess.connection().rollback();
                            throw e;
                        }
                    }
                }
                if (args[0].equals("rename")) {
                    Session sess = sessions.openSession();
                    try {
                        if (args[1].equals("edge")) {
                            Edge e = (Edge)sess.find("from e in class net.sf.hibernate.eg.Edge where e.name = ?", args[2], Hibernate.STRING).get(0);
                            e.setName(args[3]);
                            System.out.println("renamed");
                        } else if (args[1].equals("vertex")) {
                            Vertex v = (Vertex)sess.find("from v in class net.sf.hibernate.eg.Vertex where v.name = ?", args[2], Hibernate.STRING).get(0);
                            v.setName(args[3]);
                            System.out.println("renamed");
                        } else {
                            System.out.println("usage: rename ( vertex | edge ) <old-name> <new-name>");
                        }
                        sess.flush();
                        sess.connection().commit();
                        Object var10_36 = null;
                        sess.close();
                    }
                    catch (Throwable throwable) {
                        Object var10_37 = null;
                        sess.close();
                        throw throwable;
                    }
                    {
                        break block48;
                        catch (Exception e) {
                            sess.connection().rollback();
                            throw e;
                        }
                    }
                }
                if (args[0].equals("show")) {
                    Session sess = sessions.openSession();
                    try {
                        Iterator iter = sess.find("from v in class net.sf.hibernate.eg.Vertex").iterator();
                        while (iter.hasNext()) {
                            Vertex v = (Vertex)iter.next();
                            System.out.println((v instanceof Source ? "source " : "vertex ") + v.getName() + ": " + v.getExcessCapacity() + " " + v.getIncoming().size() + "," + v.getOutgoing().size());
                        }
                        iter = sess.find("from e in class net.sf.hibernate.eg.Edge").iterator();
                        while (iter.hasNext()) {
                            Edge e = (Edge)iter.next();
                            System.out.println("edge " + e.getName() + ": " + e.getSource().getName() + "->" + e.getSink().getName() + " " + e.getCapacity() + " " + e.getLength());
                        }
                        sess.connection().commit();
                        Object var12_39 = null;
                        sess.close();
                    }
                    catch (Throwable throwable) {
                        Object var12_40 = null;
                        sess.close();
                        throw throwable;
                    }
                    {
                        break block48;
                        catch (Exception e) {
                            sess.connection().rollback();
                            throw e;
                        }
                    }
                }
                if (args[0].equals("find")) {
                    String query = "";
                    int i = 1;
                    while (i < args.length) {
                        query = query + args[i] + " ";
                        ++i;
                    }
                    Session sess = sessions.openSession();
                    Databinder db = sessions.openDatabinder();
                    db.setInitializeLazy(true);
                    try {
                        Iterator iter = sess.find(query).iterator();
                        while (iter.hasNext()) {
                            db.bind(iter.next());
                        }
                        System.out.println(db.toXML());
                        sess.connection().commit();
                        Object var14_42 = null;
                        sess.close();
                    }
                    catch (Throwable throwable) {
                        Object var14_43 = null;
                        sess.close();
                        throw throwable;
                    }
                    {
                        break block48;
                        catch (Exception e) {
                            sess.connection().rollback();
                            throw e;
                        }
                    }
                }
                System.out.println("recognized commands are: setup, create, delete, rename, show, drop, quit");
                System.out.println("type \"command help\" for usage description");
            }
            catch (ArrayIndexOutOfBoundsException abe) {
                System.out.println("incorrect usage");
                System.out.println("recognized commands are: setup, create, delete, rename, show, drop, quit");
                System.out.println("type \"<command> help\" for usage description");
            }
            catch (IndexOutOfBoundsException iob) {
                System.out.println("named object not found");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

