/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.AssertionFailure;

public final class IdentityMap
implements Map,
Serializable {
    private static final Class IDENTITY_MAP_CLASS;
    private final Map map = new HashMap();
    static /* synthetic */ Class class$net$sf$hibernate$util$IdentityMap;

    public static Map instantiate() {
        try {
            return (Map)IDENTITY_MAP_CLASS.newInstance();
        }
        catch (Exception ie) {
            throw new AssertionFailure("could not instantiate identity map", ie);
        }
    }

    public static Collection entries(Map map) {
        if (IDENTITY_MAP_CLASS == (class$net$sf$hibernate$util$IdentityMap == null ? (class$net$sf$hibernate$util$IdentityMap = IdentityMap.class$("net.sf.hibernate.util.IdentityMap")) : class$net$sf$hibernate$util$IdentityMap)) {
            return ((IdentityMap)map).entryList();
        }
        return new ArrayList(map.entrySet());
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        IdentityKey k = new IdentityKey(key);
        return this.map.containsKey(k);
    }

    public boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    public Object get(Object key) {
        IdentityKey k = new IdentityKey(key);
        return this.map.get(k);
    }

    public Object put(Object key, Object value) {
        return this.map.put(new IdentityKey(key), value);
    }

    public Object remove(Object key) {
        IdentityKey k = new IdentityKey(key);
        return this.map.remove(k);
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            this.put(me.getKey(), me.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        HashSet<IdentityMapEntry> set = new HashSet<IdentityMapEntry>(this.map.size());
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            set.add(new IdentityMapEntry(((IdentityKey)me.getKey()).key, me.getValue()));
        }
        return set;
    }

    private List entryList() {
        ArrayList<IdentityMapEntry> list = new ArrayList<IdentityMapEntry>(this.map.size());
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            list.add(new IdentityMapEntry(((IdentityKey)me.getKey()).key, me.getValue()));
        }
        return list;
    }

    public static Object serialize(Map map) {
        if (IDENTITY_MAP_CLASS == (class$net$sf$hibernate$util$IdentityMap == null ? (class$net$sf$hibernate$util$IdentityMap = IdentityMap.class$("net.sf.hibernate.util.IdentityMap")) : class$net$sf$hibernate$util$IdentityMap)) {
            return map;
        }
        Object[] array = new Object[map.size() * 2];
        Iterator iter = map.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            array[i++] = e.getKey();
            array[i++] = e.getValue();
        }
        return array;
    }

    public static Map deserialize(Object o) {
        if (IDENTITY_MAP_CLASS == (class$net$sf$hibernate$util$IdentityMap == null ? (class$net$sf$hibernate$util$IdentityMap = IdentityMap.class$("net.sf.hibernate.util.IdentityMap")) : class$net$sf$hibernate$util$IdentityMap)) {
            return (Map)o;
        }
        Map idmap = IdentityMap.instantiate();
        Object[] array = (Object[])o;
        int i = 0;
        while (i < array.length) {
            idmap.put(array[i], array[i + 1]);
            i += 2;
        }
        return idmap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class imc;
        try {
            imc = Class.forName("java.util.IdentityHashMap");
        }
        catch (ClassNotFoundException cnfe) {
            imc = class$net$sf$hibernate$util$IdentityMap == null ? (class$net$sf$hibernate$util$IdentityMap = IdentityMap.class$("net.sf.hibernate.util.IdentityMap")) : class$net$sf$hibernate$util$IdentityMap;
        }
        IDENTITY_MAP_CLASS = imc;
    }

    public static final class IdentityKey
    implements Serializable {
        private Object key;

        IdentityKey(Object key) {
            this.key = key;
        }

        public boolean equals(Object other) {
            return this.key == ((IdentityKey)other).key;
        }

        public int hashCode() {
            return System.identityHashCode(this.key);
        }
    }

    public static final class IdentityMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        IdentityMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object result = this.value;
            this.value = value;
            return result;
        }
    }
}

