/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.util.Iterator;
import java.util.StringTokenizer;

public final class StringHelper {
    public static final String EMPTY_STRING = "";
    public static final char DOT = '.';
    public static final char UNDERSCORE = '_';
    public static final String COMMA_SPACE = ", ";
    public static final String COMMA = ",";
    public static final String OPEN_PAREN = "(";
    public static final String CLOSE_PAREN = ")";

    public static String join(String seperator, String[] strings) {
        int length = strings.length;
        if (length == 0) {
            return EMPTY_STRING;
        }
        StringBuffer buf = new StringBuffer(length * strings[0].length()).append(strings[0]);
        int i = 1;
        while (i < length) {
            buf.append(seperator).append(strings[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String join(String seperator, Iterator objects) {
        StringBuffer buf = new StringBuffer();
        buf.append(objects.next());
        while (objects.hasNext()) {
            buf.append(seperator).append(objects.next());
        }
        return buf.toString();
    }

    public static String[] add(String[] x, String sep, String[] y) {
        String[] result = new String[x.length];
        int i = 0;
        while (i < x.length) {
            result[i] = x[i] + sep + y[i];
            ++i;
        }
        return result;
    }

    public static String repeat(String string, int times) {
        StringBuffer buf = new StringBuffer(string.length() * times);
        int i = 0;
        while (i < times) {
            buf.append(string);
            ++i;
        }
        return buf.toString();
    }

    public static String replace(String template, String placeholder, String replacement) {
        int loc = template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        return template.substring(0, loc) + replacement + StringHelper.replace(template.substring(loc + placeholder.length()), placeholder, replacement);
    }

    public static String replaceOnce(String template, String placeholder, String replacement) {
        int loc = template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        return template.substring(0, loc) + replacement + template.substring(loc + placeholder.length());
    }

    public static String[] split(String seperators, String list) {
        return StringHelper.split(seperators, list, false);
    }

    public static String[] split(String seperators, String list, boolean include) {
        StringTokenizer tokens = new StringTokenizer(list, seperators, include);
        String[] result = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            result[i++] = tokens.nextToken();
        }
        return result;
    }

    public static String unqualify(String qualifiedName) {
        return StringHelper.unqualify(qualifiedName, ".");
    }

    public static String unqualify(String qualifiedName, String seperator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(seperator) + 1);
    }

    public static String qualifier(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(".");
        if (loc < 0) {
            return EMPTY_STRING;
        }
        return qualifiedName.substring(0, loc);
    }

    public static String[] suffix(String[] columns, String suffix) {
        if (suffix == null) {
            return columns;
        }
        String[] qualified = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            qualified[i] = StringHelper.suffix(columns[i], suffix);
            ++i;
        }
        return qualified;
    }

    public static String suffix(String name, String suffix) {
        return suffix == null ? name : name + suffix;
    }

    public static String[] prefix(String[] columns, String prefix) {
        if (prefix == null) {
            return columns;
        }
        String[] qualified = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            qualified[i] = prefix + columns[i];
            ++i;
        }
        return qualified;
    }

    public static String root(String qualifiedName) {
        int loc = qualifiedName.indexOf(".");
        return loc < 0 ? qualifiedName : qualifiedName.substring(0, loc);
    }

    public static boolean booleanValue(String tfString) {
        String trimmed = tfString.trim().toLowerCase();
        return trimmed.equals("true") || trimmed.equals("t");
    }

    public static String toString(Object[] array) {
        int len = array.length;
        if (len == 0) {
            return EMPTY_STRING;
        }
        StringBuffer buf = new StringBuffer(len * 12);
        int i = 0;
        while (i < len - 1) {
            buf.append(array[i]).append(COMMA_SPACE);
            ++i;
        }
        return buf.append(array[len - 1]).toString();
    }

    public static String[] multiply(String string, Iterator placeholders, Iterator replacements) {
        String[] result = new String[]{string};
        while (placeholders.hasNext()) {
            result = StringHelper.multiply(result, (String)placeholders.next(), (String[])replacements.next());
        }
        return result;
    }

    private static String[] multiply(String[] strings, String placeholder, String[] replacements) {
        String[] results = new String[replacements.length * strings.length];
        int n = 0;
        int i = 0;
        while (i < replacements.length) {
            int j = 0;
            while (j < strings.length) {
                results[n++] = StringHelper.replaceOnce(strings[j], placeholder, replacements[i]);
                ++j;
            }
            ++i;
        }
        return results;
    }

    private StringHelper() {
    }
}

