// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BindParams bind params
//
// swagger:model bind_params
type BindParams struct {

	// accept netscaler cip
	AcceptNetscalerCip int64 `json:"accept_netscaler_cip,omitempty"`

	// accept proxy
	AcceptProxy bool `json:"accept_proxy,omitempty"`

	// allow 0rtt
	Allow0rtt bool `json:"allow_0rtt,omitempty"`

	// alpn
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Alpn string `json:"alpn,omitempty"`

	// backlog
	Backlog string `json:"backlog,omitempty"`

	// ca ignore err
	CaIgnoreErr string `json:"ca_ignore_err,omitempty"`

	// ca sign file
	CaSignFile string `json:"ca_sign_file,omitempty"`

	// ca sign pass
	CaSignPass string `json:"ca_sign_pass,omitempty"`

	// ca verify file
	CaVerifyFile string `json:"ca_verify_file,omitempty"`

	// ciphers
	Ciphers string `json:"ciphers,omitempty"`

	// ciphersuites
	Ciphersuites string `json:"ciphersuites,omitempty"`

	// client sigalgs
	ClientSigalgs string `json:"client_sigalgs,omitempty"`

	// crl file
	CrlFile string `json:"crl_file,omitempty"`

	// crt ignore err
	CrtIgnoreErr string `json:"crt_ignore_err,omitempty"`

	// crt list
	CrtList string `json:"crt_list,omitempty"`

	// curves
	Curves string `json:"curves,omitempty"`

	// default crt list
	DefaultCrtList []string `json:"default_crt_list,omitempty"`

	// defer accept
	DeferAccept bool `json:"defer_accept,omitempty"`

	// ecdhe
	Ecdhe string `json:"ecdhe,omitempty"`

	// expose fd listeners
	ExposeFdListeners bool `json:"expose_fd_listeners,omitempty"`

	// force sslv3
	ForceSslv3 bool `json:"force_sslv3,omitempty"`

	// force tlsv10
	ForceTlsv10 bool `json:"force_tlsv10,omitempty"`

	// force tlsv11
	ForceTlsv11 bool `json:"force_tlsv11,omitempty"`

	// force tlsv12
	ForceTlsv12 bool `json:"force_tlsv12,omitempty"`

	// force tlsv13
	ForceTlsv13 bool `json:"force_tlsv13,omitempty"`

	// generate certificates
	GenerateCertificates bool `json:"generate_certificates,omitempty"`

	// gid
	Gid int64 `json:"gid,omitempty"`

	// group
	Group string `json:"group,omitempty"`

	// guid prefix
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	GUIDPrefix string `json:"guid_prefix,omitempty"`

	// id
	ID string `json:"id,omitempty"`

	// interface
	Interface string `json:"interface,omitempty"`

	// level
	// Example: user
	// Enum: ["user","operator","admin"]
	// +kubebuilder:validation:Enum="user","operator","admin";
	Level string `json:"level,omitempty"`

	// maxconn
	// Example: 1234
	Maxconn int64 `json:"maxconn,omitempty"`

	// mode
	Mode string `json:"mode,omitempty"`

	// mss
	Mss string `json:"mss,omitempty"`

	// name
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Name string `json:"name,omitempty"`

	// namespace
	// Example: app
	Namespace string `json:"namespace,omitempty"`

	// nbconn
	Nbconn int64 `json:"nbconn,omitempty"`

	// nice
	// Example: 1
	Nice int64 `json:"nice,omitempty"`

	// no alpn
	NoAlpn bool `json:"no_alpn,omitempty"`

	// no ca names
	NoCaNames bool `json:"no_ca_names,omitempty"`

	// no sslv3
	NoSslv3 bool `json:"no_sslv3,omitempty"`

	// no tls tickets
	NoTLSTickets bool `json:"no_tls_tickets,omitempty"`

	// no tlsv10
	NoTlsv10 bool `json:"no_tlsv10,omitempty"`

	// no tlsv11
	NoTlsv11 bool `json:"no_tlsv11,omitempty"`

	// no tlsv12
	NoTlsv12 bool `json:"no_tlsv12,omitempty"`

	// no tlsv13
	NoTlsv13 bool `json:"no_tlsv13,omitempty"`

	// npn
	Npn string `json:"npn,omitempty"`

	// prefer client ciphers
	PreferClientCiphers bool `json:"prefer_client_ciphers,omitempty"`

	// proto
	Proto string `json:"proto,omitempty"`

	// quic cc algo
	// Enum: ["cubic","newreno"]
	// +kubebuilder:validation:Enum="cubic","newreno";
	QuicCcAlgo string `json:"quic-cc-algo,omitempty"`

	// quic force retry
	QuicForceRetry bool `json:"quic-force-retry,omitempty"`

	// quic socket
	// Enum: ["connection","listener"]
	// +kubebuilder:validation:Enum="connection","listener";
	QuicSocket string `json:"quic-socket,omitempty"`

	// severity output
	// Example: none
	// Enum: ["none","number","string"]
	// +kubebuilder:validation:Enum="none","number","string";
	SeverityOutput string `json:"severity_output,omitempty"`

	// sigalgs
	Sigalgs string `json:"sigalgs,omitempty"`

	// ssl
	Ssl bool `json:"ssl,omitempty"`

	// ssl cafile
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SslCafile string `json:"ssl_cafile,omitempty"`

	// ssl certificate
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SslCertificate string `json:"ssl_certificate,omitempty"`

	// ssl max ver
	// Enum: ["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]
	// +kubebuilder:validation:Enum="SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3";
	SslMaxVer string `json:"ssl_max_ver,omitempty"`

	// ssl min ver
	// Enum: ["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]
	// +kubebuilder:validation:Enum="SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3";
	SslMinVer string `json:"ssl_min_ver,omitempty"`

	// strict sni
	StrictSni bool `json:"strict_sni,omitempty"`

	// tcp user timeout
	TCPUserTimeout *int64 `json:"tcp_user_timeout,omitempty"`

	// tfo
	Tfo bool `json:"tfo,omitempty"`

	// thread
	Thread string `json:"thread,omitempty"`

	// tls ticket keys
	TLSTicketKeys string `json:"tls_ticket_keys,omitempty"`

	// transparent
	Transparent bool `json:"transparent,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`

	// user
	User string `json:"user,omitempty"`

	// v4v6
	V4v6 bool `json:"v4v6,omitempty"`

	// v6only
	V6only bool `json:"v6only,omitempty"`

	// verify
	// Example: none
	// Enum: ["none","optional","required"]
	// +kubebuilder:validation:Enum="none","optional","required";
	Verify string `json:"verify,omitempty"`
}

// Validate validates this bind params
func (m *BindParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAlpn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDefaultCrtList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGUIDPrefix(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuicCcAlgo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuicSocket(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverityOutput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslCafile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslMaxVer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslMinVer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerify(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BindParams) validateAlpn(formats strfmt.Registry) error {
	if swag.IsZero(m.Alpn) { // not required
		return nil
	}

	if err := validate.Pattern("alpn", "body", m.Alpn, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *BindParams) validateDefaultCrtList(formats strfmt.Registry) error {
	if swag.IsZero(m.DefaultCrtList) { // not required
		return nil
	}

	for i := 0; i < len(m.DefaultCrtList); i++ {

		if err := validate.Pattern("default_crt_list"+"."+strconv.Itoa(i), "body", m.DefaultCrtList[i], `^[^\s]+$`); err != nil {
			return err
		}

	}

	return nil
}

func (m *BindParams) validateGUIDPrefix(formats strfmt.Registry) error {
	if swag.IsZero(m.GUIDPrefix) { // not required
		return nil
	}

	if err := validate.Pattern("guid_prefix", "body", m.GUIDPrefix, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var bindParamsTypeLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["user","operator","admin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bindParamsTypeLevelPropEnum = append(bindParamsTypeLevelPropEnum, v)
	}
}

const (

	// BindParamsLevelUser captures enum value "user"
	BindParamsLevelUser string = "user"

	// BindParamsLevelOperator captures enum value "operator"
	BindParamsLevelOperator string = "operator"

	// BindParamsLevelAdmin captures enum value "admin"
	BindParamsLevelAdmin string = "admin"
)

// prop value enum
func (m *BindParams) validateLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bindParamsTypeLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BindParams) validateLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.Level) { // not required
		return nil
	}

	// value enum
	if err := m.validateLevelEnum("level", "body", m.Level); err != nil {
		return err
	}

	return nil
}

func (m *BindParams) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.Pattern("name", "body", m.Name, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var bindParamsTypeQuicCcAlgoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cubic","newreno"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bindParamsTypeQuicCcAlgoPropEnum = append(bindParamsTypeQuicCcAlgoPropEnum, v)
	}
}

const (

	// BindParamsQuicCcAlgoCubic captures enum value "cubic"
	BindParamsQuicCcAlgoCubic string = "cubic"

	// BindParamsQuicCcAlgoNewreno captures enum value "newreno"
	BindParamsQuicCcAlgoNewreno string = "newreno"
)

// prop value enum
func (m *BindParams) validateQuicCcAlgoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bindParamsTypeQuicCcAlgoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BindParams) validateQuicCcAlgo(formats strfmt.Registry) error {
	if swag.IsZero(m.QuicCcAlgo) { // not required
		return nil
	}

	// value enum
	if err := m.validateQuicCcAlgoEnum("quic-cc-algo", "body", m.QuicCcAlgo); err != nil {
		return err
	}

	return nil
}

var bindParamsTypeQuicSocketPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["connection","listener"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bindParamsTypeQuicSocketPropEnum = append(bindParamsTypeQuicSocketPropEnum, v)
	}
}

const (

	// BindParamsQuicSocketConnection captures enum value "connection"
	BindParamsQuicSocketConnection string = "connection"

	// BindParamsQuicSocketListener captures enum value "listener"
	BindParamsQuicSocketListener string = "listener"
)

// prop value enum
func (m *BindParams) validateQuicSocketEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bindParamsTypeQuicSocketPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BindParams) validateQuicSocket(formats strfmt.Registry) error {
	if swag.IsZero(m.QuicSocket) { // not required
		return nil
	}

	// value enum
	if err := m.validateQuicSocketEnum("quic-socket", "body", m.QuicSocket); err != nil {
		return err
	}

	return nil
}

var bindParamsTypeSeverityOutputPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","number","string"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bindParamsTypeSeverityOutputPropEnum = append(bindParamsTypeSeverityOutputPropEnum, v)
	}
}

const (

	// BindParamsSeverityOutputNone captures enum value "none"
	BindParamsSeverityOutputNone string = "none"

	// BindParamsSeverityOutputNumber captures enum value "number"
	BindParamsSeverityOutputNumber string = "number"

	// BindParamsSeverityOutputString captures enum value "string"
	BindParamsSeverityOutputString string = "string"
)

// prop value enum
func (m *BindParams) validateSeverityOutputEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bindParamsTypeSeverityOutputPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BindParams) validateSeverityOutput(formats strfmt.Registry) error {
	if swag.IsZero(m.SeverityOutput) { // not required
		return nil
	}

	// value enum
	if err := m.validateSeverityOutputEnum("severity_output", "body", m.SeverityOutput); err != nil {
		return err
	}

	return nil
}

func (m *BindParams) validateSslCafile(formats strfmt.Registry) error {
	if swag.IsZero(m.SslCafile) { // not required
		return nil
	}

	if err := validate.Pattern("ssl_cafile", "body", m.SslCafile, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *BindParams) validateSslCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.SslCertificate) { // not required
		return nil
	}

	if err := validate.Pattern("ssl_certificate", "body", m.SslCertificate, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var bindParamsTypeSslMaxVerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bindParamsTypeSslMaxVerPropEnum = append(bindParamsTypeSslMaxVerPropEnum, v)
	}
}

const (

	// BindParamsSslMaxVerSSLv3 captures enum value "SSLv3"
	BindParamsSslMaxVerSSLv3 string = "SSLv3"

	// BindParamsSslMaxVerTLSv1Dot0 captures enum value "TLSv1.0"
	BindParamsSslMaxVerTLSv1Dot0 string = "TLSv1.0"

	// BindParamsSslMaxVerTLSv1Dot1 captures enum value "TLSv1.1"
	BindParamsSslMaxVerTLSv1Dot1 string = "TLSv1.1"

	// BindParamsSslMaxVerTLSv1Dot2 captures enum value "TLSv1.2"
	BindParamsSslMaxVerTLSv1Dot2 string = "TLSv1.2"

	// BindParamsSslMaxVerTLSv1Dot3 captures enum value "TLSv1.3"
	BindParamsSslMaxVerTLSv1Dot3 string = "TLSv1.3"
)

// prop value enum
func (m *BindParams) validateSslMaxVerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bindParamsTypeSslMaxVerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BindParams) validateSslMaxVer(formats strfmt.Registry) error {
	if swag.IsZero(m.SslMaxVer) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslMaxVerEnum("ssl_max_ver", "body", m.SslMaxVer); err != nil {
		return err
	}

	return nil
}

var bindParamsTypeSslMinVerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bindParamsTypeSslMinVerPropEnum = append(bindParamsTypeSslMinVerPropEnum, v)
	}
}

const (

	// BindParamsSslMinVerSSLv3 captures enum value "SSLv3"
	BindParamsSslMinVerSSLv3 string = "SSLv3"

	// BindParamsSslMinVerTLSv1Dot0 captures enum value "TLSv1.0"
	BindParamsSslMinVerTLSv1Dot0 string = "TLSv1.0"

	// BindParamsSslMinVerTLSv1Dot1 captures enum value "TLSv1.1"
	BindParamsSslMinVerTLSv1Dot1 string = "TLSv1.1"

	// BindParamsSslMinVerTLSv1Dot2 captures enum value "TLSv1.2"
	BindParamsSslMinVerTLSv1Dot2 string = "TLSv1.2"

	// BindParamsSslMinVerTLSv1Dot3 captures enum value "TLSv1.3"
	BindParamsSslMinVerTLSv1Dot3 string = "TLSv1.3"
)

// prop value enum
func (m *BindParams) validateSslMinVerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bindParamsTypeSslMinVerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BindParams) validateSslMinVer(formats strfmt.Registry) error {
	if swag.IsZero(m.SslMinVer) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslMinVerEnum("ssl_min_ver", "body", m.SslMinVer); err != nil {
		return err
	}

	return nil
}

var bindParamsTypeVerifyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","optional","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bindParamsTypeVerifyPropEnum = append(bindParamsTypeVerifyPropEnum, v)
	}
}

const (

	// BindParamsVerifyNone captures enum value "none"
	BindParamsVerifyNone string = "none"

	// BindParamsVerifyOptional captures enum value "optional"
	BindParamsVerifyOptional string = "optional"

	// BindParamsVerifyRequired captures enum value "required"
	BindParamsVerifyRequired string = "required"
)

// prop value enum
func (m *BindParams) validateVerifyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bindParamsTypeVerifyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BindParams) validateVerify(formats strfmt.Registry) error {
	if swag.IsZero(m.Verify) { // not required
		return nil
	}

	// value enum
	if err := m.validateVerifyEnum("verify", "body", m.Verify); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this bind params based on context it is used
func (m *BindParams) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BindParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BindParams) UnmarshalBinary(b []byte) error {
	var res BindParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
