\page README_basic Basic Examples

The set of basic examples is oriented to "novice" users and covering many
basic general use-cases typical of an "application"-oriented kind of
development.

- \ref ExampleB1
   - Simple geometry with a few solids
   - Geometry with simple placements (G4PVPlacement)
   - Scoring total dose in a selected volume user action classes
   - Using G4Accumulable for automatic merging of scored values in multi-threading mode
   - Geant4 physics list (QBBC)

- \ref ExampleB2
   - Simplified tracker geometry with global constant magnetic field
   - Geometry with simple placements (G4PVPlacement) and parameterisation
     (G4PVParameterisation)
   - Scoring within tracker via G4 sensitive detector and hits
   - Geant4 physics list (FTFP_BERT) with step limiter
   - Started from novice/N02 example

- \ref ExampleB3
   - Schematic Positron Emitted Tomography system
   - Geometry with simple placements with rotation (G4PVPlacement)
   - Radioactive source
   - Scoring within Crystals via G4 scorers
   - Using G4Accumulable for automatic merging of scored values in multi-threading mode (a)
     and G4StatAnalysis for accumulating statistics (b)
   - Modular physics list built via builders provided in Geant4

- \ref ExampleB4
   - Simplified calorimeter with layers of two materials
   - Geometry with replica (G4PVReplica)
   - Scoring within layers in four ways: via user actions (a), via user own
     object (b), via G4 sensitive detector and hits (c) and via scorers (d)
   - Geant4 physics list (FTFP_BERT)
   - Histograms (1D) and ntuple saved in the output file
   - Started from novice/N03 example

- \ref ExampleB5
   - A double-arm spectrometer with wire chambers, hodoscopes and calorimeters
     with a local constant magnetic field
   - Geometry with placements with rotation, replicas and parameterisation
   - Scoring within wire chambers, hodoscopes and calorimeters via
     G4 sensitive detector and hits
   - Geant4 physics list (FTFP_BERT) with step limiter
   - UI commans defined using G4GenericMessenger
   - Histograms (1D, 2D) and ntuple saved in two output files
   - Plotting of histograms with visualization drivers
   - Offscreen drawing with TSG
   - Started from extended/analysis/A01
