\page ExampleclGeometry Example clGeometry

<h1> Use of G3toG4 tool </h1>

This examples demonstrates the usage of the g3tog4 tool for converting 
Geant 3.21 simple geometries to Geant4 ones.

It requires Geant4 installation with G3toG4 library (
handled with GEANT4_USE_G3TOG4 option in CMake build or the G4LIB_USE_G3TOG4
environment variable in GNUmake build).

It demonstrates building a detector geometry using the call list
mechanism and also provides visualization, see the G3toG4DetectorConstruction
class. The executable is provided in clGeometry.cc.

The example uses the GunPrimaryGeneratorAction class from the extended examples common 
repository available in common subdirectory. This class is instatiated in G3toG4ActionInitialization class as it is required for processing with both sequential and multi-threaded Geant4 modes.

To run the application, one must provide as input argument a call list file
(few test samples are placed in data directory), generated by the rztog4 application
which can be built typing "make bin" from $G4INSTALL/source/g3tog4.
Then several optional arguments can be specified to define a macro, UI session 
or number of threads (applicable only with multi-threading mode):
```
clGeometry callListFile [-m macro ] [-u UIsession] [-t nThreads]
```

There are provided clGeometry.in and run.mac macros which can be executed either interactively
or in batch.

For example:
```
> clGeometry data/testmodel.dat -m clGeometry.in
```
