/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import net.sf.samtools.BinaryTagCodec;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.util.DateParser;
import net.sf.samtools.util.Iso8601Date;
import net.sf.samtools.util.StringUtil;

class TextTagCodec {
    private static final int NUM_TAG_FIELDS = 3;
    private final String[] fields = new String[3];
    private final String[] typeAndValueFields = new String[2];

    TextTagCodec() {
    }

    String encode(String tagName, Object value) {
        long longVal;
        StringBuilder sb = new StringBuilder(tagName);
        sb.append(':');
        char tagType = BinaryTagCodec.getTagValueType(value);
        switch (tagType) {
            case 'C': 
            case 'I': 
            case 'S': 
            case 'c': 
            case 's': {
                tagType = 'i';
            }
        }
        if (tagType == 'H') {
            value = StringUtil.bytesToHexString((byte[])value);
        } else if (tagType == 'i' && ((longVal = ((Number)value).longValue()) > Integer.MAX_VALUE || longVal < Integer.MIN_VALUE)) {
            throw new SAMFormatException("Value for tag " + tagName + " cannot be stored in an Integer: " + longVal);
        }
        sb.append(tagType);
        sb.append(':');
        sb.append(value.toString());
        return sb.toString();
    }

    String encodeUntypedTag(String tagName, Object value) {
        StringBuilder sb = new StringBuilder(tagName);
        sb.append(':');
        sb.append(value.toString());
        return sb.toString();
    }

    Map.Entry<String, Object> decode(String tag) {
        int numFields = StringUtil.splitConcatenateExcessTokens(tag, this.fields, ':');
        if (numFields != 3) {
            throw new SAMFormatException("Not enough fields in tag '" + tag + "'");
        }
        final String key = this.fields[0];
        String type = this.fields[1];
        String stringVal = this.fields[2];
        final Object val = this.convertStringToObject(type, stringVal);
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return val;
            }

            @Override
            public Object setValue(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    Object decodeTypeAndValue(String typeAndValue) {
        int numFields = StringUtil.splitConcatenateExcessTokens(typeAndValue, this.typeAndValueFields, ':');
        if (numFields == 1) {
            return typeAndValue;
        }
        return this.convertStringToObject(this.typeAndValueFields[0], this.typeAndValueFields[1]);
    }

    private Object convertStringToObject(String type, String stringVal) {
        Object val;
        if (type.equals("Z")) {
            val = stringVal;
        } else if (type.equals("A")) {
            if (stringVal.length() != 1) {
                throw new SAMFormatException("Tag of type A should have a single-character value");
            }
            val = Character.valueOf(stringVal.charAt(0));
        } else if (type.equals("i")) {
            try {
                val = new Integer(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type i should have signed decimal value");
            }
        } else if (type.equals("f")) {
            try {
                val = new Float(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type f should have single-precision floating point value");
            }
        } else if (type.equals("H")) {
            try {
                val = StringUtil.hexStringToBytes(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type H should have valid hex string with even number of digits");
            }
        } else {
            throw new SAMFormatException("Unrecognized tag type: " + type);
        }
        return val;
    }

    Iso8601Date decodeDate(String dateStr) {
        try {
            return new Iso8601Date(dateStr);
        }
        catch (DateParser.InvalidDateException ex) {
            try {
                return new Iso8601Date(DateFormat.getDateTimeInstance().parse(dateStr));
            }
            catch (ParseException e) {
                try {
                    return new Iso8601Date(new Date(dateStr));
                }
                catch (Exception e1) {
                    throw new DateParser.InvalidDateException("Could not parse as date: " + dateStr, e);
                }
            }
        }
    }
}

