/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.MessageFormat;
import java.util.Date;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public abstract class WrappersEditor
implements ExPropertyEditor {
    protected PropertyEditor pe = null;

    public WrappersEditor(Class clazz) {
        this.pe = PropertyEditorManager.findEditor(clazz);
    }

    public void setValue(Object object) throws IllegalArgumentException {
        this.pe.setValue(object);
    }

    public Object getValue() {
        return this.pe.getValue();
    }

    public boolean isPaintable() {
        return this.pe.isPaintable();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        this.pe.paintValue(graphics, rectangle);
    }

    public String getAsText() {
        if (this.pe.getValue() == null) {
            return "null";
        }
        return this.pe.getAsText();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if ("null".equals(string)) {
            return;
        }
        try {
            this.pe.setAsText(string);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exception.getMessage());
            String string2 = exception.getLocalizedMessage();
            if (string2 == null || exception.getMessage().equals(string2)) {
                string2 = MessageFormat.format(NbBundle.getMessage(WrappersEditor.class, (String)"FMT_EXC_GENERIC_BAD_VALUE"), string);
            }
            UIExceptions.annotateUser(illegalArgumentException, illegalArgumentException.getMessage(), string2, exception, new Date());
            throw illegalArgumentException;
        }
    }

    public String[] getTags() {
        return this.pe.getTags();
    }

    public Component getCustomEditor() {
        return this.pe.getCustomEditor();
    }

    public boolean supportsCustomEditor() {
        return this.pe.supportsCustomEditor();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pe.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pe.removePropertyChangeListener(propertyChangeListener);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        if (this.pe instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.pe).attachEnv(propertyEnv);
        }
    }
}

