﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/model/ErrorDetail.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AppSync {
namespace Model {
class EvaluateMappingTemplateResult {
 public:
  AWS_APPSYNC_API EvaluateMappingTemplateResult() = default;
  AWS_APPSYNC_API EvaluateMappingTemplateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPSYNC_API EvaluateMappingTemplateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The mapping template; this can be a request or response template.</p>
   */
  inline const Aws::String& GetEvaluationResult() const { return m_evaluationResult; }
  template <typename EvaluationResultT = Aws::String>
  void SetEvaluationResult(EvaluationResultT&& value) {
    m_evaluationResultHasBeenSet = true;
    m_evaluationResult = std::forward<EvaluationResultT>(value);
  }
  template <typename EvaluationResultT = Aws::String>
  EvaluateMappingTemplateResult& WithEvaluationResult(EvaluationResultT&& value) {
    SetEvaluationResult(std::forward<EvaluationResultT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>ErrorDetail</code> object.</p>
   */
  inline const ErrorDetail& GetError() const { return m_error; }
  template <typename ErrorT = ErrorDetail>
  void SetError(ErrorT&& value) {
    m_errorHasBeenSet = true;
    m_error = std::forward<ErrorT>(value);
  }
  template <typename ErrorT = ErrorDetail>
  EvaluateMappingTemplateResult& WithError(ErrorT&& value) {
    SetError(std::forward<ErrorT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
   * <code>util.log.error</code> in the evaluated code.</p>
   */
  inline const Aws::Vector<Aws::String>& GetLogs() const { return m_logs; }
  template <typename LogsT = Aws::Vector<Aws::String>>
  void SetLogs(LogsT&& value) {
    m_logsHasBeenSet = true;
    m_logs = std::forward<LogsT>(value);
  }
  template <typename LogsT = Aws::Vector<Aws::String>>
  EvaluateMappingTemplateResult& WithLogs(LogsT&& value) {
    SetLogs(std::forward<LogsT>(value));
    return *this;
  }
  template <typename LogsT = Aws::String>
  EvaluateMappingTemplateResult& AddLogs(LogsT&& value) {
    m_logsHasBeenSet = true;
    m_logs.emplace_back(std::forward<LogsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An object available inside each resolver and function handler. A single
   * <code>stash</code> object lives through a single resolver run. Therefore, you
   * can use the stash to pass arbitrary data across request and response handlers
   * and across functions in a pipeline resolver.</p>
   */
  inline const Aws::String& GetStash() const { return m_stash; }
  template <typename StashT = Aws::String>
  void SetStash(StashT&& value) {
    m_stashHasBeenSet = true;
    m_stash = std::forward<StashT>(value);
  }
  template <typename StashT = Aws::String>
  EvaluateMappingTemplateResult& WithStash(StashT&& value) {
    SetStash(std::forward<StashT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of runtime errors that are added to the GraphQL operation
   * response.</p>
   */
  inline const Aws::String& GetOutErrors() const { return m_outErrors; }
  template <typename OutErrorsT = Aws::String>
  void SetOutErrors(OutErrorsT&& value) {
    m_outErrorsHasBeenSet = true;
    m_outErrors = std::forward<OutErrorsT>(value);
  }
  template <typename OutErrorsT = Aws::String>
  EvaluateMappingTemplateResult& WithOutErrors(OutErrorsT&& value) {
    SetOutErrors(std::forward<OutErrorsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  EvaluateMappingTemplateResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_evaluationResult;
  bool m_evaluationResultHasBeenSet = false;

  ErrorDetail m_error;
  bool m_errorHasBeenSet = false;

  Aws::Vector<Aws::String> m_logs;
  bool m_logsHasBeenSet = false;

  Aws::String m_stash;
  bool m_stashHasBeenSet = false;

  Aws::String m_outErrors;
  bool m_outErrorsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppSync
}  // namespace Aws
