﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgentRuntime {
namespace Model {
class GetExecutionFlowSnapshotResult {
 public:
  AWS_BEDROCKAGENTRUNTIME_API GetExecutionFlowSnapshotResult() = default;
  AWS_BEDROCKAGENTRUNTIME_API GetExecutionFlowSnapshotResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BEDROCKAGENTRUNTIME_API GetExecutionFlowSnapshotResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier of the flow.</p>
   */
  inline const Aws::String& GetFlowIdentifier() const { return m_flowIdentifier; }
  template <typename FlowIdentifierT = Aws::String>
  void SetFlowIdentifier(FlowIdentifierT&& value) {
    m_flowIdentifierHasBeenSet = true;
    m_flowIdentifier = std::forward<FlowIdentifierT>(value);
  }
  template <typename FlowIdentifierT = Aws::String>
  GetExecutionFlowSnapshotResult& WithFlowIdentifier(FlowIdentifierT&& value) {
    SetFlowIdentifier(std::forward<FlowIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the flow alias used for the flow execution.</p>
   */
  inline const Aws::String& GetFlowAliasIdentifier() const { return m_flowAliasIdentifier; }
  template <typename FlowAliasIdentifierT = Aws::String>
  void SetFlowAliasIdentifier(FlowAliasIdentifierT&& value) {
    m_flowAliasIdentifierHasBeenSet = true;
    m_flowAliasIdentifier = std::forward<FlowAliasIdentifierT>(value);
  }
  template <typename FlowAliasIdentifierT = Aws::String>
  GetExecutionFlowSnapshotResult& WithFlowAliasIdentifier(FlowAliasIdentifierT&& value) {
    SetFlowAliasIdentifier(std::forward<FlowAliasIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the flow used for the flow execution.</p>
   */
  inline const Aws::String& GetFlowVersion() const { return m_flowVersion; }
  template <typename FlowVersionT = Aws::String>
  void SetFlowVersion(FlowVersionT&& value) {
    m_flowVersionHasBeenSet = true;
    m_flowVersion = std::forward<FlowVersionT>(value);
  }
  template <typename FlowVersionT = Aws::String>
  GetExecutionFlowSnapshotResult& WithFlowVersion(FlowVersionT&& value) {
    SetFlowVersion(std::forward<FlowVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the IAM service role that's used by the
   * flow execution.</p>
   */
  inline const Aws::String& GetExecutionRoleArn() const { return m_executionRoleArn; }
  template <typename ExecutionRoleArnT = Aws::String>
  void SetExecutionRoleArn(ExecutionRoleArnT&& value) {
    m_executionRoleArnHasBeenSet = true;
    m_executionRoleArn = std::forward<ExecutionRoleArnT>(value);
  }
  template <typename ExecutionRoleArnT = Aws::String>
  GetExecutionFlowSnapshotResult& WithExecutionRoleArn(ExecutionRoleArnT&& value) {
    SetExecutionRoleArn(std::forward<ExecutionRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The flow definition used for the flow execution, including the nodes,
   * connections, and configuration at the time when the execution started.</p>
   * <p>The definition returns as a string that follows the structure of a <a
   * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowDefinition.html">FlowDefinition</a>
   * object.</p>
   */
  inline const Aws::String& GetDefinition() const { return m_definition; }
  template <typename DefinitionT = Aws::String>
  void SetDefinition(DefinitionT&& value) {
    m_definitionHasBeenSet = true;
    m_definition = std::forward<DefinitionT>(value);
  }
  template <typename DefinitionT = Aws::String>
  GetExecutionFlowSnapshotResult& WithDefinition(DefinitionT&& value) {
    SetDefinition(std::forward<DefinitionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the customer managed KMS key that's used to
   * encrypt the flow snapshot.</p>
   */
  inline const Aws::String& GetCustomerEncryptionKeyArn() const { return m_customerEncryptionKeyArn; }
  template <typename CustomerEncryptionKeyArnT = Aws::String>
  void SetCustomerEncryptionKeyArn(CustomerEncryptionKeyArnT&& value) {
    m_customerEncryptionKeyArnHasBeenSet = true;
    m_customerEncryptionKeyArn = std::forward<CustomerEncryptionKeyArnT>(value);
  }
  template <typename CustomerEncryptionKeyArnT = Aws::String>
  GetExecutionFlowSnapshotResult& WithCustomerEncryptionKeyArn(CustomerEncryptionKeyArnT&& value) {
    SetCustomerEncryptionKeyArn(std::forward<CustomerEncryptionKeyArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetExecutionFlowSnapshotResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_flowIdentifier;
  bool m_flowIdentifierHasBeenSet = false;

  Aws::String m_flowAliasIdentifier;
  bool m_flowAliasIdentifierHasBeenSet = false;

  Aws::String m_flowVersion;
  bool m_flowVersionHasBeenSet = false;

  Aws::String m_executionRoleArn;
  bool m_executionRoleArnHasBeenSet = false;

  Aws::String m_definition;
  bool m_definitionHasBeenSet = false;

  Aws::String m_customerEncryptionKeyArn;
  bool m_customerEncryptionKeyArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
