'\"
'\" Generated from file 'plotchart\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2022 Arjen Markus <arjenmarkus@users\&.sourceforge\&.net>
'\"
.TH "Plotchart" n 2\&.6\&.2 tklib "Plotchart"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
Plotchart \- Simple plotting and charting package
.SH SYNOPSIS
package require \fBTcl  ?8\&.5?\fR
.sp
package require \fBTk  ?8\&.5?\fR
.sp
package require \fBPlotchart  ?2\&.6\&.2?\fR
.sp
\fB::Plotchart::createXYPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
.sp
\fB::Plotchart::createStripchart\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
.sp
\fB::Plotchart::createTXPlot\fR \fIw\fR \fItimeaxis\fR \fIxaxis\fR \fIargs\fR
.sp
\fB::Plotchart::createXLogYPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
.sp
\fB::Plotchart::createLogXYPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
.sp
\fB::Plotchart::createLogXLogYPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
.sp
\fB::Plotchart::createPolarPlot\fR \fIw\fR \fIradius_data\fR \fIargs\fR
.sp
\fB::Plotchart::createWindrose\fR \fIw\fR \fIradius_data\fR \fIsectors\fR
.sp
\fB::Plotchart::createIsometricPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIstepsize\fR
.sp
\fB::Plotchart::createHistogram\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
.sp
\fB::Plotchart::create3DPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIzaxis\fR \fIargs\fR
.sp
\fB::Plotchart::create3DRibbonPlot\fR \fIw\fR \fIyaxis\fR \fIzaxis\fR
.sp
\fB::Plotchart::createPiechart\fR \fIw\fR
.sp
\fB::Plotchart::createSpiralPie\fR \fIw\fR
.sp
\fB::Plotchart::createRadialchart\fR \fIw\fR \fInames\fR \fIscale\fR \fIstyle\fR
.sp
\fB::Plotchart::createBarchart\fR \fIw\fR \fIxlabels\fR \fIyaxis\fR \fInoseries\fR \fIargs\fR
.sp
\fB::Plotchart::createHorizontalBarchart\fR \fIw\fR \fIxaxis\fR \fIylabel\fR \fInoseries\fR
.sp
\fB::Plotchart::create3DBarchart\fR \fIw\fR \fIyaxis\fR \fInobars\fR
.sp
\fB::Plotchart::create3DRibbonChart\fR \fIw\fR \fInames\fR \fIyaxis\fR \fIzaxis\fR
.sp
\fB::Plotchart::createBoxplot\fR \fIw\fR \fIxdata\fR \fIydata\fR \fIorientation\fR
.sp
\fB::Plotchart::createTimechart\fR \fIw\fR \fItime_begin\fR \fItime_end\fR \fIargs\fR
.sp
\fB::Plotchart::createGanttchart\fR \fIw\fR \fItime_begin\fR \fItime_end\fR \fIargs\fR
.sp
\fB::Plotchart::createRightAxis\fR \fIw_or_plot\fR \fIyaxis\fR
.sp
\fB::Plotchart::createTableChart\fR \fIw\fR \fIcolumns\fR ?widths?
.sp
\fB::Plotchart::createTernaryDiagram\fR \fIw\fR \fIargs\fR
.sp
\fB::Plotchart::createNormalPlot\fR \fIw\fR \fIxscale\fR \fIargs\fR
.sp
\fB::Plotchart::createStatusTimeline\fR \fIw\fR \fIxaxis\fR \fIylabel\fR \fIargs\fR
.sp
\fB::Plotchart::createDendrogram\fR \fIw\fR \fIargs\fR
.sp
\fB$anyplot\fR title \fItext\fR \fIposition\fR
.sp
\fB$anyplot\fR subtitle \fItext\fR
.sp
\fB$anyplot\fR canvas
.sp
\fB$anyplot\fR saveplot \fIfilename\fR \fIargs\fR
.sp
\fB$anyplot\fR xtext \fItext\fR
.sp
\fB$anyplot\fR ytext \fItext\fR
.sp
\fB$anyplot\fR vtext \fItext\fR
.sp
\fB$anyplot\fR xsubtext \fItext\fR
.sp
\fB$anyplot\fR ysubtext \fItext\fR
.sp
\fB$anyplot\fR vsubtext \fItext\fR
.sp
\fB$anyplot\fR xconfig \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$anyplot\fR yconfig \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$anyplot\fR background \fIpart\fR \fIcolour_or_image\fR \fIdir\fR ?brightness?
.sp
\fB$anyplot\fR xticklines \fIcolour\fR ?dash?
.sp
\fB$anyplot\fR yticklines \fIcolour\fR ?dash?
.sp
\fB$anyplot\fR legend \fIseries\fR \fItext\fR ?spacing?
.sp
\fB$anyplot\fR removefromlegend \fIseries\fR
.sp
\fB$anyplot\fR legendconfig \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$anyplot\fR balloon \fIx\fR \fIy\fR \fItext\fR \fIdir\fR
.sp
\fB$anyplot\fR balloonconfig \fIargs\fR
.sp
\fB$anyplot\fR plaintext \fIx\fR \fIy\fR \fItext\fR \fIdir\fR
.sp
\fB$anyplot\fR plaintextconfig \fIargs\fR
.sp
\fB$anyplot\fR object \fIitemtype\fR \fIseries\fR \fIargs\fR
.sp
\fB$anyplot\fR deletedata
.sp
\fB$xyplot\fR plot \fIseries\fR \fIxcrd\fR \fIycrd\fR
.sp
\fB$normalplot\fR plot \fIseries\fR \fImean\fR \fIstdev\fR \fIdata\fR
.sp
\fB$normalplot\fR diagonal
.sp
\fB$xyplot\fR plotlist \fIseries\fR \fIxlist\fR \fIylist\fR \fIevery\fR
.sp
\fB$xyplot\fR region \fIseries\fR \fIxlist\fR \fIylist\fR
.sp
\fB$xyplot\fR minmax \fIseries\fR \fIxcrd\fR \fIymin\fR \fIymax\fR
.sp
\fB$histogram\fR plotcumulative \fIseries\fR \fIxcrd\fR \fIycrd\fR
.sp
\fB$xyplot\fR trend \fIseries\fR \fIxcrd\fR \fIycrd\fR
.sp
\fB$xyplot\fR rchart \fIseries\fR \fIxcrd\fR \fIycrd\fR
.sp
\fB$xyplot\fR interval \fIseries\fR \fIxcrd\fR \fIymin\fR \fIymax\fR ?ycentr?
.sp
\fB$xyplot\fR box-and-whiskers \fIseries\fR \fIxcrd\fR \fIycrd\fR
.sp
\fB$xyplot\fR violin \fIseries\fR \fIxcrd\fR \fIycrd\fR
.sp
\fB$xyplot\fR vector \fIseries\fR \fIxcrd\fR \fIycrd\fR \fIucmp\fR \fIvcmp\fR
.sp
\fB$xyplot\fR vectorconfig \fIseries\fR \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$xyplot\fR dot \fIseries\fR \fIxcrd\fR \fIycrd\fR \fIvalue\fR
.sp
\fB$xyplot\fR dotconfig \fIseries\fR \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$xyplot\fR contourlines \fIxcrd\fR \fIycrd\fR \fIvalues\fR ?classes?
.sp
\fB$xyplot\fR contourlinesfunctionvalues \fIxvec\fR \fIyvec\fR \fIvaluesmat\fR ?classes?
.sp
\fB$xyplot\fR contourfill \fIxcrd\fR \fIycrd\fR \fIvalues\fR ?classes?
.sp
\fB$xyplot\fR contourbox \fIxcrd\fR \fIycrd\fR \fIvalues\fR ?classes?
.sp
\fB$xyplot\fR colorMap \fIcolours\fR
.sp
\fB$xyplot\fR legendisolines \fIvalues\fR \fIclasses\fR
.sp
\fB$xyplot\fR legendshades \fIvalues\fR \fIclasses\fR
.sp
\fB$xyplot\fR grid \fIxcrd\fR \fIycrd\fR
.sp
\fB$xyplot\fR xband \fIymin\fR \fIymax\fR
.sp
\fB$xyplot\fR yband \fIxmin\fR \fIxmax\fR
.sp
\fB$xyplot\fR labeldot \fIx\fR \fIy\fR \fItext\fR \fIorient\fR
.sp
\fB$polarplot\fR plot \fIseries\fR \fIradius\fR \fIangle\fR
.sp
\fB$windrose\fR plot \fIdata\fR \fIcolour\fR
.sp
\fB$plot3d\fR plotfunc \fIfunction\fR
.sp
\fB$plot3d\fR plotfuncont \fIfunction\fR \fIcontours\fR
.sp
\fB$plot3d\fR gridsize \fInxcells\fR \fInycells\fR
.sp
\fB$plot3d\fR plotdata \fIdata\fR
.sp
\fB$plot3d\fR interpolatedata \fIdata\fR \fIcontours\fR
.sp
\fB$plot3d\fR colour \fIfill\fR \fIborder\fR
.sp
\fB$plot3d\fR ribbon \fIyzpairs\fR
.sp
\fB$plot3d\fR plot \fIyzpairs\fR
.sp
\fB$xyplot\fR dataconfig \fIseries\fR \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$pie\fR plot \fIdata\fR
.sp
\fB$pie\fR colours \fIcolour1\fR \fIcolour2\fR \&.\&.\&.
.sp
\fB$pie\fR explode \fIsegment\fR
.sp
\fB$radial\fR plot \fIdata\fR \fIcolour\fR \fIthickness\fR
.sp
\fB$pie\fR colours \fIcolour1\fR \fIcolour2\fR \&.\&.\&.
.sp
\fB$barchart\fR plot \fIseries\fR \fIydata\fR \fIcolour\fR ?dir? ?brightness?
.sp
\fB$barchart\fR config \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$barchart\fR plot \fIseries\fR \fIxdata\fR \fIcolour\fR ?dir? ?brightness?
.sp
\fB$barchart\fR config \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$barchart\fR plot \fIlabel\fR \fIyvalue\fR \fIcolour\fR
.sp
\fB$barchart\fR config \fB-option\fR \fIvalue\fR \&.\&.\&.
.sp
\fB$ribbon\fR line \fIxypairs\fR \fIcolour\fR
.sp
\fB$ribbon\fR area \fIxypairs\fR \fIcolour\fR
.sp
\fB$boxplot\fR plot \fIseries\fR \fIlabel\fR \fIvalues\fR
.sp
\fB$boxplot\fR violin \fIseries\fR \fIlabel\fR \fIvalues\fR
.sp
\fB$timechart\fR period \fItext\fR \fItime_begin\fR \fItime_end\fR \fIcolour\fR
.sp
\fB$timechart\fR addperiod \fItime_begin\fR \fItime_end\fR \fIcolour\fR
.sp
\fB$timechart\fR milestone \fItext\fR \fItime\fR \fIcolour\fR
.sp
\fB$timechart\fR addmilestone \fItime\fR \fIcolour\fR
.sp
\fB$timechart\fR vertline \fItext\fR \fItime\fR \fIcolour\fR
.sp
\fB$timechart\fR hscroll \fIscrollbar\fR
.sp
\fB$timechart\fR vscroll \fIscrollbar\fR
.sp
\fB$ganttchart\fR task \fItext\fR \fItime_begin\fR \fItime_end\fR \fIcompleted\fR
.sp
\fB$ganttchart\fR milestone \fItext\fR \fItime\fR \fIcolour\fR
.sp
\fB$ganttchart\fR vertline \fItext\fR \fItime\fR
.sp
\fB$ganttchart\fR connect \fIfrom\fR \fIto\fR
.sp
\fB$ganttchart\fR summary \fItext\fR \fIargs\fR
.sp
\fB$ganttchart\fR color \fIkeyword\fR \fInewcolor\fR
.sp
\fB$ganttchart\fR font \fIkeyword\fR \fInewfont\fR
.sp
\fB$ganttchart\fR hscroll \fIscrollbar\fR
.sp
\fB$ganttchart\fR vscroll \fIscrollbar\fR
.sp
\fB$isoplot\fR plot rectangle \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR \fIcolour\fR
.sp
\fB$isoplot\fR plot filled-rectangle \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR \fIcolour\fR
.sp
\fB$isoplot\fR plot circle \fIxc\fR \fIyc\fR \fIradius\fR \fIcolour\fR
.sp
\fB$isoplot\fR plot filled-circle \fIxc\fR \fIyc\fR \fIradius\fR \fIcolour\fR
.sp
\fB$table\fR row \fIitems\fR
.sp
\fB$table\fR separator
.sp
\fB$table\fR formatcommand \fIprocname\fR
.sp
\fB$table\fR cellconfigure \fIargs\fR
.sp
\fB$ternary\fR plot \fIseries\fR \fIxcrd\fR \fIycrd\fR \fIzcrd\fR \fItext\fR \fIdir\fR
.sp
\fB$ternary\fR line \fIseries\fR \fIcoords\fR
.sp
\fB$ternary\fR fill \fIseries\fR \fIcoords\fR
.sp
\fB$ternary\fR text \fIxtext\fR \fIytext\fR \fIztext\fR
.sp
\fB$ternary\fR ticklines \fIcolour\fR
.sp
\fB$timeline\fR plot \fIseries\fR \fIitem\fR \fIstart\fR \fIstop\fR \fIcolor\fR
.sp
\fB$timeline\fR vertline \fItext\fR \fItime\fR \fIargs\fR
.sp
\fB$dendrogram\fR plot \fIseries\fR \fIdata\fR
.sp
\fB::Plotchart::viewPort\fR \fIw\fR \fIpxmin\fR \fIpymin\fR \fIpxmax\fR \fIpymax\fR
.sp
\fB::Plotchart::worldCoordinates\fR \fIw\fR \fIxmin\fR \fIymin\fR \fIxmax\fR \fIymax\fR
.sp
\fB::Plotchart::world3DCoordinates\fR \fIw\fR \fIxmin\fR \fIymin\fR \fIzmin\fR \fIxmax\fR \fIymax\fR \fIzmax\fR
.sp
\fB::Plotchart::coordsToPixel\fR \fIw\fR \fIx\fR \fIy\fR
.sp
\fB::Plotchart::coords3DToPixel\fR \fIw\fR \fIx\fR \fIy\fR \fIz\fR
.sp
\fB::Plotchart::polarCoordinates\fR \fIw\fR \fIradmax\fR
.sp
\fB::Plotchart::polarToPixel\fR \fIw\fR \fIrad\fR \fIphi\fR
.sp
\fB::Plotchart::pixelToCoords\fR \fIw\fR \fIx\fR \fIy\fR
.sp
\fB::Plotchart::pixelToIndex\fR \fIw\fR \fIx\fR \fIy\fR
.sp
\fB::Plotchart::determineScale\fR \fIxmin\fR \fIxmax\fR \fIinverted\fR
.sp
\fB::Plotchart::determineScaleFromList\fR \fIvalues\fR \fIinverted\fR
.sp
\fB::Plotchart::plotconfig\fR \fIcharttype\fR \fIcomponent\fR \fIproperty\fR \fIvalue\fR
.sp
\fB::Plotchart::plotstyle\fR \fIsubcmd\fR \fIstyle\fR \fIargs\fR
.sp
\fB::Plotchart::eraseplot\fR \fIanyplot\fR
.sp
\fB::Plotchart::createTargetDiagram\fR \fIw\fR \fIlimits\fR \fIscale\fR
.sp
\fB$target\fR plot \fIseries\fR \fIxvalues\fR \fIyvalues\fR
.sp
\fB::Plotchart::createPerformanceProfile\fR \fIw\fR \fImax\fR
.sp
\fB$performance\fR plot \fIseries_and_data_pairs\fR
.sp
\fB::Plotchart::createTaylorDiagram\fR \fIw\fR \fIradius_data\fR \fIargs\fR
.sp
\fB$taylor\fR plot \fIseries\fR \fIstdev\fR \fIcorr\fR
.sp
\fB::Plotchart::createHeatmap\fR \fIw\fR \fIrowlabels\fR \fIcolumnlabels\fR \fIargs\fR
.sp
\fB$heatmap\fR plot row \fIlabel\fR \fIdata\fR
.sp
\fB$heatmap\fR plot column \fIlabel\fR \fIdata\fR
.sp
\fB$heatmap\fR plot cell \fIrowlabel\fR \fIcolumnlabel\fR \fIvalue\fR
.sp
\fB$heatmap\fR scale values \fImin\fR \fImax\fR
.sp
\fB$heatmap\fR scale colours \fImincolour\fR \fImaxcolour\fR
.sp
\fB::Plotchart::createCircleplot\fR \fIw\fR \fIlabels\fR \fIargs\fR
.sp
\fB$circleplot\fR connect \fIlabel1\fR \fIlabel2\fR \fIcolour\fR \fIwidth\fR
.sp
\fB$circleplot\fR modify \fIlabel\fR \fIargs\fR
.sp
\fB::Plotchart::plotmethod\fR \fIcharttype\fR \fImethodname\fR \fIplotproc\fR
.sp
\fB::Plotchart::plotpack\fR \fIw\fR \fIdir\fR \fIargs\fR
.sp
\fB$anyplot\fR bindplot \fIevent\fR \fIcommand\fR \fIargs\fR
.sp
\fB$anyplot\fR bindlast \fIseries\fR \fIevent\fR \fIcommand\fR
.sp
.BE
.SH DESCRIPTION
.PP
Plotchart is a Tcl-only package that focuses on the easy creation of
xy-plots, barcharts and other common types of graphical presentations\&.
The emphasis is on ease of use, rather than flexibility\&. The procedures
that create a plot use the entire canvas window, making the layout
of the plot completely automatic\&.
.PP
This results in the creation of an xy-plot in, say, ten lines of code:
.PP
.CS


    package require Plotchart

    canvas \&.c -background white -width 400 -height 200
    pack   \&.c -fill both

    #
    # Create the plot with its x- and y-axes
    #
    set s [::Plotchart::createXYPlot \&.c {0\&.0 100\&.0 10\&.0} {0\&.0 100\&.0 20\&.0}]

    foreach {x y} {0\&.0 32\&.0 10\&.0 50\&.0 25\&.0 60\&.0 78\&.0 11\&.0 } {
        $s plot series1 $x $y
    }

    $s title "Data series"

.CE
.PP
A drawback of the package might be that it does not do any data
management\&. So if the canvas that holds the plot is to be resized, the
whole plot must be redrawn\&.
The advantage, though, is that it offers a number of plot and chart
types:
.IP \(bu
XY-plots like the one shown above with any number of data series\&.
.IP \(bu
Stripcharts, a kind of XY-plots where the horizontal axis is adjusted
automatically\&. The result is a kind of sliding window on the data
series\&.
.IP \(bu
Polar plots, where the coordinates are polar instead of cartesian\&.
.IP \(bu
Histograms, for plotting statistical information\&.
.IP \(bu
Barcharts, piecharts, Gantt charts, time charts\&.
.IP \(bu
Isometric plots, where the scale of the coordinates in the two
directions is always the same, i\&.e\&. a circle in world coordinates
appears as a circle on the screen\&.
.sp
You can zoom in and out, as well as pan with these plots (\fINote:\fR
this works best if no axes are drawn, the zooming and panning routines
do not distinguish the axes), using the mouse buttons with the control
key and the arrow keys with the control key\&.
.IP \(bu
Piecharts, with automatic scaling to indicate the proportions\&.
.IP \(bu
Barcharts, with either vertical or horizontal bars, stacked bars or
bars side by side\&.
.IP \(bu
Timecharts, where bars indicate a time period and milestones or other
important moments in time are represented by triangles\&.
.IP \(bu
3D plots (both for displaying surfaces and 3D bars)
.PP
With version 1\&.5 a new command has been introduced: plotconfig, which
can be used to configure the plot options for particular types of plots
and charts (cf\&. \fBCONFIGURATION OPTIONS AND OTHER COMMANDS\fR)
With version 1\&.8\&.3 several new features were introduced, which allow more interactivity
(cf\&. \fBINTERACTIVE USE\fR)
With version 2\&.0 it has become possible to put several plots or charts in one canvas\&.
.SH "PLOT CREATION COMMANDS"
You create the plot or chart with one single command and then fill the
plot with data:
.TP
\fB::Plotchart::createXYPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
Create a new xy-plot (configuration type: xyplot)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order\&.
For an inverted axis, where the maximum appears on the left-hand side,
use: maximum, minimum and a \fInegative\fR stepsize\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
For an inverted axis, where the maximum appears at the bottom,
use: maximum, minimum and a \fInegative\fR stepsize\&.
.TP
list \fIargs\fR (in)
Zero or more options that influence the appearance of the plot:
.RS
.IP \(bu
\fI-xlabels {labels}:\fR Custom labels for the x-axis\&. If the labels
are numeric, they are positioned according to the given scale,
otherwise they are positioned with equal distance, based on the number
of labels\&. Note: this only works if the stepsize of the xaxis argument is
the empty string\&.
.IP \(bu
\fI-ylabels {labels}:\fR Similarly, custom labels for the y-axis\&.
.IP \(bu
\fI-box {measures}:\fR See \fBARRANGING MULTIPLE PLOTS IN A CANVAS\fR
.IP \(bu
\fI-axesbox {measures}:\fR See \fBARRANGING MULTIPLE PLOTS IN A CANVAS\fR
.IP \(bu
\fI-timeformat format:\fR See \fBUSING DATE/TIME LABELS\fR
.IP \(bu
\fI-gmt 0/1:\fR See \fBUSING DATE/TIME LABELS\fR
.IP \(bu
\fI-axestozero:\fR Draw the axes at the origin (1), or at the sides of the plot area (0, default)\&.
This option is implemented for XY plots only\&.
.IP \(bu
\fI-isometric:\fR Rescale the axes, so that a square in the coordinates appears as a square on the
screen (1), or use the given extremes (0, default)\&. This option is implemented for XY plots only\&.
.RE
.RE
.sp
.TP
\fB::Plotchart::createStripchart\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
Create a new strip chart (configuration type: stripchart)\&. The
only difference to a regular XY plot is
that the x-axis will be automatically adjusted when the x-coordinate
of a new point exceeds the maximum\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order\&.
Note that an inverted x-axis is \fInot\fR supported for this type of plot\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
For an inverted axis, where the maximum appears at the bottom,
use: maximum, minimum and a \fInegative\fR stepsize\&.
.TP
list \fIargs\fR (in)
Zero or more options - see the XY-plot for more information\&.
.RE
.sp
.TP
\fB::Plotchart::createTXPlot\fR \fIw\fR \fItimeaxis\fR \fIxaxis\fR \fIargs\fR
Create a new time-x-plot (configuration type: txplot)\&. The horizontal axis represents the date/time
of the data and the vertical axis the values themselves\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fItimeaxis\fR (in)
A 3-element list containing the minimum and maximum date/time to be
shown and the stepsize (\fIin days\fR) for the time-axis, in this order\&.
Note that an inverted time-axis is \fInot\fR supported\&.
.TP
list \fIxaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the
vertical axis, in this order\&.
For an inverted axis, where the maximum appears at the bottom,
use: maximum, minimum and a \fInegative\fR stepsize\&.
.TP
list \fIargs\fR (in)
Zero or more options - see the XY-plot for more information\&.
.RE
.sp
.TP
\fB::Plotchart::createXLogYPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
Create a new xy-plot where the y-axis has a logarithmic scale (configuration type: xlogyplot)\&.
.sp
The data should be given as for a linear scale, as the logarithmic transformation
is taken of internally\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order\&.
For an inverted axis, where the maximum appears on the left-hand side,
use: maximum, minimum and a \fInegative\fR stepsize\&.
.TP
list \fIyaxis\fR (in)
A 2-element list containing minimum and maximum for the y-axis, in this order\&.
Note that an inverted logarithmic axis is \fInot\fR supported\&.
.TP
list \fIargs\fR (in)
Zero or more options - see the XY-plot for more information\&.
.RE
.sp
.TP
\fB::Plotchart::createLogXYPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
Create a new xy-plot where the x-axis has a logarithmic scale (configuration type: logxyplot)\&.
.sp
The data should be given as for a linear scale, as the logarithmic transformation
is taken of internally\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 2-element list containing minimum and maximum for the x-axis, in this order\&.
Note that an inverted logarithmic axis is \fInot\fR supported\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
For an inverted axis, where the maximum appears on the left-hand side,
use: maximum, minimum and a \fInegative\fR stepsize\&.
.TP
list \fIargs\fR (in)
Zero or more options - see the XY-plot for more information\&.
.RE
.sp
.TP
\fB::Plotchart::createLogXLogYPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
Create a new xy-plot where both the x-axis and the y-axis have a logarithmic scale
(configuration type: logxlogyplot)\&.
.sp
The data should be given as for a linear scale, as the logarithmic transformation
is taken of internally\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 2-element list containing minimum and maximum for the x-axis, in this order\&.
Note that an inverted logarithmic axis is \fInot\fR supported\&.
.TP
list \fIyaxis\fR (in)
A 2-element list containing minimum and maximum for the y-axis, in this order\&.
Note that an inverted logarithmic axis is \fInot\fR supported\&.
.TP
list \fIargs\fR (in)
Zero or more options - see the XY-plot for more information\&.
.RE
.sp
.TP
\fB::Plotchart::createPolarPlot\fR \fIw\fR \fIradius_data\fR \fIargs\fR
Create a new polar plot (configuration type: polarplot)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIradius_data\fR (in)
A 2-element list containing maximum radius and stepsize for the radial
axis, in this order\&.
.TP
list \fIargs\fR (in)
Zero or more options - see the XY-plot for more information\&.
.RE
.sp
.TP
\fB::Plotchart::createWindrose\fR \fIw\fR \fIradius_data\fR \fIsectors\fR
Create a new windrose diagram\&. The diagram will consist of concentric
circles as defined by the \fIradius_data\fR argument and a number of
sectors (given by the \fIsectors\fR argument)\&. The sectors are drawn in
the "nautical" convention, that is: the first is located at the positive
y-axis, the second is to the right and so on in a clockwise direction\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the diagram
.TP
list \fIradius_data\fR (in)
A 2-element list, the first element is the maximum radius, the second is
the step to be used for the circles\&.
.TP
int \fIsectors\fR
Number of sectors to use (defaults to 16)\&.
.RE
.sp
.TP
\fB::Plotchart::createIsometricPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIstepsize\fR
Create a new isometric plot, where the vertical and the horizontal
coordinates are scaled so that a circle will truly appear as a circle (configuration type: isometric)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 2-element list containing minimum, and maximum for the x-axis, in this order\&.
.TP
list \fIyaxis\fR (in)
A 2-element list containing minimum, and maximum for the y-axis, in this order\&.
.TP
float|\fBnoaxes\fR \fIstepsize\fR (in)
Either the stepsize used by both axes or the keyword \fBnoaxes\fR to
signal the plot that it should use the full area of the widget, to not
draw any of the axes\&.
.RE
.sp
.TP
\fB::Plotchart::createHistogram\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIargs\fR
Create a new histogram (configuration type: histogram)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
.TP
list \fIargs\fR (in)
Zero or more options - see the XY-plot for more information\&.
.RE
.sp
.TP
\fB::Plotchart::create3DPlot\fR \fIw\fR \fIxaxis\fR \fIyaxis\fR \fIzaxis\fR \fIargs\fR
Create a new 3D plot\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
.TP
list \fIzaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the z-axis, in this order\&.
.TP
list \fIargs\fR (in)
Optional list of options (keyword-value pairs)\&. Currently supported: -xlabels to set the
labels for the x-axis\&.
.RE
.sp
.TP
\fB::Plotchart::create3DRibbonPlot\fR \fIw\fR \fIyaxis\fR \fIzaxis\fR
Create a new 3D ribbon plot\&. It is a simplification of the full 3D plot and allows for
the drawing of a ribbon only (the x-axis is dropped)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
.TP
list \fIzaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the z-axis, in this order\&.
.RE
.sp
.TP
\fB::Plotchart::createPiechart\fR \fIw\fR
Create a new piechart (configuration type: piechart)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.RE
.sp
.TP
\fB::Plotchart::createSpiralPie\fR \fIw\fR
Create a new "spiral pie" (configuration type: spiralpie), a variation on the ordinary
piechart\&. The value is used to scale the radius, rather than the angle\&. By default the
data are sorted\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.RE
.sp
.TP
\fB::Plotchart::createRadialchart\fR \fIw\fR \fInames\fR \fIscale\fR \fIstyle\fR
Create a new radial chart (the data are drawn as a line connecting the
spokes of the diagram) (configuration type: radialchart)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fInames\fR (in)
Names for the spokes\&.
.TP
float \fIscale\fR (in)
Scale value to determine the position of the data along the spokes\&.
.TP
string \fIstyle\fR (in)
Style of the chart (optional)\&. One of:
.RS
.IP \(bu
\fIlines\fR - the default: draw the data as independent polylines\&.
.IP \(bu
\fIcumulative\fR - draw the data as polylines where the data are
accumulated\&.
.IP \(bu
\fIfilled\fR - draw the data as filled polygons where the data are
accumulated
.RE
.RE
.sp
.TP
\fB::Plotchart::createBarchart\fR \fIw\fR \fIxlabels\fR \fIyaxis\fR \fInoseries\fR \fIargs\fR
Create a new barchart with vertical bars (configuration type: vertbars)\&. The horizontal axis will
display the labels contained in the argument \fIxlabels\fR\&. The number
of series given by \fInoseries\fR determines both the width of the
bars, and the way the series will be drawn\&.
.sp
If the keyword \fBstacked\fR was specified the series will be drawn
stacked on top of each other\&. Otherwise each series that is drawn will
be drawn shifted to the right\&.
.sp
The number of series determines the width of the bars, so that there is
space of that number of bars\&. If you use a floating-point number, like
2\&.2, instead of an integer, like 2, a small gap between the sets of bars
will be drawn - the width depends on the fractional part\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxlabels\fR (in)
List of labels for the x-axis\&. Its length also determines the number of
bars that will be plotted per series\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
.TP
int|\fBstacked\fR \fInoseries\fR (in)
The number of data series that will be plotted\&. This has to be an
integer number greater than zero (if \fBstacked\fR is not used)\&.
.TP
string \fIargs\fR (in)
One or more key-value pairs defining the options\&. Specific to barcharts: \fB-xlabelangle\fR value,
the angle under which the labels should be drawn\&. This defaults to 0 - horizontal text\&. This option
is especially useful if you have fairly long labels\&.
.RE
.sp
.TP
\fB::Plotchart::createHorizontalBarchart\fR \fIw\fR \fIxaxis\fR \fIylabel\fR \fInoseries\fR
Create a new barchart with horizontal bars (configuration type: horizbars)\&. The vertical axis will
display the labels contained in the argument \fIylabels\fR\&. The number
of series given by \fInoseries\fR determines both the width of the
bars, and the way the series will be drawn\&.
.sp
If the keyword \fBstacked\fR was specified the series will be drawn
stacked from left to right\&. Otherwise each series that is drawn will
be drawn shifted upward\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order\&.
.TP
list \fIylabels\fR (in)
List of labels for the y-axis\&. Its length also determines the number of
bars that will be plotted per series\&.
.TP
int|\fBstacked\fR \fInoseries\fR (in)
The number of data series that will be plotted\&. This has to be an
integer number greater than zero (if \fBstacked\fR is not used)\&.
.RE
.sp
.TP
\fB::Plotchart::create3DBarchart\fR \fIw\fR \fIyaxis\fR \fInobars\fR
Create a new barchart with 3D vertical bars (configuration type: 3dbars)\&. The horizontal axis will
display the labels per bar\&. The number of bars given by \fInobars\fR
determines the position and the width of the bars\&. The colours can be
varied per bar\&. (This type of chart was inspired by the Wiki page on 3D
bars by Richard Suchenwirth\&.)
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
.TP
int \fInobars\fR (in)
The number of bars that will be plotted\&.
.RE
.sp
.TP
\fB::Plotchart::create3DRibbonChart\fR \fIw\fR \fInames\fR \fIyaxis\fR \fIzaxis\fR
Create a new "ribbon chart" (configuration type: 3dribbon)\&. This is
a chart where the data series are
represented as ribbons in a three-dimensional axis system\&. Along the
x-axis (which is "into" the screen) the names are plotted, each
representing a single series\&. The first plot command draws the furthest
series, the second draws the series in front of that and so on\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
widget \fIw\fR (in)
Names of the series, plotted as labels along the x-axis
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis
(drawn horizontally!), in this order\&.
.TP
list \fIzaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the z-axis
(drawn vertically), in this order\&.
.TP
int \fInobars\fR (in)
The number of bars that will be plotted\&.
.RE
.sp
.TP
\fB::Plotchart::createBoxplot\fR \fIw\fR \fIxdata\fR \fIydata\fR \fIorientation\fR
Create a new boxplot with horizontal or vertical boxes (box-and-whiskers) (configuration type: boxplot)\&. Depending
on the orientation the x- or y-axis is drawn with labels\&. The boxes are drawn based on the raw data
(see the plot subcommand for this type of plot)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIxdata\fR (in)
This is either a 3-element list containing minimum, maximum and stepsize for the x-axis, in this order
(when orientation is horizontal), or a list of labels for the x-axis (when orientation is vertical)\&. The length
of the label list also determines the number of boxes that can be plotted\&. The labels are also used in the plot
subcommand\&.
.TP
list \fIydata\fR (in)
This is either a 3-element list containing minimum, maximum and stepsize for the y-axis, in this order
(when orientation is vertical), or a list of labels for the y-axis (when orientation is horizontal)\&. The length
of the label list also determines the number of boxes that can be plotted\&. The labels are also used in the plot
subcommand\&.
.TP
string \fIorientation\fR (in)
If given, "horizontal" or "vertical" determines the orientation of the boxes\&. This optional value (default: horizontal)
also determines the interpretation of the xdata and ydata arguments\&.
.RE
.sp
.TP
\fB::Plotchart::createTimechart\fR \fIw\fR \fItime_begin\fR \fItime_end\fR \fIargs\fR
Create a new timechart (configuration type: timechart)\&.
The time axis (= x-axis) goes from \fItime_begin\fR to \fItime_end\fR,
and the vertical spacing is determined by the number of items to plot\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
string \fItime_begin\fR (in)
The start time given in a form that is recognised by the \fBclock scan\fR
command (e\&.g\&. "1 january 2004")\&.
.TP
string \fItime_end\fR (in)
The end time given in a form that is recognised by the \fBclock scan\fR
command (e\&.g\&. "1 january 2004")\&.
.TP
arguments \fIargs\fR (in)
The remaining arguments can be:
.RS
.IP \(bu
The expected/maximum number of items\&. This determines the vertical
spacing\&. (If given, it must be the first argument after "time_end"
.IP \(bu
The keyword -barheight and the number of pixels per bar\&. This is an
alternative method to determine the vertical spacing\&.
.IP \(bu
The keyword -ylabelwidth and the number of pixels to reserve for the
labels at the y-axis\&.
.RE
.RE
.TP
\fB::Plotchart::createGanttchart\fR \fIw\fR \fItime_begin\fR \fItime_end\fR \fIargs\fR
Create a new Gantt chart (configuration type: ganttchart)\&.
The time axis (= x-axis) goes from \fItime_begin\fR to \fItime_end\fR,
and the vertical spacing is determined by the number of items to plot\&.
Via the specific commands you can then add tasks and connections between
the tasks\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
string \fItime_begin\fR (in)
The start time given in a form that is recognised by the \fBclock scan\fR
command (e\&.g\&. "1 january 2004")\&.
.TP
string \fItime_end\fR (in)
The end time given in a form that is recognised by the \fBclock scan\fR
command (e\&.g\&. "1 january 2004")\&.
.TP
arguments \fIargs\fR (in)
The remaining arguments can be:
.RS
.IP \(bu
The expected/maximum number of items\&. This determines the vertical
spacing\&. (If given this way, it must be the first argument after "time_end")
.IP \(bu
The expected/maximum width of the descriptive text (roughly in characters,
for the actual space reserved for the text, it is assumed that a
character is about ten pixels wide)\&. Defaults to 20\&. (If given this way,
it must be the second argument after "time_end")\&.
.IP \(bu
The keyword -barheight and the number of pixels per bar\&. This is an
alternative method to determine the vertical spacing\&.
.IP \(bu
The keyword -ylabelwidth and the number of pixels to reserve for the
labels at the y-axis\&.
.RE
.RE
.TP
\fB::Plotchart::createRightAxis\fR \fIw_or_plot\fR \fIyaxis\fR
Create a plot command that will use a right axis instead of the left
axis (configuration type: inherited from the existing plot)\&. The canvas widget
must already contain an ordinary plot, as the
horizontal axis and other properties are reused\&. Preferably use the
plot command, as with multiple plots in a canvas (also when redefining an existing
plot!), the wrong geometry might be used\&.
.sp
To plot data using the
right axis, use this new command, to plot data using the \fIleft\fR
axis, use the original plot command\&.
.RS
.TP
widget \fIw_or_plot\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot or preferably the
plot command for the plot with the left axis\&.
.TP
list \fIyaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order\&.
.RE
.TP
\fB::Plotchart::createTableChart\fR \fIw\fR \fIcolumns\fR ?widths?
Create a command to draw a table\&. You can use a variety of commands to
draw the actual rows of the table, but the number of columns is fixed\&.
(See \fBTABLE CHARTS\fR for an example)
.RS
.TP
widget \fIw\fR (in)
Name of the canvas widget to hold the table\&.
.TP
list \fIcolumns\fR (in)
The headers of the columns in the table\&. The number of elements
determines the number of columns\&.
.TP
list \fIwidths\fR (in)
If given, either a single value, the width in pixels for all columns or
for each column the width of that column\&. If not given, the table is
spread out over the width of the canvas (minus the margins)\&.
.RE
.sp
.TP
\fB::Plotchart::createTernaryDiagram\fR \fIw\fR \fIargs\fR
Create a command to draw a ternary diagram (configuration type: ternary)\&. You can draw
individual (labelled) data points in the diagram, lines and filled polygons\&.
.RS
.TP
widget \fIw\fR (in)
Name of the canvas widget to hold the ternary diagram\&.
.TP
list \fIargs\fR (in)
Zero or more option-value pairs to influence the position and the appearance of the
diagram\&. In addition to the positioning options (-box and -axesbox) the diagram supports:
\fI-fractions yes/no\fR, to display numbers 0 to 1 instead of 0 to 100% and \fI-steps number\fR
to influence the number of labels along the three sides\&.
.RE
.sp
.TP
\fB::Plotchart::createNormalPlot\fR \fIw\fR \fIxscale\fR \fIargs\fR
Create a command to draw a normal plot - useful to investigate whether a data set is normally
distributed or not\&. In that case the data will fall on or near the diagonal\&. As such, it is a
specialised plotting procedure\&.
.sp
The details of the plotting procedure have been adopted from the \fIqqnorm\fR in the "R" \fIstats\fR
package and described on Wikipedia\&.
.sp
As the implementation of this plot type relies on the \fImath::statistics\fR package, it is only
available if that package can be loaded\&.
.RS
.TP
widget \fIw\fR (in)
Name of the canvas widget to hold the normal plot\&.
.TP
list \fIxscale\fR (in)
A 3-element list containing minimum, maximum and stepsize for the x-axis
in this order\&. The scaling of the y-axis is determined from that\&. \fIImportant:\fR the scale
is to be given in terms of the normalised data, that is: 0 represents the mean of the data,
1 one standard deviation away from the mean etc\&.
.TP
list \fIargs\fR (in)
Zero or more option-value pairs to influence the position and the appearance of the
plot - see the XY-plot for more details\&.
.RE
.sp
.TP
\fB::Plotchart::createStatusTimeline\fR \fIw\fR \fIxaxis\fR \fIylabel\fR \fIargs\fR
Create a command to draw a so-called status timeline\&. Its layout is similar to a horizontal
barchart, but the bars are drawn in different colours, each representing the status of
the item as it varies over time (the horizontal axis)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the canvas widget to hold the ternary diagram\&.
.TP
list \fIxaxis\fR (in)
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order\&.
.TP
list \fIylabels\fR (in)
List of labels for the y-axis\&. Its length also determines the number of
bars that will be plotted per series\&.
.TP
list \fIargs\fR (in)
Zero or more option-value pairs to influence the position and the appearance of the
diagram\&. In addition to the positioning options (-box and -axesbox) the diagram supports:
\fI-xaxis yes/no\fR, to turn displaying the numeric labels on or off\&.
.RE
.TP
\fB::Plotchart::createDendrogram\fR \fIw\fR \fIargs\fR
Create a dendrogram to plot hierarchically organised data\&. The labels that identify
the endpoints of the hierarchy can all be drawn on the same level or where their
branch ends\&. This is controlled by the option "-extend"\&.
.sp
The data are organised as nested lists, like:
.CS


     \\$dendrogram plot data { {"Label1"  "Label2"} {F {A B} {C {D E}}} }

.CE
.IP
Sublists with more than one element are considered a branching and are drawn in that way\&.
Sublists with only one element are considered a leaf and are drawn as text\&.
Because a string with two or more words can not be distinguished from a list with two
or more elements, a provision is made for this situation: if the first element is "LEAF",
then the list is considered to consist of leafs only and all elements (even if they
are actually nested lists themselves are drawn as text:
.CS


     \\$dendrogram plot data { {LEAF "Label 1"  "Label 2"} {F {A B} {C {D E}}} }

.CE
.RS
.TP
widget \fIw\fR (in)
Name of the canvas widget to hold the dendrogram\&.
.TP
list \fIargs\fR (in)
Zero or more option-value pairs:
.RS
.IP \(bu
The option "-direction" takes one of the following values: left-right, right-left,
top-bottom, bottom-top, with "top-bottom" as the default\&. The tree will be drawn
according to this option, the labels appear either horizontally or vertically at
the end of the tree\&.
.IP \(bu
The option "-extend" with value 1 (default) or 0 (no extension) to indicate that
the labels should all appear at the same level\&.
.RE
.RE
.sp
.PP
.SH "PLOT METHODS"
Each of the creation commands explained in the last section returns
the name of a new object command that can be used to manipulate the
plot or chart\&. The subcommands available to a chart command depend on
the type of the chart\&.
.PP
General subcommands for all types of charts\&. \\$anyplot is the command
returned by the creation command:
.TP
\fB$anyplot\fR title \fItext\fR \fIposition\fR
Specify the title of the whole chart\&.
.RS
.TP
string \fItext\fR (in)
The text of the title to be drawn\&.
.TP
string \fIposition\fR (in)
The position of the title\&. The default position is "center", but you can
alternatively use "left" or "right"\&. You can use multiple titles with
different positions\&.
.RE
.sp
.TP
\fB$anyplot\fR subtitle \fItext\fR
Specify the subtitle of the whole chart\&.
.RS
.TP
string \fItext\fR (in)
The text of the subtitle to be drawn\&.
.RE
.sp
.TP
\fB$anyplot\fR canvas
Return the name of the canvas (or the alias if you use more than one plot within a
canvas)\&. Use this value for the coordinate transformations\&.
.sp
.TP
\fB$anyplot\fR saveplot \fIfilename\fR \fIargs\fR
Draws the plot into a file, using PostScript\&.
.RS
.TP
string \fIfilename\fR (in)
Contain the path name of the file to write the plot to\&.
.TP
list \fIargs\fR (in)
If the standard PostScript output is used, the option -plotregion can be specifed
to save the whole plot (value: bbox) regardless of what is visible in the window\&.
The default (value: window) is to only plot the visible part of the plot\&.
.sp
Optionally you can specify the option -format "some picture format" to
store the plot in a different file than a PostScript file\&. This,
however, relies on the Img package to do the actual job\&.
.sp
\fINote:\fR
Because the window holding the plot must be fully visible before Img can
successfully grab it, it is raised first\&.
On some systems, for instance Linux with KDE, raising
a window is not done automatically, but instead you need to click on the
window in the task bar\&. Similar things happen on Windows XP\&.
.sp
There seems to be something wrong under some circumstances, so instead
of waiting for the visibility of the window, the procedure simply waits
two seconds\&. It is not ideal, but it seems to work better\&.
.RE
.sp
.TP
\fB$anyplot\fR xtext \fItext\fR
Specify the title of the (horizontal) x-axis, for those plots that have
a straight x-axis\&.
.RS
.TP
string \fItext\fR (in)
The text of the x-axis label to be drawn\&.
.RE
.sp
.TP
\fB$anyplot\fR ytext \fItext\fR
Specify the title of the (horizontal) y-axis, for those plots that have
a straight y-axis\&.
.RS
.TP
string \fItext\fR (in)
The text of the y-axis label to be drawn\&.
.RE
.TP
\fB$anyplot\fR vtext \fItext\fR
Draw a \fIvertical\fR label to the y-axis\&. Note: this requires Tk 8\&.6
or later, for older versions it does nothing\&.
.RS
.TP
string \fItext\fR (in)
Text to drawn to the y-axis
.RE
.sp
.TP
\fB$anyplot\fR xsubtext \fItext\fR
Specify the subtext of the (horizontal) x-axis, for those plots that have
a straight x-axis\&. This text is drawn below the primary text\&.
.sp
Since this involves positioning the primary text and setting margins, you need to
set the option "usesubtext" for the bottom axis via the plotstyle command\&. The relevant
options are: usesubtext, subtextcolor and subtextfont\&.
.RS
.TP
string \fItext\fR (in)
The secondary text of the x-axis label to be drawn\&.
.RE
.sp
.TP
\fB$anyplot\fR ysubtext \fItext\fR
Specify the subtext of the (vertical) y-axis, for those plots that have
a straight y-axis\&. This text is drawn below the primary text, for both
axes on the left and the right\&.
.sp
Since this involves positioning the primary text and setting margins, you need to
set the option "usesubtext" for the left or right axis via the plotstyle command\&. The relevant
options are: usesubtext, subtextcolor and subtextfont\&.
.RS
.TP
string \fItext\fR (in)
The secondary text of the y-axis label to be drawn\&.
.RE
.sp
.TP
\fB$anyplot\fR vsubtext \fItext\fR
Specify the subtext of the (vertical) y-axis, for those plots that have
a straight y-axis\&. This text is drawn to the \fIright\fR of the primary text, for both
axes on the left and the right\&.
.sp
Since this involves positioning the primary text and setting margins, you need to
set the option "usesubtext" for the left or right axis via the plotstyle command\&. The relevant
options are: usevsubtext, vsubtextcolor and vsubtextfont\&. (Note the "v" to distinguish this
option from the text at the top of a vertical axis that is drawn via \fI$anyplot ytext\fR or
\fI$anyplot ysubtext\fR\&.)
.RS
.TP
string \fItext\fR (in)
The secondary (vertical) text of the y-axis label to be drawn\&.
.RE
.sp
.TP
\fB$anyplot\fR xconfig \fB-option\fR \fIvalue\fR \&.\&.\&.
Set one or more configuration parameters for the x-axis\&.
The following options are supported:
.RS
.TP
\fBformat\fR fmt
The format for the numbers along the axis\&.
.TP
\fBticklength\fR length
The length of the tickmarks (in pixels)\&.
.TP
\fBticklines\fR boolean
Whether to draw ticklines (\fBtrue\fR) or not (\fBfalse\fR)\&.
.TP
\fBscale\fR scale_data
New scale data for the axis, i\&.e\&. a 3-element list containing minimum,
maximum and stepsize for the axis, in this order\&.
.sp
\fIBeware:\fR Setting this option will clear all data from the plot\&.
.RE
.sp
.TP
\fB$anyplot\fR yconfig \fB-option\fR \fIvalue\fR \&.\&.\&.
Set one or more configuration parameters for the y-axis\&. This method
accepts the same options and values as the method \fBxconfig\fR\&.
.TP
\fB$anyplot\fR background \fIpart\fR \fIcolour_or_image\fR \fIdir\fR ?brightness?
Set the background of a part of the plot
.RS
.TP
string \fIpart\fR
Which part of the plot: "axes" for the axes area and "plot" for the
inner part\&. The interpretation depends on the type of plot\&. Two further
possibilities are:
.RS
.IP \(bu
\fIimage\fR, in which case a predefined image is loaded
into the background of the plot\&.
.IP \(bu
\fIgradient\fR, in which case the background is coloured in different
shades of the given colour\&. The "dir" argument specifies the direction
in which the colour gets whiter\&.
.RE
.TP
string \fIcolour_or_image\fR
Colour for that part or the name of the image if "part" is "image"
.TP
string \fIdir\fR
The direction of the gradient\&. One of: top-down, bottom-up, left-right
or right-left\&.
.TP
string \fIbrightness\fR
Indicates whether the colour should become brighter (bright) or darker (dark)\&. Defaults to bright
.RE
.sp
.TP
\fB$anyplot\fR xticklines \fIcolour\fR ?dash?
Draw vertical ticklines at each tick location
.RS
.TP
string \fIcolour\fR
Colour of the lines\&. Specifying an empty colour ("") removes them again\&.
Defaults to "black"
.TP
string \fIdash\fR
Optional argument to specify the dash pattern for the lines\&. Defaults to "lines"
Possible values: lines, dots1, dots2, dots3, dots4, dots5\&.
The actual effect depends on the platform\&.
.RE
.sp
.TP
\fB$anyplot\fR yticklines \fIcolour\fR ?dash?
Draw horizontal ticklines at each tick location
.RS
.TP
string \fIcolour\fR
Colour of the lines\&. Specifying an empty colour ("") removes them again
Defaults to "black"
.TP
string \fIdash\fR
Optional argument to specify the dash pattern for the lines\&. Defaults to "lines"
Possible values: lines, dots1, dots2, dots3, dots4, dots5\&.
The actual effect depends on the platform\&.
.RE
.sp
.TP
\fB$anyplot\fR legend \fIseries\fR \fItext\fR ?spacing?
Add an entry to the legend\&. The series determines which graphical
symbol is to be used\&. (As a side effect the legend is actually drawn\&.)
.RS
.TP
string \fIseries\fR
Name of the data series\&. This determines the colour of the line and the
symbol (if any) that will be drawn\&.
.TP
string \fItext\fR
Text to be drawn next to the line/symbol\&.
.TP
integer \fIspacing\fR
Optional argument to specify the vertical spacing between the entries (in pixels)\&.
(Note that this spacing will be reused later\&.)
.RE
.sp
.TP
\fB$anyplot\fR removefromlegend \fIseries\fR
Remove an entry for a series from the legend and redraw it\&.
.RS
.TP
string \fIseries\fR
Name of the data series to be removed\&.
.RE
.sp
.TP
\fB$anyplot\fR legendconfig \fB-option\fR \fIvalue\fR \&.\&.\&.
Set one or more options for the legend\&. The legend is drawn as a
rectangle with text and graphics inside\&.
.RS
.TP
\fBbackground\fR colour
Set the colour of the background (the default colour is white)\&.
Set to the empty string for a transparant legend\&.
.TP
\fBborder\fR colour
Set the colour of the border (the default colour is black)\&. Set to the
empty string if you do not want a border\&.
.TP
\fBcanvas\fR c
Draw the legend in a different canvas widget\&. This gives you the freedom
to position the legend outside the actual plot\&.
.TP
\fBfont\fR font
Set the font used to draw the text next to the symbol\&.
.TP
\fBlegendtype\fR type
Override the type of the legend, that is pre-defined for the current type of
plot\&. May be one of: rectangle or line\&.
.TP
\fBposition\fR corner
Set the position of the legend\&. May be one of: top-left, top-right,
bottom-left or bottom-right\&. (Default value is top-right\&.)
.TP
\fBspacing\fR pixels
Set the vertical spacing between entries in the legend (in pixels)\&.
bottom-left or bottom-right\&. (Default value is 10 pixels\&.)
.TP
\fBorder\fR string
Determine the ordering of the legend entries - "normal" means the order
in which the entries are defined, "reverse" exactly the opposite\&. (Default: normal)
.RE
.sp
.TP
\fB$anyplot\fR balloon \fIx\fR \fIy\fR \fItext\fR \fIdir\fR
Add balloon text to the plot (except for 3D plots)\&. The arrow will point
to the given x- and y-coordinates\&. For xy-graphs and such, the
coordinates are directly related to the axes; for vertical barcharts the
x-coordinate is measured as the number of bars minus 1 and similar for
horizontal barcharts\&.
.RS
.TP
float \fIx\fR
X-coordinate of the point that the arrow of the balloon will point to\&.
.TP
float \fIy\fR
Y-coordinate of the point that the arrow of the balloon will point to\&.
.TP
string \fItext\fR
Text to be drawn in the balloon\&.
.TP
string \fIdir\fR
Direction of the arrow, one of: north, north-east, east, south-east,
south, south-west, west or north-west\&.
.RE
.sp
.TP
\fB$anyplot\fR balloonconfig \fIargs\fR
Configure the balloon text for the plot\&. The new settings will be used
for the next balloon text\&.
.RS
.TP
\fBfont\fR fontname
Font to be used for the text
.TP
\fBjustify\fR left|center|right
Way to justify multiline text
.TP
\fBtextcolour\fR colour
Colour for the text (synonym: textcolor)
.TP
\fBbackground\fR colour
Background colour for the balloon
.TP
\fBoutline\fR colour
Colour of the outline of the balloon
.TP
\fBmargin\fR value
Margin around the text (in pixels)
.TP
\fBrimwidth\fR value
Width of the outline of the balloon (in pixels)
.TP
\fBarrowsize\fR value
Length factor for the arrow (in pixels)
.RE
.TP
\fB$anyplot\fR plaintext \fIx\fR \fIy\fR \fItext\fR \fIdir\fR
Add plain text to the plot (except for 3D plots)\&. The text is positioned at
the given x- and y-coordinates\&. For xy-graphs and such, the
coordinates are directly related to the axes; for vertical barcharts the
x-coordinate is measured as the number of bars minus 1 and similar for
horizontal barcharts\&.
.RS
.TP
float \fIx\fR
X-coordinate of the text position
.TP
float \fIy\fR
Y-coordinate of the text position
.TP
string \fItext\fR
Text to be drawn\&.
.TP
string \fIdir\fR
Anchor for the text, one of: north, north-east, east, south-east,
south, south-west, west or north-west\&.
.RE
.sp
.TP
\fB$anyplot\fR plaintextconfig \fIargs\fR
Configure the plain text annotation for the plot\&. The new settings will be used
for the next plain text\&.
.RS
.TP
\fBfont\fR fontname
Font to be used for the text
.TP
\fBjustify\fR left|center|right
Way to justify multiline text
.TP
\fBtextcolour\fR colour
Colour for the text (synonym: textcolor)
.RE
.TP
\fB$anyplot\fR object \fIitemtype\fR \fIseries\fR \fIargs\fR
Draw a canvas item in the plot where the coordinates are scaled using the
coordinate system of the plot\&. In addition to the standard canvas types, it
also supports circles, dots and crosses\&.
.sp
\fINote:\fR Currently implemented for xy-plots, (vertical and horizontal)
barcharts, and piecharts\&.
.sp
\fINote:\fR To add an entry in the legend for the object, you can use the
\fIdataconfig\fR subcommand with a type "rectangle"\&. This will cause a rectangle
to be shown\&.
.RS
.TP
string \fIitemtype\fR (in)
Name of a standard canvas item or "circle", "dot" or "cross"
.TP
string \fIseries\fR (in)
The data series it belongs to, used for setting the default drawing options
.TP
list \fIargs\fR (in)
List of coordinates and drawing options
.RE
.TP
\fB$anyplot\fR deletedata
Remove the lines, symbols and other graphical object associated with the
actual data from the plot\&.
.sp
\fINote:\fR Currently implemented for xy-plots only
.sp
\fINote:\fR The existing options for data series and the legend entry are
kept as they were\&.
.sp
\fINote:\fR Currently there are side effects if the canvas contains more than
one plot\&.
.PP
.PP
\fINote:\fR The commands \fBxconfig\fR and \fByconfig\fR are
currently implemented only for XY-plots
and only the option \fB-format\fR has any effect\&.
.PP
For \fIxy plots\fR, \fIstripcharts\fR, \fIhistograms\fR and
\fItime-x-plots\fR:
.TP
\fB$xyplot\fR plot \fIseries\fR \fIxcrd\fR \fIycrd\fR
Add a data point to the plot\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the new point belongs to\&.
.TP
float \fIxcrd\fR (in)
X-coordinate of the new point\&. (For time-x plots this must be valid
date/time that can be read with the \fIclock scan\fR command)\&.
.TP
float \fIycrd\fR (in)
Y-coordinate of the new point\&.
.RE
.PP
.PP
For \fInormal plots\fR:
.TP
\fB$normalplot\fR plot \fIseries\fR \fImean\fR \fIstdev\fR \fIdata\fR
Plot the data set using the given mean and stanard deviation\&.
.sp
As you give the mean and standard deviation separately, the plot can be used for several data series
or for adding to an existing data series\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series - used to determine the appearance
.TP
float \fImean\fR (in)
Assumed mean of the data set\&.
.TP
float \fIstdev\fR (in)
Assumed standard deviation of the data set\&.
.TP
list \fIdata\fR (in)
List of the data comprising the data set
.RE
.TP
\fB$normalplot\fR diagonal
Draw a diagonal line, indicating the ideal normally distributed data set\&.
.PP
.PP
For \fIxy, x-log y, log-x-y, log-x-log-y plots\fR there is the additional command \fIplotlist\fR,
which is useful for plotting a large amount of data:
.TP
\fB$xyplot\fR plotlist \fIseries\fR \fIxlist\fR \fIylist\fR \fIevery\fR
Draw a series of data as a whole\&. If symbols are asked for, draw them only
for every Nth data point\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the new line belongs to\&.
.TP
float \fIxlist\fR (in)
List of X-coordinates for the data series\&.
.TP
float \fIycrd\fR (in)
List of Y-coordinates for the data series\&.
.TP
int \fIevery\fR (in)
Optional argument stating how often a symbol (if any) should be drawn\&.
If left out, use a simple heuristic: N = sqrt(number of data points)\&.
.RE
.PP
Other commands for \fIxy, x-log y, log-x-y, log-x-log-y plots\fR are \fIregion\fR and \fIminmax\fR to draw filled polygons:
.TP
\fB$xyplot\fR region \fIseries\fR \fIxlist\fR \fIylist\fR
Draw a filled polygon (region)\&. The configuration of the series influences the polygon as follows:
\fI-fillcolour\fR is used to fill the polygon, \fI-colour\fR is used for the boundary (set it to {} if
no boundary is required and \fI-width\fR determines the width of the boundary\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the new region belongs to\&.
.TP
float \fIxlist\fR (in)
List of X-coordinates for the region\&.
.TP
float \fIycrd\fR (in)
List of Y-coordinates for the region\&.
.RE
.TP
\fB$xyplot\fR minmax \fIseries\fR \fIxcrd\fR \fIymin\fR \fIymax\fR
Draw a filled strip representing a minimum and a maximum\&. The configuration of the series influences the polygon as follows:
\fI-fillcolour\fR is used to fill the polygon, \fI-colour\fR is used for the boundary (set it to {} if
no boundary is required and \fI-width\fR determines the width of the boundary\&.
.sp
The arguments \fIymin\fR and \fIymax\fR may be empty to get an extra vertex in the strip\&. If both
are empty, a new strip is started\&. For best results, the x-coordinate should be specified in ascending
order\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the new min/max strip belongs to\&.
.TP
float \fIxcrd\fR (in)
X-coordinate for the strip\&.
.TP
float \fIymin\fR (in)
The minimum y-coordinate for the strip\&.
.TP
float \fIymax\fR (in)
The maximum y-coordinate for the strip\&.
.RE
.PP
.PP
\fINote on histograms:\fR
.PP
For histograms the x-coordinate that is given is interpreted to be
the x-coordinate of the \fIright\fR side of the bar (or line segment)\&. The first
bar starts at the y-axis on the left\&. To completely fill the range
of the x-axis, you should draw a bar at the maximum x-coordinate\&.
.PP
For histograms you can also use the \fBplotcumulative\fR command:
.TP
\fB$histogram\fR plotcumulative \fIseries\fR \fIxcrd\fR \fIycrd\fR
.PP
The arguments mean exactly the same as for the \fBplot\fR command, but
the data are accumulated to the previous values\&.
.PP
For \fIxy plots\fR:
.TP
\fB$xyplot\fR trend \fIseries\fR \fIxcrd\fR \fIycrd\fR
Draw or update a trend line using the data given sofar\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the trend line belongs to\&.
.TP
float \fIxcrd\fR (in)
X-coordinate of the new data point
.TP
float \fIycrd\fR (in)
Y-coordinate of the new data point
.RE
.TP
\fB$xyplot\fR rchart \fIseries\fR \fIxcrd\fR \fIycrd\fR
Draw data in the same way as the plot method, but with two lines added
that indicate the expected range (+/- 3*standard deviation) of the data\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the data point belongs to\&.
.TP
float \fIxcrd\fR (in)
X-coordinate of the new data point
.TP
float \fIycrd\fR (in)
Y-coordinate of the new data point
.RE
.TP
\fB$xyplot\fR interval \fIseries\fR \fIxcrd\fR \fIymin\fR \fIymax\fR ?ycentr?
Add a vertical error interval to the plot\&. The interval is drawn from
ymin to ymax\&. If the ycentr argument is given, a symbol is drawn at that
position\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the interval belongs to\&.
.TP
float \fIxcrd\fR (in)
X-coordinate of the interval
.TP
float \fIymin\fR (in)
Minimum y-coordinate of the interval\&.
.TP
float \fIymax\fR (in)
Maximum y-coordinate of the interval\&.
.TP
float \fIycentr\fR (in)
Y-coordinate to draw the symbol at (optional)
.RE
.TP
\fB$xyplot\fR box-and-whiskers \fIseries\fR \fIxcrd\fR \fIycrd\fR
Draw a box and whiskers in the plot\&. If the argument \fIxcrd\fR is a
list of
several values and the argument \fIycrd\fR is a single value, a
horizontal
box is drawn with the quartiles determined from the list of values
contained in \fIxcrd\fR\&.
.sp
If, instead, the argument \fIycrd\fR contains a list of several values
and the argument \fIxcrd\fR a single value, then a vertical box is
drawn and the quartiles are determined from \fIycrd\fR\&. (There must be
exactly one list of several values\&. Otherwise an error is reported\&.)
.sp
The option -boxwidth to the dataconfig command determines the width (or
height) of the box (default: 10 pixels)\&.
.sp
The option -whiskers to the dataconfig command determines whether the
whiskers are drawn to the extreme values (value: extremes), to 1\&.5
times the interquartile range (value: IQR or iqr), or not at all (value: none)\&.
If the value is 'IQR' (uppercase), then
also extreme values will be shown (from 1\&.5 to 3 times the IQR as dots,
above 3 times IQR as stars)\&. If the value is 'iqr' (lowercase) no extreme
values will be shown (default value: IQR)\&.
.sp
The option -whiskerwidth to the dataconfig command determines the thickness of the line
that draws the whiskers (default: 1 pixel)\&.
.sp
The option -mediancolour to the dataconfig command determines the
colour of the line used to draw the median within the box (default: same as -colour)\&.
.sp
The option -medianwidth to the dataconfig command determines the thickness of the line
that draws the median within the box (default: 1 pixel)\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the box-and-whiskers belongs to\&.
.TP
float \fIxcrd\fR (in)
X-coordinate of the box or a list of values\&.
.TP
float \fIymin\fR (in)
Y-coordinate of the box or a list of values\&.
.RE
.sp
The box ends at the 1st and 3rd quartile, while the whiskers by default
are plotted to span 1\&.5 IQR (interquartile range) from the 1st and 3rd quartile\&.
.TP
\fB$xyplot\fR violin \fIseries\fR \fIxcrd\fR \fIycrd\fR
Draw a violin plot based on the given data set\&. It is an alternative to the box and whiskers presentation\&.
Just as with the box-and-whiskers subcommand, if the argument \fIxcrd\fR is a
list of several values and the argument \fIycrd\fR is a single value, a
horizontal "violin" is drawn\&.
.sp
If, instead, the argument \fIycrd\fR contains a list of several values
and the argument \fIxcrd\fR a single value, then a vertical "violin" is
drawn\&.
.sp
The option -violinwidth to the dataconfig command determines the width (or
height) of the violin (default: 50 pixels)\&.
.sp
The option -colour (-color) determines the outline colour and the option -fillcolour (-fillcolor)
determines the colour by which the violin is filled (defaults: black and not filled)\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series to use\&.
.TP
float \fIxcrd\fR (in)
X-coordinate of the violin or a list of values\&.
.TP
float \fIymin\fR (in)
Y-coordinate of the violin or a list of values\&.
.RE
.TP
\fB$xyplot\fR vector \fIseries\fR \fIxcrd\fR \fIycrd\fR \fIucmp\fR \fIvcmp\fR
Draw a vector in the plot\&. The vector can be given as either cartesian
coordinates or as length/angle, where the angle is in degrees and is
interpreted according to the mathematical convention or the nautical\&.
(See the vectorconfig subcommand)
.RS
.TP
string \fIseries\fR (in)
Name of the series the vector belongs to\&. Determines the appearance and
interpretation\&.
.TP
float \fIxcrd\fR (in)
X-coordinate of the point where the arrow appears
.TP
float \fIycrd\fR (in)
Y-coordinate of the point where the arrow appears
.TP
float \fIucmp\fR (in)
X-component or the length of the vector
.TP
float \fIycentr\fR (in)
Y-component or the angle of the vector
.RE
.TP
\fB$xyplot\fR vectorconfig \fIseries\fR \fB-option\fR \fIvalue\fR \&.\&.\&.
]
Set the vector drawing options for a particular series
.RS
.TP
string \fIseries\fR (in)
Name of the series the vector belongs to\&.
.RE
.IP
The options can be one of the following:
.RS
.TP
\fBcolour\fR
The colour of the arrow (default: black; synonym: color)
.TP
\fBscale\fR value
The scale factor used to convert the length of the
arrow into a number of pixels (default: 1\&.0)
.TP
\fBcentred\fR onoff
Logical value indicating that the xy-coordinates
are to be used as the start of the arrow or as the centre (default: 0;
synonym: centered)
.TP
\fBtype\fR keyword
Interpretation of the vector components\&. Can be "cartesian"
(default), in which case the x- and y-components are expected, "polar"
(the angle 0 coincides with the positive x-axis, 90 coincides with the
positive y-axis) or "nautical" (0 is "north" and 90 is "east")\&.
.RE
.sp
.TP
\fB$xyplot\fR dot \fIseries\fR \fIxcrd\fR \fIycrd\fR \fIvalue\fR
Draw a dot in the plot\&. The size and colour is determined by the value
and by the options set for the series it belongs to\&.
(See the dotconfig subcommand)
.RS
.TP
string \fIseries\fR (in)
Name of the series the dot belongs to\&. Determines size and colour
.TP
float \fIxcrd\fR (in)
X-coordinate of the point where the arrow appears
.TP
float \fIycrd\fR (in)
Y-coordinate of the point where the arrow appears
.TP
float \fIvalue\fR (in)
Value determining size and colour
.RE
.TP
\fB$xyplot\fR dotconfig \fIseries\fR \fB-option\fR \fIvalue\fR \&.\&.\&.
]
Set the dot drawing options for a particular series
.RS
.TP
string \fIseries\fR (in)
Name of the series the dot belongs to\&.
.RE
.IP
The options can be one of the following:
.RS
.TP
\fBcolour\fR
The colour of the dot if no scaling is used or the value exceeds the
last limit of the classes\&.
.TP
\fBscale\fR value
The scale factor used to convert the value into the radius of the dot
in pixels (default: 1\&.0)
.TP
\fBradius\fR value
The default radius of the dots, used if there is no scaling by value
(in pixels; default: 3)
.TP
\fBscalebyvalue\fR onoff
Determines whether the dots all have the same size or a size depending
on the given value (default: on)\&.
.TP
\fBoutline\fR onoff
Draw a black circle around the dot or not (default: on)
.TP
\fBclasses\fR list
Set the limits and the corresponding colours\&. For instance:
.CS


    $xyplot series1 -classes {0 blue 1 green} -colour red

.CE
.IP
will cause a blue dot to be drawn for values smaller than 0, a green dot
for values larger/equal 0 but lower than 1 and a red dot for values
larger/equal 1\&.
.TP
\fB3deffect\fR onoff
Show a highlight in the dots, to mimick a 3D effect (default: off)
.sp
If there is no list of classes for the particular series, the dots are
scaled by the value\&.
.sp
You can combine the colouring by value and the scaling by value by
setting a list of classes and setting the \fIscalebyvalue\fR option on\&.
.RE
.sp
.TP
\fB$xyplot\fR contourlines \fIxcrd\fR \fIycrd\fR \fIvalues\fR ?classes?
Draw contour lines for the values given on the grid\&. The grid is defined
by the xcrd and ycrd arguments\&. The xcrd argument (resp\&. ycrd)
is expected to be a matrix, implemented as a list of lists which gives the
x-coordinates (resp\&. y-coordinates) of the grid cell corners\&.
The function values are given at these corners\&.
The number of rows in xcrd (resp\&. ycrd) is ny and each row contains nx values
so that the total number of values in xcrd (resp\&. ycrd) is nx * ny\&.
The classes determine which contour lines are drawn\&. If a value on one of
the corners is missing, the contour lines in that cell will not be
drawn\&.
.sp
Entries in the legend are drawn via the \fIlegendisolines\fR subcommand\&.
.RS
.TP
list \fIxcrd\fR (in)
List of lists, each value is an x-coordinate for a grid cell corner
.TP
list \fIycrd\fR (in)
List of lists, each value is an y-coordinate for a grid cell corner
.TP
list \fIvalues\fR (in)
List of lists, each value is the value at a grid cell corner
.TP
list \fIclasses\fR (in)
List of class values or a list of lists of two elements (each inner list
the class value and the colour to be used)\&. If empty or missing, the
classes are determined automatically\&.
.sp
\fINote:\fR The class values must enclose the whole range of values\&.
\fINote:\fR The xcrd argument is generally made of nypoints identical rows, while
each row of ycrd is made with one single value\&.
.sp
.RE
.TP
\fB$xyplot\fR contourlinesfunctionvalues \fIxvec\fR \fIyvec\fR \fIvaluesmat\fR ?classes?
Draw contour lines for the values given on the grid\&. The grid is defined
by the xvec and yvec arguments\&. Here, xvec (resp\&. yvec) is a list of x-coordinates
(resp\&. y-coordinates)\&. The number of values in xvec (resp\&. yvec) is the number of points in
the x-coordinate (resp\&. y-coordinate)\&.
The function values are given at these corners\&. The
classes determine which contour lines are drawn\&. If a value on one of
the corners is missing, the contour lines in that cell will not be
drawn\&.
.sp
Entries in the legend are drawn via the \fIlegendisolines\fR subcommand\&.
.RS
.TP
list \fIxvec\fR (in)
List of x-coordinates in increasing order\&.
.TP
list \fIyvec\fR (in)
List y-coordinates in increasing order\&.
.TP
list \fIvaluesmat\fR (in)
List of ny lists of nx values, each value is the value at a grid cell corner\&.
The total number of values is valuesmat is nx * ny\&.
.TP
list \fIclasses\fR (in)
List of class values or a list of lists of two elements (each inner list
the class value and the colour to be used)\&. If empty or missing, the
classes are determined automatically\&.
.sp
\fINote:\fR The class values must enclose the whole range of values\&.
.sp
.RE
.TP
\fB$xyplot\fR contourfill \fIxcrd\fR \fIycrd\fR \fIvalues\fR ?classes?
Draw filled contours for the values given on the grid\&. (The use of this
method is identical to the "contourlines" method)\&.
.sp
Entries in the legend are drawn via the \fIlegendshades\fR subcommand\&.
.TP
\fB$xyplot\fR contourbox \fIxcrd\fR \fIycrd\fR \fIvalues\fR ?classes?
Draw the cells as filled quadrangles\&. The colour is determined from
the average of the values on all four corners\&.
.sp
Entries in the legend are drawn via the \fIlegendshades\fR subcommand\&.
.TP
\fB$xyplot\fR colorMap \fIcolours\fR
Set the colours to be used with the contour methods\&. The argument is
either a predefined colourmap (grey/gray, jet, hot or cool)
or a list of colours\&. When selecting the colours for actually drawing the
contours, the given colours will be interpolated (based on the HLS scheme)\&.
.RS
.TP
list \fIcolours\fR (in)
List of colour names or colour values or one of the predefined maps:
.RS
.IP \(bu
grey or gray: gray colours from dark to light
.IP \(bu
jet: rainbow colours
.IP \(bu
hot: colours from yellow via red to darkred
.IP \(bu
cool: colours from cyan via blue to magenta
.RE
.RE
.TP
\fB$xyplot\fR legendisolines \fIvalues\fR \fIclasses\fR
Add the contour classes to the legend as coloured lines\&. The text indicates the
values\&.
.RS
.TP
list \fIvalues\fR (in)
The list of values as used for the actual drawing\&. This argument is used only
if the list of classes is empty\&.
.TP
list \fIvalues\fR (in)
The list of classes as used for the actual drawing\&.
.RE
.TP
\fB$xyplot\fR legendshades \fIvalues\fR \fIclasses\fR
Add the contour classes to the legend as coloured rectangles\&. The text indicates the
values\&.
.RS
.TP
list \fIvalues\fR (in)
The list of values as used for the actual drawing\&. This argument is used only
if the list of classes is empty\&.
.TP
list \fIvalues\fR (in)
The list of classes as used for the actual drawing\&.
.RE
.TP
\fB$xyplot\fR grid \fIxcrd\fR \fIycrd\fR
Draw the grid cells as lines connecting the (valid) grid points\&.
.RS
.TP
list \fIxcrd\fR (in)
List of lists, each value is an x-coordinate for a grid cell corner
.TP
list \fIycrd\fR (in)
List of lists, each value is an y-coordinate for a grid cell corner
.RE
.sp
.TP
\fB$xyplot\fR xband \fIymin\fR \fIymax\fR
Draw a light grey band in the plot, ranging over the full x-axis\&. This
can be used to indicate a "typical" range for the data\&.
.RS
.TP
float \fIymin\fR (in)
Lower bound for the band
.TP
float \fIymax\fR (in)
Upper bound for the band
.RE
.sp
.TP
\fB$xyplot\fR yband \fIxmin\fR \fIxmax\fR
Draw a light grey band in the plot, ranging over the full y-axis\&. This
can be used to indicate a "typical" range for the data\&.
.RS
.TP
float \fIxmin\fR (in)
Lower bound for the band
.TP
float \fIxmax\fR (in)
Upper bound for the band
.RE
.sp
.TP
\fB$xyplot\fR labeldot \fIx\fR \fIy\fR \fItext\fR \fIorient\fR
Draw a label and a symbol in the plot\&. The label will appear near the
symbol\&. The label will be drawn in grey, so as not to be too
conspicuous\&.
.sp
You can configure the appearance of the symbol by using the data series
name "labeldot":
\fI$w dataconfig labeldot -colour red -type symbol -symbol dot\fR
.RS
.TP
float \fIx\fR (in)
X-coordinate of the symbol to be drawn
.TP
float \fIy\fR (in)
Y-coordinate of the symbol to be drawn
.TP
string \fItext\fR (in)
Text for the label
.TP
string \fIorient\fR (in)
Optional orientation (one of w, e, n, s) defining the position of the
label with respect to the symbol\&. It defaults to w (so the label
appears left of the symbol)\&.
.RE
.PP
.PP
For \fIpolar plots\fR:
.TP
\fB$polarplot\fR plot \fIseries\fR \fIradius\fR \fIangle\fR
Add a data point to the polar plot\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the new point belongs to\&.
.TP
float \fIradius\fR (in)
Radial coordinate of the new point\&.
.TP
float \fIangle\fR (in)
Angular coordinate of the new point (in degrees)\&.
.RE
.PP
.PP
For \fIwind rose diagrams\fR:
.TP
\fB$windrose\fR plot \fIdata\fR \fIcolour\fR
Draw the data contained in the \fIdata\fR argument\&. The data are added to
the existing spokes towards the outer circle\&.
.RS
.TP
list \fIdata\fR (in)
List of data (the length should correspond to the number of sectors)
.TP
string \fIcolour\fR
Colour in which the new segments will be drawn
.RE
.PP
.PP
For \fI3D plots\fR:
.TP
\fB$plot3d\fR plotfunc \fIfunction\fR
Plot a function defined over two variables \fBx\fR and \fBy\fR\&.
The resolution is determined by the set grid sizes (see the method
\fBgridsize\fR for more information)\&.
.RS
.TP
string \fIfunction\fR (in)
Name of the procedure that calculates the z-value for the given x and
y coordinates\&. The procedure has to accept two float arguments (x is
first argument, y is second) and return a floating-point value\&.
.RE
.sp
.TP
\fB$plot3d\fR plotfuncont \fIfunction\fR \fIcontours\fR
Plot a function defined over two variables \fBx\fR and \fBy\fR using
the contour levels in \fBcontours\fR to colour the surface\&.
The resolution is determined by the set grid sizes (see the method
\fBgridsize\fR for more information)\&.
.RS
.TP
string \fIfunction\fR (in)
Name of the procedure that calculates the z-value for the given x and
y coordinates\&. The procedure has to accept two float arguments (x is
first argument, y is second) and return a floating-point value\&.
.TP
list \fIcontours\fR (in)
List of values in ascending order that represent the contour levels
(the boundaries between the colours in the contour map)\&.
.RE
.sp
.TP
\fB$plot3d\fR gridsize \fInxcells\fR \fInycells\fR
Set the grid size in the two directions\&. Together they determine how
many polygons will be drawn for a function plot\&.
.RS
.TP
int \fInxcells\fR (in)
Number of grid cells in x direction\&. Has to be an integer number
greater than zero\&.
.TP
int \fInycells\fR (in)
Number of grid cells in y direction\&. Has to be an integer number
greater than zero\&.
.RE
.sp
.TP
\fB$plot3d\fR plotdata \fIdata\fR
Plot a matrix of data\&.
.RS
.TP
list \fIdata\fR (in)
The data to be plotted\&. The data has to be provided as a nested list
with 2 levels\&. The outer list contains rows, drawn in y-direction, and
each row is a list whose elements are drawn in x-direction, for the
columns\&. Example:
.sp
.CS


    set data {
    {1\&.0 2\&.0 3\&.0}
    {4\&.0 5\&.0 6\&.0}
    }

.CE
.RE
.sp
.TP
\fB$plot3d\fR interpolatedata \fIdata\fR \fIcontours\fR
Plot the data using bilinear interpolation with
the contour levels in \fBcontours\fR to colour the surface\&.
The resolution is determined by the set grid sizes (see the method
\fBgridsize\fR for more information)\&.
.RS
.TP
list \fIdata\fR (in)
The data to be plotted, just as for the plotdata subcommand\&.
.TP
list \fIcontours\fR (in)
List of values in ascending order that represent the contour levels
(the boundaries between the colours in the contour map)\&.
.RE
.sp
.TP
\fB$plot3d\fR colour \fIfill\fR \fIborder\fR
Configure the colour to use for polygon borders and inner area\&.
\fINote:\fR The "color" subcommand is a synonym\&.
.RS
.TP
color \fIfill\fR (in)
The colour to use for filling the polygons\&.
.TP
color \fIborder\fR (in)
The colour to use for the border of the polygons\&.
.RE
.TP
\fB$plot3d\fR ribbon \fIyzpairs\fR
Plot a ribbon based on the pairs of yz-coordinates\&. The colours for
the ribbon itself and the edge are taken from the colours option\&.
.RS
.TP
list \fIyzpairs\fR (in)
List of pairs of yz-coordinates
.RE
.PP
.PP
For 3D ribbon plots:
.TP
\fB$plot3d\fR plot \fIyzpairs\fR
Plot a ribbon based on the pairs of yz-coordinates\&. The colours for
the ribbon itself and the edge are taken from the colours option\&.
.RS
.TP
list \fIyzpairs\fR (in)
List of pairs of yz-coordinates
.RE
.PP
.PP
For \fIxy plots\fR, \fIstripcharts\fR, \fIhistograms\fR, \fIpolar plots\fR and \fIternary diagrams\fR:
.TP
\fB$xyplot\fR dataconfig \fIseries\fR \fB-option\fR \fIvalue\fR \&.\&.\&.
Set the value for one or more options regarding the drawing of data of
a specific series\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series whose configuration we are changing\&.
.RE
.sp
The following options are allowed:
.RS
.TP
\fBcolour\fR c
.TP
\fBcolor\fR c
The colour to be used when drawing the data series\&.
.TP
\fBtype\fR enum
The drawing mode chosen for the series\&.
This can be one of \fBline\fR, \fBsymbol\fR, or \fBboth\fR\&.
.TP
\fBsymbol\fR enum
What kind of symbol to draw\&. The value of this option is ignored when
the drawing mode \fBline\fR was chosen\&. This can be one of
\fBplus\fR, \fBcross\fR, \fBcircle\fR, \fBup\fR (triangle
pointing up), \fBdown\fR (triangle pointing down), \fBdot\fR
(filled circle), \fBupfilled\fR or \fBdownfilled\fR (filled
triangles)\&.
.TP
\fBradius\fR integer
The size of the radius of the symbol\&. The total width of the symbol will be
2 times the radius size\&. The default radius is 4\&.
.TP
\fBwidth\fR integer
The width of the line (if drawn) or the width of the polygon outline (if -filled)\&.
.TP
\fBfilled\fR enum
Whether to fill the area above or below the data line or not\&. Can be one
of: \fBno\fR, \fBup\fR or \fBdown\fR (\fBSPECIAL EFFECTS\fR)
.TP
\fBfillcolour\fR colour
Colour to use when filling the area associated with the data line\&.
.TP
\fBstyle\fR enum
The style to be used for histograms:
.RS
.IP \(bu
\fBfilled\fR: Fill the area under the data points with bars (default)
.IP \(bu
\fBspike\fR: Draw vertical lines from the y-axis (lower boundary) to the data point
.IP \(bu
\fBsymbol\fR: Draw a symbol at the data point
.IP \(bu
\fBplateau\fR: Draw a horizontal line at the height of the data point
.IP \(bu
\fBstair\fR: Draw a continuous stair-like line connecting the data points
.RE
.TP
\fBsmooth\fR boolean
(Used with ternary diagrams) Whether to draw the lines and filled polygons with the
smooth option on (rounded corners) or not\&.
.RE
.PP
.PP
For \fIpiecharts\fR and \fIspiral pies\fR:
.TP
\fB$pie\fR plot \fIdata\fR
Fill a piechart\&.
.RS
.TP
list \fIdata\fR (in)
A list of pairs (labels and values)\&. The values determine the relative
size of the circle segments\&. The labels are drawn beside the circle\&.
.RE
.TP
\fB$pie\fR colours \fIcolour1\fR \fIcolour2\fR \&.\&.\&.
Set the colours to be used\&.
.RS
.TP
color \fIcolour1\fR (in)
The first colour\&.
.TP
color \fIcolour2\fR (in)
The second colour, and so on\&.
.RE
.TP
\fB$pie\fR explode \fIsegment\fR
Explode a segment (that is: move one segment out of the circle)\&. If the segment is
indicated as "auto", then you can click on a segment\&. This will be exploded instead of
any previously exploded segment\&.
.RS
.TP
int \fIsegment\fR
The segment to be exploded or "auto" if you want to do this interactively\&.
.RE
.PP
.PP
For \fIradial charts\fR:
.TP
\fB$radial\fR plot \fIdata\fR \fIcolour\fR \fIthickness\fR
Draw a new line in the radial chart
.RS
.TP
list \fIdata\fR (in)
A list of data (one for each spoke)\&. The values determine the distance
from the centre of the line connecting the spokes\&.
.TP
color \fIcolour\fR (in)
The colour for the line\&.
.TP
int \fIthickness\fR (in)
An optional argument for the thickness of the line\&.
.RE
.TP
\fB$pie\fR colours \fIcolour1\fR \fIcolour2\fR \&.\&.\&.
Set the colours to be used\&.
.RS
.TP
color \fIcolour1\fR (in)
The first colour\&.
.TP
color \fIcolour2\fR (in)
The second colour, and so on\&.
.RE
.PP
.PP
For \fIvertical barcharts\fR:
.TP
\fB$barchart\fR plot \fIseries\fR \fIydata\fR \fIcolour\fR ?dir? ?brightness?
Add a data series to a barchart\&. The bars are tagged with a tag "data_\\$series" to identify them\&.
.RS
.TP
string \fIseries\fR (in)
Name of the series the values belong to\&.
.TP
list \fIydata\fR (in)
A list of values, one for each x-axis label\&.
.TP
color \fIcolour\fR (in)
The colour of the bars\&.
.TP
string \fIdir\fR (in)
If given, "top-down" or "bottom-up", to indicate the direction in which the colour changes\&.
(If not given, a uniform colour is used)\&.
.TP
string \fIbrightness\fR (in)
If given, "bright" or "dark" (defaulting to "bright")\&. The colour will change to respectively
white or black, depending on the direction\&.
.RE
.TP
\fB$barchart\fR config \fB-option\fR \fIvalue\fR \&.\&.\&.
Set options for drawing the bars\&.
.RS
.TP
\fBshowvalues\fR boolean
Whether to show the values or not (above the bars)
.TP
\fBvaluefont\fR newfont
Name of the font to use for the values
.TP
\fBvaluecolour\fR colour
Colour for the values
.TP
\fBvalueformat\fR format
Format string to use for formatting the values
.RE
.PP
.PP
For \fIhorizontal barcharts\fR:
.TP
\fB$barchart\fR plot \fIseries\fR \fIxdata\fR \fIcolour\fR ?dir? ?brightness?
Add a data series to a barchart\&. The bars are tagged with a tag "data_\\$series" to identify them\&.
.RS
.TP
string \fIseries\fR (in)
Name of the series the values belong to\&.
.TP
list \fIxdata\fR (in)
A list of values, one for each y-axis label\&.
.TP
color \fIcolour\fR (in)
The colour of the bars\&.
.TP
string \fIdir\fR (in)
If given, "left-right" or "right-left", to indicate the direction in which the colour changes\&.
(If not given, a uniform colour is used)\&.
.TP
string \fIbrightness\fR (in)
If given, "bright" or "dark" (defaulting to "bright")\&. The colour will change to respectively
white or black, depending on the direction\&.
.RE
.TP
\fB$barchart\fR config \fB-option\fR \fIvalue\fR \&.\&.\&.
Set options for drawing the bars\&.
.RS
.TP
\fBshowvalues\fR boolean
Whether to show the values or not (to the right of the bars)
.TP
\fBvaluefont\fR newfont
Name of the font to use for the values
.TP
\fBvaluecolour\fR colour
Colour for the values
.TP
\fBvalueformat\fR format
Format string to use for formatting the values
.RE
.PP
.PP
For \fI3D barcharts\fR:
.TP
\fB$barchart\fR plot \fIlabel\fR \fIyvalue\fR \fIcolour\fR
Add the next bar to the barchart\&.
.RS
.TP
string \fIlabel\fR (in)
The label to be shown below the column\&.
.TP
float \fIyvalue\fR (in)
The value that determines the height of the column
.TP
color \fIcolour\fR (in)
The colour of the column\&.
.RE
.TP
\fB$barchart\fR config \fB-option\fR \fIvalue\fR \&.\&.\&.
Set one or more configuration parameters\&. The following options are
supported:
.RS
.TP
\fBusebackground\fR boolean
Whether to draw walls to the left and to the back of the columns or not
.TP
\fBuseticklines\fR boolean
Whether to draw ticklines on the walls or not
.TP
\fBshowvalues\fR boolean
Whether to show the values or not
.TP
\fBlabelfont\fR newfont
Name of the font to use for labels
.TP
\fBlabelcolour\fR colour
Colour for the labels
.TP
\fBvaluefont\fR newfont
Name of the font to use for the values
.TP
\fBvaluecolour\fR colour
Colour for the values
.RE
.PP
.PP
For \fI3D ribbon charts\fR:
.TP
\fB$ribbon\fR line \fIxypairs\fR \fIcolour\fR
Plot the given xy-pairs as a ribbon in the chart
.RS
.TP
list \fIxypairs\fR (in)
The pairs of x/y values to be drawn (the series is drawn as a whole)
.TP
color \fIcolour\fR (in)
The colour of the ribbon\&.
.RE
.TP
\fB$ribbon\fR area \fIxypairs\fR \fIcolour\fR
Plot the given xy-pairs as a ribbon with a filled area in front\&. The
effect is that of a box with the data as its upper surface\&.
.RS
.TP
list \fIxypairs\fR (in)
The pairs of x/y values to be drawn (the series is drawn as a whole)
.TP
color \fIcolour\fR (in)
The colour of the ribbon/area\&.
.RE
.PP
For \fIboxplots\fR:
.TP
\fB$boxplot\fR plot \fIseries\fR \fIlabel\fR \fIvalues\fR
Add a box-and-whisker to the plot\&. The dataconfig command can be used to customize
the box-and-whisker (see the box-and-whiskers command for the xyplot for details)\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the box belongs to
.TP
string \fIlabel\fR (in)
The label along the x- or y-axis to which the data belong
.TP
list \fIvalues\fR (in)
List of raw values, the extent of the box and the whiskers will be
determined from this list\&.
.RE
.TP
\fB$boxplot\fR violin \fIseries\fR \fIlabel\fR \fIvalues\fR
Add a "violin" to the plot\&. The dataconfig command can be used to customize
the appearance (see the violin command for the xyplot for details)\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series to be used for settings
.TP
string \fIlabel\fR (in)
The label along the x- or y-axis to which the data belong
.TP
list \fIvalues\fR (in)
List of raw values, the extent of the box and the whiskers will be
determined from this list\&.
.RE
.PP
For \fItimecharts\fR:
.TP
\fB$timechart\fR period \fItext\fR \fItime_begin\fR \fItime_end\fR \fIcolour\fR
Add a time period to the chart\&.
.RS
.TP
string \fItext\fR (in)
The text describing the period\&.
.TP
string \fItime_begin\fR (in)
Start time of the period\&.
.TP
string \fItime_end\fR (in)
Stop time of the period\&.
.TP
color \fIcolour\fR (in)
The colour of the bar (defaults to black)\&.
.RE
.sp
.TP
\fB$timechart\fR addperiod \fItime_begin\fR \fItime_end\fR \fIcolour\fR
Add a new period to the current row in the chart\&. This allows you to highlight several periods
in the same row\&. No new text is drawn\&.
.RS
.TP
string \fItime_begin\fR (in)
Start time of the period\&.
.TP
string \fItime_end\fR (in)
Stop time of the period\&.
.TP
color \fIcolour\fR (in)
The colour of the bar (defaults to black)\&.
.RE
.sp
.TP
\fB$timechart\fR milestone \fItext\fR \fItime\fR \fIcolour\fR
Add a \fImilestone\fR (represented as an point-down triangle) to the
chart\&.
.RS
.TP
string \fItext\fR (in)
The text describing the milestone\&.
.TP
string \fItime\fR (in)
Time at which the milestone must be positioned\&.
.TP
color \fIcolour\fR (in)
The colour of the triangle (defaults to black)\&.
.RE
.sp
.TP
\fB$timechart\fR addmilestone \fItime\fR \fIcolour\fR
Add another \fImilestone\fR to the current row in the chart\&.
.RS
.TP
string \fItime\fR (in)
Time at which the milestone must be positioned\&.
.TP
color \fIcolour\fR (in)
The colour of the triangle (defaults to black)\&.
.RE
.sp
.TP
\fB$timechart\fR vertline \fItext\fR \fItime\fR \fIcolour\fR
Add a vertical line (to indicate the start of the month for instance)
to the chart in the specified colour\&.
.RS
.TP
string \fItext\fR (in)
The text appearing at the top (an abbreviation of the
date/time for instance)\&.
.TP
string \fItime\fR (in)
Time at which the line must be positioned\&.
.TP
color \fIcolour\fR (in)
The colour of the line to be drawn (defaults to black)
.RE
.TP
\fB$timechart\fR hscroll \fIscrollbar\fR
Connect a horizontal scrollbar to the chart\&. See also the section on
scrolling\&.
.RS
.TP
widget \fIscrollbar\fR (in)
The horizontal scrollbar that is to be connected to the chart
.RE
.TP
\fB$timechart\fR vscroll \fIscrollbar\fR
Connect a vertical scrollbar to the chart\&. See also the section on
scrolling\&.
.RS
.TP
widget \fIscrollbar\fR (in)
The vertical scrollbar that is to be connected to the chart
.RE
.PP
.PP
For \fIGantt charts\fR:
.TP
\fB$ganttchart\fR task \fItext\fR \fItime_begin\fR \fItime_end\fR \fIcompleted\fR
Add a task with its period and level of completion to the chart\&. Returns
a list of canvas items that can be used for further manipulations, like
connecting two tasks\&.
.RS
.TP
string \fItext\fR (in)
The text describing the task\&.
.TP
string \fItime_begin\fR (in)
Start time of the task\&.
.TP
string \fItime_end\fR (in)
Stop time of the task\&.
.TP
float \fIcompleted\fR (in)
The percentage of the task that is completed\&.
.RE
.sp
.TP
\fB$ganttchart\fR milestone \fItext\fR \fItime\fR \fIcolour\fR
Add a \fImilestone\fR (represented as an point-down triangle) to the
chart\&.
.RS
.TP
string \fItext\fR (in)
The text describing the milestone\&.
.TP
string \fItime\fR (in)
Time at which the milestone must be positioned\&.
.TP
color \fIcolour\fR (in)
The colour of the triangle (defaults to black)\&.
.RE
.sp
.TP
\fB$ganttchart\fR vertline \fItext\fR \fItime\fR
Add a vertical line (to indicate the start of the month for instance)
to the chart\&.
.RS
.TP
string \fItext\fR (in)
The text appearing at the top (an abbreviation of the
date/time for instance)\&.
.TP
string \fItime\fR (in)
Time at which the line must be positioned\&.
.RE
.sp
.TP
\fB$ganttchart\fR connect \fIfrom\fR \fIto\fR
Add an arrow that connects the \fIfrom\fR task with the \fIto\fR task\&.
.RS
.TP
list \fIfrom\fR (in)
The list of items returned by the "task" command that represents the
task from which the arrow starts\&.
.TP
string \fItext\fR (in)
The text summarising the tasks
.TP
list \fIargs\fR (in)
One or more tasks (the lists returned by the "task" command)\&. They are
shifted down to make room for the summary\&.
.TP
list \fIto\fR (in)
The list of items returned by the "task" command that represents the
task at which the arrow ends\&.
.RE
.sp
.TP
\fB$ganttchart\fR summary \fItext\fR \fIargs\fR
Add a summary item that spans all the tasks listed\&. The graphical
representation is a thick bar running from the leftmost task to the
rightmost\&.
.sp
Use this command before connecting the tasks, as the arrow would not be
shifted down!
.RS
.TP
string \fItext\fR (in)
The text summarising the tasks
.TP
list \fIargs\fR (in)
One or more tasks (the lists returned by the "task" command)\&. They are
shifted down to make room for the summary\&.
.RE
.sp
.TP
\fB$ganttchart\fR color \fIkeyword\fR \fInewcolor\fR
Set the colour of a part of the Gantt chart\&. These colours hold for all
items of that type\&.
.RS
.TP
string \fIkeyword\fR (in)
The keyword indicates which part of the Gantt chart to change:
.RS
.IP \(bu
description - the colour of the descriptive text
.IP \(bu
completed - the colour of the filled bar representing the completed part
of a task
.IP \(bu
left - the colour for the part that is not yet completed
.IP \(bu
odd - the background colour for the odd entries
.IP \(bu
even - the background colour for the even entries
.IP \(bu
summary - the colour for the summary text
.IP \(bu
summarybar - the colour for the bar for a summary
.RE
.TP
string \fInewcolor\fR (in)
The new colour for the chosen items\&.
.RE
.sp
.TP
\fB$ganttchart\fR font \fIkeyword\fR \fInewfont\fR
Set the font of a part of the Gantt chart\&. These fonts hold for all
items of that type\&.
.RS
.TP
string \fIkeyword\fR (in)
The keyword indicates which part of the Gantt chart to change:
.RS
.IP \(bu
description - the font used for descriptive text
.IP \(bu
summary - the font used for summaries
.IP \(bu
scale - the font used for the time scale
.RE
.TP
string \fInewfont\fR (in)
The new font for the chosen items\&.
.RE
.TP
\fB$ganttchart\fR hscroll \fIscrollbar\fR
Connect a horizontal scrollbar to the chart\&. See also the section on
scrolling\&.
.RS
.TP
widget \fIscrollbar\fR (in)
The horizontal scrollbar that is to be connected to the chart
.RE
.TP
\fB$ganttchart\fR vscroll \fIscrollbar\fR
Connect a vertical scrollbar to the chart\&. See also the section on
scrolling\&.
.RS
.TP
widget \fIscrollbar\fR (in)
The vertical scrollbar that is to be connected to the chart
.RE
.PP
.PP
For \fIisometric plots\fR (to be extended):
.TP
\fB$isoplot\fR plot rectangle \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR \fIcolour\fR
Plot the outlines of a rectangle\&.
.RS
.TP
float \fIx1\fR (in)
Minimum x coordinate of the rectangle to be drawn\&.
.TP
float \fIy1\fR (in)
Minimum y coordinate of the rectangle\&.
.TP
float \fIx2\fR (in)
Maximum x coordinate of the rectangle to be drawn\&.
.TP
float \fIy2\fR (in)
Maximum y coordinate of the rectangle\&.
.TP
color \fIcolour\fR (in)
The colour of the rectangle\&.
.RE
.sp
.TP
\fB$isoplot\fR plot filled-rectangle \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR \fIcolour\fR
Plot a rectangle filled with the given colour\&.
.RS
.TP
float \fIx1\fR (in)
Minimum x coordinate of the rectangle to be drawn\&.
.TP
float \fIy1\fR (in)
Minimum y coordinate of the rectangle\&.
.TP
float \fIx2\fR (in)
Maximum x coordinate of the rectangle to be drawn\&.
.TP
float \fIy2\fR (in)
Maximum y coordinate of the rectangle\&.
.TP
color \fIcolour\fR (in)
The colour of the rectangle\&.
.RE
.sp
.TP
\fB$isoplot\fR plot circle \fIxc\fR \fIyc\fR \fIradius\fR \fIcolour\fR
Plot the outline of a circle\&.
.RS
.TP
float \fIxc\fR (in)
X coordinate of the circle's centre\&.
.TP
float \fIyc\fR (in)
Y coordinate of the circle's centre\&.
.TP
color \fIcolour\fR (in)
The colour of the circle\&.
.RE
.sp
.TP
\fB$isoplot\fR plot filled-circle \fIxc\fR \fIyc\fR \fIradius\fR \fIcolour\fR
Plot a circle filled with the given colour\&.
.RS
.TP
float \fIxc\fR (in)
X coordinate of the circle's centre\&.
.TP
float \fIyc\fR (in)
Y coordinate of the circle's centre\&.
.TP
color \fIcolour\fR (in)
The colour of the circle\&.
.RE
.PP
.PP
For \fItables\fR you can use the following subcommands:
.TP
\fB$table\fR row \fIitems\fR
Draw a single row of items\&. The appearance of the items can be
controlled explicitly via the format command\&.
.RS
.TP
list \fIitems\fR (in)
List of text items to be drawn, one per column
.RE
.TP
\fB$table\fR separator
Draw a horizontal line to separate two rows
.TP
\fB$table\fR formatcommand \fIprocname\fR
Set the procedure that controls the formatting of items\&. By default
items are simply drawn as centered text\&.
.RS
.TP
string \fIprocname\fR (in)
Name of the procedure to be used\&. Its signature is:
.CS


proc procname {table widget row column value} {\&.\&.\&.}

.CE
.IP
Use the cellconfigure subcommand to set the attributes per cell\&.
.RE
.TP
\fB$table\fR cellconfigure \fIargs\fR
Set the attributes for the next cell(s) to be drawn\&.
.RS
.TP
list \fIargs\fR (in)
Key-value pairs: -background sets the background colour of the cells,
-cell sets the foreground colour, -font sets the text font, -anchor sets
the position of the text within the cell and -justify controls the
layout of multiline text\&.
.RE
.PP
For \fIternary diagrams\fR you can use the following subcommands:
.TP
\fB$ternary\fR plot \fIseries\fR \fIxcrd\fR \fIycrd\fR \fIzcrd\fR \fItext\fR \fIdir\fR
Draw a single data point with a label\&. The three coordinates are scaled so that a unique point
in the triangle results\&. A label is drawn next to it\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the point belongs to (used to determine colour and symbol)
.TP
float \fIxcrd\fR (in)
X-coordinate of the data point (refers to the lower-left corner)\&.
.TP
float \fIycrd\fR (in)
Y-coordinate of the data point (refers to the lower-right corner)\&.
.TP
float \fIzcrd\fR (in)
Z-coordinate of the data point (refers to the top corner)\&.
.TP
string \fItext\fR (in)
Label describing the data point\&.
.TP
string \fIdir\fR (in)
Optional string indicating the direction in which to plot the label (e, n, etc\&.)
.RE
.TP
\fB$ternary\fR line \fIseries\fR \fIcoords\fR
Draw a continuous line based on the given coordinates (triplets)\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the line belongs to (used to determine colour and smoothness)
.TP
list \fIcoords\fR (in)
The coordinates of the points that determine the line (note that a point is defined by
three coordinates)\&.
.RE
.TP
\fB$ternary\fR fill \fIseries\fR \fIcoords\fR
Draw a filled polygon based on the given coordinates (triplets)\&.
.RS
.TP
string \fIseries\fR (in)
Name of the data series the polygon belongs to (used to determine colour and smoothness)
.TP
list \fIcoords\fR (in)
The coordinates of the points that determine the polygon (note that a point is defined by
three coordinates)\&.
.RE
.TP
\fB$ternary\fR text \fIxtext\fR \fIytext\fR \fIztext\fR
Draw text at the three corners of the diagram to identify the components\&.
.RS
.TP
string \fIxtext\fR (in)
Text to be plotted at the lower-left corner
.TP
string \fIytext\fR (in)
Text to be plotted at the lower-right corner
.TP
string \fIztext\fR (in)
Text to be plotted at the top corner
.RE
.TP
\fB$ternary\fR ticklines \fIcolour\fR
Draw ticklines to facilitate reading off the diagram\&.
.RS
.TP
string \fIcolour\fR (in)
Optional argument used as the colour of the ticklines\&. Defaults to grey\&.
.RE
.PP
For \fIstatus timeline plots\fR you can use the following subcommands:
.TP
\fB$timeline\fR plot \fIseries\fR \fIitem\fR \fIstart\fR \fIstop\fR \fIcolor\fR
Draw a bar in the given colour from \fIstart\fR to \fIstop\fR for the item \fIitem\fR\&.
The item is a convenient label - there is no relation to the labels along the axis\&.
The items are drawn from bottom to top\&.
.RS
.TP
string \fIitem\fR (in)
Name to identify the bar\&. See remark above\&.
.TP
float \fIstart\fR (in)
X-coordinate (or time) at which the bar starts
.TP
float \fIstop\fR (in)
X-coordinate (or time) at which the bar stops
.TP
string \fIcolor\fR (in)
Colour to use for the bar\&. Defaults to black\&.
.RE
.TP
\fB$timeline\fR vertline \fItext\fR \fItime\fR \fIargs\fR
Draw a vertical line to indicate a significant moment\&.
.RS
.TP
string \fItext\fR (in)
Text to identify the moment\&.
.TP
float \fItime\fR (in)
X-coordinate (or time) at which the line is to be drawn
.TP
list \fIargs\fR (in)
Individual optional arguments that will be passed to the \fIcreate line\fR subcommand
of the underlying canvas\&. This way you can set the colour or the line width
of the vertical line\&.
.RE
.PP
For \fIdendrograms\fR there is one specific subcommand:
.TP
\fB$dendrogram\fR plot \fIseries\fR \fIdata\fR
Draw a dendrogram according to the options given or implied when the dendrogram command was created\&.
The "series" name allows you to select the colour of the branches (-colour/-color) as well as the colour and font of the labels
(-labelcolour/-labelcolor and -labelfont)\&.
.RS
.TP
string \fIseries\fR (in)
Name of the set of options to draw the dendrogram with\&.
.TP
list \fIdata\fR (in)
Nested list, describing the tree structure\&. See the \fIcreateDendrogram\fR command\&.
.RE
.PP
.SH "COORDINATE TRANSFORMATIONS"
Besides the commands that deal with the plots and charts directly,
there are a number of commands that can be used to convert world
coordinates to pixels and vice versa\&.
These include:
.TP
\fB::Plotchart::viewPort\fR \fIw\fR \fIpxmin\fR \fIpymin\fR \fIpxmax\fR \fIpymax\fR
Set the viewport for window \fIw\fR\&. Should be used in cooperation
with \fB::Plotchart::worldCoordinates\fR\&.
.RS
.TP
widget \fIw\fR (in)
Name of the window (canvas widget) in question\&.
.TP
float \fIpxmin\fR (in)
Left-most pixel coordinate\&.
.TP
float \fIpymin\fR (in)
Top-most pixel coordinate (remember: the vertical pixel coordinate
starts with 0 at the top!)\&.
.TP
float \fIpxmax\fR (in)
Right-most pixel coordinate\&.
.TP
float \fIpymax\fR (in)
Bottom-most pixel coordinate\&.
.RE
.sp
.TP
\fB::Plotchart::worldCoordinates\fR \fIw\fR \fIxmin\fR \fIymin\fR \fIxmax\fR \fIymax\fR
Set the extreme world coordinates for window \fIw\fR\&. The world
coordinates need not be in ascending order (i\&.e\&. xmin can be larger
than xmax, so that a reversal of the x-axis is achieved)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the window (canvas widget) in question\&.
.TP
float \fIxmin\fR (in)
X-coordinate to be mapped to left side of viewport\&.
.TP
float \fIymin\fR (in)
Y-coordinate to be mapped to bottom of viewport\&.
.TP
float \fIxmax\fR (in)
X-coordinate to be mapped to right side of viewport\&.
.TP
float \fIymax\fR (in)
Y-coordinate to be mapped to top side of viewport\&.
.RE
.sp
.TP
\fB::Plotchart::world3DCoordinates\fR \fIw\fR \fIxmin\fR \fIymin\fR \fIzmin\fR \fIxmax\fR \fIymax\fR \fIzmax\fR
Set the extreme three-dimensional world coordinates for window
\fIw\fR\&. The world coordinates need not be in ascending order (i\&.e\&. xmin
can be larger than xmax, so that a reversal of the x-axis is
achieved)\&.
.RS
.TP
widget \fIw\fR (in)
Name of the window (canvas widget) in question\&.
.TP
float \fIxmin\fR (in)
X-coordinate to be mapped to front side of the 3D viewport\&.
.TP
float \fIymin\fR (in)
Y-coordinate to be mapped to left side of the viewport\&.
.TP
float \fIzmin\fR (in)
Z-coordinate to be mapped to bottom of viewport\&.
.TP
float \fIxmax\fR (in)
X-coordinate to be mapped to back side of viewport\&.
.TP
float \fIymax\fR (in)
Y-coordinate to be mapped to right side of viewport\&.
.TP
float \fIzmax\fR (in)
Z-coordinate to be mapped to top side of viewport\&.
.RE
.sp
.TP
\fB::Plotchart::coordsToPixel\fR \fIw\fR \fIx\fR \fIy\fR
Return a list of pixel coordinates valid for the given window\&.
.RS
.TP
widget \fIw\fR (in)
Name of the canvas alias (as returned by [\\$anyplot canvas]) in question\&.
.TP
float \fIx\fR (in)
X-coordinate to be mapped\&.
.TP
float \fIy\fR (in)
Y-coordinate to be mapped\&.
.RE
.sp
.TP
\fB::Plotchart::coords3DToPixel\fR \fIw\fR \fIx\fR \fIy\fR \fIz\fR
Return a list of pixel coordinates valid for the given window\&.
.RS
.TP
widget \fIw\fR (in)
Name of the canvas alias (as returned by [\\$anyplot canvas]) in question\&.
.TP
float \fIx\fR (in)
X-coordinate to be mapped\&.
.TP
float \fIy\fR (in)
Y-coordinate to be mapped\&.
.TP
float \fIy\fR (in)
Z-coordinate to be mapped\&.
.RE
.sp
.TP
\fB::Plotchart::polarCoordinates\fR \fIw\fR \fIradmax\fR
Set the extreme polar coordinates for window \fIw\fR\&. The angle always
runs from 0 to 360 degrees and the radius starts at 0\&. Hence you only
need to give the maximum radius\&.
\fINote:\fR If the viewport is not square, this procedure will not
adjust the extremes, so that would result in an elliptical plot\&. The
creation routine for a polar plot always determines a square viewport\&.
.RS
.TP
widget \fIw\fR (in)
Name of the canvas alias (as returned by [\\$anyplot canvas]) in question\&.
.TP
float \fIradmax\fR (in)
Maximum radius\&.
.RE
.sp
.TP
\fB::Plotchart::polarToPixel\fR \fIw\fR \fIrad\fR \fIphi\fR
Wrapper for a call to \fB::Plotchart::coordsToPixel\fR\&.
\fINote:\fR This procedure has been deprecated - you should
use the procedure \fB::Plotchart::coordsToPixel\fR instead\&.
.RS
.TP
widget \fIw\fR (in)
Name of the canvas alias (as returned by [\\$anyplot canvas]) in question\&.
.TP
float \fIrad\fR (in)
Radius of the point\&.
.TP
float \fIphi\fR (in)
Angle to the positive x-axis\&.
.RE
.sp
.TP
\fB::Plotchart::pixelToCoords\fR \fIw\fR \fIx\fR \fIy\fR
Return a list of world coordinates valid for the given window\&.
.RS
.TP
widget \fIw\fR (in)
Name of the canvas alias (as returned by [\\$anyplot canvas]) in question\&.
.TP
float \fIx\fR (in)
X-pixel to be mapped\&.
.TP
float \fIy\fR (in)
Y-pixel to be mapped\&.
.RE
.TP
\fB::Plotchart::pixelToIndex\fR \fIw\fR \fIx\fR \fIy\fR
Return the index of the pie segment containing the pixel coordinates
(x,y)
.RS
.TP
widget \fIw\fR (in)
Name of the canvas alias (as returned by [\\$anyplot canvas]) in question,
holding a piechart\&.
.TP
float \fIx\fR (in)
X-pixel to be mapped\&.
.TP
float \fIy\fR (in)
Y-pixel to be mapped\&.
.RE
.PP
.PP
Furthermore there is a routine to determine "pretty" numbers for use
with an axis:
.TP
\fB::Plotchart::determineScale\fR \fIxmin\fR \fIxmax\fR \fIinverted\fR
Determine "pretty" numbers from the given range and return a list
containing the minimum, maximum and stepsize that can be used for a
(linear) axis\&.
.RS
.TP
float \fIxmin\fR (in)
Rough minimum value for the scaling
.TP
float \fIxmax\fR (in)
Rough maximum value for the scaling\&.
.TP
boolean \fIinverted\fR (in)
Optional argument: if 1, then the returned list produces an
inverted axis\&. Defaults to 0 (the axis will be from minimum to maximum)
.RE
.TP
\fB::Plotchart::determineScaleFromList\fR \fIvalues\fR \fIinverted\fR
Determine "pretty" numbers from the given list of values and return a list
containing the minimum, maximum and stepsize that can be used for a
(linear) axis\&.
.RS
.TP
float \fIvalues\fR (in)
List of values that will be examined\&. May contain missing values (empty strings)
.TP
boolean \fIinverted\fR (in)
Optional argument: if 1, then the returned list produces an
inverted axis\&. Defaults to 0 (the axis will be from minimum to maximum)
.RE
.PP
.SH "MISSING VALUES"
Often data that need to be plotted contain gaps - in a series of
measurement data, they can occur because the equipment failed, a sample
was not collected correctly or for many other reasons\&. The
\fIPlotchart\fR handles these gaps by assuming that one or both
coordinates of such data points are an empty string:
.CS


    #
    # Create the plot with its x- and y-axes
    #
    set s [::Plotchart::createXYPlot \&.c {0\&.0 100\&.0 10\&.0} {0\&.0 100\&.0 20\&.0}]

    foreach {x y} {0\&.0 32\&.0 10\&.0 {} 25\&.0 60\&.0 78\&.0 11\&.0 } {
        $s plot series1 $x $y
    }

.CE
The effect varies according to the type of plot:
.IP \(bu
For xy-plots, radial plots and strip charts the missing data point
causes a gap in the line through the points\&.
.IP \(bu
For barchats, missing values are treated as if a value of zero was
given\&.
.IP \(bu
For time charts and Gantt charts missing values cause errors - there is
no use for them there\&.
.PP
.SH "OTHER OUTPUT FORMATS"
Besides output to the canvas on screen, the module is capable, via
\fBcanvas postscript\fR, of producing PostScript files\&. One may wonder
whether it is possible to extend this set of output formats and the
answer is "yes"\&. This section tries to sum up the aspects of using this
module for another sort of output\&.
.PP
One way you can create output files in a different format, is by
examining the contents of the canvas after everything has been drawn and
render that contents in the right form\&. This is probably the easiest
way, as it involves nothing more than the re-creation of all the
elements in the plot that are already there\&.
.PP
The drawback of that method is that you need to have a display, which is
not always the case if you run a CGI server or something like that\&.
.PP
An alternative is to emulate the canvas command\&. For this to work, you
need to know which canvas subcommands are used and what for\&. Obviously,
the \fIcreate\fR subcommand is used to create the lines, texts and
other items\&. But also the \fIraise\fR and \fIlower\fR subcommands are
used, because with these the module can influence the drawing order -
important to simulate a clipping rectangle around the axes\&. (The routine
DrawMask is responsible for this - if the output format supports proper
clipping areas, then a redefinition of this routine might just solve
this)\&.
.PP
Furthermore, the module uses the \fIcget\fR subcommand to find out the
sizes of the canvas\&. A more mundane aspect of this is that the module
currently assumes that the text is 14 pixels high and that 80 pixels in
width suffice for the axis' labels\&. No "hook" is provided to customise
this\&.
.PP
In summary:
.IP \(bu
Emulate the \fIcreate\fR subcommand to create all the items in the
correct format
.IP \(bu
Emulate the \fIcget\fR subcommand for the options -width and -height to
allow the correct calculation of the rectangle's position and size
.IP \(bu
Solve the problem of \fIraising\fR and \fIlowering\fR the items so
that they are properly clipped, for instance by redefining the
routine DrawMask\&.
.IP \(bu
Take care of the currently fixed text size properties
.PP
.SH "SPECIAL EFFECTS"
As an example of some special effects you can achieve, here is the
code for a plot where the area below the data line varies in colour:
.CS


canvas \&.c  -background white -width 400 -height 200
pack \&.c -fill both

set s [::Plotchart::createXYPlot \&.c {0\&.0 100\&.0 10\&.0} {0\&.0 100\&.0 20\&.0}]

$s background gradient green top-down

$s dataconfig series1 -filled up -fillcolour white

$s plot series1  0\&.0 20\&.0
$s plot series1 10\&.0 20\&.0
$s plot series1 30\&.0 50\&.0
$s plot series1 35\&.0 45\&.0
$s plot series1 45\&.0 25\&.0
$s plot series1 75\&.0 55\&.0
$s plot series1 100\&.0 55\&.0

$s plaintext 30\&.0 60\&.0 "Peak" south

.CE
The trick is to fill the background with a colour that changes from
green at the top to white at the bottom\&. Then the area above the data
line is filled with a white polygon\&. Thus the green shading varies with
the height of the line\&.
.SH "ROOM FOR IMPROVEMENT"
In this version there are a lot of things that still need to
be implemented:
.IP \(bu
More robust handling of incorrect calls (right now the procedures may
fail when called incorrectly):
.RS
.IP \(bu
The axis drawing routines can not handle inverse axes right now\&.
.IP \(bu
If the user provides an invalid date/time string, the routines simply
throw an error\&.
.RE
.PP
.SH RESIZING
\fBPlotchart\fR has not been designed to create plots and charts
that keep track of the data that are put in\&. This means that if an
application needs to allow the user to resize the window holding the
plot or chart, it must take care to redraw the complete plot\&.
.PP
The code below is a simple example of how to do that:
.CS


package require Plotchart

grid [canvas \&.c -background white] -sticky news
grid columnconfigure \&. 0 -weight 1
grid rowconfigure \&. 0 -weight 1

bind \&.c <Configure> {doResize}

proc doPlot {} {
    #
    # Clean up the contents (see also the note below!)
    #
    \&.c delete all

    #
    # (Re)draw the bar chart
    #
    set p [::Plotchart::createBarchart \&.c {x y z} {0 100 10} 3]
    $p plot R {10 30 40} red
    $p plot G {30 40 60} green
}

proc doResize {} {
    global redo

    #
    # To avoid redrawing the plot many times during resizing,
    # cancel the callback, until the last one is left\&.
    #
    if { [info exists redo] } {
        after cancel $redo
    }

    set redo [after 50 doPlot]
}
.CE
\fIPlease note:\fR
The code above will work fine for barcharts and many other types of
plots, but as \fBPlotchart\fR keeps some private information for
xy plots, more is needed in these cases\&. This actually requires a
command "destroyPlot" to take care of such details\&. A next version
of \fBPlotchart\fR may have that\&.
.PP
Alternatively, you can use the \fBxyplot\fR package which is built
on top of Plotchart\&. This package supports zooming in and zooming out,
as well as resizing the plot as a whole\&. Here is a small demonstration
program:
.CS


# xyplot_demo\&.tcl --
#     Demonstration of the xyplot package
#

package require xyplot

set xydata1 {}
set xydata2 {}
set xydata3 {}
set xydata4 {}
for { set i 0 } { $i < 1024 } { incr i } {
    lappend xydata1 [expr {$i-1000}] [expr {$i * sin($i/4096\&.0*3\&.1415*2) * (sin($i/256\&.0*3\&.1415*2))}]
    lappend xydata2 [expr {$i-1000}] [expr {$i * sin($i/4096\&.0*3\&.1415*2) * (sin($i/256\&.0*3\&.1415*2) + 0\&.25 * sin($i/256\&.0*3\&.1415*6))}]
    lappend xydata3 [expr {$i-1000}] [expr {$i * sin($i/4096\&.0*3\&.1415*2) * (sin($i/256\&.0*3\&.1415*2) + 0\&.25 * sin($i/256\&.0*3\&.1415*6) + 0\&.0625 * sin($i/256\&.0*3\&.1415*10))}]
    lappend xydata4 [expr {$i-1000}] [expr {$i * sin($i/4096\&.0*3\&.1415*2) * (sin($i/256\&.0*3\&.1415*2) + 0\&.25 * sin($i/256\&.0*3\&.1415*6) + 0\&.0625 * sin($i/256\&.0*3\&.1415*10) + 0\&.015625 * sin($i/256\&.0*3\&.1415*14))}]
}

set xyp [xyplot \&.xyp -xformat "%5\&.0f" -yformat "%5\&.0f" -title "XY plot testing" -background gray90]
pack $xyp -fill both -expand true

set s1 [$xyp add_data sf1 $xydata1 -legend "Serie 1 data" -color red]
set s2 [$xyp add_data sf2 $xydata2 -legend "Serie 2 data" -color green]
set s3 [$xyp add_data sf3 $xydata3 -legend "Serie 3 data" -color blue]
set s4 [$xyp add_data sf4 $xydata4 -legend "Serie 4 data" -color orange]

set xyp2 [xyplot \&.xyp2 -xticks 8 -yticks 4 -yformat %\&.2f -xformat %\&.0f]
pack $xyp2 -fill both -expand true

set s1 [$xyp2 add_data sf1 $xydata1]
set s2 [$xyp2 add_data sf2 $xydata2]
set s3 [$xyp2 add_data sf3 $xydata3]
set s4 [$xyp2 add_data sf4 $xydata4]

.CE
Zooming in is done by selecting a rectangle with the left mouse button
pressed\&. Zooming out is done by pressing the right mouse button\&. If you
resize the window, the canvases inside are resized too\&. If you zoom in,
you can scroll the plot via the scrollbars that are automatically
attached\&.
.SH "ZOOMING IN"
As the Plotchart package does not keep track of the data itself,
rescaling an existing plot - for instance when zooming in - would have
to be done by redefining the plot and redrawing the data\&. However, the
canvas widget offers a way out by scaling and moving items, so that
zooming in becomes a bit simpler\&.
.PP
Whether zooming is indeed useful, depends on the type of plot\&. Currently
it is defined for XY-plots only\&. The method is called "rescale" and
simply redraws the axes and scales and moves the data items so that they
conform to the new axes\&. The drawback is that any symbols are scaled by
the same amount\&. The rescale method works best for plots that only have
lines, not symbols\&.
.PP
The method works very simply:
.CS


   $p rescale {newxmin newxmax newxstep} {newymin newymax newystep}

.CE
.SH "CONFIGURATION OPTIONS AND OTHER COMMANDS"
The commands \fBplotconfig\fR and \fBplotstyle\fR can be used to set all
manner of options\&. The command \fBeraseplot\fR can be used to completely erase a plot or
chart\&. The syntax of these commands is:
.TP
\fB::Plotchart::plotconfig\fR \fIcharttype\fR \fIcomponent\fR \fIproperty\fR \fIvalue\fR
Set a new value for the property of a component in a particular chart or
plot type or query its current value\&. Changed properties only have effect for
the consecutive plots, not for the ones already created\&. Each argument is optional\&.
.sp
\fINote:\fR The \fBplotstyle\fR command offers a more
flexible way to control the configuration options\&.
.RS
.TP
string \fIcharttype\fR (in)
The type of chart or plot (see the configuration type that is mentioned
for each create command)\&. If not given or empty, a list of chart types
is returned\&. If it is given, the properties for that particular type are
used\&.
.TP
string \fIcomponent\fR (in)
The component of the plot/chart: leftaxis, rightaxis, background, margin
and so on\&. If not given or empty, a list of components is returned\&. If
it is given, the properties for that particular component will be set
for that particular type of chart\&.
.TP
string \fIproperty\fR (in)
The property of the component of the plot/chart: textcolor, thickness of
the axis line, etc\&. If not given or empty, a list of properties is returned\&. If
it is given, that particular property for that particular component
will be set for that particular type of chart\&.
.TP
string \fIvalue\fR (in)
The new value for the property\&. If empty, the current value is returned\&.
If the value is "default", the default value will be restored\&.
.sp
Note, that in some cases an empty value is useful\&. Use "none" in this
case - it can be useful for colours and for formats\&.
.RE
.TP
\fB::Plotchart::plotstyle\fR \fIsubcmd\fR \fIstyle\fR \fIargs\fR
Manipulate the \fIstyle\fR in which subsequent plots will be drawn\&. The
default style is "default", but you can define and load any number of
other styles\&.
.RS
.TP
string \fIsubcmd\fR (in)
The subcommand to be executed:
.RS
.IP \(bu
\fIconfigure\fR - this subcommand allows you to set the options per chart type\&.
It takes the same options as the \fBplotconfig\fR command\&.
.IP \(bu
\fIcurrent\fR - return the current style
.IP \(bu
\fIload\fR - make the given style the active style for subsequent plots and charts
.IP \(bu
\fInames\fR - return the list of currently defined styles
.RE
.TP
string \fIstyle\fR (in)
The name of the plot style to manipulate
.TP
list \fIargs\fR (in)
The new options for the style\&. Each option is described by: chart type, component of the chart,
property of the component and the new value for the property - see the \fBplotconfig\fR command for details\&.
.RE
.PP
Below is a detailed list of the components and properties:
.IP \(bu
Axes come in a wide variety:
.RS
.IP \(bu
leftaxis, rightaxis, topaxis, bottomaxis for the plots with a
rectangular shape\&.
.IP \(bu
xaxis, yaxis and zaxis are used for the 3D plots
.IP \(bu
axis, this represents the radial and tangential axes of a polar plot
.RE
.IP
All axes have the following properties:
.RS
.IP \(bu
color - the colour of the line and the tickmarks
.IP \(bu
thickness - the width of the line of the axis itself, not the tickmarks
.IP \(bu
ticklength - the length of the tickmarks in pixels\&. A positive value is
outward, a negative value is inward\&.
.IP \(bu
font - the font for the labels and the text at the axis
.IP \(bu
format - the format for rendering the (numerical) labels\&. For the time
axis it is the format for a date and time\&.
.IP \(bu
textcolor - the colour for the labels and the text\&.
.IP \(bu
labeloffset - space (in pixels) between the tickmark and the actual label
.IP \(bu
minorticks - number of minor tickmarks between the major tickmarks
.IP \(bu
shownumbers - show the numbers/labels or not\&.
.IP \(bu
showaxle - show the axis line or not\&.
.RE
.IP \(bu
The \fImargin\fR is important for the layout\&. Currently only the
rectangular plots allow the margins to be set: left, right, top and bottom\&.
The values are in pixels\&.
.IP \(bu
The \fItext\fR component is meant for any text appearing via the
plaintext subcommand\&. The properties are: textcolor, font and anchor
(positioning of the text relative to the given coordinates)\&.
.IP \(bu
The \fIbackground\fR has two properties: outercolor, the colour outside
of the actual plot, and innercolor, the colour inside the plot\&. (Note:
only "outercolor" has now been implemented)\&.
.IP \(bu
The \fImask\fR has one property only: draw\&. If set to 1, the default, white rectangles
are drawn to mimick the effects of clipping - excess data are made invisible this way\&.
Otherwise these rectangles are not drawn\&. This is useful to control
the layout more tightly, for instance with multiple plots in one canvas\&.
.IP \(bu
The \fItitle\fR component has the same properties as the \fItext\fR component
(but it is independent of that component)\&. It also has a \fIbackground\fR property:
If not set (or set to the empty string) this is the same as the outercolor property
of the \fIbackground\fR component, otherwise it is a separate colour\&.
.IP \(bu
The \fIlegend\fR has three properties: background, border and position\&.
See the legend subcommand for the meaning\&.
.IP \(bu
The \fIbar\fR components is used for all barchart-like plots and has
three properties: \fIbarwidth\fR (relative width of the bars in
relation to the items along the axis), \fIinnermargin\fR (the
relative width of the gaps between bars or groups of bars) and
the \fIoutline\fR colour\&.
.IP \(bu
The \fIlabels\fR component is used to describe the appearance of the
labels of piecharts and "spiral" piecharts\&. The properties are:
.RS
.IP \(bu
textcolor - colour of the label text
.IP \(bu
font - font to be used for the label text
.IP \(bu
placement - \fIout\fR of the circle or \fIin\fR the circle
.IP \(bu
sorted - the data are sorted in ascending order first
.IP \(bu
shownumbers - the labels are combined with the numbers according to the
format
.IP \(bu
format - the format to be used (defaults to: "%s (%g)")
if the numbers are to shown\&. The format command gets the label first,
then the number)
.IP \(bu
formatright - if given, the format to be used for labels and numbers
appearing to the right of the pie\&. The format command gets the
number first, then the label\&. (Defaults to "")
.RE
.IP \(bu
The \fIslice\fR component has properties to control the appearance of
the sections in the pie diagram:
.RS
.IP \(bu
outline - the colour of the line around the slices (default: black)
.IP \(bu
outlinewidth - width of the line around the slices (default: 1 pixel)
.IP \(bu
startangle - the angle w\&.r\&.t\&. positive x-axis where the first slice
starts
.IP \(bu
direction - the direction in which to draw the slices (default: +, that
is clockwise)
.RE
.IP \(bu
The table charts use the general components \fItitle\fR and \fImargin\fR
and further more the specific components \fIheader\fR, \fIoddrow\fR,
\fIevenrow\fR, \fIcell\fR and \fIframe\fR:
.RS
.IP \(bu
\fIheader\fR, \fIoddrow\fR and \fIevenrow\fR have the properties:
\fIbackground\fR, \fIfont\fR, \fIcolor\fR, \fIheight\fR and
\fIanchor\fR with obvious meanings\&.
.IP \(bu
The \fIcell\fR component defines in addition \fIleftspace\fR,
\fIrightspace\fR and \fItopspace\fR for fine-grained control of the spacing
inside the cell\&. These are not set via the \fIcellconfigure\fR
subcommand however\&.
.IP \(bu
Finally the \fIframe\fR component uses \fIcolor\fR, \fIouterwidth\fR
(for the width of the line surrounding the whole table) and
\fIinnerwidth\fR (for the width of lines separating columns and rows)\&.
.RE
.IP \(bu
The target diagram and the Taylor diagram use the \fIlimits\fR components
in addition to the various general components\&. The limits component has
one property: the color of the circles and circle segments\&.
.sp
For the Taylor diagram you can specify the color of the reference circles
via the \fIreference\fR component\&.
.PP
.TP
\fB::Plotchart::eraseplot\fR \fIanyplot\fR
Erase the plot/chart with all resources connected to it\&.
.RS
.TP
string \fIanyplot\fR (in)
The plot/chart command\&. All canvas items associated with this command and all
internal resources will be removed, including the plot/chart command itself\&.
.RE
.PP
See the examples in plotdemos7\&.tcl for its use\&.
.SH "SCROLLING FOR TIMECHARTS AND GANTT CHARTS"
For two types of plots automatic scrolling management has been
implemented: timecharts and Gantt charts\&. The subcommands \fIhscroll\fR
and \fIvscroll\fR associate (existing) scrollbars to the plot, in much
the same way as for text and canvas widgets\&.
.PP
Once the association is made, the scrollbars are automatically
updated if:
.IP \(bu
You add an item with a period wider than the current one\&.
.IP \(bu
You add a vertical line for a time beyond the current bounds\&.
.IP \(bu
You add an extra item beyond the number that was used to create the
chart\&.
.PP
For instance:
.CS


package require Plotchart

canvas \&.c -width 400 -height 200
scrollbar \&.y -orient vertical
scrollbar \&.x -orient horizontal

grid \&.c \&.y -sticky news
grid \&.x    -sticky news

source plotchart\&.tcl

set s [::Plotchart::createTimechart \&.c "1 january 2004"  "31 december 2004" 4]

$s period "Spring" "1 march 2004" "1 june 2004" green
$s period "Summer" "1 june 2004" "1 september 2004" yellow
$s vertline "1 jan" "1 january 2004"
$s vertline "1 apr" "1 april 2004"
$s vertline "1 jul" "1 july 2004"
$s vertline "1 oct" "1 october 2004"
$s vertline "1 jan" "1 january 2005"
$s vertline "1 apr" "1 april 2005"
$s vertline "1 jul" "1 july 2005"
$s milestone "Longest day" "21 july 2004"
$s milestone "Longest day 2" "21 july 2004"
$s milestone "Longest day 3" "21 july 2004"
$s milestone "Longest day 4" "21 july 2004"
$s milestone "Longest day 5" "21 july 2004"
$s milestone "Longest day 6" "21 july 2004"
$s title "Seasons (northern hemisphere)"

$s vscroll \&.y
$s hscroll \&.x

.CE
The original extent of the chart is from 1 january 2004 to 31 december
2004\&. But because of the addition of vertical lines in 2005 and
more items than was specified at the creation of the chart, both the
horizontal and the vertical scrollbar will be enabled\&.
.SH "SPECIALISED PLOTS"
Most of the plot and chart types described above have a fairly general use
and you simply prepares the data to be plotted yourself\&. This section describes
several plot types that are more specialised, in the sense that they have specific
purposes and you pass raw data that are then processed in the plotting routines\&.
.PP
Currently there are the following types:
.IP \(bu
Target diagrams are used to assess the capacity of numerical models to reproduce measurement
data\&. They are described in detail in:
.CS


Jason K\&. Joliff et al\&.
    Summary diagrams for coupled hydrodynamic-ecosystem model skill assessment
    Journal of Marine Systems 76 (2009) 64-82
    DOI: 10\&.1016/j\&.jmarsys\&.2008\&.05\&.014

.CE
.IP \(bu
Performance profiles are used for comparing the performance of numerical methods or
implementations thereof with each other\&. For more information:
.CS


Desmond Higham and Nicholas Higham
    Matlab Guide
    SIAM, 2005, Philadephia

.CE
.IP \(bu
Taylor diagrams are another graphical representation of how numerical models reproduce
measurement data\&. A detailed description appears in \fIhttps://en\&.wikipedia\&.org/wiki/Taylor_diagram\fR
.PP
Most of the general methods for XY-plots work for these plots as well, but their
creation and the methods to plot the data are very specific\&.
.TP
\fB::Plotchart::createTargetDiagram\fR \fIw\fR \fIlimits\fR \fIscale\fR
Create a new target diagram with circles indicating specific limits\&. The x-axis represents the
unbiased "root-mean-square difference" (typically varying between -1 and 1) and the y-axis
represents the normalised bias\&.
.sp
Data points closer to the origin represent better results than data points further away\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIlimits\fR (in)
List of radii for the circles that represent the limits (for instance: 0\&.5 and 0\&.7)
.TP
double \fIscale\fR (in)
Scale for the axes - defaults to 1, but if the model results are a poor fit, then
that may be too small a value\&. Both axes are scaled in the same way\&.
.RE
.sp
.TP
\fB$target\fR plot \fIseries\fR \fIxvalues\fR \fIyvalues\fR
The plot method takes two series of data of the same length, the first one
representing the model results, the second one represent the measurements
or, more general, the data that need to be reproduced\&.
.RS
.TP
string \fIseries\fR (in)
Name of the series (it will be plotted as a symbol that is configured via the
\fI$target dataconfig\fR command (see the XY-plot equivalent for an explanation)
.TP
list \fIxvalues\fR (in)
List of model results (missing values are represented as empty strings)
.TP
list \fIyvalues\fR (in)
List of measured values (missing values are represented as empty strings; only if
both the x and the y values are given, is the pair used in the computations)
.RE
.TP
\fB::Plotchart::createPerformanceProfile\fR \fIw\fR \fImax\fR
Create a diagram to show the performance of various numerical methods (or solvers)\&. The idea is
to first run these methods on a set of problems and measure their performance\&. The smaller the
number the better\&. Then these methods are compared via a so-called performance profile:
the data are scaled and ordered, such that the best method ends up highest\&.
.sp
Because of the nature of the plot all data must be given at once\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
float \fImax\fR (in)
Maximum value for the x-axis (the x-axis is the scaled performance of the series)\&.
.RE
.TP
\fB$performance\fR plot \fIseries_and_data_pairs\fR
Plot the data for each given method\&. The data are identified by the series name and the
appearance is controlled via prior dataconfig subcommand\&.
.RS
.TP
list \fIseries_and_data_pairs\fR (in)
List of series names and data\&. All data must be given at once\&.
.RE
.TP
\fB::Plotchart::createTaylorDiagram\fR \fIw\fR \fIradius_data\fR \fIargs\fR
Create a new Taylor diagram (one quadrant) with circles indicating the distance to the reference point\&.
.sp
The data points are given as the standard deviation and the correlation to the reference\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the plot\&.
.TP
list \fIradius_data\fR (in)
A list of the maximum radius for the standard deviation and the step size\&. Quarter circles are
drawn with the axis labels\&.
.RE
.sp
Currently one option is supported:
.RS
.TP
\fBreference\fR value
Reference value for the data points to be compared with\&. It appears as a dot at the x-axis\&.
Along with this dot circle segments are drawn at the same spacing as the axis labels to indicate
the distance of the data points from the reference\&.
.RE
.TP
\fB$taylor\fR plot \fIseries\fR \fIstdev\fR \fIcorr\fR
The plot method takes the standard deviation and the correlation to the reference as input
and draws a symbol as a representation\&. The standard deviation serves as the distance from the
origin and the correlation determines the angle\&.
.RS
.TP
string \fIseries\fR (in)
Name of the series (it will be plotted as a symbol that is configured via the
\fI$target dataconfig\fR command (see the XY-plot equivalent for an explanation)
.TP
float \fIstdev\fR (in)
Standard deviation of the data point
.TP
list \fIcorr\fR (in)
Correlation coefficient with the reference dataset
.RE
.TP
\fB::Plotchart::createHeatmap\fR \fIw\fR \fIrowlabels\fR \fIcolumnlabels\fR \fIargs\fR
Create a heatmap, i\&.e\&. a tableau of rectangles whose colours depend on some data\&. The row and
column labels are used as identifiers when filling in the data\&. The number of them determines the
size of the tableau\&.
.sp
The data are passed by row, by column or per individual cell\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the heatmap\&.
.TP
list \fIrowlabels\fR (in)
List of labels to display at each row\&. The labels also serve as identifiers\&.
.TP
list \fIcolumnlabels\fR (in)
List of labels to display at each column\&. The labels also serve as identifiers\&.
.TP
list \fIargs\fR (in)
Zero or more arguments to influence the size of the heatmap\&. See XY plot for more information\&.
.RE
.TP
\fB$heatmap\fR plot row \fIlabel\fR \fIdata\fR
Use the given data to fill the rectangles belonging to the row "label"\&.
.RS
.TP
string \fIlabel\fR (in)
String indicating which row to use\&.
.TP
list \fIdata\fR (in)
List of numerical data to be used for the colouring of the rectangles\&.
.RE
.TP
\fB$heatmap\fR plot column \fIlabel\fR \fIdata\fR
Use the given data to fill the rectangles belonging to the column "label"\&.
.RS
.TP
string \fIlabel\fR (in)
String indicating which column to use\&.
.TP
list \fIdata\fR (in)
List of numerical data to be used for the colouring of the rectangles\&.
.RE
.TP
\fB$heatmap\fR plot cell \fIrowlabel\fR \fIcolumnlabel\fR \fIvalue\fR
Use the given value to fill the rectangle belonging to the cell with the given row and column labels\&.
.RS
.TP
string \fIrowlabel\fR (in)
String indicating which row to use\&.
.TP
string \fIcolumnlabel\fR (in)
String indicating which column to use\&.
.TP
float \fIvalue\fR (in)
Value to be used for the colouring of the cell\&.
.RE
.TP
\fB$heatmap\fR scale values \fImin\fR \fImax\fR
Set the range for the values - they are mapped to a colour via linear interpolation\&.
.RS
.TP
float \fImin\fR (in)
Minimum value to be used\&.
.TP
float \fImax\fR (in)
Maximum value to be used\&.
.RE
.TP
\fB$heatmap\fR scale colours \fImincolour\fR \fImaxcolour\fR
Set the colours to be used for the minimum and the maximum values\&. The actual
colour is determined via linear interpolation of the RGB values\&.
.RS
.TP
string \fImincolour\fR (in)
Colour to be used at the minimum value\&.
.TP
string \fImaxcolour\fR (in)
Colour to be used at the maximum value\&.
.RE
.TP
\fB::Plotchart::createCircleplot\fR \fIw\fR \fIlabels\fR \fIargs\fR
Create a circle plot, i\&.e\&. a circle with labels that can be connected by coloured arcs\&.
Typical use: present the relationship between the items on the circle in a graphical way\&.
.sp
The connections can be drawn pair by pair\&.
.RS
.TP
widget \fIw\fR (in)
Name of the \fIexisting\fR canvas widget to hold the circle plot\&.
.TP
list \fIrowlabels\fR (in)
List of labels to display along the circle\&. Each label is accompanied by a filled dot\&.
.TP
list \fIargs\fR (in)
Zero or more arguments to influence the size of the circle plot\&. See XY plot for more information\&.
.RE
.TP
\fB$circleplot\fR connect \fIlabel1\fR \fIlabel2\fR \fIcolour\fR \fIwidth\fR
Connect the two labels via a coloured arc of given width (the arc is actually a parabola)\&.
.RS
.TP
string \fIlabel1\fR (in)
String indicating the first label to connect\&.
.TP
string \fIlabel2\fR (in)
String indicating the second label to connect\&.
.TP
string \fIcolour\fR (in)
Colour to use for the connected arc\&.
.TP
string \fIwidth\fR (in)
Width for the connected arc\&.
.RE
.TP
\fB$circleplot\fR modify \fIlabel\fR \fIargs\fR
Modify the appearance of the label and the accompanying dot\&.
.RS
.TP
string \fIlabel\fR (in)
String indicating which label to modify\&.
.TP
list \fIargs\fR (in)
List of key-value pairs:
.RS
.IP \(bu
\fI-textcolour colour\fR - colour of the text to be used (alternative: "-textcolor")
.IP \(bu
\fI-font font\fR - font for the text
.IP \(bu
\fI-dotcolour colour\fR - colour for the dot (alternative: "-dotcolor")
.RE
.RE
.PP
.SH "ADDING SPECIFIC PLOT METHODS"
The command \fIplotmethod\fR can be used to add new methods for a particular
plot or chart type\&. It is intended to help you develop specialised graphical displays\&.
.TP
\fB::Plotchart::plotmethod\fR \fIcharttype\fR \fImethodname\fR \fIplotproc\fR
Adds a new method for the given plot or chart type\&. The method is implemented by the
command or procedure given in the plotproc argument\&. The procedure will be called with
two extra arguments, the name of the created plot and the canvas widget that contains
(see the example below)\&.
.RS
.TP
string \fIcharttype\fR (in)
The type of plot or chart that the new method should be added to\&.
.TP
string \fImethodname\fR (in)
Name of the method to be used\&.
.TP
string \fIplotproc\fR (in)
Name of the command or procedure that implements the method\&.
.RE
.PP
.PP
Here is a trivial example of how to use this:
.CS


#
# The custom method "doodle" always adds the text "DOODLE"
# to the plot
#
proc doodle {p w x y} {
    $p plaintext $x $y "DOODLE"
}
::Plotchart::plotmethod xyplot doodle doodle

#
# Use it
pack [canvas \&.c]

set p [::Plotchart::createXYPlot \&.c {0 100 10} {0 20 5}]

$p doodle 40 10

.CE
.SH "TABLE CHARTS"
To show what you can do with table charts, here is a simple example that
plots a number of random data\&. The colours depend on the range that the
data belong to\&. For this the procedure \fIsetColor\fR is used\&.
.CS


package require Plotchart

pack [canvas \&.c -bg white -height 300] -fill both -expand yes

::Plotchart::plotconfig table frame outerwidth 3
::Plotchart::plotconfig table frame color red

set t [::Plotchart::createTableChart \&.c {"Column 1" "Column 2" "Column 3"} 80]


proc setColor {table widget row col value} {
    $table cellconfigure -background white -color black
    if { $value < 2\&.0 } {
        $table cellconfigure -background red -color white
    }
    if { $value > 6\&.0 } {
        $table cellconfigure -background green
    }

    return [format "%6\&.3f" $value]
}

# Command must already exist \&.\&.\&.
$t formatcommand setColor

$t title "Demonstration of table charts"
$t separator

for {set i 0} {$i < 9} {incr i} {
    set row {}

    for {set j 0} {$j < 3} {incr j} {
        lappend row [expr {10\&.0 * rand()}]
    }

    if { $i == 3 } {
        $t separator
    }

    $t row $row
}
.CE
.SH "CONTROL DISPLAYS"
TODO
.SH "USING DATE/TIME LABELS"
The options -timeformat and -gmt are used to control the display of date/time
labels along the x-axis for those plot types for which it makes sense\&. These
options were implemented to take care of date/time labels for stripcharts,
as you can also use custom labels (the option -xlabels) if the axis is "static"\&.
Since this is not the case for stripcharts, this was not an option (Tcllib/Tklib bug 3613718)\&.
You can also specify the -locale option to get a localised date/time label\&.
The example below illustrates how to use the -timeformat option\&. The -gmt option
merely suppresses the handling of daylight saving time by the [clock format] command\&.
.CS


package require Plotchart

pack [canvas \&.c -width 500 -bg white]

#
# Note that we need to present the x values as clock seconds
#
set start [clock scan  "0:00"]
set stop  [clock scan "10:00"]
set s [Plotchart::createStripchart \&.c [list $start $stop 7200] {0 10 1} -timeformat "%H:%M"]

# With a locale like "de":
#set s [Plotchart::createStripchart \&.c [list $start $stop 7200] {0 10 1} -timeformat "%H:%M" -locale de]

foreach {x y} {0 0 2 5 5 2 9 9 12 10} {
    set x [expr {$start + 3600 * $x}] ;# Convert hour to clock seconds
    $s plot a $x $y
}
.CE
The \fIplot\fR subcommand simply interprets the x and y data as straightforward
numbers, so that you need to do the conversion from date/time to "clock seconds" yourself\&.
.SH "ARRANGING MULTIPLE PLOTS IN A CANVAS"
The command \fIplotpack\fR allows you to copy the contents of a plot
into another canvas widget\&. This canvas widget does not act as a
composite plot, but it can be saved as a PostScript file for instance:
Note: the command simply takes a snapshot of the plots/charts as they
are at that moment\&.
.TP
\fB::Plotchart::plotpack\fR \fIw\fR \fIdir\fR \fIargs\fR
Copy the contents of the plots/charts into another widget, in a manner
similar to the \fIpack\fR geometry manager\&.
.RS
.TP
widget \fIw\fR (in)
The name of the canvas widget to copy the plots/charts into
.TP
string \fIdir\fR (in)
The direction of the arrangement - top, left, bottom or right
.TP
list \fIargs\fR (in)
List of plots/charts to be copied\&.
.RE
.PP
For example:
.CS


    set p1 [createXYPlot \&.\&.\&.]
    set p2 [createBarchart \&.\&.\&.]

    \&.\&.\&. fill the plots \&.\&.\&.

    toplevel \&.t
    pack [canvas \&.t\&.c2 -width \&.\&.\&.]

    #
    # Copy the two plots above each other in the new canvas
    #
    plotpack \&.t\&.c2 top $p1 $p2

.CE
A different method is to use the \fI-box\fR and \fI-axesbox\fR options
when creating the plot\&. These control the area in the canvas where the
plot or chart will be drawn\&.
.PP
The \fI-box\fR option takes as its value a list of four numbers:
.IP \(bu
X-coordinate of the upper-left corner of the area that will contain the
plot or chart (simply a canvas coordinate)
.IP \(bu
Y-coordinate of the upper-left corner
.IP \(bu
Width of the area
.IP \(bu
Height of the area
.PP
Specifying the width and height makes it easier to reposition the area
with respect to other plots\&.
.PP
The \fI-axesbox\fR option is meant to make aligning the axes of a
plot with those of other plots easier\&. The option takes a list of
six arguments:
.IP \(bu
Identification of the plot with respect to which it should be
positioned (the command returned by the creation command)\&.
.IP \(bu
The anchor position that should be used (n, nw, \&.\&.\&.)
.IP \(bu
X-coordinate of the upper-left corner of the area that will contain the
plot or chart\&. This coordinates is taken relative to the
\fIanchor position\fR
.IP \(bu
Y-coordinate of the upper-left corner
.IP \(bu
Width of the axis area
.IP \(bu
Height of the axis area
.PP
With this option the area the axes occupy is first determined and the
complete area is derived from the margins\&.
.PP
For example:
.CS


    set p2 [::Plotchart::createXYPlot \&.c {0 10 1} {-5 5 2\&.5} -axesbox [list $p1 ne 0 0 200 200]]

.CE
will create a second plot whose left axis coincides with the right axis
of plot "\\$p1" and the top of the axis is at the same heigt as well -
because the axes are positioned at a point 0 pixels to the left and 0
pixels below the north-east corner\&.
.SH "INTERACTIVE USE"
\fIPlotchart\fR has several features for interactive use (cf\&. \fBNOTES ON TAGS\fR):
.IP \(bu
The legend can be moved around by pressing mouse button 1 in the legend's box and
keeping it down\&.
.IP \(bu
You can use the \fIbindplot\fR and \fIbindlast\fR commands to
define actions that are to be taken when the user clicks on an element of the plot or chart\&.
(see below, see also the sample code in plotdemos12\&.tcl)
.IP \(bu
\fIPiecharts\fR can show an "exploded" segment that you can select with mouse button 1\&.
.PP
If you require different forms of interaction, not covered by \fIPlotchart\fR itself,
you can use the tags on the various canvas elements to define other bindings\&.
.PP
The \fIbindplot\fR and \fIbindlast\fR are defined as follows:
.TP
\fB$anyplot\fR bindplot \fIevent\fR \fIcommand\fR \fIargs\fR
Register a command that will be run whenever the given event occurs in the plot\&.
.RS
.TP
string \fIevent\fR
The event that you want to bind the command to
.TP
string \fIcommand\fR
Name of the command/procedure that you want to run\&. The following arguments
are prefixed: the x- and y-coordinates of the point in the plot (the world coordinates!),
so that the procedure has the signature:
.CS


    cmd $xworld $yworld $string1 $string2 $string3

.CE
.IP
assuming the argument "command" is: {cmd A B C}
.RE
.TP
\fB$anyplot\fR bindlast \fIseries\fR \fIevent\fR \fIcommand\fR
Register a command that will be run when the event occurs within the neighbourhood of
the last point added to the given series\&. (You can use directly after inserting
a data point\&. All such commands will remain active)\&.
.RS
.TP
string \fIevent\fR
The event that you want to bind the command to
.TP
list \fIcommand\fR
Name of the command/procedure that you want to run\&. The following arguments
are prefixed: the x- and y-coordinates of the point in the plot (the world coordinates!),
so that the procedure has the signature:
.CS


    cmd $xworld $yworld $string1 $string2 $string3

.CE
.IP
assuming the argument "command" is: {cmd A B C}
.RE
.PP
Here is an example - show the values of the data points in an annotation
(from the sample code in plotdemos12\&.tcl):
.CS


#
# Procedure for showing an annotation
#
proc showAnnotation {xcoord ycoord plot w} {

    $plot balloon $xcoord $ycoord "Data point: [format "%\&.3f, %\&.3f" $xcoord $ycoord]" north

    after 2000 [list removeAnnotation $w]
}

#
# Procedure for erase an annotation
#
proc removeAnnotation {w} {

    # Use the tags to remove all annotations
    $w delete BalloonText
    $w delete BalloonFrame
}

#
# Create a simple plot and a label
#
pack [canvas \&.c -bg white] [label \&.l -textvariable coords]

set p [::Plotchart::createXYPlot \&.c {0 1000 200} {0 10 1}]

$p dataconfig series1 -type both -symbol cross

foreach x {1 2 5 10 20 50 100 200 500 1000} {
    $p plot series1 $x [expr {log($x)}]

    #
    # Show the annotation for each data point
    #
    $p bindlast series1 <Enter> [list showAnnotation $p %W]
}

.CE
.SH "NOTES ON TAGS"
The implementation of \fIPlotchart\fR relies heavily on the canvas's
ability to identify graphical objects by tags and to change the drawing order of
the objects\&. This section documents the tags that are used\&.
.PP
(\fINote:\fR the tags are not always used consistently - see the notes appearing with
the various tags\&. This section describes the current state\&.)
.PP
\fIGeneral graphical objects:\fR
.IP \(bu
\fImask\fR - Used to manipulate the opaque rectangles that ensure data outside
the viewport are not shown\&.
.IP \(bu
\fItopmask, horizmask, vertmask\fR - specialised tags, used for scrollable plots\&.
.IP \(bu
\fItitle\fR - Used for title strings\&.
.IP \(bu
\fIBalloonText, BalloonFrame\fR - Used to manipulate balloon text\&.
.IP \(bu
\fIPlainText\fR - Used to manipulate ordinary text without any decoration\&.
.IP \(bu
\fIbackground\fR - Tag used for gradient and image backgrounds (and for gradient-filled bars)\&.
.IP \(bu
\fIxaxis, yaxis\fR - Tags used for all objects related to horizontal or vertical axes\&.
(also: both for numerical axes and axes with labels as in barcharts)\&.
Note, however, that the \fItext\fR along the axes has no particular tag\&.
.IP \(bu
\fIraxis\fR - Tag used for all objects related to a \fIright\fR axis\&.
.IP \(bu
\fItaxis\fR - Tag used for all objects related to a \fItime\fR axis\&.
.IP \(bu
\fIaxis3d\fR - Tag used for 3D axes
.IP \(bu
\fIxtickline, ytickline\fR - Tags used for ticklines\&.
.IP \(bu
\fIlegend, legengb, legendobj\fR - Tags used for the legend\&. The latter is used to manipulate
the legend as a whole\&.
.IP \(bu
\fIlegend_series\fR - Tag used to control the appearance of the legend entry ("series" should
be replaced by the series name)\&.
.IP \(bu
\fIobject\fR - used as standard tag for all objects drawn with the \fB::Plotchart::drawobject\fR
procedure\&. Tags given at object creation time are added to this tag\&.
.PP
\fIXY-plots (all types of axes):\fR
.IP \(bu
\fIdata\fR - The general tag to identify graphical objects associated with data\&.
\fIdata_seriesname\fR - The tag specific to a data series ("seriesname" should be replaced)\&.
\fIband\fR - The horizontal or vertical band drawn with the xband otr yband subcommands have this tag
by the actual name)\&.
\fIxtext\fR - The text labelling the xaxis\&.
\fIytext\fR - The text labelling hte yaxis horizontically\&.
\fIvtext\fR - The text labelling the yaxis vertically\&.
.PP
Items such as labelled dots only have the "data" tag\&.
.PP
\fIPiecharts and spiral pies:\fR
.IP \(bu
\fIsegment_segmentnumber\fR - The tag identifying the segment, the string "segmentnumber" should
be replaced by the actual number\&. This tag is used to explode the segments\&.
.PP
\fIBarcharts:\fR
.PP
Barcharts use the same tags as xy-plots (but for gradient-filled bars the data_seriesname is not used)\&.
.PP
\fIHistograms and isometric plots:\fR
.PP
Currently the only tag used is "data"\&.
.PP
\fITime-charts:\fR
.PP
As these plots are scrollable, several tags are used specific to the scrolling:
vertscroll, horizscroll, below, lowest, above, timeline, tline\&.
Each item also has a tag of the form "item_number",
where "number" is to be replaced by the actual sequence number of the item\&.
.PP
\fIGantt charts:\fR
.PP
In addition to the tags described for the time-charts, the following tags are used:
description, completed, summary and summarybar\&.
.PP
\fIRadial charts and polar plots:\fR
.PP
Currently the radial lines indicating the grid have no tags\&. The graphical objects associated with
data only have the "data" tag\&.
.PP
\fIWindroses:\fR
.PP
Only the tag \fIdata_number\fR is currently used ("number" should be replaced by the
sequence number of the data, starting at 0\&.
.PP
\fIContour and isoline plots:\fR
.PP
No tags are used\&.
.PP
\fI3D plots and 3D ribbon plots:\fR
.PP
Tags are used for the axes and for the data objects:
.IP \(bu
\fIdata\fR - The general tag to identify graphical objects associated with data\&.
\fIline\fR - The tag used for lines created with the plotline subcommand\&.
.PP
.PP
\fICharts decorated with 3D effects:\fR
.PP
The following tags are used to identify various types of graphical objects: platform, background, d, u,
ticklines\&.
.PP
The text associated with the bars has no tags\&. The ribbon lines and areas have no tags either\&.
.PP
\fITables:\fR
.PP
Tags used are: frame, cellbg and celltext
.PP
\fISpecial plot types (target diagrams, Taylor diagrams:\fR
.PP
Tags used are: limits, limit_labels, reference
\fIIn addition:\fR
To implement multiple plots and charts in a single canvas, all items
also get as a tag the plot/chart they belong to\&. This enables Plotchart
to manipulate only those items\&.
.SH "TODO - SOME PRIVATE NOTES"
I have the following wishlist:
.IP \(bu
Isometric plots - allow new items to be implemented easily\&.
.IP \(bu
A general 3D viewer - emphasis on geometry, not a ray-tracer\&.
.IP \(bu
Several improvements for boxplots:
.RS
.IP \(bu
Height of the box scales with the logarithm of the number of points
.IP \(bu
Marker line to indicate a "current" value
.IP \(bu
Box drawn from quantiles
.RE
.PP
<
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIplotchart\fR of the
\fITklib Trackers\fR [http://core\&.tcl\&.tk/tklib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
<
.SH COPYRIGHT
.nf
Copyright (c) 2022 Arjen Markus <arjenmarkus@users\&.sourceforge\&.net>

.fi
