/*
 *  hap -- a mail notification program
 * 
 *  copyright 1995 by Eric Fischer, etaoin@uchicago.edu
 * 
 *  copies of hap may be redistributed under the terms of the
 *  GNU public license, copies of which are available from
 *  the Free Software Foundation, 59 Temple Place, Boston, MA
 *  02111 USA.
 *
 */

#include "hap.h"

/**************************************************************************

   ALIVE -- check whether our session still exists

**************************************************************************/

/* return true if the process 'shell' (a global) is still around.
   return false if it's passed on.

   the version 7 manual doesn't explicitly say what happens when you
   send signal 0 to a process, so I don't know if this will work on such
   machines.  4.2BSD and 4.3BSD explicitly allow it for process ID checking,
   as does the DomainOS manual for, I think, SVr3.
*/

int
alive()
{
	int ret;

	errno = 0;
	ret = kill (shell, 0);  /* send no signal, just see if we can */

	if (ret == 0) {
		return 1;   /* no error: it's still there */
	} else {
		return 0;   /* can't send signal: process must be dead */
	}
}
