/*
 *  hap -- a mail notification program
 * 
 *  copyright 1995 by Eric Fischer, etaoin@uchicago.edu
 * 
 *  copies of hap may be redistributed under the terms of the
 *  GNU public license, copies of which are available from
 *  the Free Software Foundation, 59 Temple Place, Boston, MA
 *  02111 USA.
 *
 */

#include "hap.h"

/*************************************************************************

   DISCOVERING THEIR SECRET IDENTITY

*************************************************************************/

/* find out the name of the user.  returns a pointer to static data. */

/* notice that strdupe() is called *before* checking for null, so it's
   important that strdupe return null when that's what it's passed,
   rather than trying to duplicate whatever's sitting at the bottom
   of memory.
*/

char *
whoami()
{
	static char *ret = 0;
	struct passwd *p;

	if (ret) return ret;

	ret = strdupe (getlogin());
	if (ret) return ret;

	p = getpwuid (getuid());
	if (p) ret = strdupe (p->pw_name);
	if (ret) return ret;

	return "who-are-you?";
}

