// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_CLIENT_H

#include "google/cloud/aiplatform/v1/featurestore_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The service that handles CRUD and List for resources for Featurestore.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class FeaturestoreServiceClient {
 public:
  explicit FeaturestoreServiceClient(
      std::shared_ptr<FeaturestoreServiceConnection> connection,
      Options opts = {});
  ~FeaturestoreServiceClient();

  ///@{
  /// @name Copy and move support
  FeaturestoreServiceClient(FeaturestoreServiceClient const&) = default;
  FeaturestoreServiceClient& operator=(FeaturestoreServiceClient const&) =
      default;
  FeaturestoreServiceClient(FeaturestoreServiceClient&&) = default;
  FeaturestoreServiceClient& operator=(FeaturestoreServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(FeaturestoreServiceClient const& a,
                         FeaturestoreServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(FeaturestoreServiceClient const& a,
                         FeaturestoreServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a new Featurestore in a given project and location.
  ///
  /// @param parent  Required. The resource name of the Location to create Featurestores.
  ///  Format:
  ///  `projects/{project}/locations/{location}`
  /// @param featurestore  Required. The Featurestore to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Featurestore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L335}
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  CreateFeaturestore(
      std::string const& parent,
      google::cloud::aiplatform::v1::Featurestore const& featurestore,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Featurestore in a given project and location.
  ///
  /// @param parent  Required. The resource name of the Location to create Featurestores.
  ///  Format:
  ///  `projects/{project}/locations/{location}`
  /// @param featurestore  Required. The Featurestore to create.
  /// @param featurestore_id  Required. The ID to use for this Featurestore, which will become the final
  ///  component of the Featurestore's resource name.
  ///  @n
  ///  This value may be up to 60 characters, and valid characters are
  ///  `[a-z0-9_]`. The first character cannot be a number.
  ///  @n
  ///  The value must be unique within the project and location.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Featurestore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L335}
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  CreateFeaturestore(
      std::string const& parent,
      google::cloud::aiplatform::v1::Featurestore const& featurestore,
      std::string const& featurestore_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Featurestore in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateFeaturestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Featurestore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L335}
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  CreateFeaturestore(
      google::cloud::aiplatform::v1::CreateFeaturestoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Featurestore.
  ///
  /// @param name  Required. The name of the Featurestore resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Featurestore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  /// [google.cloud.aiplatform.v1.GetFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L361}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Featurestore> GetFeaturestore(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Featurestore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetFeaturestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Featurestore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  /// [google.cloud.aiplatform.v1.GetFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L361}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Featurestore> GetFeaturestore(
      google::cloud::aiplatform::v1::GetFeaturestoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Featurestores in a given project and location.
  ///
  /// @param parent  Required. The resource name of the Location to list Featurestores.
  ///  Format:
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Featurestore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  /// [google.cloud.aiplatform.v1.ListFeaturestoresRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L373}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Featurestore> ListFeaturestores(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Featurestores in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListFeaturestoresRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Featurestore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  /// [google.cloud.aiplatform.v1.ListFeaturestoresRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L373}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Featurestore> ListFeaturestores(
      google::cloud::aiplatform::v1::ListFeaturestoresRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Featurestore.
  ///
  /// @param featurestore  Required. The Featurestore's `name` field is used to identify the
  ///  Featurestore to be updated. Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// @param update_mask  Field mask is used to specify the fields to be overwritten in the
  ///  Featurestore resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then only the non-empty fields present in the
  ///  request will be overwritten. Set the update_mask to `*` to override all
  ///  fields.
  ///  @n
  ///  Updatable fields:
  ///  @n
  ///    * `labels`
  ///    * `online_serving_config.fixed_node_count`
  ///    * `online_serving_config.scaling`
  ///    * `online_storage_ttl_days`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Featurestore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  /// [google.cloud.aiplatform.v1.UpdateFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L448}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  UpdateFeaturestore(
      google::cloud::aiplatform::v1::Featurestore const& featurestore,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Featurestore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateFeaturestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Featurestore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Featurestore]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore.proto#L35}
  /// [google.cloud.aiplatform.v1.UpdateFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L448}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  UpdateFeaturestore(
      google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Featurestore. The Featurestore must not contain any
  /// EntityTypes or `force` must be set to true for the request to succeed.
  ///
  /// @param name  Required. The name of the Featurestore to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L473}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeaturestore(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Featurestore. The Featurestore must not contain any
  /// EntityTypes or `force` must be set to true for the request to succeed.
  ///
  /// @param name  Required. The name of the Featurestore to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// @param force  If set to true, any EntityTypes and Features for this Featurestore will
  ///  also be deleted. (Otherwise, the request will only work if the Featurestore
  ///  has no EntityTypes.)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L473}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeaturestore(std::string const& name, bool force, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Featurestore. The Featurestore must not contain any
  /// EntityTypes or `force` must be set to true for the request to succeed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteFeaturestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteFeaturestoreRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L473}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeaturestore(
      google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new EntityType in a given Featurestore.
  ///
  /// @param parent  Required. The resource name of the Featurestore to create EntityTypes.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// @param entity_type  The EntityType to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.EntityType] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L790}
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::EntityType>> CreateEntityType(
      std::string const& parent,
      google::cloud::aiplatform::v1::EntityType const& entity_type,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new EntityType in a given Featurestore.
  ///
  /// @param parent  Required. The resource name of the Featurestore to create EntityTypes.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// @param entity_type  The EntityType to create.
  /// @param entity_type_id  Required. The ID to use for the EntityType, which will become the final
  ///  component of the EntityType's resource name.
  ///  @n
  ///  This value may be up to 60 characters, and valid characters are
  ///  `[a-z0-9_]`. The first character cannot be a number.
  ///  @n
  ///  The value must be unique within a featurestore.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.EntityType] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L790}
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::EntityType>> CreateEntityType(
      std::string const& parent,
      google::cloud::aiplatform::v1::EntityType const& entity_type,
      std::string const& entity_type_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new EntityType in a given Featurestore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateEntityTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.EntityType] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L790}
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::EntityType>> CreateEntityType(
      google::cloud::aiplatform::v1::CreateEntityTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single EntityType.
  ///
  /// @param name  Required. The name of the EntityType resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  /// [google.cloud.aiplatform.v1.GetEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L816}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::EntityType> GetEntityType(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single EntityType.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetEntityTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  /// [google.cloud.aiplatform.v1.GetEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L816}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::EntityType> GetEntityType(
      google::cloud::aiplatform::v1::GetEntityTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists EntityTypes in a given Featurestore.
  ///
  /// @param parent  Required. The resource name of the Featurestore to list EntityTypes.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.EntityType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  /// [google.cloud.aiplatform.v1.ListEntityTypesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L830}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::EntityType> ListEntityTypes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists EntityTypes in a given Featurestore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListEntityTypesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.EntityType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  /// [google.cloud.aiplatform.v1.ListEntityTypesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L830}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::EntityType> ListEntityTypes(
      google::cloud::aiplatform::v1::ListEntityTypesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single EntityType.
  ///
  /// @param entity_type  Required. The EntityType's `name` field is used to identify the EntityType
  ///  to be updated. Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// @param update_mask  Field mask is used to specify the fields to be overwritten in the
  ///  EntityType resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then only the non-empty fields present in the
  ///  request will be overwritten. Set the update_mask to `*` to override all
  ///  fields.
  ///  @n
  ///  Updatable fields:
  ///  @n
  ///    * `description`
  ///    * `labels`
  ///    * `monitoring_config.snapshot_analysis.disabled`
  ///    * `monitoring_config.snapshot_analysis.monitoring_interval_days`
  ///    * `monitoring_config.snapshot_analysis.staleness_days`
  ///    * `monitoring_config.import_features_analysis.state`
  ///    * `monitoring_config.import_features_analysis.anomaly_detection_baseline`
  ///    * `monitoring_config.numerical_threshold_config.value`
  ///    * `monitoring_config.categorical_threshold_config.value`
  ///    * `offline_storage_ttl_days`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  /// [google.cloud.aiplatform.v1.UpdateEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L905}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::EntityType> UpdateEntityType(
      google::cloud::aiplatform::v1::EntityType const& entity_type,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single EntityType.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateEntityTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.EntityType]: @googleapis_reference_link{google/cloud/aiplatform/v1/entity_type.proto#L35}
  /// [google.cloud.aiplatform.v1.UpdateEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L905}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::EntityType> UpdateEntityType(
      google::cloud::aiplatform::v1::UpdateEntityTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single EntityType. The EntityType must not have any Features
  /// or `force` must be set to true for the request to succeed.
  ///
  /// @param name  Required. The name of the EntityType to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L935}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteEntityType(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single EntityType. The EntityType must not have any Features
  /// or `force` must be set to true for the request to succeed.
  ///
  /// @param name  Required. The name of the EntityType to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// @param force  If set to true, any Features for this EntityType will also be deleted.
  ///  (Otherwise, the request will only work if the EntityType has no Features.)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L935}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteEntityType(std::string const& name, bool force, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single EntityType. The EntityType must not have any Features
  /// or `force` must be set to true for the request to succeed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteEntityTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteEntityTypeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L935}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteEntityType(
      google::cloud::aiplatform::v1::DeleteEntityTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Feature in a given EntityType.
  ///
  /// @param parent  Required. The resource name of the EntityType or FeatureGroup to create a
  ///  Feature. Format for entity_type as parent:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  ///  Format for feature_group as parent:
  ///  `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// @param feature  Required. The Feature to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Feature] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L955}
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      std::string const& parent,
      google::cloud::aiplatform::v1::Feature const& feature, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Feature in a given EntityType.
  ///
  /// @param parent  Required. The resource name of the EntityType or FeatureGroup to create a
  ///  Feature. Format for entity_type as parent:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  ///  Format for feature_group as parent:
  ///  `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// @param feature  Required. The Feature to create.
  /// @param feature_id  Required. The ID to use for the Feature, which will become the final
  ///  component of the Feature's resource name.
  ///  @n
  ///  This value may be up to 128 characters, and valid characters are
  ///  `[a-z0-9_]`. The first character cannot be a number.
  ///  @n
  ///  The value must be unique within an EntityType/FeatureGroup.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Feature] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L955}
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      std::string const& parent,
      google::cloud::aiplatform::v1::Feature const& feature,
      std::string const& feature_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Feature in a given EntityType.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateFeatureRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Feature] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L955}
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a batch of Features in a given EntityType.
  ///
  /// @param parent  Required. The resource name of the EntityType to create the batch of
  ///  Features under. Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// @param requests  Required. The request message specifying the Features to create. All
  ///  Features must be created under the same parent EntityType. The `parent`
  ///  field in each child request message can be omitted. If `parent` is set in a
  ///  child request, then the value must match the `parent` value in this request
  ///  message.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.BatchCreateFeaturesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchCreateFeaturesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L983}
  /// [google.cloud.aiplatform.v1.BatchCreateFeaturesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1005}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::BatchCreateFeaturesResponse>>
  BatchCreateFeatures(
      std::string const& parent,
      std::vector<google::cloud::aiplatform::v1::CreateFeatureRequest> const&
          requests,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a batch of Features in a given EntityType.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.BatchCreateFeaturesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.BatchCreateFeaturesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchCreateFeaturesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L983}
  /// [google.cloud.aiplatform.v1.BatchCreateFeaturesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1005}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::BatchCreateFeaturesResponse>>
  BatchCreateFeatures(
      google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Feature.
  ///
  /// @param name  Required. The name of the Feature resource.
  ///  Format for entity_type as parent:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  ///  Format for feature_group as parent:
  ///  `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Feature])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.GetFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1014}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Feature> GetFeature(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetFeatureRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Feature])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.GetFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1014}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Feature> GetFeature(
      google::cloud::aiplatform::v1::GetFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Features in a given EntityType.
  ///
  /// @param parent  Required. The resource name of the Location to list Features.
  ///  Format for entity_type as parent:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  ///  Format for feature_group as parent:
  ///  `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Feature], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.ListFeaturesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1032}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Feature> ListFeatures(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Features in a given EntityType.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListFeaturesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Feature], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.ListFeaturesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1032}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Feature> ListFeatures(
      google::cloud::aiplatform::v1::ListFeaturesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Feature.
  ///
  /// @param feature  Required. The Feature's `name` field is used to identify the Feature to be
  ///  updated.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
  ///  `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
  /// @param update_mask  Field mask is used to specify the fields to be overwritten in the
  ///  Features resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then only the non-empty fields present in the
  ///  request will be overwritten. Set the update_mask to `*` to override all
  ///  fields.
  ///  @n
  ///  Updatable fields:
  ///  @n
  ///    * `description`
  ///    * `labels`
  ///    * `disable_monitoring` (Not supported for FeatureRegistry Feature)
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Feature])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.UpdateFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1240}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Feature> UpdateFeature(
      google::cloud::aiplatform::v1::Feature const& feature,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateFeatureRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Feature])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.UpdateFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1240}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Feature> UpdateFeature(
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Feature.
  ///
  /// @param name  Required. The name of the Features to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
  ///  `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1268}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeature(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteFeatureRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteFeatureRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1268}
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeature(
      google::cloud::aiplatform::v1::DeleteFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Imports Feature values into the Featurestore from a source storage.
  ///
  /// The progress of the import is tracked by the returned operation. The
  /// imported features are guaranteed to be visible to subsequent read
  /// operations after the operation is marked as successfully done.
  ///
  /// If an import operation fails, the Feature values returned from
  /// reads and exports may be inconsistent. If consistency is
  /// required, the caller must retry the same import request again and wait till
  /// the new operation returned is marked as successfully done.
  ///
  /// There are also scenarios where the caller can cause inconsistency.
  ///
  ///  - Source data for import contains multiple distinct Feature values for
  ///    the same entity ID and timestamp.
  ///  - Source is modified during an import. This includes adding, updating, or
  ///  removing source data and/or metadata. Examples of updating metadata
  ///  include but are not limited to changing storage location, storage class,
  ///  or retention policy.
  ///  - Online serving cluster is under-provisioned.
  ///
  /// @param entity_type  Required. The resource name of the EntityType grouping the Features for
  ///  which values are being imported. Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.ImportFeatureValuesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ImportFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L492}
  /// [google.cloud.aiplatform.v1.ImportFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L565}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::ImportFeatureValuesResponse>>
  ImportFeatureValues(std::string const& entity_type, Options opts = {});

  // clang-format off
  ///
  /// Imports Feature values into the Featurestore from a source storage.
  ///
  /// The progress of the import is tracked by the returned operation. The
  /// imported features are guaranteed to be visible to subsequent read
  /// operations after the operation is marked as successfully done.
  ///
  /// If an import operation fails, the Feature values returned from
  /// reads and exports may be inconsistent. If consistency is
  /// required, the caller must retry the same import request again and wait till
  /// the new operation returned is marked as successfully done.
  ///
  /// There are also scenarios where the caller can cause inconsistency.
  ///
  ///  - Source data for import contains multiple distinct Feature values for
  ///    the same entity ID and timestamp.
  ///  - Source is modified during an import. This includes adding, updating, or
  ///  removing source data and/or metadata. Examples of updating metadata
  ///  include but are not limited to changing storage location, storage class,
  ///  or retention policy.
  ///  - Online serving cluster is under-provisioned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ImportFeatureValuesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.ImportFeatureValuesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ImportFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L492}
  /// [google.cloud.aiplatform.v1.ImportFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L565}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::ImportFeatureValuesResponse>>
  ImportFeatureValues(
      google::cloud::aiplatform::v1::ImportFeatureValuesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Batch reads Feature values from a Featurestore.
  ///
  /// This API enables batch reading Feature values, where each read
  /// instance in the batch may read Feature values of entities from one or
  /// more EntityTypes. Point-in-time correctness is guaranteed for Feature
  /// values of each read instance as of each instance's read timestamp.
  ///
  /// @param featurestore  Required. The resource name of the Featurestore from which to query Feature
  ///  values. Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.BatchReadFeatureValuesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L586}
  /// [google.cloud.aiplatform.v1.BatchReadFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L786}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::aiplatform::v1::BatchReadFeatureValuesResponse>>
  BatchReadFeatureValues(std::string const& featurestore, Options opts = {});

  // clang-format off
  ///
  /// Batch reads Feature values from a Featurestore.
  ///
  /// This API enables batch reading Feature values, where each read
  /// instance in the batch may read Feature values of entities from one or
  /// more EntityTypes. Point-in-time correctness is guaranteed for Feature
  /// values of each read instance as of each instance's read timestamp.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.BatchReadFeatureValuesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L586}
  /// [google.cloud.aiplatform.v1.BatchReadFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L786}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::aiplatform::v1::BatchReadFeatureValuesResponse>>
  BatchReadFeatureValues(
      google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Exports Feature values from all the entities of a target EntityType.
  ///
  /// @param entity_type  Required. The resource name of the EntityType from which to export Feature
  ///  values. Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.ExportFeatureValuesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ExportFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L681}
  /// [google.cloud.aiplatform.v1.ExportFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L782}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::ExportFeatureValuesResponse>>
  ExportFeatureValues(std::string const& entity_type, Options opts = {});

  // clang-format off
  ///
  /// Exports Feature values from all the entities of a target EntityType.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ExportFeatureValuesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.ExportFeatureValuesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ExportFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L681}
  /// [google.cloud.aiplatform.v1.ExportFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L782}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::ExportFeatureValuesResponse>>
  ExportFeatureValues(
      google::cloud::aiplatform::v1::ExportFeatureValuesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Delete Feature values from Featurestore.
  ///
  /// The progress of the deletion is tracked by the returned operation. The
  /// deleted feature values are guaranteed to be invisible to subsequent read
  /// operations after the operation is marked as successfully done.
  ///
  /// If a delete feature values operation fails, the feature values
  /// returned from reads and exports may be inconsistent. If consistency is
  /// required, the caller must retry the same delete request again and wait till
  /// the new operation returned is marked as successfully done.
  ///
  /// @param entity_type  Required. The resource name of the EntityType grouping the Features for
  ///  which values are being deleted from. Format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteFeatureValuesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1361}
  /// [google.cloud.aiplatform.v1.DeleteFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1418}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteFeatureValuesResponse>>
  DeleteFeatureValues(std::string const& entity_type, Options opts = {});

  // clang-format off
  ///
  /// Delete Feature values from Featurestore.
  ///
  /// The progress of the deletion is tracked by the returned operation. The
  /// deleted feature values are guaranteed to be invisible to subsequent read
  /// operations after the operation is marked as successfully done.
  ///
  /// If a delete feature values operation fails, the feature values
  /// returned from reads and exports may be inconsistent. If consistency is
  /// required, the caller must retry the same delete request again and wait till
  /// the new operation returned is marked as successfully done.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteFeatureValuesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteFeatureValuesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1361}
  /// [google.cloud.aiplatform.v1.DeleteFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1418}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteFeatureValuesResponse>>
  DeleteFeatureValues(
      google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Searches Features matching a query in a given project.
  ///
  /// @param location  Required. The resource name of the Location to search Features.
  ///  Format:
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Feature], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.SearchFeaturesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1126}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Feature> SearchFeatures(
      std::string const& location, Options opts = {});

  // clang-format off
  ///
  /// Searches Features matching a query in a given project.
  ///
  /// @param location  Required. The resource name of the Location to search Features.
  ///  Format:
  ///  `projects/{project}/locations/{location}`
  /// @param query  Query string that is a conjunction of field-restricted queries and/or
  ///  field-restricted filters.  Field-restricted queries and filters can be
  ///  combined using `AND` to form a conjunction.
  ///  @n
  ///  For more information, see [SearchFeaturesRequest][google.cloud.aiplatform.v1.SearchFeaturesRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Feature], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.SearchFeaturesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1126}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Feature> SearchFeatures(
      std::string const& location, std::string const& query, Options opts = {});

  // clang-format off
  ///
  /// Searches Features matching a query in a given project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.SearchFeaturesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Feature], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Feature]: @googleapis_reference_link{google/cloud/aiplatform/v1/feature.proto#L34}
  /// [google.cloud.aiplatform.v1.SearchFeaturesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_service.proto#L1126}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Feature> SearchFeatures(
      google::cloud::aiplatform::v1::SearchFeaturesRequest request,
      Options opts = {});

 private:
  std::shared_ptr<FeaturestoreServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_CLIENT_H
