// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/clusters.proto

#include "google/cloud/dataproc/v1/cluster_controller_connection.h"
#include "google/cloud/dataproc/v1/cluster_controller_options.h"
#include "google/cloud/dataproc/v1/internal/cluster_controller_connection_impl.h"
#include "google/cloud/dataproc/v1/internal/cluster_controller_option_defaults.h"
#include "google/cloud/dataproc/v1/internal/cluster_controller_stub_factory.h"
#include "google/cloud/dataproc/v1/internal/cluster_controller_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ClusterControllerConnection::~ClusterControllerConnection() = default;

future<StatusOr<google::cloud::dataproc::v1::Cluster>>
ClusterControllerConnection::CreateCluster(
    google::cloud::dataproc::v1::CreateClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataproc::v1::Cluster>>
ClusterControllerConnection::UpdateCluster(
    google::cloud::dataproc::v1::UpdateClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataproc::v1::Cluster>>
ClusterControllerConnection::StopCluster(
    google::cloud::dataproc::v1::StopClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataproc::v1::Cluster>>
ClusterControllerConnection::StartCluster(
    google::cloud::dataproc::v1::StartClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataproc::v1::ClusterOperationMetadata>>
ClusterControllerConnection::DeleteCluster(
    google::cloud::dataproc::v1::DeleteClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::ClusterOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::dataproc::v1::Cluster>
ClusterControllerConnection::GetCluster(
    google::cloud::dataproc::v1::GetClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dataproc::v1::Cluster>
ClusterControllerConnection::ListClusters(
    google::cloud::dataproc::v1::
        ListClustersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataproc::v1::Cluster>>();
}

future<StatusOr<google::cloud::dataproc::v1::DiagnoseClusterResults>>
ClusterControllerConnection::DiagnoseCluster(
    google::cloud::dataproc::v1::DiagnoseClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::DiagnoseClusterResults>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<ClusterControllerConnection> MakeClusterControllerConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ClusterControllerPolicyOptionList>(options,
                                                                    __func__);
  options = dataproc_v1_internal::ClusterControllerDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = dataproc_v1_internal::CreateDefaultClusterControllerStub(
      background->cq(), options);
  return dataproc_v1_internal::MakeClusterControllerTracingConnection(
      std::make_shared<dataproc_v1_internal::ClusterControllerConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<ClusterControllerConnection> MakeClusterControllerConnection(
    Options options) {
  return MakeClusterControllerConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
