// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/snooze_service.proto

#include "google/cloud/monitoring/v3/internal/snooze_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/v3/snooze_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SnoozeServiceLogging::SnoozeServiceLogging(
    std::shared_ptr<SnoozeServiceStub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceLogging::CreateSnooze(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateSnoozeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateSnoozeRequest const& request) {
        return child_->CreateSnooze(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ListSnoozesResponse>
SnoozeServiceLogging::ListSnoozes(
    grpc::ClientContext& context,
    google::monitoring::v3::ListSnoozesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::ListSnoozesRequest const& request) {
        return child_->ListSnoozes(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceLogging::GetSnooze(
    grpc::ClientContext& context,
    google::monitoring::v3::GetSnoozeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::GetSnoozeRequest const& request) {
        return child_->GetSnooze(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceLogging::UpdateSnooze(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateSnoozeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::UpdateSnoozeRequest const& request) {
        return child_->UpdateSnooze(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
